/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.oauth.web.response.callback;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.support.oauth.OAuth20ResponseTypes;
import org.apereo.cas.support.oauth.services.OAuthRegisteredService;
import org.apereo.cas.support.oauth.util.OAuth20Utils;
import org.apereo.cas.support.oauth.web.endpoints.OAuth20ConfigurationContext;
import org.apereo.cas.support.oauth.web.response.OAuth20AuthorizationRequest;
import org.apereo.cas.support.oauth.web.response.accesstoken.ext.AccessTokenRequestContext;
import org.apereo.cas.support.oauth.web.response.callback.BaseOAuth20AuthorizationResponseBuilder;
import org.apereo.cas.support.oauth.web.response.callback.OAuth20AuthorizationModelAndViewBuilder;
import org.apereo.cas.ticket.Ticket;
import org.apereo.cas.ticket.TicketGrantingTicket;
import org.apereo.cas.ticket.code.OAuth20Code;
import org.apereo.cas.ticket.code.OAuth20CodeFactory;
import org.apereo.cas.util.function.FunctionUtils;
import org.apereo.inspektr.audit.annotation.Audit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.servlet.ModelAndView;

public class OAuth20AuthorizationCodeAuthorizationResponseBuilder
extends BaseOAuth20AuthorizationResponseBuilder<OAuth20ConfigurationContext> {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(OAuth20AuthorizationCodeAuthorizationResponseBuilder.class);

    public OAuth20AuthorizationCodeAuthorizationResponseBuilder(OAuth20ConfigurationContext context, OAuth20AuthorizationModelAndViewBuilder authorizationModelAndViewBuilder) {
        super(context, authorizationModelAndViewBuilder);
    }

    @Audit(action="OAUTH2_CODE_RESPONSE", actionResolverName="OAUTH2_CODE_RESPONSE_ACTION_RESOLVER", resourceResolverName="OAUTH2_CODE_RESPONSE_RESOURCE_RESOLVER")
    public ModelAndView build(AccessTokenRequestContext holder) throws Exception {
        Authentication authentication = holder.getAuthentication();
        OAuth20CodeFactory factory = (OAuth20CodeFactory)this.configurationContext.getTicketFactory().get(OAuth20Code.class);
        OAuth20Code code = factory.create(holder.getService(), authentication, holder.getTicketGrantingTicket(), (Collection)holder.getScopes(), holder.getCodeChallenge(), holder.getCodeChallengeMethod(), holder.getClientId(), holder.getClaims(), holder.getResponseType(), holder.getGrantType());
        LOGGER.debug("Generated OAuth code: [{}]", (Object)code);
        this.configurationContext.getTicketRegistry().addTicket((Ticket)code);
        TicketGrantingTicket ticketGrantingTicket = holder.getTicketGrantingTicket();
        Optional.ofNullable(ticketGrantingTicket).ifPresent(tgt -> FunctionUtils.doAndHandle(ticket -> this.configurationContext.getTicketRegistry().updateTicket((Ticket)ticket), throwable -> {
            LOGGER.error("Unable to update ticket-granting-ticket [{}]", (Object)ticketGrantingTicket, throwable);
            return null;
        }).accept(tgt));
        return this.buildCallbackViewViaRedirectUri(holder, code);
    }

    public boolean supports(OAuth20AuthorizationRequest context) {
        return StringUtils.equalsIgnoreCase((CharSequence)context.getResponseType(), (CharSequence)OAuth20ResponseTypes.CODE.getType());
    }

    protected ModelAndView buildCallbackViewViaRedirectUri(AccessTokenRequestContext holder, OAuth20Code code) throws Exception {
        Map attributes = holder.getAuthentication().getAttributes();
        String state = ((List)attributes.get("state")).get(0).toString();
        String nonce = ((List)attributes.get("nonce")).get(0).toString();
        LOGGER.debug("Authorize request successful for client [{}] with redirect uri [{}]", (Object)holder.getClientId(), (Object)holder.getRedirectUri());
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        params.put("code", code.getId());
        if (StringUtils.isNotBlank((CharSequence)state)) {
            params.put("state", state);
        }
        if (StringUtils.isNotBlank((CharSequence)nonce)) {
            params.put("nonce", nonce);
        }
        LOGGER.debug("Redirecting to URL [{}] with params [{}] for clientId [{}]", new Object[]{holder.getRedirectUri(), params.keySet(), holder.getClientId()});
        OAuthRegisteredService registeredService = OAuth20Utils.getRegisteredOAuthServiceByClientId(this.configurationContext.getServicesManager(), holder.getClientId());
        return this.build(registeredService, holder.getResponseMode(), holder.getRedirectUri(), params);
    }
}

