/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.oauth.services;

import java.util.List;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import lombok.Generated;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.NameValuePair;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.message.BasicNameValuePair;
import org.apereo.cas.authentication.BaseAuthenticationServiceSelectionStrategy;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.authentication.principal.ServiceFactory;
import org.apereo.cas.authentication.principal.WebApplicationService;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.support.oauth.OAuth20GrantTypes;
import org.apereo.cas.support.oauth.util.OAuth20Utils;
import org.apereo.cas.support.oauth.web.OAuth20RequestParameterResolver;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.util.HttpRequestUtils;
import org.apereo.cas.util.LoggingUtils;
import org.jooq.lambda.Unchecked;
import org.pac4j.core.context.WebContext;
import org.pac4j.jee.context.JEEContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OAuth20AuthenticationServiceSelectionStrategy
extends BaseAuthenticationServiceSelectionStrategy {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(OAuth20AuthenticationServiceSelectionStrategy.class);
    private static final long serialVersionUID = 8517547235465666978L;
    private final String callbackUrl;
    private final OAuth20RequestParameterResolver requestParameterResolver;

    public OAuth20AuthenticationServiceSelectionStrategy(ServicesManager servicesManager, ServiceFactory<WebApplicationService> webApplicationServiceFactory, String callbackUrl, OAuth20RequestParameterResolver requestParameterResolver) {
        super(servicesManager, webApplicationServiceFactory);
        this.callbackUrl = callbackUrl;
        this.requestParameterResolver = requestParameterResolver;
    }

    public Service resolveServiceFrom(Service service) {
        Optional<NameValuePair> clientId = this.resolveClientIdFromService(service);
        if (clientId.isPresent()) {
            service.getAttributes().computeIfAbsent("client_id", k -> CollectionUtils.wrapList((Object[])new Object[]{((NameValuePair)clientId.get()).getValue()}));
            Optional<NameValuePair> redirectUri = this.resolveRedirectUri(service);
            if (redirectUri.isPresent()) {
                return this.createService(redirectUri.get().getValue(), service);
            }
            Optional<NameValuePair> grantType = this.resolveGrantType(service);
            if (grantType.isPresent()) {
                String id = "";
                String grantValue = grantType.get().getValue();
                if (OAuth20Utils.isGrantType(grantValue, OAuth20GrantTypes.CLIENT_CREDENTIALS)) {
                    LOGGER.debug("Located grant type [{}]; checking for service headers", (Object)grantValue);
                    HttpServletRequest request = HttpRequestUtils.getHttpServletRequestFromRequestAttributes();
                    HttpServletResponse response = HttpRequestUtils.getHttpServletResponseFromRequestAttributes();
                    id = OAuth20Utils.getServiceRequestHeaderIfAny((WebContext)new JEEContext(request, response));
                }
                if (StringUtils.isBlank((CharSequence)id)) {
                    id = clientId.get().getValue();
                }
                LOGGER.debug("Built web application service based on identifier [{}]", (Object)id);
                return this.createService(id, service);
            }
        }
        return service;
    }

    public boolean supports(Service service) {
        RegisteredService svc = this.getServicesManager().findServiceBy(service);
        boolean res = svc != null && service.getId().startsWith(this.callbackUrl);
        String msg = String.format("Authentication request is%s identified as an OAuth request", BooleanUtils.toString((boolean)res, (String)"", (String)" not"));
        LOGGER.trace(msg);
        return res;
    }

    private Optional<NameValuePair> resolveRedirectUri(Service service) {
        return this.getRequestParameter(service, "redirect_uri");
    }

    private Optional<NameValuePair> resolveGrantType(Service service) {
        return this.getRequestParameter(service, "grant_type");
    }

    private Optional<NameValuePair> resolveClientIdFromService(Service service) {
        return this.getRequestParameter(service, "client_id");
    }

    private Optional<NameValuePair> getRequestParameter(Service service, String name) {
        try {
            Optional<String> value = this.getJwtRequestParameter(service, name).or(Unchecked.supplier(() -> {
                URIBuilder builder = new URIBuilder(service.getId());
                return builder.getQueryParams().stream().filter(p -> p.getName().equals(name)).map(NameValuePair::getValue).findFirst();
            }));
            return value.map(v -> new BasicNameValuePair(name, v));
        }
        catch (Exception e) {
            LoggingUtils.error((Logger)LOGGER, (Throwable)e);
            return Optional.empty();
        }
    }

    private Optional<String> getJwtRequestParameter(Service service, String paramName) throws Exception {
        if (service.getAttributes().containsKey("request")) {
            String jwtRequest = (String)((List)service.getAttributes().get("request")).get(0);
            RegisteredService registeredService = this.getServicesManager().findServiceBy(service);
            String paramValue = (String)this.requestParameterResolver.resolveJwtRequestParameter(jwtRequest, registeredService, paramName, String.class);
            return Optional.of(paramValue);
        }
        return Optional.empty();
    }

    @Generated
    public String getCallbackUrl() {
        return this.callbackUrl;
    }

    @Generated
    public OAuth20RequestParameterResolver getRequestParameterResolver() {
        return this.requestParameterResolver;
    }
}

