/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.saml.metadata;

import java.util.Objects;
import java.util.Optional;
import org.opensaml.saml.saml2.metadata.EntityDescriptor;
import org.opensaml.xmlsec.SignatureSigningParameters;
import org.opensaml.xmlsec.signature.SignableXMLObject;
import org.opensaml.xmlsec.signature.support.SignatureSupport;
import org.pac4j.saml.config.SAML2Configuration;
import org.pac4j.saml.crypto.CredentialProvider;
import org.pac4j.saml.exceptions.SAMLException;
import org.pac4j.saml.metadata.SAML2MetadataSigner;

public class DefaultSAML2MetadataSigner
implements SAML2MetadataSigner {
    protected final CredentialProvider credentialProvider;
    protected final String signatureAlgorithm;
    protected final String signatureReferenceDigestMethod;
    protected final SAML2Configuration configuration;

    public DefaultSAML2MetadataSigner(SAML2Configuration configuration) {
        this.configuration = configuration;
        this.credentialProvider = null;
        this.signatureAlgorithm = "http://www.w3.org/2001/04/xmldsig-more#rsa-sha256";
        this.signatureReferenceDigestMethod = "http://www.w3.org/2001/04/xmlenc#sha256";
    }

    public DefaultSAML2MetadataSigner(CredentialProvider credentialProvider, String signatureAlgorithm, String signatureReferenceDigestMethod) {
        this.configuration = null;
        this.credentialProvider = credentialProvider;
        this.signatureAlgorithm = signatureAlgorithm;
        this.signatureReferenceDigestMethod = signatureReferenceDigestMethod;
    }

    @Override
    public void sign(EntityDescriptor descriptor) {
        try {
            SignatureSigningParameters signingParameters = new SignatureSigningParameters();
            CredentialProvider activeProvider = Objects.requireNonNull(Optional.ofNullable(this.configuration).map(SAML2Configuration::getCredentialProvider).orElseGet(() -> this.credentialProvider));
            signingParameters.setKeyInfoGenerator(activeProvider.getKeyInfoGenerator());
            signingParameters.setSigningCredential(activeProvider.getCredential());
            String signingAlgorithm = Optional.ofNullable(this.configuration).map(SAML2Configuration::getSignatureAlgorithms).filter(algorithms -> !algorithms.isEmpty()).map(algorithms -> (String)algorithms.get(0)).orElse(this.signatureAlgorithm);
            signingParameters.setSignatureAlgorithm(signingAlgorithm);
            String signingReference = Optional.ofNullable(this.configuration).map(SAML2Configuration::getSignatureReferenceDigestMethods).filter(algorithms -> !algorithms.isEmpty()).map(algorithms -> (String)algorithms.get(0)).orElse(this.signatureReferenceDigestMethod);
            signingParameters.setSignatureReferenceDigestMethod(signingReference);
            signingParameters.setSignatureCanonicalizationAlgorithm("http://www.w3.org/2001/10/xml-exc-c14n#");
            SignatureSupport.signObject((SignableXMLObject)descriptor, (SignatureSigningParameters)signingParameters);
        }
        catch (Exception e) {
            throw new SAMLException(e.getMessage(), e);
        }
    }
}

