/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.shadow.org.terracotta.offheapstore.util;

import java.io.IOException;
import java.nio.channels.ClosedByInterruptException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.InterruptibleChannel;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ReopeningInterruptibleChannel<T extends InterruptibleChannel>
implements InterruptibleChannel {
    private static final Logger LOGGER = LoggerFactory.getLogger(ReopeningInterruptibleChannel.class);
    private final Supplier<T> channelFactory;
    private final AtomicReference<T> currentChannel;

    public static <T extends InterruptibleChannel> ReopeningInterruptibleChannel<T> create(Supplier<T> channelFactory) {
        return new ReopeningInterruptibleChannel<T>(channelFactory);
    }

    private ReopeningInterruptibleChannel(Supplier<T> deviceFactory) {
        this.channelFactory = deviceFactory;
        this.currentChannel = new AtomicReference<T>(deviceFactory.get());
    }

    public <R> R execute(IoOperation<T, R> operation) throws IOException {
        boolean interrupted = Thread.interrupted();
        while (true) {
            R r;
            InterruptibleChannel current = (InterruptibleChannel)this.currentChannel.get();
            if (current == null) {
                throw new ClosedChannelException();
            }
            try {
                r = operation.apply(current);
            }
            catch (ClosedChannelException e) {
                InterruptibleChannel newDevice;
                interrupted |= Thread.interrupted();
                if (e instanceof ClosedByInterruptException) {
                    LOGGER.info("Interruption of this thread (" + Thread.currentThread() + ") caused premature closure of a channel");
                }
                if (!this.currentChannel.compareAndSet(current, newDevice = (InterruptibleChannel)this.channelFactory.get())) {
                    newDevice.close();
                    continue;
                }
                LOGGER.debug("Replacing channel " + current + " with " + newDevice + " due to premature closure");
                continue;
            }
            return r;
        }
        finally {
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
    }

    @Override
    public boolean isOpen() {
        return this.currentChannel.get() != null;
    }

    @Override
    public void close() throws IOException {
        InterruptibleChannel terminalDevice = this.currentChannel.getAndSet(null);
        if (terminalDevice != null) {
            terminalDevice.close();
        }
    }

    public static interface IoOperation<T, R> {
        public R apply(T var1) throws IOException;
    }
}

