/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.common.lib.to;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlElementWrapper;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.apache.syncope.common.lib.Attr;
import org.apache.syncope.common.lib.Attributable;
import org.apache.syncope.common.lib.BaseBean;

public class MembershipTO
implements BaseBean,
Attributable {
    private static final long serialVersionUID = 5992828670273935861L;
    private String groupKey;
    private String groupName;
    private final Set<Attr> plainAttrs = new TreeSet<Attr>();
    private final Set<Attr> derAttrs = new TreeSet<Attr>();
    private final Set<Attr> virAttrs = new TreeSet<Attr>();

    public String getGroupKey() {
        return this.groupKey;
    }

    public void setGroupKey(String groupKey) {
        this.groupKey = groupKey;
    }

    public String getGroupName() {
        return this.groupName;
    }

    public void setGroupName(String groupName) {
        this.groupName = groupName;
    }

    @Override
    @JacksonXmlElementWrapper(localName="plainAttrs")
    @JacksonXmlProperty(localName="plainAttr")
    public Set<Attr> getPlainAttrs() {
        return this.plainAttrs;
    }

    @Override
    @JsonIgnore
    public Optional<Attr> getPlainAttr(String schema) {
        return this.plainAttrs.stream().filter(attr -> attr.getSchema().equals(schema)).findFirst();
    }

    @Override
    @JacksonXmlElementWrapper(localName="derAttrs")
    @JacksonXmlProperty(localName="derAttr")
    public Set<Attr> getDerAttrs() {
        return this.derAttrs;
    }

    @Override
    @JsonIgnore
    public Optional<Attr> getDerAttr(String schema) {
        return this.derAttrs.stream().filter(attr -> attr.getSchema().equals(schema)).findFirst();
    }

    @Override
    @JacksonXmlElementWrapper(localName="virAttrs")
    @JacksonXmlProperty(localName="virAttr")
    public Set<Attr> getVirAttrs() {
        return this.virAttrs;
    }

    @Override
    @JsonIgnore
    public Optional<Attr> getVirAttr(String schema) {
        return this.virAttrs.stream().filter(attr -> attr.getSchema().equals(schema)).findFirst();
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.groupKey).append((Object)this.groupName).append(this.plainAttrs).append(this.derAttrs).append(this.virAttrs).build();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MembershipTO other = (MembershipTO)obj;
        return new EqualsBuilder().append((Object)this.groupKey, (Object)other.groupKey).append((Object)this.groupName, (Object)other.groupName).append(this.plainAttrs, other.plainAttrs).append(this.derAttrs, other.derAttrs).append(this.virAttrs, other.virAttrs).build();
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.SIMPLE_STYLE).append((Object)this.groupKey).append((Object)this.groupName).build();
    }

    public static class Builder {
        private final MembershipTO instance = new MembershipTO();

        public Builder(String groupKey) {
            this.instance.setGroupKey(groupKey);
        }

        public Builder groupName(String groupName) {
            this.instance.setGroupName(groupName);
            return this;
        }

        public Builder plainAttr(Attr plainAttr) {
            this.instance.getPlainAttrs().add(plainAttr);
            return this;
        }

        public Builder plainAttrs(Attr ... plainAttrs) {
            this.instance.getPlainAttrs().addAll(List.of(plainAttrs));
            return this;
        }

        public Builder plainAttrs(Collection<Attr> plainAttrs) {
            this.instance.getPlainAttrs().addAll(plainAttrs);
            return this;
        }

        public Builder virAttr(Attr virAttr) {
            this.instance.getVirAttrs().add(virAttr);
            return this;
        }

        public Builder virAttrs(Collection<Attr> virAttrs) {
            this.instance.getVirAttrs().addAll(virAttrs);
            return this;
        }

        public Builder virAttrs(Attr ... virAttrs) {
            this.instance.getVirAttrs().addAll(List.of(virAttrs));
            return this;
        }

        public MembershipTO build() {
            return this.instance;
        }
    }
}

