/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.binding.expression.spel;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.binding.expression.Expression;
import org.springframework.binding.expression.spel.EvaluationContextFactory;
import org.springframework.core.convert.ConversionService;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.PropertyAccessor;
import org.springframework.expression.TypeConverter;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import org.springframework.expression.spel.support.StandardTypeConverter;

public class StandardEvaluationContextFactory
implements EvaluationContextFactory {
    private final List<PropertyAccessor> propertyAccessors;
    private final ConversionService conversionService;
    private final Map<String, Expression> expressionVariables;

    public StandardEvaluationContextFactory(List<PropertyAccessor> propertyAccessors, ConversionService conversionService, Map<String, Expression> expressionVariables) {
        this.propertyAccessors = propertyAccessors;
        this.conversionService = conversionService;
        this.expressionVariables = expressionVariables;
    }

    @Override
    public EvaluationContext createContext(Object rootObject) {
        StandardEvaluationContext context = new StandardEvaluationContext(rootObject);
        context.setVariables(this.getVariableValues(rootObject));
        context.setTypeConverter((TypeConverter)new StandardTypeConverter(this.conversionService));
        context.getPropertyAccessors().addAll(this.propertyAccessors);
        return context;
    }

    private Map<String, Object> getVariableValues(Object rootObject) {
        if (this.expressionVariables == null) {
            return Collections.emptyMap();
        }
        HashMap<String, Object> variableValues = new HashMap<String, Object>(this.expressionVariables.size());
        for (Map.Entry<String, Expression> var : this.expressionVariables.entrySet()) {
            variableValues.put(var.getKey(), var.getValue().getValue(rootObject));
        }
        return variableValues;
    }
}

