/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.context.servlet;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.util.StringUtils;
import org.springframework.webflow.context.servlet.FlowUrlHandler;
import org.springframework.webflow.core.collection.AttributeMap;

public class DefaultFlowUrlHandler
implements FlowUrlHandler {
    private static final String FLOW_EXECUTION_KEY_PARAMETER = "execution";
    private String encodingScheme;

    public void setEncodingScheme(String encodingScheme) {
        this.encodingScheme = encodingScheme;
    }

    @Override
    public String getFlowExecutionKey(HttpServletRequest request) {
        return request.getParameter(FLOW_EXECUTION_KEY_PARAMETER);
    }

    @Override
    public String getFlowId(HttpServletRequest request) {
        String pathInfo = request.getPathInfo();
        if (pathInfo != null) {
            return pathInfo.substring(1);
        }
        String servletPath = request.getServletPath();
        if (StringUtils.hasText((String)servletPath)) {
            int dotIndex = servletPath.lastIndexOf(46);
            if (dotIndex != -1) {
                return servletPath.substring(1, dotIndex);
            }
            return servletPath.substring(1);
        }
        String contextPath = request.getContextPath();
        if (StringUtils.hasText((String)contextPath)) {
            return request.getContextPath().substring(1);
        }
        return null;
    }

    @Override
    public String createFlowExecutionUrl(String flowId, String flowExecutionKey, HttpServletRequest request) {
        StringBuilder url = new StringBuilder();
        url.append(request.getRequestURI());
        url.append('?');
        this.appendQueryParameter(url, FLOW_EXECUTION_KEY_PARAMETER, flowExecutionKey, this.getEncodingScheme(request));
        return url.toString();
    }

    @Override
    public String createFlowDefinitionUrl(String flowId, AttributeMap<?> input, HttpServletRequest request) {
        StringBuilder url = new StringBuilder();
        if (request.getPathInfo() != null) {
            url.append(request.getContextPath());
            url.append(request.getServletPath());
            url.append('/');
            url.append(flowId);
        } else {
            String servletPath = request.getServletPath();
            if (StringUtils.hasText((String)servletPath)) {
                url.append(request.getContextPath());
                url.append('/');
                url.append(flowId);
                int dotIndex = servletPath.lastIndexOf(46);
                if (dotIndex != -1) {
                    url.append(servletPath.substring(dotIndex));
                }
            } else {
                url.append('/');
                url.append(flowId);
            }
        }
        if (input != null && !input.isEmpty()) {
            url.append('?');
            this.appendQueryParameters(url, input.asMap(), this.getEncodingScheme(request));
        }
        return url.toString();
    }

    protected String getEncodingScheme(HttpServletRequest request) {
        if (this.encodingScheme != null) {
            return this.encodingScheme;
        }
        String encodingScheme = request.getCharacterEncoding();
        if (encodingScheme == null) {
            encodingScheme = "ISO-8859-1";
        }
        return encodingScheme;
    }

    protected <T> void appendQueryParameters(StringBuilder url, Map<String, T> parameters, String encodingScheme) {
        Iterator<Map.Entry<String, T>> entries = parameters.entrySet().iterator();
        while (entries.hasNext()) {
            Map.Entry<String, T> entry = entries.next();
            this.appendQueryParameter(url, entry.getKey(), entry.getValue(), encodingScheme);
            if (!entries.hasNext()) continue;
            url.append('&');
        }
    }

    private void appendQueryParameter(StringBuilder url, Object key, Object value, String encodingScheme) {
        String encodedKey = this.encode(key, encodingScheme);
        String encodedValue = this.encode(value, encodingScheme);
        url.append(encodedKey).append('=').append(encodedValue);
    }

    private String encode(Object value, String encodingScheme) {
        return value != null ? this.urlEncode(value.toString(), encodingScheme) : "";
    }

    private String urlEncode(String value, String encodingScheme) {
        try {
            return URLEncoder.encode(value, encodingScheme);
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException("Cannot url encode " + value);
        }
    }
}

