/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.context.servlet;

import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.context.support.WebApplicationObjectSupport;
import org.springframework.webflow.context.servlet.AjaxHandler;

public abstract class AbstractAjaxHandler
extends WebApplicationObjectSupport
implements AjaxHandler {
    private AbstractAjaxHandler delegate;

    public AbstractAjaxHandler(AbstractAjaxHandler delegate) {
        this.delegate = delegate;
    }

    @Override
    public final boolean isAjaxRequest(HttpServletRequest request, HttpServletResponse response) {
        if (this.isAjaxRequestInternal(request, response)) {
            return true;
        }
        if (this.delegate != null) {
            return this.delegate.isAjaxRequest(request, response);
        }
        return false;
    }

    @Override
    public final void sendAjaxRedirect(String targetUrl, HttpServletRequest request, HttpServletResponse response, boolean popup) throws IOException {
        if (this.isAjaxRequestInternal(request, response)) {
            this.sendAjaxRedirectInternal(targetUrl, request, response, popup);
        }
        if (this.delegate != null) {
            this.delegate.sendAjaxRedirect(targetUrl, request, response, popup);
        }
    }

    protected abstract boolean isAjaxRequestInternal(HttpServletRequest var1, HttpServletResponse var2);

    protected abstract void sendAjaxRedirectInternal(String var1, HttpServletRequest var2, HttpServletResponse var3, boolean var4) throws IOException;
}

