/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas;

import java.io.Serializable;
import lombok.Generated;
import org.apereo.cas.CentralAuthenticationService;
import org.apereo.cas.CentralAuthenticationServiceContext;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.ContextualAuthenticationPolicy;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.authentication.principal.WebApplicationService;
import org.apereo.cas.services.CasModelRegisteredService;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.ServiceContext;
import org.apereo.cas.services.UnauthorizedProxyingException;
import org.apereo.cas.ticket.AbstractTicketException;
import org.apereo.cas.ticket.TicketFactory;
import org.apereo.cas.ticket.TicketGrantingTicket;
import org.apereo.cas.ticket.UnsatisfiedAuthenticationPolicyException;
import org.apereo.cas.util.LoggingUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEvent;
import org.springframework.util.ObjectUtils;

public abstract class AbstractCentralAuthenticationService
implements CentralAuthenticationService,
Serializable {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractCentralAuthenticationService.class);
    private static final long serialVersionUID = -7572316677901391166L;
    protected final CentralAuthenticationServiceContext configurationContext;

    protected void doPublishEvent(ApplicationEvent e) {
        if (this.configurationContext.getApplicationContext() != null) {
            LOGGER.trace("Publishing [{}]", (Object)e);
            this.configurationContext.getApplicationContext().publishEvent(e);
        }
    }

    protected Authentication getAuthenticationSatisfiedByPolicy(Authentication authentication, ServiceContext context) throws AbstractTicketException {
        ContextualAuthenticationPolicy policy = this.configurationContext.getAuthenticationPolicyFactory().createPolicy((Object)context);
        try {
            if (policy.isSatisfiedBy(authentication)) {
                return authentication;
            }
        }
        catch (Exception e) {
            LoggingUtils.error((Logger)LOGGER, (Throwable)e);
        }
        throw new UnsatisfiedAuthenticationPolicyException(policy);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void evaluateProxiedServiceIfNeeded(Service service, TicketGrantingTicket ticketGrantingTicket, RegisteredService registeredService) {
        Service proxiedBy = ticketGrantingTicket.getProxiedBy();
        if (proxiedBy != null) {
            LOGGER.debug("Ticket-granting ticket is proxied by [{}]. Locating proxy service in registry...", (Object)proxiedBy.getId());
            CasModelRegisteredService proxyingService = (CasModelRegisteredService)this.configurationContext.getServicesManager().findServiceBy(proxiedBy, CasModelRegisteredService.class);
            if (proxyingService != null) {
                LOGGER.debug("Located proxying service [{}] in the service registry", (Object)proxyingService);
                if (proxyingService.getProxyPolicy().isAllowedToProxy()) return;
                LOGGER.warn("Proxying service [{}] is not authorized to fulfill the proxy attempt made by [{}]", (Object)proxyingService.getId(), (Object)service.getId());
                throw new UnauthorizedProxyingException("Proxying is not allowed for registered service " + registeredService.getId());
            }
            LOGGER.warn("Proxy attempt by service [{}] (registered service [{}]) is not allowed.", (Object)service.getId(), (Object)registeredService.getId());
            throw new UnauthorizedProxyingException("Proxying is not allowed for registered service " + registeredService.getId());
        }
        LOGGER.trace("Ticket-granting ticket is not proxied by another service");
    }

    protected WebApplicationService resolveServiceFromAuthenticationRequest(Service service) {
        return (WebApplicationService)this.configurationContext.getAuthenticationServiceSelectionPlan().resolveService(service, WebApplicationService.class);
    }

    protected boolean isTicketAuthenticityVerified(String ticketId) {
        try {
            if (this.configurationContext.getCipherExecutor() != null) {
                LOGGER.trace("Attempting to decode service ticket [{}] to verify authenticity", (Object)ticketId);
                return !ObjectUtils.isEmpty((Object)this.configurationContext.getCipherExecutor().decode((Object)ticketId));
            }
            return !ObjectUtils.isEmpty((Object)ticketId);
        }
        catch (Exception e) {
            LoggingUtils.warn((Logger)LOGGER, (Throwable)e);
            return false;
        }
    }

    public TicketFactory getTicketFactory() {
        return this.configurationContext.getTicketFactory();
    }

    @Generated
    protected AbstractCentralAuthenticationService(CentralAuthenticationServiceContext configurationContext) {
        this.configurationContext = configurationContext;
    }
}

