/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.oidc;

import lombok.Generated;
import org.apache.commons.text.WordUtils;

public interface OidcConstants {
    public static final String ACR = "acr";
    public static final String AMR = "amr";
    public static final String PROMPT_NONE = "none";
    public static final String PROMPT_LOGIN = "login";
    public static final String PROMPT_CONSENT = "consent";
    public static final String LOGIN_HINT = "login_hint";
    public static final String REQUEST_URI = "request_uri";
    public static final String EXPIRES_IN = "expires_in";
    public static final String CLAIM_SUB = "sub";
    public static final String CLAIM_PREFERRED_USERNAME = "preferred_username";
    public static final String CLAIM_AUTH_TIME = "auth_time";
    public static final String CLAIM_AT_HASH = "at_hash";
    public static final String CLAIM_SESSION_ID = "sid";
    public static final String ID_TOKEN = "id_token";
    public static final String ISS = "iss";
    public static final String MAX_AGE = "max_age";
    public static final String UI_LOCALES = "ui_locales";
    public static final String BASE_OIDC_URL = "oidc";
    public static final String LOGOUT_URL = "oidcLogout";
    public static final String AUTHORIZE_URL = "oidcAuthorize";
    public static final String ACCESS_TOKEN_URL = "oidcAccessToken";
    public static final String TOKEN_URL = "oidcToken";
    public static final String PROFILE_URL = "oidcProfile";
    public static final String PUSHED_AUTHORIZE_URL = "oidcPushAuthorize";
    public static final String JWKS_URL = "jwks";
    public static final String REVOCATION_URL = "revoke";
    public static final String REGISTRATION_URL = "register";
    public static final String REGISTRATION_INITIAL_TOKEN_URL = "initToken";
    public static final String CLIENT_REGISTRATION_SCOPE = "client_registration_scope";
    public static final String CLIENT_CONFIGURATION_URL = "clientConfig";
    public static final String INTROSPECTION_URL = "introspect";
    public static final String LOGIN_REQUIRED = "login_required";
    public static final String CONFIRM_VIEW = "oidcConfirmView";
    public static final String WEBFINGER_REL = "http://openid.net/specs/connect/1.0/issuer";
    public static final String WELL_KNOWN_URL = ".well-known";
    public static final String WELL_KNOWN_OPENID_CONFIGURATION_URL = ".well-known/openid-configuration";
    public static final String WELL_KNOWN_OAUTH_AUTHORIZATION_SERVER_URL = ".well-known/oauth-authorization-server";
    public static final String CLIENT_CONFIGURATION_SCOPE = "client_configuration_scope";
    public static final String CAS_OAUTH_CLIENT_CONFIG_ACCESS_TOKEN_AUTHN = "ClientRegistrationClient";
    public static final String CAS_OAUTH_CLIENT_PRIVATE_KEY_JWT_AUTHN = "ClientPrivateKeyJwtClient";
    public static final String CUSTOM_SCOPE_TYPE = "custom";
    public static final String CONTENT_TYPE_JWT = "application/jwt";

    public static enum StandardScopes {
        OPENID("openid"),
        ADDRESS("address"),
        EMAIL("email"),
        PROFILE("profile"),
        PHONE("phone"),
        OFFLINE_ACCESS("offline_access");

        private final String scope;

        private StandardScopes(String scope) {
            this.scope = scope;
        }

        public String getFriendlyName() {
            return WordUtils.capitalize((String)this.scope.replace('_', ' '));
        }

        @Generated
        public String getScope() {
            return this.scope;
        }
    }
}

