/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.transport.utils.conn;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.Header;
import org.apache.http.HttpException;
import org.apache.http.HttpMessage;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.config.ConnectionConfig;
import org.apache.http.config.MessageConstraints;
import org.apache.http.entity.ContentLengthStrategy;
import org.apache.http.impl.ConnSupport;
import org.apache.http.impl.entity.StrictContentLengthStrategy;
import org.apache.http.impl.nio.DefaultNHttpServerConnection;
import org.apache.http.impl.nio.codecs.DefaultHttpRequestParser;
import org.apache.http.impl.nio.codecs.DefaultHttpResponseWriter;
import org.apache.http.nio.NHttpConnectionFactory;
import org.apache.http.nio.NHttpMessageParser;
import org.apache.http.nio.NHttpMessageParserFactory;
import org.apache.http.nio.NHttpMessageWriter;
import org.apache.http.nio.NHttpMessageWriterFactory;
import org.apache.http.nio.reactor.IOSession;
import org.apache.http.nio.reactor.SessionInputBuffer;
import org.apache.http.nio.reactor.SessionOutputBuffer;
import org.apache.http.nio.util.ByteBufferAllocator;
import org.apache.http.nio.util.HeapByteBufferAllocator;
import org.apache.synapse.transport.nhttp.AccessHandler;
import org.apache.synapse.transport.utils.conn.logging.LoggingIOSession;
import org.apache.synapse.transport.utils.conn.logging.LoggingNHttpServerConnection;

public class SynapseNHttpServerConnectionFactory
implements NHttpConnectionFactory<DefaultNHttpServerConnection> {
    private static final Log sourceConnLog = LogFactory.getLog((String)"org.apache.synapse.transport.http.conn.SourceConnection");
    private static final Log sourceHeaderLog = LogFactory.getLog((String)"org.apache.synapse.transport.http.headers.SourceHeaders");
    private static final Log sourceSessionLog = LogFactory.getLog((String)"org.apache.synapse.transport.http.session.SourceSession");
    private static final Log sourceWireLog = LogFactory.getLog((String)"org.apache.synapse.transport.http.wire.SourceWire");
    private static final NHttpMessageParserFactory<HttpRequest> requestParserFactory = new LoggingNHttpRequestParserFactory();
    private static final NHttpMessageWriterFactory<HttpResponse> responseWriterFactory = new LoggingNHttpResponseWriterFactory();
    private final ConnectionConfig config;

    public SynapseNHttpServerConnectionFactory(ConnectionConfig config) {
        this.config = config;
    }

    public DefaultNHttpServerConnection createConnection(IOSession session) {
        if (sourceSessionLog.isDebugEnabled() || sourceWireLog.isDebugEnabled()) {
            session = new LoggingIOSession(sourceSessionLog, sourceWireLog, session, "http-listener");
        }
        if (sourceConnLog.isDebugEnabled()) {
            return new LoggingNHttpServerConnection(session, this.config.getBufferSize(), this.config.getFragmentSizeHint(), (ByteBufferAllocator)HeapByteBufferAllocator.INSTANCE, ConnSupport.createDecoder((ConnectionConfig)this.config), ConnSupport.createEncoder((ConnectionConfig)this.config), this.config.getMessageConstraints(), (ContentLengthStrategy)StrictContentLengthStrategy.INSTANCE, (ContentLengthStrategy)StrictContentLengthStrategy.INSTANCE, requestParserFactory, responseWriterFactory, sourceConnLog);
        }
        return new DefaultNHttpServerConnection(session, this.config.getBufferSize(), this.config.getFragmentSizeHint(), (ByteBufferAllocator)HeapByteBufferAllocator.INSTANCE, ConnSupport.createDecoder((ConnectionConfig)this.config), ConnSupport.createEncoder((ConnectionConfig)this.config), this.config.getMessageConstraints(), (ContentLengthStrategy)StrictContentLengthStrategy.INSTANCE, (ContentLengthStrategy)StrictContentLengthStrategy.INSTANCE, requestParserFactory, responseWriterFactory);
    }

    static class LoggingNHttpResponseWriter
    extends DefaultHttpResponseWriter {
        public LoggingNHttpResponseWriter(SessionOutputBuffer buffer) {
            super(buffer);
        }

        public void write(HttpResponse response) throws IOException, HttpException {
            if (response != null) {
                if (response != null && sourceHeaderLog.isDebugEnabled()) {
                    Header[] headers;
                    sourceHeaderLog.debug((Object)("<< " + response.getStatusLine().toString()));
                    for (Header header : headers = response.getAllHeaders()) {
                        sourceHeaderLog.debug((Object)("<< " + header.toString()));
                    }
                }
                if (AccessHandler.getAccessLog().isInfoEnabled()) {
                    AccessHandler.getAccess().addAccessToQueue(response);
                }
            }
            super.write((HttpMessage)response);
        }
    }

    static class LoggingNHttpRequestParser
    extends DefaultHttpRequestParser {
        public LoggingNHttpRequestParser(SessionInputBuffer buffer, MessageConstraints constraints) {
            super(buffer, constraints);
        }

        public HttpRequest parse() throws IOException, HttpException {
            HttpRequest request = (HttpRequest)super.parse();
            if (request != null) {
                if (sourceHeaderLog.isDebugEnabled()) {
                    Header[] headers;
                    sourceHeaderLog.debug((Object)(">> " + request.getRequestLine().toString()));
                    for (Header header : headers = request.getAllHeaders()) {
                        sourceHeaderLog.debug((Object)(">> " + header.toString()));
                    }
                }
                if (AccessHandler.getAccessLog().isInfoEnabled()) {
                    AccessHandler.getAccess().addAccessToQueue(request);
                }
            }
            return request;
        }
    }

    static class LoggingNHttpResponseWriterFactory
    implements NHttpMessageWriterFactory<HttpResponse> {
        LoggingNHttpResponseWriterFactory() {
        }

        public NHttpMessageWriter<HttpResponse> create(SessionOutputBuffer sessionBuffer) {
            return new LoggingNHttpResponseWriter(sessionBuffer);
        }
    }

    static class LoggingNHttpRequestParserFactory
    implements NHttpMessageParserFactory<HttpRequest> {
        LoggingNHttpRequestParserFactory() {
        }

        public NHttpMessageParser<HttpRequest> create(SessionInputBuffer sessionBuffer, MessageConstraints messageConstraints) {
            return new LoggingNHttpRequestParser(sessionBuffer, messageConstraints);
        }
    }
}

