/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.ws.processor.modeler.annotation;

import java.util.Collection;
import java.util.List;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;

final class TypeModeler {
    private TypeModeler() {
    }

    public static TypeElement getDeclaration(TypeMirror typeMirror) {
        if (typeMirror != null && typeMirror.getKind().equals((Object)TypeKind.DECLARED)) {
            return (TypeElement)((DeclaredType)typeMirror).asElement();
        }
        return null;
    }

    public static TypeElement getDeclaringClassMethod(TypeMirror theClass, String methodName, TypeMirror[] args) {
        return TypeModeler.getDeclaringClassMethod(TypeModeler.getDeclaration(theClass), methodName, args);
    }

    public static TypeElement getDeclaringClassMethod(TypeElement theClass, String methodName, TypeMirror[] args) {
        TypeMirror superClass;
        TypeElement retClass = null;
        if (theClass.getKind().equals((Object)ElementKind.CLASS) && !(superClass = theClass.getSuperclass()).getKind().equals((Object)TypeKind.NONE)) {
            retClass = TypeModeler.getDeclaringClassMethod(superClass, methodName, args);
        }
        if (retClass == null) {
            for (TypeMirror typeMirror : theClass.getInterfaces()) {
                retClass = TypeModeler.getDeclaringClassMethod(typeMirror, methodName, args);
            }
        }
        if (retClass == null) {
            List<ExecutableElement> methods = ElementFilter.methodsIn(theClass.getEnclosedElements());
            for (ExecutableElement method : methods) {
                if (!method.getSimpleName().toString().equals(methodName)) continue;
                retClass = theClass;
                break;
            }
        }
        return retClass;
    }

    public static Collection<DeclaredType> collectInterfaces(TypeElement type) {
        List<? extends TypeMirror> interfaces = type.getInterfaces();
        for (TypeMirror typeMirror : type.getInterfaces()) {
            interfaces.addAll(TypeModeler.collectInterfaces(TypeModeler.getDeclaration(typeMirror)));
        }
        return interfaces;
    }

    public static boolean isSubclass(String subTypeName, String superTypeName, ProcessingEnvironment env) {
        return TypeModeler.isSubclass(env.getElementUtils().getTypeElement(subTypeName), env.getElementUtils().getTypeElement(superTypeName), env);
    }

    public static boolean isSubclass(TypeElement subType, TypeElement superType, ProcessingEnvironment env) {
        return !subType.equals(superType) && TypeModeler.isSubElement(subType, superType);
    }

    public static TypeMirror getHolderValueType(TypeMirror type, TypeElement defHolder, ProcessingEnvironment env) {
        TypeElement typeElement = TypeModeler.getDeclaration(type);
        if (typeElement == null) {
            return null;
        }
        if (TypeModeler.isSubElement(typeElement, defHolder) && type.getKind().equals((Object)TypeKind.DECLARED)) {
            VariableElement member;
            List<? extends TypeMirror> argTypes = ((DeclaredType)type).getTypeArguments();
            if (argTypes.size() == 1) {
                return (TypeMirror)argTypes.iterator().next();
            }
            if (argTypes.size() == 0 && (member = TypeModeler.getValueMember(typeElement)) != null) {
                return member.asType();
            }
        }
        return null;
    }

    public static VariableElement getValueMember(TypeMirror classType) {
        return TypeModeler.getValueMember(TypeModeler.getDeclaration(classType));
    }

    public static VariableElement getValueMember(TypeElement type) {
        VariableElement member = null;
        for (VariableElement field : ElementFilter.fieldsIn(type.getEnclosedElements())) {
            if (!"value".equals(field.getSimpleName().toString())) continue;
            member = field;
            break;
        }
        if (member == null && type.getKind().equals((Object)ElementKind.CLASS)) {
            member = TypeModeler.getValueMember(type.getSuperclass());
        }
        return member;
    }

    public static boolean isSubElement(TypeElement d1, TypeElement d2) {
        TypeMirror superClass;
        if (d1.equals(d2)) {
            return true;
        }
        TypeElement superClassDecl = null;
        if (d1.getKind().equals((Object)ElementKind.CLASS) && !(superClass = d1.getSuperclass()).getKind().equals((Object)TypeKind.NONE) && (superClassDecl = (TypeElement)((DeclaredType)superClass).asElement()).equals(d2)) {
            return true;
        }
        for (TypeMirror typeMirror : d1.getInterfaces()) {
            DeclaredType declaredSuperIntf = (DeclaredType)typeMirror;
            if (((Object)declaredSuperIntf.asElement()).equals(d2)) {
                return true;
            }
            if (TypeModeler.isSubElement((TypeElement)declaredSuperIntf.asElement(), d2)) {
                return true;
            }
            if (superClassDecl == null || !TypeModeler.isSubElement(superClassDecl, d2)) continue;
            return true;
        }
        return false;
    }
}

