/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.message.processors;

import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.SynapseException;
import org.apache.synapse.config.SynapseConfiguration;
import org.apache.synapse.core.SynapseEnvironment;
import org.apache.synapse.message.processors.MessageProcessor;

public abstract class AbstractMessageProcessor
implements MessageProcessor {
    protected Log log = LogFactory.getLog(this.getClass());
    protected String messageStore;
    protected String description;
    protected String name;
    protected String fileName;
    protected SynapseConfiguration configuration;
    protected Map<String, Object> parameters = null;
    private State state = State.DESTROY;

    @Override
    public void init(SynapseEnvironment se) {
        this.configuration = se.getSynapseConfiguration();
    }

    @Override
    public void setMessageStoreName(String messageStore) {
        if (messageStore == null) {
            throw new SynapseException("Error Can't set Message store to null");
        }
        this.messageStore = messageStore;
    }

    @Override
    public String getMessageStoreName() {
        return this.messageStore;
    }

    @Override
    public void setParameters(Map<String, Object> parameters) {
        this.parameters = parameters;
    }

    @Override
    public Map<String, Object> getParameters() {
        return this.parameters;
    }

    @Override
    public boolean isStarted() {
        return this.state == State.START;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public void setFileName(String filename) {
        this.fileName = filename;
    }

    @Override
    public String getFileName() {
        return this.fileName;
    }

    protected static enum State {
        INITIALIZED,
        START,
        STOP,
        DESTROY;

    }
}

