/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.aspects.statistics;

import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.Identifiable;
import org.apache.synapse.MessageContext;
import org.apache.synapse.aspects.AspectConfiguration;
import org.apache.synapse.aspects.ComponentType;
import org.apache.synapse.aspects.statistics.ErrorLog;
import org.apache.synapse.aspects.statistics.ErrorLogFactory;
import org.apache.synapse.aspects.statistics.StatisticsCollector;
import org.apache.synapse.aspects.statistics.StatisticsConfigurable;
import org.apache.synapse.aspects.statistics.StatisticsLog;
import org.apache.synapse.aspects.statistics.StatisticsRecord;
import org.apache.synapse.aspects.statistics.StatisticsRecordFactory;

public class StatisticsReporter {
    private static final Log log = LogFactory.getLog(StatisticsReporter.class);

    public static void reportForComponent(MessageContext synCtx, StatisticsConfigurable configurable, ComponentType componentType) {
        if (!(configurable instanceof Identifiable)) {
            return;
        }
        if (!configurable.isStatisticsEnable()) {
            return;
        }
        StatisticsRecord record = null;
        if (synCtx.getProperty("synapse.statistics.stack") instanceof StatisticsRecord) {
            record = (StatisticsRecord)synCtx.getProperty("synapse.statistics.stack");
        }
        if (record == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Setting a statistics stack on the message context.");
            }
            record = StatisticsRecordFactory.getStatisticsRecord(synCtx);
            synCtx.setProperty("synapse.statistics.stack", record);
        }
        record.setOwner(componentType);
        record.collect(StatisticsReporter.createStatisticsLog((Identifiable)((Object)configurable), componentType, synCtx));
    }

    public static void reportForAllOnResponseReceived(MessageContext synCtx) {
        synCtx.setProperty("synapse.internal.request.sending", false);
        StatisticsRecord statisticsRecord = null;
        if (synCtx.getProperty("synapse.statistics.stack") instanceof StatisticsRecord) {
            statisticsRecord = (StatisticsRecord)synCtx.getProperty("synapse.statistics.stack");
        }
        if (statisticsRecord != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Reporting a statistics on a response is received : " + statisticsRecord));
            }
            AspectConfiguration configuration = new AspectConfiguration("synapse.aspects");
            configuration.enableStatistics();
            statisticsRecord.collect(StatisticsReporter.createStatisticsLog(configuration, ComponentType.ANY, synCtx));
        }
    }

    public static void reportFaultForAll(MessageContext synCtx, ErrorLog errorLog) {
        StatisticsRecord statisticsRecord = null;
        if (synCtx.getProperty("synapse.statistics.stack") instanceof StatisticsRecord) {
            statisticsRecord = (StatisticsRecord)synCtx.getProperty("synapse.statistics.stack");
        }
        if (statisticsRecord != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Reporting a fault : " + statisticsRecord));
            }
            StatisticsLog statisticsLog = new StatisticsLog("synapse.aspects", ComponentType.ANY);
            statisticsLog.setResponse(synCtx.isResponse() || synCtx.isFaultResponse());
            statisticsLog.setFault(true);
            statisticsLog.setErrorLog(errorLog);
            statisticsRecord.collect(statisticsLog);
        }
    }

    public static void reportForAllOnResponseSent(MessageContext synCtx) {
        StatisticsReporter.endReportForAll(synCtx);
    }

    private static void endReportForAll(MessageContext synCtx) {
        StatisticsRecord record = null;
        if (synCtx.getProperty("synapse.statistics.stack") instanceof StatisticsRecord) {
            record = (StatisticsRecord)synCtx.getProperty("synapse.statistics.stack");
        }
        if (record == null) {
            return;
        }
        if (record.isEndReported()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"The statistics record has been already reported.");
            }
            return;
        }
        StatisticsLog statisticsLog = new StatisticsLog("synapse.aspects", ComponentType.ANY);
        statisticsLog.setResponse(synCtx.isResponse() || synCtx.isFaultResponse());
        if (StatisticsReporter.isFault(synCtx)) {
            statisticsLog.setFault(true);
            statisticsLog.setErrorLog(ErrorLogFactory.createErrorLog(synCtx));
        }
        statisticsLog.setEndAnyLog(true);
        record.collect(statisticsLog);
        record.setEndReported(true);
        StatisticsCollector collector = synCtx.getEnvironment().getStatisticsCollector();
        if (collector == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Setting statistics collector in the synapse environment.");
            }
            collector = new StatisticsCollector();
            synCtx.getEnvironment().setStatisticsCollector(collector);
        }
        synCtx.getPropertyKeySet().remove("synapse.statistics.stack");
        if (!collector.contains(record)) {
            collector.collect(record);
        }
    }

    public static void endReportForAllOnRequestProcessed(MessageContext synCtx) {
        StatisticsRecord statisticsRecord = null;
        if (synCtx.getProperty("synapse.statistics.stack") instanceof StatisticsRecord) {
            statisticsRecord = (StatisticsRecord)synCtx.getProperty("synapse.statistics.stack");
        }
        if (statisticsRecord == null) {
            return;
        }
        boolean isOutOnly = Boolean.parseBoolean(String.valueOf(synCtx.getProperty("OUT_ONLY")));
        if (!isOutOnly) {
            boolean bl = isOutOnly = !Boolean.parseBoolean(String.valueOf(synCtx.getProperty("synapse.internal.request.sending"))) && !synCtx.isResponse();
        }
        if (isOutOnly) {
            StatisticsReporter.endReportForAll(synCtx);
        }
    }

    public static void reportForAllOnOutFlowEnd(MessageContext synCtx) {
        StatisticsReporter.endReportForAll(synCtx);
    }

    private static StatisticsLog createStatisticsLog(Identifiable identifiable, ComponentType componentType, MessageContext synCtx) {
        if (StatisticsReporter.isValid(identifiable)) {
            String auditID = identifiable.getId();
            StatisticsLog statisticsLog = new StatisticsLog(auditID, componentType);
            statisticsLog.setResponse(synCtx.isResponse() || synCtx.isFaultResponse());
            if (StatisticsReporter.isFault(synCtx)) {
                statisticsLog.setFault(true);
                statisticsLog.setErrorLog(ErrorLogFactory.createErrorLog(synCtx));
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Created statistics log : " + statisticsLog));
            }
            return statisticsLog;
        }
        return null;
    }

    private static boolean isValid(Identifiable identifiable) {
        if (identifiable == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Invalid aspects configuration , It is null.");
            }
            return false;
        }
        String auditID = identifiable.getId();
        if (auditID == null || "".equals(auditID)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Invalid aspects configuration , Audit name is null.");
            }
            return false;
        }
        return true;
    }

    private static boolean isFault(MessageContext context) {
        boolean isFault = context.isFaultResponse();
        if (!isFault) {
            SOAPEnvelope envelope;
            boolean bl = isFault = context.getProperty("ERROR_CODE") != null;
            if (!isFault && (envelope = context.getEnvelope()) != null) {
                isFault = envelope.hasFault();
            }
        }
        return isFault;
    }
}

