/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.convert;

import net.sf.jasperreports.engine.JRElement;
import net.sf.jasperreports.engine.JRImage;
import net.sf.jasperreports.engine.JRPrintElement;
import net.sf.jasperreports.engine.base.JRBasePrintImage;
import net.sf.jasperreports.engine.convert.ElementConverter;
import net.sf.jasperreports.engine.convert.ReportConverter;
import net.sf.jasperreports.engine.type.OnErrorTypeEnum;
import net.sf.jasperreports.engine.util.JRExpressionUtil;
import net.sf.jasperreports.renderers.ResourceRenderer;

public final class ImageConverter
extends ElementConverter {
    private static final ImageConverter INSTANCE = new ImageConverter();

    private ImageConverter() {
    }

    public static ImageConverter getInstance() {
        return INSTANCE;
    }

    @Override
    public JRPrintElement convert(ReportConverter reportConverter, JRElement element) {
        JRBasePrintImage printImage = new JRBasePrintImage(reportConverter.getDefaultStyleProvider());
        JRImage image = (JRImage)element;
        this.copyGraphicElement(reportConverter, image, printImage);
        printImage.copyBox(image.getLineBox());
        printImage.setAnchorName(JRExpressionUtil.getExpressionText(image.getAnchorNameExpression()));
        printImage.setBookmarkLevel(image.getBookmarkLevel());
        printImage.setHorizontalImageAlign(image.getOwnHorizontalImageAlign());
        printImage.setLinkType(image.getLinkType());
        printImage.setOnErrorType(OnErrorTypeEnum.ICON);
        printImage.setVerticalImageAlign(image.getOwnVerticalImageAlign());
        printImage.setRenderer(ResourceRenderer.getInstance(JRExpressionUtil.getSimpleExpressionText(image.getExpression()), image.isLazy()));
        printImage.setScaleImage(image.getOwnScaleImage());
        printImage.setRotation(image.getOwnRotation());
        return printImage;
    }
}

