/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.daemon.ui;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import jakarta.servlet.DispatcherType;
import jakarta.servlet.Filter;
import jakarta.servlet.Servlet;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.SecurityContext;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Objects;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.minidev.json.JSONValue;
import org.apache.logging.log4j.Level;
import org.apache.storm.daemon.common.ReloadableSslContextFactory;
import org.apache.storm.daemon.ui.FilterConfiguration;
import org.apache.storm.daemon.ui.IConfigurator;
import org.apache.storm.generated.Bolt;
import org.apache.storm.generated.BoltAggregateStats;
import org.apache.storm.generated.ClusterSummary;
import org.apache.storm.generated.CommonAggregateStats;
import org.apache.storm.generated.ComponentAggregateStats;
import org.apache.storm.generated.ComponentPageInfo;
import org.apache.storm.generated.ComponentType;
import org.apache.storm.generated.ErrorInfo;
import org.apache.storm.generated.ExecutorAggregateStats;
import org.apache.storm.generated.ExecutorInfo;
import org.apache.storm.generated.ExecutorSummary;
import org.apache.storm.generated.GetInfoOptions;
import org.apache.storm.generated.GlobalStreamId;
import org.apache.storm.generated.Grouping;
import org.apache.storm.generated.KillOptions;
import org.apache.storm.generated.LogConfig;
import org.apache.storm.generated.LogLevel;
import org.apache.storm.generated.LogLevelAction;
import org.apache.storm.generated.Nimbus;
import org.apache.storm.generated.NimbusSummary;
import org.apache.storm.generated.NodeInfo;
import org.apache.storm.generated.NumErrorsChoice;
import org.apache.storm.generated.OwnerResourceSummary;
import org.apache.storm.generated.ProfileAction;
import org.apache.storm.generated.ProfileRequest;
import org.apache.storm.generated.RebalanceOptions;
import org.apache.storm.generated.SpecificAggregateStats;
import org.apache.storm.generated.SpoutAggregateStats;
import org.apache.storm.generated.SpoutSpec;
import org.apache.storm.generated.StormTopology;
import org.apache.storm.generated.SupervisorPageInfo;
import org.apache.storm.generated.SupervisorSummary;
import org.apache.storm.generated.TopologyHistoryInfo;
import org.apache.storm.generated.TopologyInfo;
import org.apache.storm.generated.TopologyPageInfo;
import org.apache.storm.generated.TopologyStats;
import org.apache.storm.generated.TopologySummary;
import org.apache.storm.generated.WorkerSummary;
import org.apache.storm.logging.filters.AccessLoggingFilter;
import org.apache.storm.scheduler.resource.normalization.NormalizedResourceRequest;
import org.apache.storm.stats.StatsUtil;
import org.apache.storm.thrift.TException;
import org.apache.storm.utils.IVersionInfo;
import org.apache.storm.utils.ObjectReader;
import org.apache.storm.utils.Time;
import org.apache.storm.utils.TopologySpoutLag;
import org.apache.storm.utils.Utils;
import org.apache.storm.utils.VersionInfo;
import org.apache.storm.utils.WebAppUtils;
import org.eclipse.jetty.ee10.servlet.FilterHolder;
import org.eclipse.jetty.ee10.servlet.ServletContextHandler;
import org.eclipse.jetty.ee10.servlet.ServletHolder;
import org.eclipse.jetty.ee10.servlets.CrossOriginFilter;
import org.eclipse.jetty.http.HttpStatus;
import org.eclipse.jetty.http.HttpVersion;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.SecureRequestCustomizer;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.SslConnectionFactory;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UIHelpers {
    private static final Logger LOG = LoggerFactory.getLogger(UIHelpers.class);
    private static final Object[][] PRETTY_SEC_DIVIDERS = new Object[][]{{"s", 60}, {"m", 60}, {"h", 24}, {"d", null}};
    private static final Object[][] PRETTY_MS_DIVIDERS = new Object[][]{{"ms", 1000}, {"s", 60}, {"m", 60}, {"h", 24}, {"d", null}};
    private static final AtomicReference<List<Map<String, String>>> MEMORIZED_VERSIONS = new AtomicReference();
    private static final AtomicReference<Map<String, String>> MEMORIZED_FULL_VERSION = new AtomicReference();

    public static String prettyUptimeStr(String val, Object[][] dividers) {
        int uptime = Integer.parseInt(val);
        LinkedList<CallSite> tmp = new LinkedList<CallSite>();
        for (Object[] divider : dividers) {
            if (uptime <= 0) continue;
            String state = (String)divider[0];
            Integer div = (Integer)divider[1];
            if (div != null) {
                tmp.addFirst((CallSite)((Object)(uptime % div + state)));
                uptime /= div.intValue();
                continue;
            }
            tmp.addFirst((CallSite)((Object)(uptime + state)));
        }
        return Joiner.on((String)" ").join(tmp);
    }

    public static String prettyUptimeSec(String sec) {
        return UIHelpers.prettyUptimeStr(sec, PRETTY_SEC_DIVIDERS);
    }

    public static String prettyUptimeSec(int secs) {
        return UIHelpers.prettyUptimeStr(String.valueOf(secs), PRETTY_SEC_DIVIDERS);
    }

    public static String prettyUptimeMs(String ms) {
        return UIHelpers.prettyUptimeStr(ms, PRETTY_MS_DIVIDERS);
    }

    public static String prettyUptimeMs(int ms) {
        return UIHelpers.prettyUptimeStr(String.valueOf(ms), PRETTY_MS_DIVIDERS);
    }

    public static String urlFormat(String fmt, Object ... args) {
        Object[] argsEncoded = new String[args.length];
        for (int i = 0; i < args.length; ++i) {
            argsEncoded[i] = Utils.urlEncodeUtf8((String)String.valueOf(args[i]));
        }
        return String.format(fmt, argsEncoded);
    }

    public static String prettyExecutorInfo(ExecutorInfo e) {
        return "[" + e.get_task_start() + "-" + e.get_task_end() + "]";
    }

    public static Map<String, Object> unauthorizedUserJson(String user) {
        return ImmutableMap.of((Object)"error", (Object)"No Authorization", (Object)"errorMessage", (Object)String.format("User %s is not authorized.", user));
    }

    private static ServerConnector mkSslConnector(Server server, Integer port, String ksPath, String ksPassword, String ksType, String keyPassword, String tsPath, String tsPassword, String tsType, Boolean needClientAuth, Boolean wantClientAuth, Integer headerBufferSize, boolean enableSslReload) {
        ReloadableSslContextFactory factory = new ReloadableSslContextFactory(enableSslReload);
        factory.setExcludeCipherSuites(new String[]{"SSL_RSA_WITH_RC4_128_MD5", "SSL_RSA_WITH_RC4_128_SHA"});
        factory.setExcludeProtocols(new String[]{"SSLv3"});
        factory.setRenegotiationAllowed(false);
        factory.setKeyStorePath(ksPath);
        factory.setKeyStoreType(ksType);
        factory.setKeyStorePassword(ksPassword);
        factory.setKeyManagerPassword(keyPassword);
        if (tsPath != null && tsPassword != null && tsType != null) {
            factory.setTrustStorePath(tsPath);
            factory.setTrustStoreType(tsType);
            factory.setTrustStorePassword(tsPassword);
        }
        if (needClientAuth != null && needClientAuth.booleanValue()) {
            factory.setNeedClientAuth(true);
        } else if (wantClientAuth != null && wantClientAuth.booleanValue()) {
            factory.setWantClientAuth(true);
        }
        HttpConfiguration httpsConfig = new HttpConfiguration();
        httpsConfig.addCustomizer((HttpConfiguration.Customizer)new SecureRequestCustomizer());
        if (null != headerBufferSize) {
            httpsConfig.setRequestHeaderSize(headerBufferSize.intValue());
        }
        ServerConnector sslConnector = new ServerConnector(server, new ConnectionFactory[]{new SslConnectionFactory((SslContextFactory.Server)factory, HttpVersion.HTTP_1_1.asString()), new HttpConnectionFactory(httpsConfig)});
        sslConnector.setPort(port.intValue());
        return sslConnector;
    }

    public static void configSsl(Server server, Integer port, String ksPath, String ksPassword, String ksType, String keyPassword, String tsPath, String tsPassword, String tsType, Boolean needClientAuth, Boolean wantClientAuth, boolean enableSslReload) {
        UIHelpers.configSsl(server, port, ksPath, ksPassword, ksType, keyPassword, tsPath, tsPassword, tsType, needClientAuth, wantClientAuth, null, enableSslReload);
    }

    public static void configSsl(Server server, Integer port, String ksPath, String ksPassword, String ksType, String keyPassword, String tsPath, String tsPassword, String tsType, Boolean needClientAuth, Boolean wantClientAuth, Integer headerBufferSize, boolean enableSslReload) {
        if (port > 0) {
            server.addConnector((Connector)UIHelpers.mkSslConnector(server, port, ksPath, ksPassword, ksType, keyPassword, tsPath, tsPassword, tsType, needClientAuth, wantClientAuth, headerBufferSize, enableSslReload));
        }
    }

    public static FilterHolder corsFilterHandle() {
        FilterHolder filterHolder = new FilterHolder((Filter)new CrossOriginFilter());
        filterHolder.setInitParameter("allowedOrigins", "*");
        filterHolder.setInitParameter("allowedOrigins", "GET, POST, PUT");
        filterHolder.setInitParameter("allowedOrigins", "X-Requested-With, X-Requested-By, Access-Control-Allow-Origin, Content-Type, Content-Length, Accept, Origin");
        filterHolder.setInitParameter("Access-Control-Allow-Origin", "*");
        return filterHolder;
    }

    public static FilterHolder mkAccessLoggingFilterHandle() {
        return new FilterHolder((Filter)new AccessLoggingFilter());
    }

    public static void configFilter(Server server, Servlet servlet, List<FilterConfiguration> filtersConfs) {
        UIHelpers.configFilter(server, servlet, filtersConfs, null);
    }

    public static void configFilter(Server server, Servlet servlet, List<FilterConfiguration> filtersConfs, Map<String, String> params) {
        if (filtersConfs != null) {
            ServletHolder servletHolder = new ServletHolder(servlet);
            servletHolder.setInitOrder(0);
            if (params != null) {
                servletHolder.setInitParameters(params);
            }
            ServletContextHandler context = new ServletContextHandler("/");
            context.addServlet(servletHolder, "/");
            UIHelpers.configFilters(context, filtersConfs);
            server.setHandler((Handler)context);
        }
    }

    public static void configFilters(ServletContextHandler context, List<FilterConfiguration> filtersConfs) {
        context.addFilter(UIHelpers.corsFilterHandle(), "/*", EnumSet.allOf(DispatcherType.class));
        for (FilterConfiguration filterConf : filtersConfs) {
            String filterName = filterConf.getFilterName();
            String filterClass = filterConf.getFilterClass();
            Map<String, String> filterParams = filterConf.getFilterParams();
            if (filterClass == null) continue;
            FilterHolder filterHolder = new FilterHolder();
            filterHolder.setClassName(filterClass);
            if (filterName != null) {
                filterHolder.setName(filterName);
            } else {
                filterHolder.setName(filterClass);
            }
            if (filterParams != null) {
                filterHolder.setInitParameters(filterParams);
            } else {
                filterHolder.setInitParameters(new HashMap());
            }
            context.addFilter(filterHolder, "/*", EnumSet.allOf(DispatcherType.class));
        }
        context.addFilter(UIHelpers.mkAccessLoggingFilterHandle(), "/*", EnumSet.allOf(DispatcherType.class));
    }

    public static Server jettyCreateServer(Integer port, String host, Integer httpsPort, Boolean disableHttpBinding) {
        return UIHelpers.jettyCreateServer(port, host, httpsPort, null, disableHttpBinding);
    }

    public static Server jettyCreateServer(Integer port, String host, Integer httpsPort, Integer headerBufferSize, Boolean disableHttpBinding) {
        Server server = new Server();
        if (httpsPort == null || httpsPort <= 0 || disableHttpBinding == null || !disableHttpBinding.booleanValue()) {
            HttpConfiguration httpConfig = new HttpConfiguration();
            httpConfig.setSendDateHeader(true);
            if (null != headerBufferSize) {
                httpConfig.setRequestHeaderSize(headerBufferSize.intValue());
            }
            ServerConnector httpConnector = new ServerConnector(server, new ConnectionFactory[]{new HttpConnectionFactory(httpConfig)});
            httpConnector.setPort(ObjectReader.getInt((Object)port, (Integer)80).intValue());
            httpConnector.setIdleTimeout(200000L);
            httpConnector.setHost(host);
            server.addConnector((Connector)httpConnector);
        }
        return server;
    }

    public static void stormRunJetty(Integer port, String host, Integer httpsPort, Integer headerBufferSize, IConfigurator configurator) throws Exception {
        Server s = UIHelpers.jettyCreateServer(port, host, httpsPort, headerBufferSize, false);
        if (configurator != null) {
            configurator.execute(s);
        }
        s.start();
    }

    public static void stormRunJetty(Integer port, Integer headerBufferSize, IConfigurator configurator) throws Exception {
        UIHelpers.stormRunJetty(port, null, null, headerBufferSize, configurator);
    }

    public static String wrapJsonInCallback(String callback, String response) {
        return callback + "(" + response + ");";
    }

    public static Map getJsonResponseHeaders(String callback, Map headers) {
        HashMap<String, String> headersResult = new HashMap<String, String>();
        headersResult.put("Cache-Control", "no-cache, no-store");
        headersResult.put("Access-Control-Allow-Origin", "*");
        headersResult.put("Access-Control-Allow-Headers", "Content-Type, Access-Control-Allow-Headers, Access-Controler-Allow-Origin, X-Requested-By, X-Csrf-Token, Authorization, X-Requested-With");
        if (callback != null) {
            headersResult.put("Content-Type", "application/javascript;charset=utf-8");
        } else {
            headersResult.put("Content-Type", "application/json;charset=utf-8");
        }
        if (headers != null) {
            headersResult.putAll(headers);
        }
        return headersResult;
    }

    public static String getJsonResponseBody(Object data, String callback, boolean needSerialize) {
        String serializedData = needSerialize ? JSONValue.toJSONString((Object)data) : (String)data;
        return callback != null ? UIHelpers.wrapJsonInCallback(callback, serializedData) : serializedData;
    }

    public static Map exceptionToJson(Exception ex, int statusCode) {
        StringWriter sw = new StringWriter();
        ex.printStackTrace(new PrintWriter(sw));
        return ImmutableMap.of((Object)"error", (Object)(statusCode + " " + HttpStatus.getMessage((int)statusCode)), (Object)"errorMessage", (Object)sw.toString());
    }

    public static Response makeStandardResponse(Object data, String callback) {
        return UIHelpers.makeStandardResponse(data, callback, true, Response.Status.OK);
    }

    public static Response makeStandardResponse(Object data, String callback, Response.Status status) {
        return UIHelpers.makeStandardResponse(data, callback, true, status);
    }

    public static Response makeStandardResponse(Object data, String callback, boolean needsSerialization, Response.Status status) {
        String body = UIHelpers.getJsonResponseBody(data, callback, needsSerialization);
        Response.ResponseBuilder responseBuilder = Response.status((Response.Status)status).entity((Object)body);
        Map headers = UIHelpers.getJsonResponseHeaders(callback, null);
        for (Map.Entry headerEntry : headers.entrySet()) {
            responseBuilder.header((String)headerEntry.getKey(), headerEntry.getValue());
        }
        return responseBuilder.build();
    }

    private static Map<String, String> toJsonStruct(IVersionInfo info) {
        HashMap<String, String> ret = new HashMap<String, String>();
        ret.put("version", info.getVersion());
        ret.put("revision", info.getRevision());
        ret.put("branch", info.getBranch());
        ret.put("date", info.getDate());
        ret.put("srcChecksum", info.getSrcChecksum());
        return ret;
    }

    public static Map<String, Object> getClusterSummary(ClusterSummary clusterSummary, String user, Map<String, Object> conf) {
        List<Map<String, String>> versions;
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (MEMORIZED_VERSIONS.get() == null) {
            NavigableMap versionsMap = Utils.getAlternativeVersionsMap(conf);
            ArrayList<HashMap<String, String>> versionList = new ArrayList<HashMap<String, String>>();
            for (Map.Entry entry : versionsMap.entrySet()) {
                HashMap<String, String> single = new HashMap<String, String>(UIHelpers.toJsonStruct((IVersionInfo)entry.getValue()));
                single.put("versionMatch", (String)entry.getKey());
                versionList.add(single);
            }
            MEMORIZED_VERSIONS.set(versionList);
        }
        if (!(versions = MEMORIZED_VERSIONS.get()).isEmpty()) {
            result.put("alternativeWorkerVersions", versions);
        }
        if (MEMORIZED_FULL_VERSION.get() == null) {
            MEMORIZED_FULL_VERSION.set(UIHelpers.toJsonStruct(VersionInfo.OUR_FULL_VERSION));
        }
        result.put("user", user);
        result.put("stormVersion", VersionInfo.getVersion());
        result.put("stormVersionInfo", MEMORIZED_FULL_VERSION.get());
        List supervisorSummaries = clusterSummary.get_supervisors();
        result.put("supervisors", supervisorSummaries.size());
        result.put("topologies", clusterSummary.get_topologies_size());
        int usedSlots = supervisorSummaries.stream().mapToInt(SupervisorSummary::get_num_used_workers).sum();
        result.put("slotsUsed", usedSlots);
        int totalSlots = supervisorSummaries.stream().mapToInt(SupervisorSummary::get_num_workers).sum();
        result.put("slotsTotal", totalSlots);
        result.put("slotsFree", totalSlots - usedSlots);
        List topologySummaries = clusterSummary.get_topologies();
        int totalTasks = topologySummaries.stream().mapToInt(TopologySummary::get_num_tasks).sum();
        result.put("tasksTotal", totalTasks);
        int totalExecutors = topologySummaries.stream().mapToInt(TopologySummary::get_num_executors).sum();
        result.put("executorsTotal", totalExecutors);
        double supervisorTotalMemory = supervisorSummaries.stream().mapToDouble(x -> x.get_total_resources().getOrDefault("memory.mb", (Double)x.get_total_resources().get("supervisor.memory.capacity.mb"))).sum();
        result.put("totalMem", supervisorTotalMemory);
        double supervisorTotalCpu = supervisorSummaries.stream().mapToDouble(x -> x.get_total_resources().getOrDefault("cpu.pcore.percent", (Double)x.get_total_resources().get("supervisor.cpu.capacity"))).sum();
        result.put("totalCpu", supervisorTotalCpu);
        double supervisorUsedMemory = supervisorSummaries.stream().mapToDouble(SupervisorSummary::get_used_mem).sum();
        result.put("availMem", supervisorTotalMemory - supervisorUsedMemory);
        double supervisorUsedCpu = supervisorSummaries.stream().mapToDouble(SupervisorSummary::get_used_cpu).sum();
        result.put("availCpu", supervisorTotalCpu - supervisorUsedCpu);
        result.put("fragmentedMem", supervisorSummaries.stream().mapToDouble(SupervisorSummary::get_fragmented_mem).sum());
        result.put("fragmentedCpu", supervisorSummaries.stream().mapToDouble(SupervisorSummary::get_fragmented_cpu).sum());
        result.put("schedulerDisplayResource", conf.get("scheduler.display.resource"));
        result.put("memAssignedPercentUtil", supervisorTotalMemory > 0.0 ? StatsUtil.floatStr((Double)(supervisorUsedMemory * 100.0 / supervisorTotalMemory)) : "0.0");
        result.put("cpuAssignedPercentUtil", supervisorTotalCpu > 0.0 ? StatsUtil.floatStr((Double)(supervisorUsedCpu * 100.0 / supervisorTotalCpu)) : "0.0");
        result.put("bugtracker-url", conf.get("ui.project.bugtracker.url"));
        result.put("central-log-url", conf.get("ui.central.logging.url"));
        Map usedGenericResources = new HashMap();
        Map<String, Double> totalGenericResources = new HashMap<String, Double>();
        for (SupervisorSummary ss : supervisorSummaries) {
            usedGenericResources = NormalizedResourceRequest.addResourceMap(usedGenericResources, (Map)ss.get_used_generic_resources());
            totalGenericResources = NormalizedResourceRequest.addResourceMap(totalGenericResources, (Map)ss.get_total_resources());
        }
        Map availGenericResources = NormalizedResourceRequest.subtractResourceMap(totalGenericResources, usedGenericResources);
        result.put("availGenerics", UIHelpers.prettifyGenericResources(availGenericResources));
        result.put("totalGenerics", UIHelpers.prettifyGenericResources(totalGenericResources));
        return result;
    }

    private static String prettifyGenericResources(Map<String, Double> resourceMap) {
        if (resourceMap == null) {
            return null;
        }
        TreeMap<String, Double> treeGenericResources = new TreeMap<String, Double>();
        treeGenericResources.putAll(resourceMap);
        NormalizedResourceRequest.removeNonGenericResources(treeGenericResources);
        return treeGenericResources.toString().replaceAll("[{}]", "").replace(",", "");
    }

    public static Map<String, Object> unpackOwnerResourceSummary(OwnerResourceSummary ownerResourceSummary) {
        Double memoryGuarantee = -1.0;
        if (ownerResourceSummary.is_set_memory_guarantee()) {
            memoryGuarantee = ownerResourceSummary.get_memory_guarantee();
        }
        Double cpuGuaranteee = -1.0;
        if (ownerResourceSummary.is_set_cpu_guarantee()) {
            cpuGuaranteee = ownerResourceSummary.get_cpu_guarantee();
        }
        int isolatedNodeGuarantee = -1;
        if (ownerResourceSummary.is_set_isolated_node_guarantee()) {
            isolatedNodeGuarantee = ownerResourceSummary.get_isolated_node_guarantee();
        }
        Double memoryGuaranteeRemaining = -1.0;
        if (ownerResourceSummary.is_set_memory_guarantee_remaining()) {
            memoryGuaranteeRemaining = ownerResourceSummary.get_memory_guarantee_remaining();
        }
        Double cpuGuaranteeRemaining = -1.0;
        if (ownerResourceSummary.is_set_cpu_guarantee_remaining()) {
            cpuGuaranteeRemaining = ownerResourceSummary.get_cpu_guarantee_remaining();
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("owner", ownerResourceSummary.get_owner());
        result.put("totalTopologies", ownerResourceSummary.get_total_topologies());
        result.put("totalExecutors", ownerResourceSummary.get_total_executors());
        result.put("totalWorkers", ownerResourceSummary.get_total_workers());
        result.put("totalTasks", ownerResourceSummary.get_total_tasks());
        result.put("totalMemoryUsage", ownerResourceSummary.get_memory_usage());
        result.put("totalCpuUsage", ownerResourceSummary.get_cpu_usage());
        result.put("memoryGuarantee", memoryGuarantee != -1.0 ? memoryGuarantee : "N/A");
        result.put("cpuGuarantee", cpuGuaranteee != -1.0 ? cpuGuaranteee : "N/A");
        result.put("isolatedNodes", isolatedNodeGuarantee);
        result.put("memoryGuaranteeRemaining", memoryGuaranteeRemaining != -1.0 ? memoryGuaranteeRemaining : "N/A");
        result.put("cpuGuaranteeRemaining", cpuGuaranteeRemaining != -1.0 ? cpuGuaranteeRemaining : "N/A");
        result.put("totalReqOnHeapMem", ownerResourceSummary.get_requested_on_heap_memory());
        result.put("totalReqOffHeapMem", ownerResourceSummary.get_requested_off_heap_memory());
        result.put("totalReqMem", ownerResourceSummary.get_requested_total_memory());
        result.put("totalReqCpu", ownerResourceSummary.get_requested_cpu());
        result.put("totalAssignedOnHeapMem", ownerResourceSummary.get_assigned_on_heap_memory());
        result.put("totalAssignedOffHeapMem", ownerResourceSummary.get_assigned_off_heap_memory());
        return result;
    }

    public static Map<String, Object> getOwnerResourceSummaries(List<OwnerResourceSummary> ownerResourceSummaries, Map<String, Object> conf) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("schedulerDisplayResource", conf.get("scheduler.display.resource"));
        ArrayList<Map<String, Object>> ownerSummaries = new ArrayList<Map<String, Object>>();
        for (OwnerResourceSummary ownerResourceSummary : ownerResourceSummaries) {
            ownerSummaries.add(UIHelpers.unpackOwnerResourceSummary(ownerResourceSummary));
        }
        result.put("owners", ownerSummaries);
        return result;
    }

    public static Map<String, Object> getTopologyMap(TopologySummary topologySummary) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("id", topologySummary.get_id());
        result.put("encodedId", Utils.urlEncodeUtf8((String)topologySummary.get_id()));
        result.put("owner", topologySummary.get_owner());
        result.put("name", topologySummary.get_name());
        result.put("status", topologySummary.get_status());
        result.put("uptime", UIHelpers.prettyUptimeSec(topologySummary.get_uptime_secs()));
        result.put("uptimeSeconds", topologySummary.get_uptime_secs());
        result.put("tasksTotal", topologySummary.get_num_tasks());
        result.put("workersTotal", topologySummary.get_num_workers());
        result.put("executorsTotal", topologySummary.get_num_executors());
        result.put("replicationCount", topologySummary.get_replication_count());
        result.put("schedulerInfo", topologySummary.get_sched_status());
        result.put("requestedMemOnHeap", topologySummary.get_requested_memonheap());
        result.put("requestedMemOffHeap", topologySummary.get_requested_memoffheap());
        result.put("requestedTotalMem", topologySummary.get_requested_memoffheap() + topologySummary.get_assigned_memonheap());
        result.put("requestedCpu", topologySummary.get_requested_cpu());
        result.put("requestedGenericResources", UIHelpers.prettifyGenericResources(topologySummary.get_requested_generic_resources()));
        result.put("assignedMemOnHeap", topologySummary.get_assigned_memonheap());
        result.put("assignedMemOffHeap", topologySummary.get_assigned_memoffheap());
        result.put("assignedTotalMem", topologySummary.get_assigned_memoffheap() + topologySummary.get_assigned_memonheap());
        result.put("assignedCpu", topologySummary.get_assigned_cpu());
        result.put("assignedGenericResources", UIHelpers.prettifyGenericResources(topologySummary.get_assigned_generic_resources()));
        result.put("topologyVersion", topologySummary.get_topology_version());
        result.put("stormVersion", topologySummary.get_storm_version());
        return result;
    }

    public static Map<String, Object> getOwnerResourceSummary(List<OwnerResourceSummary> ownerResourceSummaries, Nimbus.Iface client, String id, Map<String, Object> config) throws TException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("schedulerDisplayResource", config.get("scheduler.display.resource"));
        if (ownerResourceSummaries.isEmpty()) {
            return UIHelpers.unpackOwnerResourceSummary(new OwnerResourceSummary(id));
        }
        List topologies = client.getTopologySummaries();
        List<Map> topologySummaries = UIHelpers.getTopologiesMap(id, topologies);
        result.putAll(UIHelpers.unpackOwnerResourceSummary(ownerResourceSummaries.get(0)));
        result.put("topologies", topologySummaries);
        return result;
    }

    private static List<Map> getTopologiesMap(String id, List<TopologySummary> topologies) {
        ArrayList<Map> topologySummaries = new ArrayList<Map>();
        for (TopologySummary topologySummary : topologies) {
            if (id != null && !topologySummary.get_owner().equals(id)) continue;
            topologySummaries.add(UIHelpers.getTopologyMap(topologySummary));
        }
        return topologySummaries;
    }

    public static String getLogviewerLink(String host, String fname, Map<String, Object> config, int port) {
        if (UIHelpers.isSecureLogviewer(config)) {
            return UIHelpers.urlFormat("https://%s:%s/api/v1/log?file=%s", host, config.get("logviewer.https.port"), fname);
        }
        return UIHelpers.urlFormat("http://%s:%s/api/v1/log?file=%s", host, config.get("logviewer.port"), fname);
    }

    public static String getNimbusLogLink(String host, Map<String, Object> config) {
        if (UIHelpers.isSecureLogviewer(config)) {
            return UIHelpers.urlFormat("https://%s:%s/api/v1/daemonlog?file=nimbus.log", host, config.get("logviewer.https.port"));
        }
        return UIHelpers.urlFormat("http://%s:%s/api/v1/daemonlog?file=nimbus.log", host, config.get("logviewer.port"));
    }

    public static String getSupervisorLogLink(String host, Map<String, Object> config) {
        if (UIHelpers.isSecureLogviewer(config)) {
            return UIHelpers.urlFormat("https://%s:%s/api/v1/daemonlog?file=supervisor.log", host, config.get("logviewer.https.port"));
        }
        return UIHelpers.urlFormat("http://%s:%s/api/v1/daemonlog?file=supervisor.log", host, config.get("logviewer.port"));
    }

    public static String getWorkerLogLink(String host, int port, Map<String, Object> config, String topologyId) {
        return UIHelpers.getLogviewerLink(host, WebAppUtils.logsFilename((String)topologyId, (String)String.valueOf(port)), config, port);
    }

    public static Map<String, Object> getPrettifiedSupervisorMap(SupervisorSummary supervisorSummary, Map<String, Object> config) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("id", supervisorSummary.get_supervisor_id());
        result.put("host", supervisorSummary.get_host());
        result.put("uptime", UIHelpers.prettyUptimeSec(supervisorSummary.get_uptime_secs()));
        result.put("blacklisted", supervisorSummary.is_blacklisted());
        result.put("uptimeSeconds", supervisorSummary.get_uptime_secs());
        result.put("slotsTotal", supervisorSummary.get_num_workers());
        result.put("slotsUsed", supervisorSummary.get_num_used_workers());
        result.put("slotsFree", Integer.max(supervisorSummary.get_num_workers() - supervisorSummary.get_num_used_workers(), 0));
        Map totalResources = supervisorSummary.get_total_resources();
        Double totalMemory = totalResources.getOrDefault("memory.mb", (Double)totalResources.get("supervisor.memory.capacity.mb"));
        result.put("totalMem", totalMemory);
        Double totalCpu = totalResources.getOrDefault("cpu.pcore.percent", (Double)totalResources.get("supervisor.cpu.capacity"));
        result.put("totalCpu", totalCpu);
        result.put("usedMem", supervisorSummary.get_used_mem());
        result.put("usedCpu", supervisorSummary.get_used_cpu());
        result.put("logLink", UIHelpers.getSupervisorLogLink(supervisorSummary.get_host(), config));
        result.put("availMem", totalMemory - supervisorSummary.get_used_mem());
        result.put("availCpu", totalCpu - supervisorSummary.get_used_cpu());
        result.put("version", supervisorSummary.get_version());
        HashMap<String, Double> totalGenericResources = new HashMap<String, Double>(totalResources);
        result.put("totalGenericResources", UIHelpers.prettifyGenericResources(totalGenericResources));
        Map usedGenericResources = supervisorSummary.get_used_generic_resources();
        result.put("usedGenericResources", UIHelpers.prettifyGenericResources(usedGenericResources));
        Map availGenericResources = NormalizedResourceRequest.subtractResourceMap(totalGenericResources, (Map)usedGenericResources);
        result.put("availGenericResources", UIHelpers.prettifyGenericResources(availGenericResources));
        return result;
    }

    public static Map<String, Object> getTopologyHistoryInfo(TopologyHistoryInfo topologyHistory) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("topo-history", topologyHistory.get_topo_ids());
        return result;
    }

    public static boolean isSecureLogviewer(Map<String, Object> config) {
        int logviewerPort;
        return config.containsKey("logviewer.https.port") && (logviewerPort = ((Integer)config.get("logviewer.https.port")).intValue()) >= 0;
    }

    public static int getLogviewerPort(Map<String, Object> config) {
        if (UIHelpers.isSecureLogviewer(config)) {
            return (Integer)config.get("logviewer.https.port");
        }
        return (Integer)config.get("logviewer.port");
    }

    public static List<Map> getWorkerSummaries(SupervisorPageInfo supervisorPageInfo, Map<String, Object> config) {
        ArrayList<Map> workerSummaries = new ArrayList<Map>();
        if (supervisorPageInfo.is_set_worker_summaries()) {
            for (WorkerSummary workerSummary : supervisorPageInfo.get_worker_summaries()) {
                workerSummaries.add(UIHelpers.getWorkerSummaryMap(workerSummary, config));
            }
        }
        return workerSummaries;
    }

    private static Map getWorkerSummaryMap(WorkerSummary workerSummary, Map<String, Object> config) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("supervisorId", workerSummary.get_supervisor_id());
        result.put("host", workerSummary.get_host());
        result.put("port", workerSummary.get_port());
        result.put("topologyId", workerSummary.get_topology_id());
        result.put("topologyName", workerSummary.get_topology_name());
        result.put("executorsTotal", workerSummary.get_num_executors());
        result.put("assignedMemOnHeap", workerSummary.get_assigned_memonheap());
        result.put("assignedMemOffHeap", workerSummary.get_assigned_memoffheap());
        result.put("assignedCpu", workerSummary.get_assigned_cpu());
        result.put("componentNumTasks", workerSummary.get_component_to_num_tasks());
        result.put("uptime", UIHelpers.prettyUptimeSec(workerSummary.get_uptime_secs()));
        result.put("uptimeSeconds", workerSummary.get_uptime_secs());
        result.put("workerLogLink", UIHelpers.getWorkerLogLink(workerSummary.get_host(), workerSummary.get_port(), config, workerSummary.get_topology_id()));
        result.put("owner", workerSummary.get_owner());
        return result;
    }

    public static Map<String, Object> getSupervisorSummary(List<SupervisorSummary> supervisors, SecurityContext securityContext, Map<String, Object> config) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        UIHelpers.addLogviewerInfo(config, result);
        List<Map> supervisorMaps = UIHelpers.getSupervisorsMap(supervisors, config);
        result.put("supervisors", supervisorMaps);
        result.put("schedulerDisplayResource", config.get("scheduler.display.resource"));
        return result;
    }

    private static List<Map> getSupervisorsMap(List<SupervisorSummary> supervisors, Map<String, Object> config) {
        ArrayList<Map> supervisorMaps = new ArrayList<Map>();
        for (SupervisorSummary supervisorSummary : supervisors) {
            supervisorMaps.add(UIHelpers.getPrettifiedSupervisorMap(supervisorSummary, config));
        }
        return supervisorMaps;
    }

    private static void addLogviewerInfo(Map<String, Object> config, Map<String, Object> result) {
        result.put("logviewerPort", UIHelpers.getLogviewerPort(config));
        String logviewerScheme = "http";
        if (UIHelpers.isSecureLogviewer(config)) {
            logviewerScheme = "https";
        }
        result.put("logviewerScheme", logviewerScheme);
    }

    public static Map<String, Object> getSupervisorPageInfo(SupervisorPageInfo supervisorPageInfo, Map<String, Object> config) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("workers", UIHelpers.getWorkerSummaries(supervisorPageInfo, config));
        result.put("schedulerDisplayResource", config.get("scheduler.display.resource"));
        List<Map> supervisorMaps = UIHelpers.getSupervisorsMap(supervisorPageInfo.get_supervisor_summaries(), config);
        result.put("supervisors", supervisorMaps);
        UIHelpers.addLogviewerInfo(config, result);
        return result;
    }

    public static Map<String, Object> getAllTopologiesSummary(List<TopologySummary> topologies, Map<String, Object> config) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("topologies", UIHelpers.getTopologiesMap(null, topologies));
        result.put("schedulerDisplayResource", config.get("scheduler.display.resource"));
        return result;
    }

    public static String getWindowHint(String window) {
        if (window.equals(":all-time")) {
            return "All time";
        }
        return UIHelpers.prettyUptimeSec(window);
    }

    public static Map<String, Double> getStatDisplayMap(Map<String, Double> rawDisplayMap) {
        HashMap<String, Double> result = new HashMap<String, Double>();
        for (Map.Entry<String, Double> entry : rawDisplayMap.entrySet()) {
            result.put(UIHelpers.getWindowHint(entry.getKey()), entry.getValue());
        }
        return result;
    }

    public static Map<String, Object> getTopologySummary(TopologyPageInfo topologyPageInfo, String window, Map<String, Object> config, String remoteUser) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        Map topologyConf = (Map)JSONValue.parse((String)topologyPageInfo.get_topology_conf());
        int messageTimeout = (Integer)topologyConf.get("topology.message.timeout.secs");
        Map<String, Object> unpackedTopologyPageInfo = UIHelpers.unpackTopologyInfo(topologyPageInfo, window, config);
        result.putAll(unpackedTopologyPageInfo);
        result.put("user", remoteUser);
        result.put("window", window);
        result.put("windowHint", UIHelpers.getWindowHint(window));
        result.put("msgTimeout", messageTimeout);
        result.put("configuration", topologyConf);
        result.put("visualizationTable", new ArrayList());
        result.put("schedulerDisplayResource", config.get("scheduler.display.resource"));
        result.put("bugtracker-url", config.get("ui.project.bugtracker.url"));
        result.put("central-log-url", config.get("ui.central.logging.url"));
        return result;
    }

    private static Map<String, Long> getStatDisplayMapLong(Map<String, Long> windowToTransferred) {
        HashMap<String, Long> result = new HashMap<String, Long>();
        for (Map.Entry<String, Long> entry : windowToTransferred.entrySet()) {
            result.put(entry.getKey(), entry.getValue());
        }
        return result;
    }

    private static Map<String, Object> getCommonAggStatsMap(CommonAggregateStats commonAggregateStats) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("executors", commonAggregateStats.get_num_executors());
        result.put("tasks", commonAggregateStats.get_num_tasks());
        result.put("emitted", commonAggregateStats.get_emitted());
        result.put("transferred", commonAggregateStats.get_transferred());
        result.put("acked", commonAggregateStats.get_acked());
        result.put("failed", commonAggregateStats.get_failed());
        if (commonAggregateStats.is_set_resources_map()) {
            result.put("requestedMemOnHeap", commonAggregateStats.get_resources_map().get("onheap.memory.mb"));
            result.put("requestedMemOffHeap", commonAggregateStats.get_resources_map().get("offheap.memory.mb"));
            result.put("requestedCpu", commonAggregateStats.get_resources_map().get("cpu.pcore.percent"));
            result.put("requestedGenericResourcesComp", UIHelpers.prettifyGenericResources(commonAggregateStats.get_resources_map()));
        }
        return result;
    }

    private static String getTruncatedErrorString(String errorString) {
        return errorString.substring(0, Math.min(errorString.length(), 200));
    }

    private static Map<String, Object> getSpoutAggStatsMap(ComponentAggregateStats componentAggregateStats, String window) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        SpoutAggregateStats spoutAggregateStats = componentAggregateStats.get_specific_stats().get_spout();
        CommonAggregateStats commonStats = componentAggregateStats.get_common_stats();
        result.put("window", window);
        result.put("windowPretty", UIHelpers.getWindowHint(window));
        result.put("emitted", commonStats.get_emitted());
        result.put("transferred", commonStats.get_transferred());
        result.put("acked", commonStats.get_acked());
        result.put("failed", commonStats.get_failed());
        result.put("completeLatency", spoutAggregateStats.get_complete_latency_ms());
        ErrorInfo lastError = componentAggregateStats.get_last_error();
        result.put("lastError", Objects.isNull(lastError) ? "" : UIHelpers.getTruncatedErrorString(lastError.get_error()));
        return result;
    }

    private static Map<String, Object> getBoltAggStatsMap(ComponentAggregateStats componentAggregateStats, String window) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        CommonAggregateStats commonStats = componentAggregateStats.get_common_stats();
        result.put("window", window);
        result.put("windowPretty", UIHelpers.getWindowHint(window));
        result.put("emitted", commonStats.get_emitted());
        result.put("transferred", commonStats.get_transferred());
        result.put("acked", commonStats.get_acked());
        result.put("failed", commonStats.get_failed());
        BoltAggregateStats boltAggregateStats = componentAggregateStats.get_specific_stats().get_bolt();
        result.put("executeLatency", StatsUtil.floatStr((Double)boltAggregateStats.get_execute_latency_ms()));
        result.put("executed", boltAggregateStats.get_executed());
        result.put("processLatency", StatsUtil.floatStr((Double)boltAggregateStats.get_process_latency_ms()));
        result.put("capacity", StatsUtil.floatStr((Double)boltAggregateStats.get_capacity()));
        return result;
    }

    private static Long nullToZero(Long value) {
        return !Objects.isNull(value) ? value : 0L;
    }

    private static Double nullToZero(Double value) {
        return !Objects.isNull(value) ? value : 0.0;
    }

    private static Map<String, Object> getBoltInputStats(GlobalStreamId globalStreamId, ComponentAggregateStats componentAggregateStats) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        SpecificAggregateStats specificAggregateStats = componentAggregateStats.get_specific_stats();
        BoltAggregateStats boltAggregateStats = specificAggregateStats.get_bolt();
        CommonAggregateStats commonAggregateStats = componentAggregateStats.get_common_stats();
        String componentId = globalStreamId.get_componentId();
        result.put("component", componentId);
        result.put("encodedComponentId", Utils.urlEncodeUtf8((String)componentId));
        result.put("stream", globalStreamId.get_streamId());
        result.put("executeLatency", StatsUtil.floatStr((Double)boltAggregateStats.get_execute_latency_ms()));
        result.put("processLatency", StatsUtil.floatStr((Double)boltAggregateStats.get_process_latency_ms()));
        result.put("executed", UIHelpers.nullToZero(boltAggregateStats.get_executed()));
        result.put("acked", UIHelpers.nullToZero(commonAggregateStats.get_acked()));
        result.put("failed", UIHelpers.nullToZero(commonAggregateStats.get_failed()));
        return result;
    }

    private static Map<String, Object> getBoltOutputStats(String streamId, ComponentAggregateStats componentAggregateStats) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("stream", streamId);
        CommonAggregateStats commonStats = componentAggregateStats.get_common_stats();
        result.put("emitted", UIHelpers.nullToZero(commonStats.get_emitted()));
        result.put("transferred", UIHelpers.nullToZero(commonStats.get_transferred()));
        return result;
    }

    private static Map<String, Object> getSpoutOutputStats(String streamId, ComponentAggregateStats componentAggregateStats) {
        SpecificAggregateStats specificAggregateStats = componentAggregateStats.get_specific_stats();
        SpoutAggregateStats spoutAggregateStats = specificAggregateStats.get_spout();
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("stream", streamId);
        CommonAggregateStats commonStats = componentAggregateStats.get_common_stats();
        result.put("emitted", UIHelpers.nullToZero(commonStats.get_emitted()));
        result.put("transferred", UIHelpers.nullToZero(commonStats.get_transferred()));
        result.put("completeLatency", StatsUtil.floatStr((Double)spoutAggregateStats.get_complete_latency_ms()));
        result.put("acked", UIHelpers.nullToZero(commonStats.get_acked()));
        result.put("failed", UIHelpers.nullToZero(commonStats.get_failed()));
        return result;
    }

    private static Map<String, Object> getBoltExecutorStats(String topologyId, Map<String, Object> config, ExecutorAggregateStats executorAggregateStats) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        ExecutorSummary executorSummary = executorAggregateStats.get_exec_summary();
        ExecutorInfo executorInfo = executorSummary.get_executor_info();
        String executorId = UIHelpers.prettyExecutorInfo(executorInfo);
        result.put("id", executorId);
        result.put("encodedId", Utils.urlEncodeUtf8((String)executorId));
        result.put("uptime", UIHelpers.prettyUptimeSec(executorSummary.get_uptime_secs()));
        result.put("uptimeSeconds", executorSummary.get_uptime_secs());
        String host = executorSummary.get_host();
        result.put("host", host);
        int port = executorSummary.get_port();
        result.put("port", port);
        ComponentAggregateStats componentAggregateStats = executorAggregateStats.get_stats();
        CommonAggregateStats commonAggregateStats = componentAggregateStats.get_common_stats();
        result.put("emitted", UIHelpers.nullToZero(commonAggregateStats.get_emitted()));
        result.put("transferred", UIHelpers.nullToZero(commonAggregateStats.get_transferred()));
        SpecificAggregateStats specificAggregateStats = componentAggregateStats.get_specific_stats();
        BoltAggregateStats boltAggregateStats = specificAggregateStats.get_bolt();
        result.put("capacity", StatsUtil.floatStr((Double)UIHelpers.nullToZero(boltAggregateStats.get_capacity())));
        result.put("executeLatency", StatsUtil.floatStr((Double)boltAggregateStats.get_execute_latency_ms()));
        result.put("executed", UIHelpers.nullToZero(boltAggregateStats.get_executed()));
        result.put("processLatency", StatsUtil.floatStr((Double)boltAggregateStats.get_process_latency_ms()));
        result.put("acked", UIHelpers.nullToZero(commonAggregateStats.get_acked()));
        result.put("failed", UIHelpers.nullToZero(commonAggregateStats.get_failed()));
        result.put("workerLogLink", UIHelpers.getWorkerLogLink(host, port, config, topologyId));
        return result;
    }

    private static Map<String, Object> getSpoutExecutorStats(String topologyId, Map<String, Object> config, ExecutorAggregateStats executorAggregateStats) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        ExecutorSummary executorSummary = executorAggregateStats.get_exec_summary();
        ExecutorInfo executorInfo = executorSummary.get_executor_info();
        ComponentAggregateStats componentAggregateStats = executorAggregateStats.get_stats();
        SpecificAggregateStats specificAggregateStats = componentAggregateStats.get_specific_stats();
        SpoutAggregateStats spoutAggregateStats = specificAggregateStats.get_spout();
        CommonAggregateStats commonAggregateStats = componentAggregateStats.get_common_stats();
        String executorId = UIHelpers.prettyExecutorInfo(executorInfo);
        result.put("id", executorId);
        result.put("encodedId", Utils.urlEncodeUtf8((String)executorId));
        result.put("uptime", UIHelpers.prettyUptimeSec(executorSummary.get_uptime_secs()));
        result.put("uptimeSeconds", executorSummary.get_uptime_secs());
        String host = executorSummary.get_host();
        result.put("host", host);
        int port = executorSummary.get_port();
        result.put("port", port);
        result.put("emitted", UIHelpers.nullToZero(commonAggregateStats.get_emitted()));
        result.put("transferred", UIHelpers.nullToZero(commonAggregateStats.get_transferred()));
        result.put("completeLatency", StatsUtil.floatStr((Double)spoutAggregateStats.get_complete_latency_ms()));
        result.put("acked", UIHelpers.nullToZero(commonAggregateStats.get_acked()));
        result.put("failed", UIHelpers.nullToZero(commonAggregateStats.get_failed()));
        result.put("workerLogLink", UIHelpers.getWorkerLogLink(host, port, config, topologyId));
        return result;
    }

    private static Map<String, Object> getComponentLastErrorInfo(ErrorInfo lastError, Map config, String topologyId) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("lastError", "");
        result.put("errorHost", "");
        result.put("errorPort", null);
        result.put("errorWorkerLogLink", "");
        result.put("errorTime", null);
        result.put("errorLapsedSecs", null);
        if (!Objects.isNull(lastError)) {
            result.putAll(UIHelpers.getComponentErrorInfo(lastError, config, topologyId, true));
        }
        return result;
    }

    private static Map<String, Object> getComponentErrorInfo(ErrorInfo errorInfo, Map config, String topologyId, boolean asLastError) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("errorTime", errorInfo.get_error_time_secs());
        String host = errorInfo.get_host();
        result.put("errorHost", host);
        int port = errorInfo.get_port();
        result.put("errorPort", port);
        result.put("errorWorkerLogLink", UIHelpers.getWorkerLogLink(host, port, config, topologyId));
        result.put("errorLapsedSecs", Time.deltaSecs((int)errorInfo.get_error_time_secs()));
        if (asLastError) {
            result.put("lastError", UIHelpers.getTruncatedErrorString(errorInfo.get_error()));
        } else {
            result.put("error", errorInfo.get_error());
        }
        return result;
    }

    private static Map<String, Object> getComponentErrors(List<ErrorInfo> errorInfoList, String topologyId, Map config) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        errorInfoList.sort(Comparator.comparingInt(ErrorInfo::get_error_time_secs));
        result.put("componentErrors", errorInfoList.stream().map(e -> UIHelpers.getComponentErrorInfo(e, config, topologyId, false)).collect(Collectors.toList()));
        return result;
    }

    private static Map<String, Object> getTopologyErrors(List<ErrorInfo> errorInfoList, String topologyId, Map config) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        errorInfoList.sort(Comparator.comparingInt(ErrorInfo::get_error_time_secs));
        result.put("topologyErrors", errorInfoList.stream().map(e -> UIHelpers.getComponentErrorInfo(e, config, topologyId, false)).collect(Collectors.toList()));
        return result;
    }

    private static Map<String, Object> getTopologySpoutAggStatsMap(ComponentAggregateStats componentAggregateStats, String spoutId, Map<String, Object> config, String topologyId) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        CommonAggregateStats commonStats = componentAggregateStats.get_common_stats();
        result.putAll(UIHelpers.getCommonAggStatsMap(commonStats));
        result.put("spoutId", spoutId);
        result.put("encodedSpoutId", Utils.urlEncodeUtf8((String)spoutId));
        SpoutAggregateStats spoutAggregateStats = componentAggregateStats.get_specific_stats().get_spout();
        result.put("completeLatency", StatsUtil.floatStr((Double)spoutAggregateStats.get_complete_latency_ms()));
        result.putAll(UIHelpers.getComponentLastErrorInfo(componentAggregateStats.get_last_error(), config, topologyId));
        return result;
    }

    private static Map<String, Object> getTopologyBoltAggStatsMap(ComponentAggregateStats componentAggregateStats, String boltId, Map<String, Object> config, String topologyId) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        CommonAggregateStats commonStats = componentAggregateStats.get_common_stats();
        result.putAll(UIHelpers.getCommonAggStatsMap(commonStats));
        result.put("boltId", boltId);
        result.put("encodedBoltId", Utils.urlEncodeUtf8((String)boltId));
        BoltAggregateStats boltAggregateStats = componentAggregateStats.get_specific_stats().get_bolt();
        result.put("capacity", StatsUtil.floatStr((Double)boltAggregateStats.get_capacity()));
        result.put("executeLatency", StatsUtil.floatStr((Double)boltAggregateStats.get_execute_latency_ms()));
        result.put("executed", boltAggregateStats.get_executed());
        result.put("processLatency", StatsUtil.floatStr((Double)boltAggregateStats.get_process_latency_ms()));
        result.putAll(UIHelpers.getComponentLastErrorInfo(componentAggregateStats.get_last_error(), config, topologyId));
        return result;
    }

    private static List<Map> getTopologyStatsMap(TopologyStats topologyStats) {
        ArrayList<Map> result = new ArrayList<Map>();
        Map<String, Long> emittedStatDisplayMap = UIHelpers.getStatDisplayMapLong(topologyStats.get_window_to_emitted());
        Map<String, Long> transferred = UIHelpers.getStatDisplayMapLong(topologyStats.get_window_to_transferred());
        Map<String, Double> completeLatency = UIHelpers.getStatDisplayMap(topologyStats.get_window_to_complete_latencies_ms());
        Map<String, Long> acked = UIHelpers.getStatDisplayMapLong(topologyStats.get_window_to_acked());
        Map<String, Long> failed = UIHelpers.getStatDisplayMapLong(topologyStats.get_window_to_failed());
        for (String window : emittedStatDisplayMap.keySet()) {
            HashMap<String, Object> temp = new HashMap<String, Object>();
            temp.put("windowPretty", UIHelpers.getWindowHint(window));
            temp.put("window", window);
            temp.put("emitted", emittedStatDisplayMap.get(window));
            temp.put("transferred", transferred.get(window));
            temp.put("completeLatency", StatsUtil.floatStr((Double)completeLatency.get(UIHelpers.getWindowHint(window))));
            temp.put("acked", acked.getOrDefault(window, 0L));
            temp.put("failed", failed.getOrDefault(window, 0L));
            result.add(temp);
        }
        return result;
    }

    private static Map<String, Object> unpackTopologyInfo(TopologyPageInfo topologyPageInfo, String window, Map<String, Object> config) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("id", topologyPageInfo.get_id());
        result.put("encodedId", Utils.urlEncodeUtf8((String)topologyPageInfo.get_id()));
        result.put("owner", topologyPageInfo.get_owner());
        result.put("name", topologyPageInfo.get_name());
        result.put("status", topologyPageInfo.get_status());
        result.put("uptime", UIHelpers.prettyUptimeSec(topologyPageInfo.get_uptime_secs()));
        result.put("uptimeSeconds", topologyPageInfo.get_uptime_secs());
        result.put("tasksTotal", topologyPageInfo.get_num_tasks());
        result.put("workersTotal", topologyPageInfo.get_num_workers());
        result.put("executorsTotal", topologyPageInfo.get_num_executors());
        result.put("schedulerInfo", topologyPageInfo.get_sched_status());
        result.put("requestedMemOnHeap", topologyPageInfo.get_requested_memonheap());
        result.put("requestedMemOffHeap", topologyPageInfo.get_requested_memoffheap());
        result.put("requestedCpu", topologyPageInfo.get_requested_cpu());
        result.put("requestedTotalMem", topologyPageInfo.get_requested_memonheap() + topologyPageInfo.get_requested_memoffheap());
        result.put("assignedMemOnHeap", topologyPageInfo.get_assigned_memonheap());
        result.put("assignedMemOffHeap", topologyPageInfo.get_assigned_memoffheap());
        result.put("assignedTotalMem", topologyPageInfo.get_assigned_memonheap() + topologyPageInfo.get_assigned_memoffheap());
        result.put("assignedCpu", topologyPageInfo.get_assigned_cpu());
        result.put("requestedRegularOnHeapMem", topologyPageInfo.get_requested_regular_on_heap_memory());
        result.put("requestedSharedOnHeapMem", topologyPageInfo.get_requested_shared_on_heap_memory());
        result.put("requestedRegularOffHeapMem", topologyPageInfo.get_requested_regular_off_heap_memory());
        result.put("requestedSharedOffHeapMem", topologyPageInfo.get_requested_shared_off_heap_memory());
        result.put("requestedGenericResources", UIHelpers.prettifyGenericResources(topologyPageInfo.get_requested_generic_resources()));
        result.put("assignedRegularOnHeapMem", topologyPageInfo.get_assigned_regular_on_heap_memory());
        result.put("assignedSharedOnHeapMem", topologyPageInfo.get_assigned_shared_on_heap_memory());
        result.put("assignedRegularOffHeapMem", topologyPageInfo.get_assigned_regular_off_heap_memory());
        result.put("assignedSharedOffHeapMem", topologyPageInfo.get_assigned_shared_off_heap_memory());
        result.put("assignedGenericResources", UIHelpers.prettifyGenericResources(topologyPageInfo.get_assigned_generic_resources()));
        result.put("topologyStats", UIHelpers.getTopologyStatsMap(topologyPageInfo.get_topology_stats()));
        ArrayList<Map> workerSummaries = new ArrayList<Map>();
        if (topologyPageInfo.is_set_workers()) {
            for (WorkerSummary workerSummary : topologyPageInfo.get_workers()) {
                workerSummaries.add(UIHelpers.getWorkerSummaryMap(workerSummary, config));
            }
        }
        result.put("workers", workerSummaries);
        Map spouts = topologyPageInfo.get_id_to_spout_agg_stats();
        ArrayList<Map<String, Object>> spoutStats = new ArrayList<Map<String, Object>>();
        for (Map.Entry spoutEntry : spouts.entrySet()) {
            spoutStats.add(UIHelpers.getTopologySpoutAggStatsMap((ComponentAggregateStats)spoutEntry.getValue(), (String)spoutEntry.getKey(), config, topologyPageInfo.get_id()));
        }
        result.put("spouts", spoutStats);
        Map bolts = topologyPageInfo.get_id_to_bolt_agg_stats();
        ArrayList<Map<String, Object>> boltStats = new ArrayList<Map<String, Object>>();
        for (Map.Entry boltEntry : bolts.entrySet()) {
            boltStats.add(UIHelpers.getTopologyBoltAggStatsMap((ComponentAggregateStats)boltEntry.getValue(), (String)boltEntry.getKey(), config, topologyPageInfo.get_id()));
        }
        result.put("bolts", boltStats);
        result.put("configuration", topologyPageInfo.get_topology_conf());
        boolean debuggingEnabled = false;
        if (topologyPageInfo.is_set_debug_options()) {
            debuggingEnabled = topologyPageInfo.get_debug_options().is_enable();
        }
        result.put("debug", debuggingEnabled);
        double samplingPct = 10.0;
        if (debuggingEnabled) {
            samplingPct = topologyPageInfo.get_debug_options().get_samplingpct();
        }
        result.put("samplingPct", samplingPct);
        result.put("replicationCount", topologyPageInfo.get_replication_count());
        result.put("topologyVersion", topologyPageInfo.get_topology_version());
        result.put("stormVersion", topologyPageInfo.get_storm_version());
        return result;
    }

    public static Map<String, Object> getTopologyWorkers(TopologyInfo topologyInfo, Map config) {
        ArrayList executorSummaries = new ArrayList();
        for (ExecutorSummary executorSummary : topologyInfo.get_executors()) {
            HashMap<String, Object> executorSummaryMap = new HashMap<String, Object>();
            executorSummaryMap.put("host", executorSummary.get_host());
            executorSummaryMap.put("port", executorSummary.get_port());
            executorSummaries.add(executorSummaryMap);
        }
        HashSet hashSet = new HashSet();
        hashSet.addAll(executorSummaries);
        executorSummaries.clear();
        executorSummaries.addAll(hashSet);
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("hostPortList", executorSummaries);
        UIHelpers.addLogviewerInfo(config, result);
        return result;
    }

    public static Map<String, Map<String, Object>> getTopologyLag(StormTopology userTopology, Map<String, Object> config) {
        Boolean disableLagMonitoring = (Boolean)config.get("ui.disable.spout.lag.monitoring");
        return disableLagMonitoring != false ? Collections.EMPTY_MAP : TopologySpoutLag.lag((StormTopology)userTopology, config);
    }

    public static Map<String, List<ExecutorSummary>> getBoltExecutors(List<ExecutorSummary> executorSummaries, StormTopology stormTopology, boolean sys) {
        HashMap<String, List<ExecutorSummary>> result = new HashMap<String, List<ExecutorSummary>>();
        for (ExecutorSummary executorSummary : executorSummaries) {
            if (!StatsUtil.componentType((StormTopology)stormTopology, (String)executorSummary.get_component_id()).equals("bolt") || !sys && Utils.isSystemId((String)executorSummary.get_component_id())) continue;
            List executorSummaryList = result.getOrDefault(executorSummary.get_component_id(), new ArrayList());
            executorSummaryList.add(executorSummary);
            result.put(executorSummary.get_component_id(), executorSummaryList);
        }
        return result;
    }

    public static Map<String, List<ExecutorSummary>> getSpoutExecutors(List<ExecutorSummary> executorSummaries, StormTopology stormTopology) {
        HashMap<String, List<ExecutorSummary>> result = new HashMap<String, List<ExecutorSummary>>();
        for (ExecutorSummary executorSummary : executorSummaries) {
            if (!StatsUtil.componentType((StormTopology)stormTopology, (String)executorSummary.get_component_id()).equals("spout")) continue;
            List executorSummaryList = result.getOrDefault(executorSummary.get_component_id(), new ArrayList());
            executorSummaryList.add(executorSummary);
            result.put(executorSummary.get_component_id(), executorSummaryList);
        }
        return result;
    }

    public static String sanitizeStreamName(String streamName) {
        Matcher problemCharacterMatcher = Pattern.compile("(?![A-Za-z_\\-\\.]).").matcher(streamName);
        if (streamName.length() > 0 && Character.isLetter(streamName.charAt(0))) {
            return problemCharacterMatcher.replaceAll("_");
        }
        return "_s" + problemCharacterMatcher.replaceAll("_");
    }

    public static Map<String, Map<String, Long>> sanitizeTransferredStats(Map<String, Map<String, Long>> stats) {
        HashMap<String, Map<String, Long>> result = new HashMap<String, Map<String, Long>>();
        for (Map.Entry<String, Map<String, Long>> entry : stats.entrySet()) {
            HashMap<String, Long> temp = new HashMap<String, Long>();
            for (Map.Entry<String, Long> innerEntry : entry.getValue().entrySet()) {
                temp.put(UIHelpers.sanitizeStreamName(innerEntry.getKey()), innerEntry.getValue());
            }
            result.put(entry.getKey(), temp);
        }
        return result;
    }

    public static Map<String, Object> getStatMapFromExecutorSummary(ExecutorSummary executorSummary) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put(":host", executorSummary.get_host());
        result.put(":port", executorSummary.get_port());
        result.put(":uptime_secs", executorSummary.get_uptime_secs());
        result.put(":transferred", null);
        if (executorSummary.is_set_stats()) {
            result.put(":transferred", UIHelpers.sanitizeTransferredStats(executorSummary.get_stats().get_transferred()));
        }
        return result;
    }

    public static Map<String, Object> getInputMap(Map.Entry<GlobalStreamId, Grouping> entryInput) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put(":component", entryInput.getKey().get_componentId());
        result.put(":stream", entryInput.getKey().get_streamId());
        result.put(":sani-stream", UIHelpers.sanitizeStreamName(entryInput.getKey().get_streamId()));
        result.put(":grouping", ((Grouping._Fields)entryInput.getValue().getSetField()).getFieldName());
        return result;
    }

    public static Map<String, Object> getVisualizationData(Nimbus.Iface client, String window, String topoId, boolean sys) throws TException {
        GetInfoOptions getInfoOptions = new GetInfoOptions();
        getInfoOptions.set_num_err_choice(NumErrorsChoice.ONE);
        TopologyInfo topologyInfo = client.getTopologyInfoWithOpts(topoId, getInfoOptions);
        StormTopology stormTopology = client.getTopology(topoId);
        Map<String, List<ExecutorSummary>> boltSummaries = UIHelpers.getBoltExecutors(topologyInfo.get_executors(), stormTopology, sys);
        Map<String, List<ExecutorSummary>> spoutSummaries = UIHelpers.getSpoutExecutors(topologyInfo.get_executors(), stormTopology);
        Map spoutSpecs = stormTopology.get_spouts();
        Map boltSpecs = stormTopology.get_bolts();
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (Map.Entry spoutSpecMapEntry : spoutSpecs.entrySet()) {
            String spoutComponentId = (String)spoutSpecMapEntry.getKey();
            if (!spoutSummaries.containsKey(spoutComponentId)) continue;
            HashMap<String, Object> spoutData = new HashMap<String, Object>();
            spoutData.put(":type", "spout");
            spoutData.put(":capacity", 0);
            Map spoutStreamsStats = StatsUtil.spoutStreamsStats(spoutSummaries.get(spoutComponentId), (boolean)sys);
            spoutData.put(":latency", ((Map)spoutStreamsStats.get("complete-latencies")).get(window));
            spoutData.put(":transferred", ((Map)spoutStreamsStats.get("transferred")).get(window));
            spoutData.put(":stats", spoutSummaries.get(spoutComponentId).stream().map(UIHelpers::getStatMapFromExecutorSummary).collect(Collectors.toList()));
            spoutData.put(":link", UIHelpers.urlFormat("/component.html?id=%s&topology_id=%s", spoutComponentId, topoId));
            spoutData.put(":inputs", ((SpoutSpec)spoutSpecMapEntry.getValue()).get_common().get_inputs().entrySet().stream().map(UIHelpers::getInputMap).collect(Collectors.toList()));
            result.put(spoutComponentId, spoutData);
        }
        for (Map.Entry boltEntry : boltSpecs.entrySet()) {
            String boltComponentId = (String)boltEntry.getKey();
            if (!boltSummaries.containsKey(boltComponentId) || !sys && Utils.isSystemId((String)boltComponentId)) continue;
            HashMap<String, Object> boltMap = new HashMap<String, Object>();
            boltMap.put(":type", "bolt");
            boltMap.put(":capacity", StatsUtil.computeBoltCapacity(boltSummaries.get(boltComponentId)));
            Map boltStreamsStats = StatsUtil.boltStreamsStats(boltSummaries.get(boltComponentId), (boolean)sys);
            boltMap.put(":latency", ((Map)boltStreamsStats.get("process-latencies")).get(window));
            boltMap.put(":transferred", ((Map)boltStreamsStats.get("transferred")).get(window));
            boltMap.put(":stats", boltSummaries.get(boltComponentId).stream().map(UIHelpers::getStatMapFromExecutorSummary).collect(Collectors.toList()));
            boltMap.put(":link", UIHelpers.urlFormat("/component.html?id=%s&topology_id=%s", boltComponentId, topoId));
            boltMap.put(":inputs", ((Bolt)boltEntry.getValue()).get_common().get_inputs().entrySet().stream().map(UIHelpers::getInputMap).collect(Collectors.toList()));
            result.put(boltComponentId, boltMap);
        }
        return result;
    }

    public static Map<String, Object> getStreamBox(Object visualization) {
        Map visualizationData = (Map)visualization;
        HashMap<String, Object> result = new HashMap<String, Object>();
        Map temp = (Map)visualizationData.get("inputs");
        result.put("stream", temp.get("stream"));
        result.put("sani-stream", temp.get("sani-stream"));
        result.put("checked", !Utils.isSystemId((String)((String)temp.get("stream"))));
        return result;
    }

    public static Map<String, Object> getBuildVisualization(Nimbus.Iface client, Map<String, Object> config, String window, String id, boolean sys) throws TException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        Map<String, Object> visualizationData = UIHelpers.getVisualizationData(client, window, id, sys);
        List streamBoxes = visualizationData.entrySet().stream().map(UIHelpers::getStreamBox).collect(Collectors.toList());
        result.put("visualizationTable", Lists.partition(streamBoxes, (int)4));
        return result;
    }

    public static Map<String, Object> getActiveAction(ProfileRequest profileRequest, Map config, String topologyId) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("host", profileRequest.get_nodeInfo().get_node());
        result.put("port", String.valueOf(profileRequest.get_nodeInfo().get_port().toArray()[0]));
        result.put("dumplink", UIHelpers.getWorkerDumpLink(profileRequest.get_nodeInfo().get_node(), (Long)profileRequest.get_nodeInfo().get_port().toArray()[0], topologyId, config));
        result.put("timestamp", System.currentTimeMillis() - profileRequest.get_time_stamp());
        return result;
    }

    public static List getActiveProfileActions(Nimbus.Iface client, String id, String component, Map config) throws TException {
        List profileRequests = client.getComponentPendingProfileActions(id, component, ProfileAction.JPROFILE_STOP);
        return profileRequests.stream().map(x -> UIHelpers.getActiveAction(x, config, id)).collect(Collectors.toList());
    }

    public static String getWorkerDumpLink(String host, long port, String topologyId, Map<String, Object> config) {
        if (UIHelpers.isSecureLogviewer(config)) {
            return UIHelpers.urlFormat("https://%s:%s/api/v1/dumps/%s/%s", Utils.urlEncodeUtf8((String)host), config.get("logviewer.https.port"), Utils.urlEncodeUtf8((String)topologyId), Utils.urlEncodeUtf8((String)host) + ":" + Utils.urlEncodeUtf8((String)String.valueOf(port)));
        }
        return UIHelpers.urlFormat("http://%s:%s/api/v1/dumps/%s/%s", Utils.urlEncodeUtf8((String)host), config.get("logviewer.port"), Utils.urlEncodeUtf8((String)topologyId), Utils.urlEncodeUtf8((String)host) + ":" + Utils.urlEncodeUtf8((String)String.valueOf(port)));
    }

    public static Map<String, Object> unpackBoltPageInfo(ComponentPageInfo componentPageInfo, String topologyId, String window, boolean sys, Map config) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("boltStats", componentPageInfo.get_window_to_stats().entrySet().stream().map(e -> UIHelpers.getBoltAggStatsMap((ComponentAggregateStats)e.getValue(), (String)e.getKey())).collect(Collectors.toList()));
        result.put("inputStats", componentPageInfo.get_gsid_to_input_stats().entrySet().stream().map(e -> UIHelpers.getBoltInputStats((GlobalStreamId)e.getKey(), (ComponentAggregateStats)e.getValue())).collect(Collectors.toList()));
        result.put("outputStats", componentPageInfo.get_sid_to_output_stats().entrySet().stream().map(e -> UIHelpers.getBoltOutputStats((String)e.getKey(), (ComponentAggregateStats)e.getValue())).collect(Collectors.toList()));
        result.put("executorStats", componentPageInfo.get_exec_stats().stream().map(e -> UIHelpers.getBoltExecutorStats(topologyId, config, e)).collect(Collectors.toList()));
        result.putAll(UIHelpers.getComponentErrors(componentPageInfo.get_errors(), topologyId, config));
        return result;
    }

    public static Map<String, Object> unpackSpoutPageInfo(ComponentPageInfo componentPageInfo, String topologyId, String window, boolean sys, Map config) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("spoutSummary", componentPageInfo.get_window_to_stats().entrySet().stream().map(e -> UIHelpers.getSpoutAggStatsMap((ComponentAggregateStats)e.getValue(), (String)e.getKey())).collect(Collectors.toList()));
        result.put("outputStats", componentPageInfo.get_sid_to_output_stats().entrySet().stream().map(e -> UIHelpers.getSpoutOutputStats((String)e.getKey(), (ComponentAggregateStats)e.getValue())).collect(Collectors.toList()));
        result.put("executorStats", componentPageInfo.get_exec_stats().stream().map(e -> UIHelpers.getSpoutExecutorStats(topologyId, config, e)).collect(Collectors.toList()));
        result.putAll(UIHelpers.getComponentErrors(componentPageInfo.get_errors(), topologyId, config));
        return result;
    }

    public static Map<String, Object> getComponentPage(Nimbus.Iface client, String id, String component, String window, boolean sys, String user, Map config) throws TException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        ComponentPageInfo componentPageInfo = client.getComponentPageInfo(id, component, window, sys);
        if (componentPageInfo.get_component_type().equals((Object)ComponentType.BOLT)) {
            result.putAll(UIHelpers.unpackBoltPageInfo(componentPageInfo, id, window, sys, config));
        } else if (componentPageInfo.get_component_type().equals((Object)ComponentType.SPOUT)) {
            result.putAll(UIHelpers.unpackSpoutPageInfo(componentPageInfo, id, window, sys, config));
        }
        result.put("user", user);
        result.put("id", component);
        result.put("encodedId", Utils.urlEncodeUtf8((String)component));
        result.put("name", componentPageInfo.get_topology_name());
        result.put("executors", componentPageInfo.get_num_executors());
        result.put("tasks", componentPageInfo.get_num_tasks());
        result.put("requestedMemOnHeap", componentPageInfo.get_resources_map().get("onheap.memory.mb"));
        result.put("requestedMemOffHeap", componentPageInfo.get_resources_map().get("offheap.memory.mb"));
        result.put("requestedCpu", componentPageInfo.get_resources_map().get("cpu.pcore.percent"));
        result.put("requestedGenericResources", UIHelpers.prettifyGenericResources(componentPageInfo.get_resources_map()));
        result.put("schedulerDisplayResource", config.get("scheduler.display.resource"));
        result.put("topologyId", id);
        result.put("topologyStatus", componentPageInfo.get_topology_status());
        result.put("encodedTopologyId", Utils.urlEncodeUtf8((String)id));
        result.put("window", window);
        result.put("componentType", componentPageInfo.get_component_type().toString().toLowerCase());
        result.put("windowHint", UIHelpers.getWindowHint(window));
        result.put("debug", componentPageInfo.is_set_debug_options() && componentPageInfo.get_debug_options().is_enable());
        double samplingPct = 10.0;
        if (componentPageInfo.is_set_debug_options()) {
            samplingPct = componentPageInfo.get_debug_options().get_samplingpct();
        }
        result.put("samplingPct", samplingPct);
        String eventlogHost = componentPageInfo.get_eventlog_host();
        if (null != eventlogHost && !eventlogHost.isEmpty()) {
            result.put("eventLogLink", UIHelpers.getLogviewerLink(eventlogHost, WebAppUtils.eventLogsFilename((String)id, (String)String.valueOf(componentPageInfo.get_eventlog_port())), config, componentPageInfo.get_eventlog_port()));
        }
        result.put("profilingAndDebuggingCapable", !Utils.isOnWindows());
        result.put("profileActionEnabled", config.get("worker.profiler.enabled"));
        result.put("profilerActive", UIHelpers.getActiveProfileActions(client, id, component, config));
        return result;
    }

    public static Map<String, Object> getTopolgoyLogConfig(LogConfig logConfig) {
        HashMap result = new HashMap();
        if (logConfig.is_set_named_logger_level()) {
            for (Map.Entry entry : logConfig.get_named_logger_level().entrySet()) {
                HashMap<String, Object> temp = new HashMap<String, Object>();
                temp.put("target_level", ((LogLevel)entry.getValue()).get_target_log_level());
                temp.put("reset_level", ((LogLevel)entry.getValue()).get_reset_log_level());
                temp.put("timeout", ((LogLevel)entry.getValue()).get_reset_log_level_timeout_secs());
                temp.put("timeout_epoch", ((LogLevel)entry.getValue()).get_reset_log_level_timeout_epoch());
                result.put((String)entry.getKey(), temp);
            }
        }
        HashMap<String, Object> finalResult = new HashMap<String, Object>();
        finalResult.put("namedLoggerLevels", result);
        return finalResult;
    }

    public static Map<String, Object> getTopologyOpResponse(String id, String op) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("topologyOperation", op);
        result.put("topologyId", id);
        result.put("status", "success");
        return result;
    }

    public static Map<String, Object> putTopologyActivate(Nimbus.Iface client, String id) throws TException {
        GetInfoOptions getInfoOptions = new GetInfoOptions();
        getInfoOptions.set_num_err_choice(NumErrorsChoice.NONE);
        TopologyInfo topologyInfo = client.getTopologyInfoWithOpts(id, getInfoOptions);
        client.activate(topologyInfo.get_name());
        return UIHelpers.getTopologyOpResponse(id, "activate");
    }

    public static Map<String, Object> putTopologyDeactivate(Nimbus.Iface client, String id) throws TException {
        GetInfoOptions getInfoOptions = new GetInfoOptions();
        getInfoOptions.set_num_err_choice(NumErrorsChoice.NONE);
        TopologyInfo topologyInfo = client.getTopologyInfoWithOpts(id, getInfoOptions);
        client.deactivate(topologyInfo.get_name());
        return UIHelpers.getTopologyOpResponse(id, "deactivate");
    }

    public static Map<String, Object> putTopologyDebugActionSpct(Nimbus.Iface client, String id, String action, String spct, String component) throws TException {
        GetInfoOptions getInfoOptions = new GetInfoOptions();
        getInfoOptions.set_num_err_choice(NumErrorsChoice.NONE);
        TopologyInfo topologyInfo = client.getTopologyInfoWithOpts(id, getInfoOptions);
        client.debug(topologyInfo.get_name(), component, action.equals("enable"), (double)Integer.parseInt(spct));
        return UIHelpers.getTopologyOpResponse(id, "debug/" + action);
    }

    public static Map<String, Object> putTopologyRebalance(Nimbus.Iface client, String id, String waitTime) throws TException {
        GetInfoOptions getInfoOptions = new GetInfoOptions();
        getInfoOptions.set_num_err_choice(NumErrorsChoice.NONE);
        TopologyInfo topologyInfo = client.getTopologyInfoWithOpts(id, getInfoOptions);
        RebalanceOptions rebalanceOptions = new RebalanceOptions();
        rebalanceOptions.set_wait_secs(Integer.parseInt(waitTime));
        client.rebalance(topologyInfo.get_name(), rebalanceOptions);
        return UIHelpers.getTopologyOpResponse(id, "rebalance");
    }

    public static Map<String, Object> putTopologyKill(Nimbus.Iface client, String id, String waitTime) throws TException {
        GetInfoOptions getInfoOptions = new GetInfoOptions();
        getInfoOptions.set_num_err_choice(NumErrorsChoice.NONE);
        TopologyInfo topologyInfo = client.getTopologyInfoWithOpts(id, getInfoOptions);
        KillOptions killOptions = new KillOptions();
        killOptions.set_wait_secs(Integer.parseInt(waitTime));
        client.killTopologyWithOpts(topologyInfo.get_name(), killOptions);
        return UIHelpers.getTopologyOpResponse(id, "kill");
    }

    public static void setTopologyProfilingAction(Nimbus.Iface client, String id, String hostPort, Long timestamp, Map<String, Object> config, ProfileAction profileAction) throws TException {
        String host = hostPort.split(":")[0];
        HashSet<Long> ports = new HashSet<Long>();
        String port = hostPort.split(":")[1];
        ports.add(Long.valueOf(port));
        NodeInfo nodeInfo = new NodeInfo(host, ports);
        ProfileRequest profileRequest = new ProfileRequest(nodeInfo, profileAction);
        profileRequest.set_time_stamp(timestamp.longValue());
        client.setWorkerProfiler(id, profileRequest);
    }

    public static Map<String, Object> getTopologyProfilingStart(Nimbus.Iface client, String id, String hostPort, String timeout, Map<String, Object> config) throws TException {
        UIHelpers.setTopologyProfilingAction(client, id, hostPort, System.currentTimeMillis() + Long.valueOf(timeout) * 60000L, config, ProfileAction.JPROFILE_STOP);
        HashMap<String, Object> result = new HashMap<String, Object>();
        String host = hostPort.split(":")[0];
        String port = hostPort.split(":")[1];
        result.put("status", "ok");
        result.put("id", hostPort);
        result.put("timeout", timeout);
        result.put("dumplink", UIHelpers.getWorkerDumpLink(host, Long.valueOf(port), id, config));
        return result;
    }

    public static Map<String, Object> getTopologyProfilingStop(Nimbus.Iface client, String id, String hostPort, Map<String, Object> config) throws TException {
        UIHelpers.setTopologyProfilingAction(client, id, hostPort, 0L, config, ProfileAction.JPROFILE_STOP);
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("status", "ok");
        result.put("id", hostPort);
        return result;
    }

    public static Map<String, Object> getProfilingDisabled() {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("status", "disabled");
        result.put("message", "Profiling is not enabled on this server");
        return result;
    }

    public static Map<String, Object> getTopologyProfilingDump(Nimbus.Iface client, String id, String hostPort, Map<String, Object> config) throws TException {
        UIHelpers.setTopologyProfilingAction(client, id, hostPort, System.currentTimeMillis(), config, ProfileAction.JPROFILE_DUMP);
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("status", "ok");
        result.put("id", hostPort);
        return result;
    }

    public static Map<String, Object> getTopologyProfilingDumpJstack(Nimbus.Iface client, String id, String hostPort, Map<String, Object> config) throws TException {
        UIHelpers.setTopologyProfilingAction(client, id, hostPort, System.currentTimeMillis(), config, ProfileAction.JSTACK_DUMP);
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("status", "ok");
        result.put("id", hostPort);
        return result;
    }

    public static Map<String, Object> getTopologyProfilingRestartWorker(Nimbus.Iface client, String id, String hostPort, Map<String, Object> config) throws TException {
        UIHelpers.setTopologyProfilingAction(client, id, hostPort, System.currentTimeMillis(), config, ProfileAction.JVM_RESTART);
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("status", "ok");
        result.put("id", hostPort);
        return result;
    }

    public static Map<String, Object> getTopologyProfilingDumpHeap(Nimbus.Iface client, String id, String hostPort, Map<String, Object> config) throws TException {
        UIHelpers.setTopologyProfilingAction(client, id, hostPort, System.currentTimeMillis(), config, ProfileAction.JMAP_DUMP);
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("status", "ok");
        result.put("id", hostPort);
        return result;
    }

    public static Map<String, Object> putTopologyLogLevel(Nimbus.Iface client, Map<String, Map> namedLogLevel, String id) throws TException {
        Map<String, Map> namedLoggerlevels = namedLogLevel;
        for (Map.Entry<String, Map> entry : namedLoggerlevels.entrySet()) {
            String loggerNMame = entry.getKey();
            String targetLevel = (String)entry.getValue().get("target_level");
            long timeout = ((Number)entry.getValue().get("timeout")).longValue();
            LogLevel logLevel = new LogLevel();
            if (targetLevel == null) {
                logLevel.set_action(LogLevelAction.REMOVE);
                logLevel.unset_target_log_level();
            } else {
                logLevel.set_action(LogLevelAction.UPDATE);
                logLevel.set_target_log_level(Level.toLevel((String)targetLevel).name());
                logLevel.set_reset_log_level_timeout_secs(Math.toIntExact(timeout));
            }
            LogConfig logConfig = new LogConfig();
            logConfig.put_to_named_logger_level(loggerNMame, logLevel);
            client.setLogConfig(id, logConfig);
        }
        return UIHelpers.getTopolgoyLogConfig(client.getLogConfig(id));
    }

    public static Map<String, Object> getNimbusSummary(ClusterSummary clusterInfo, Map<String, Object> config) {
        HashMap<String, Object> nimbusSummaryMap;
        List nimbusSummaries = clusterInfo.get_nimbuses();
        ArrayList<CallSite> nimbusSeeds = new ArrayList<CallSite>();
        for (Object nimbusHost : (List)config.get("nimbus.seeds")) {
            if (Utils.isLocalhostAddress((String)nimbusHost)) continue;
            nimbusSeeds.add((CallSite)((Object)(nimbusHost + ":" + String.valueOf(config.get("nimbus.thrift.port")))));
        }
        ArrayList resultSummaryList = new ArrayList();
        for (NimbusSummary nimbusSummary : nimbusSummaries) {
            nimbusSummaryMap = new HashMap<String, Object>();
            nimbusSummaryMap.put("host", nimbusSummary.get_host());
            nimbusSummaryMap.put("port", nimbusSummary.get_port());
            String status = "Not a Leader";
            if (nimbusSummary.is_isLeader()) {
                status = "Leader";
            }
            nimbusSummaryMap.put("status", status);
            nimbusSummaryMap.put("version", nimbusSummary.get_version());
            nimbusSummaryMap.put("nimbusUpTimeSeconds", nimbusSummary.get_uptime_secs());
            nimbusSummaryMap.put("nimbusUpTime", UIHelpers.prettyUptimeSec(nimbusSummary.get_uptime_secs()));
            nimbusSummaryMap.put("nimbusLogLink", UIHelpers.getNimbusLogLink(nimbusSummary.get_host(), config));
            resultSummaryList.add(nimbusSummaryMap);
            nimbusSeeds.remove(nimbusSummary.get_host() + ":" + String.valueOf(nimbusSummary.get_port()));
        }
        for (String string : nimbusSeeds) {
            nimbusSummaryMap = new HashMap();
            nimbusSummaryMap.put("host", string.split(":")[0]);
            nimbusSummaryMap.put("port", string.split(":")[1]);
            nimbusSummaryMap.put("status", "Offline");
            nimbusSummaryMap.put("version", "Not applicable");
            nimbusSummaryMap.put("nimbusUpTimeSeconds", "Not applicable");
            nimbusSummaryMap.put("nimbusUpTime", "Not applicable");
            nimbusSummaryMap.put("nimbusLogLink", UIHelpers.getNimbusLogLink(string.split(":")[0], config));
            resultSummaryList.add(nimbusSummaryMap);
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("nimbuses", resultSummaryList);
        return result;
    }
}

