/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.security.auth;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Map;
import java.util.UUID;
import org.apache.storm.security.auth.ClientAuthUtils;
import org.apache.storm.security.auth.ITransportPlugin;
import org.apache.storm.security.auth.TBackoffConnect;
import org.apache.storm.security.auth.ThriftConnectionType;
import org.apache.storm.thrift.protocol.TBinaryProtocol;
import org.apache.storm.thrift.protocol.TProtocol;
import org.apache.storm.thrift.transport.TSSLTransportFactory;
import org.apache.storm.thrift.transport.TSocket;
import org.apache.storm.thrift.transport.TTransport;
import org.apache.storm.utils.ObjectReader;
import org.apache.storm.utils.SecurityUtils;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.openssl.PEMKeyPair;
import org.bouncycastle.openssl.PEMParser;
import org.bouncycastle.openssl.jcajce.JcaPEMKeyConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThriftClient
implements AutoCloseable {
    protected TProtocol protocol;
    protected boolean retryForever = false;
    private TTransport transport;
    private String host;
    private Integer port;
    private Integer timeout;
    private Map<String, Object> conf;
    private ThriftConnectionType type;
    private String asUser;
    private static final Logger LOG = LoggerFactory.getLogger(ThriftClient.class);

    public ThriftClient(Map<String, Object> topoConf, ThriftConnectionType type, String host) {
        this(topoConf, type, host, null, null, null);
    }

    public ThriftClient(Map<String, Object> topoConf, ThriftConnectionType type, String host, Integer port, Integer timeout) {
        this(topoConf, type, host, port, timeout, null);
    }

    public ThriftClient(Map<String, Object> topoConf, ThriftConnectionType type, String host, Integer port, Integer timeout, String asUser) {
        if (host == null) {
            throw new IllegalArgumentException("host is not set");
        }
        if (port == null) {
            port = type.getPort(topoConf);
        }
        if (timeout == null) {
            timeout = type.getSocketTimeOut(topoConf);
        }
        if (port <= 0 && !type.isFake()) {
            throw new IllegalArgumentException("invalid port: " + port);
        }
        this.host = host;
        this.port = port;
        this.timeout = timeout;
        this.conf = topoConf;
        this.type = type;
        this.asUser = asUser;
        if (!type.isFake()) {
            this.reconnect();
        }
    }

    public synchronized TTransport transport() {
        return this.transport;
    }

    protected PrivateKey getPrivateKey() throws IOException {
        try (FileReader fileReader = new FileReader(this.type.getClientKeyPath(this.conf));){
            PEMParser pemParser = new PEMParser((Reader)fileReader);
            JcaPEMKeyConverter converter = new JcaPEMKeyConverter();
            Object key = pemParser.readObject();
            PrivateKeyInfo privateKeyInfo = ((PEMKeyPair)key).getPrivateKeyInfo();
            PrivateKey privateKey = converter.getPrivateKey(privateKeyInfo);
            return privateKey;
        }
    }

    protected File getKeyStoreFile(String keyStorePass) throws CertificateException, KeyStoreException, IOException, NoSuchAlgorithmException {
        CertificateFactory fact = CertificateFactory.getInstance("X.509");
        KeyStore ks = KeyStore.getInstance("JKS");
        ks.load(null, keyStorePass.toCharArray());
        PrivateKey privateKey = this.getPrivateKey();
        X509Certificate cer = null;
        try (FileInputStream fileInputStream = new FileInputStream(this.type.getClientCertPath(this.conf));){
            cer = (X509Certificate)fact.generateCertificate(fileInputStream);
        }
        String certAlias = cer.getSubjectX500Principal().getName();
        Certificate[] chain = new Certificate[]{cer};
        ks.setKeyEntry(certAlias, privateKey, keyStorePass.toCharArray(), chain);
        File file = File.createTempFile("tempKeyStoreForStormAuth", null);
        file.deleteOnExit();
        try (FileOutputStream fileOutputStream = new FileOutputStream(file.getAbsolutePath());){
            ks.store(fileOutputStream, keyStorePass.toCharArray());
        }
        return file;
    }

    public synchronized void reconnect() {
        this.close();
        TSocket socket = null;
        File file = null;
        try {
            LOG.debug("Thrift client connecting to host={} port={}", (Object)this.host, (Object)this.port);
            if (this.type.isTlsEnabled()) {
                LOG.debug("Tls is enabled");
                TSSLTransportFactory.TSSLTransportParameters params = new TSSLTransportFactory.TSSLTransportParameters();
                if (this.type.getClientTrustStorePath(this.conf) == null || this.type.getClientTrustStorePassword(this.conf) == null) {
                    throw new IllegalArgumentException("The client truststore is not configured properly");
                }
                params.setTrustStore(this.type.getClientTrustStorePath(this.conf), this.type.getClientTrustStorePassword(this.conf), null, SecurityUtils.inferKeyStoreTypeFromPath(this.type.getClientTrustStorePath(this.conf)));
                if (this.type.isClientAuthRequired(this.conf)) {
                    if (this.type.getClientKeyPath(this.conf) != null && this.type.getClientCertPath(this.conf) != null) {
                        String keyStorePass = UUID.randomUUID().toString();
                        file = this.getKeyStoreFile(keyStorePass);
                        params.setKeyStore(file.getAbsolutePath(), keyStorePass, null, SecurityUtils.inferKeyStoreTypeFromPath(file.getAbsolutePath()));
                    } else if (this.type.getClientKeyStorePath(this.conf) != null && this.type.getClientKeyStorePassword(this.conf) != null) {
                        params.setKeyStore(this.type.getClientKeyStorePath(this.conf), this.type.getClientKeyStorePassword(this.conf), null, SecurityUtils.inferKeyStoreTypeFromPath(this.type.getClientKeyStorePath(this.conf)));
                    } else {
                        throw new IllegalArgumentException("The client credentials are not configured properly");
                    }
                }
                socket = TSSLTransportFactory.getClientSocket((String)this.host, (int)this.port, (int)0, (TSSLTransportFactory.TSSLTransportParameters)params);
            } else {
                socket = new TSocket(this.host, this.port.intValue());
            }
            if (this.timeout != null) {
                socket.setTimeout(this.timeout.intValue());
            }
            ITransportPlugin transportPlugin = ClientAuthUtils.getTransportPlugin(this.type, this.conf);
            TBackoffConnect connectionRetry = new TBackoffConnect(ObjectReader.getInt(this.conf.get("storm.nimbus.retry.times")), ObjectReader.getInt(this.conf.get("storm.nimbus.retry.interval.millis")), ObjectReader.getInt(this.conf.get("storm.nimbus.retry.intervalceiling.millis")), this.retryForever);
            this.transport = connectionRetry.doConnectWithRetry(transportPlugin, (TTransport)socket, this.host, this.asUser);
        }
        catch (Exception ex) {
            if (socket != null) {
                try {
                    socket.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (file != null) {
                file.delete();
            }
            throw new RuntimeException(ex);
        }
        this.protocol = null;
        if (this.transport != null) {
            this.protocol = new TBinaryProtocol(this.transport);
        }
    }

    @Override
    public synchronized void close() {
        if (this.transport != null) {
            this.transport.close();
            this.transport = null;
            this.protocol = null;
        }
    }
}

