/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.services.loader;

import java.lang.reflect.Constructor;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.loader.ClassFactory;
import org.apache.derby.iapi.services.loader.ClassInspector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Java5ClassInspector
extends ClassInspector {
    public Java5ClassInspector(ClassFactory classFactory) {
        super(classFactory);
    }

    @Override
    public Class[][] getTypeBounds(Class clazz, Class clazz2) throws StandardException {
        Type[] typeArray;
        if (clazz2 == null) {
            return null;
        }
        for (Type type : typeArray = clazz2.getGenericInterfaces()) {
            ParameterizedType parameterizedType;
            Type type2;
            if (!(type instanceof ParameterizedType) || clazz != (type2 = (parameterizedType = (ParameterizedType)type).getRawType())) continue;
            return this.findTypeBounds(parameterizedType);
        }
        return this.getTypeBounds(clazz, clazz2.getSuperclass());
    }

    @Override
    public boolean isVarArgsMethod(Member member) {
        if (member instanceof Method) {
            return ((Method)member).isVarArgs();
        }
        if (member instanceof Constructor) {
            return ((Constructor)member).isVarArgs();
        }
        return false;
    }

    @Override
    public Class[] getGenericParameterTypes(Class clazz, Class clazz2) throws StandardException {
        ArrayList<Class<?>> arrayList = this.getTypeChain(clazz, clazz2);
        HashMap<Type, Type> hashMap = this.getResolvedTypes(arrayList);
        ArrayList<Class<?>> arrayList2 = this.getParameterTypes(clazz, hashMap);
        if (arrayList2 == null) {
            return null;
        }
        Class[] classArray = new Class[arrayList2.size()];
        arrayList2.toArray(classArray);
        return classArray;
    }

    private Class[][] findTypeBounds(ParameterizedType parameterizedType) {
        Type[] typeArray = parameterizedType.getActualTypeArguments();
        int n = typeArray.length;
        Class[][] classArray = new Class[n][];
        for (int i = 0; i < n; ++i) {
            classArray[i] = this.boundType(typeArray[i]);
        }
        return classArray;
    }

    private Class[] boundType(Type type) {
        if (type instanceof Class) {
            return new Class[]{(Class)type};
        }
        if (type instanceof TypeVariable) {
            Type[] typeArray = ((TypeVariable)type).getBounds();
            int n = typeArray.length;
            Class[] classArray = new Class[n];
            for (int i = 0; i < n; ++i) {
                classArray[i] = this.getRawType(typeArray[i]);
            }
            return classArray;
        }
        return null;
    }

    private Class getRawType(Type type) {
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof ParameterizedType) {
            return this.getRawType(((ParameterizedType)type).getRawType());
        }
        return null;
    }

    private ArrayList<Class<?>> getTypeChain(Class<?> clazz, Class<?> clazz2) {
        ArrayList arrayList = null;
        if (clazz2 == null) {
            return null;
        }
        if (!clazz.isAssignableFrom(clazz2)) {
            return null;
        }
        if (clazz2 == clazz) {
            arrayList = new ArrayList();
        }
        if (arrayList == null && (arrayList = this.getTypeChain(clazz, clazz2.getSuperclass())) == null) {
            Class<?> clazz3;
            Class<?>[] classArray = clazz2.getInterfaces();
            int n = classArray.length;
            for (int i = 0; i < n && (arrayList = this.getTypeChain(clazz, clazz3 = classArray[i])) == null; ++i) {
            }
        }
        if (arrayList != null) {
            arrayList.add(clazz2);
        }
        return arrayList;
    }

    private HashMap<Type, Type> getResolvedTypes(ArrayList<Class<?>> arrayList) {
        if (arrayList == null) {
            return null;
        }
        HashMap<Type, Type> hashMap = new HashMap<Type, Type>();
        for (Class<?> clazz : arrayList) {
            this.addResolvedTypes(hashMap, clazz.getGenericSuperclass());
            for (Type type : clazz.getGenericInterfaces()) {
                this.addResolvedTypes(hashMap, type);
            }
        }
        return hashMap;
    }

    private void addResolvedTypes(HashMap<Type, Type> hashMap, Type type) {
        if (type == null) {
            return;
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            Class clazz = (Class)parameterizedType.getRawType();
            Type[] typeArray = parameterizedType.getActualTypeArguments();
            TypeVariable<Class<T>>[] typeVariableArray = clazz.getTypeParameters();
            for (int i = 0; i < typeArray.length; ++i) {
                hashMap.put(typeVariableArray[i], typeArray[i]);
            }
        }
    }

    private ArrayList<Class<?>> getParameterTypes(Class<?> clazz, HashMap<Type, Type> hashMap) {
        if (hashMap == null) {
            return null;
        }
        TypeVariable<Class<?>>[] typeVariableArray = clazz.getTypeParameters();
        ArrayList arrayList = new ArrayList();
        for (Type type : typeVariableArray) {
            while (hashMap.containsKey(type)) {
                type = hashMap.get(type);
            }
            arrayList.add(this.getRawType(type));
        }
        return arrayList;
    }
}

