/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.shaded.common.record;

public enum CompressionType {
    NONE(0, "none", 1.0f),
    GZIP(1, "gzip", 0.5f),
    SNAPPY(2, "snappy", 0.5f),
    LZ4(3, "lz4", 0.5f);

    public final int id;
    public final String name;
    public final float rate;

    private CompressionType(int id, String name, float rate) {
        this.id = id;
        this.name = name;
        this.rate = rate;
    }

    public static CompressionType forId(int id) {
        switch (id) {
            case 0: {
                return NONE;
            }
            case 1: {
                return GZIP;
            }
            case 2: {
                return SNAPPY;
            }
            case 3: {
                return LZ4;
            }
        }
        throw new IllegalArgumentException("Unknown compression type id: " + id);
    }

    public static CompressionType forName(String name) {
        if (CompressionType.NONE.name.equals(name)) {
            return NONE;
        }
        if (CompressionType.GZIP.name.equals(name)) {
            return GZIP;
        }
        if (CompressionType.SNAPPY.name.equals(name)) {
            return SNAPPY;
        }
        if (CompressionType.LZ4.name.equals(name)) {
            return LZ4;
        }
        throw new IllegalArgumentException("Unknown compression name: " + name);
    }
}

