/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.feature.maven.mojos.selection;

import java.util.ArrayList;
import java.util.List;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.sling.feature.ArtifactId;

public class IncludeExcludeMatcher {
    private List<String[]> includeMatches;
    private List<String[]> excludeMatches;

    public IncludeExcludeMatcher(List<String> incudes, List<String> excludes, String separator, boolean separatorRequired) throws MojoExecutionException {
        this.includeMatches = this.parseMatches(incudes, separator, separatorRequired);
        this.excludeMatches = this.parseMatches(excludes, null, false);
    }

    public String matches(ArtifactId id) {
        String result = null;
        if (this.includeMatches != null) {
            result = this.match(this.includeMatches, id);
            if (this.excludeMatches != null && this.match(this.excludeMatches, id) != null) {
                result = null;
            }
        }
        return result;
    }

    private List<String[]> parseMatches(List<String> patterns, String separator, boolean separatorRequired) throws MojoExecutionException {
        ArrayList<String[]> matches = null;
        if (patterns != null && !patterns.isEmpty()) {
            matches = new ArrayList<String[]>();
            for (String t : patterns) {
                String[] parts;
                if (separator == null) {
                    parts = new String[]{t, ""};
                } else if (t.endsWith(separator)) {
                    parts = new String[]{t.substring(0, t.length() - 1), ""};
                } else if (t.contains(separator)) {
                    parts = t.split(separator);
                } else {
                    if (separatorRequired) {
                        throw new MojoExecutionException("Illegal pattern: " + t);
                    }
                    parts = new String[]{t, ""};
                }
                if (parts.length != 2) {
                    throw new MojoExecutionException("Illegal pattern: " + t);
                }
                String[] val = parts[0].split(":");
                if (val.length > 5) {
                    throw new MojoExecutionException("Illegal pattern: " + t);
                }
                String[] result = new String[val.length + 1];
                System.arraycopy(val, 0, result, 1, val.length);
                result[0] = parts[1];
                matches.add(result);
            }
        }
        return matches;
    }

    private boolean match(String value, String matcher) {
        if (matcher.endsWith("*")) {
            return value.startsWith(matcher.substring(0, matcher.length() - 1));
        }
        return matcher.equals(value);
    }

    private String match(List<String[]> matches, ArtifactId id) {
        boolean match = false;
        for (String[] m : matches) {
            match = this.match(id.getGroupId(), m[1]);
            if (match && m.length > 2) {
                match = this.match(id.getArtifactId(), m[2]);
            }
            if (match && m.length == 4) {
                match = this.match(id.getVersion(), m[3]);
            } else if (match && m.length == 5) {
                match = this.match(id.getVersion(), m[4]);
                if (match) {
                    match = this.match(id.getType(), m[3]);
                }
            } else if (match && m.length == 6 && (match = this.match(id.getVersion(), m[5])) && (match = this.match(id.getType(), m[3]))) {
                match = this.match(id.getClassifier(), m[4]);
            }
            if (!match) continue;
            return m[0];
        }
        return null;
    }
}

