/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.validator.html;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import org.w3c.dom.DocumentFragment;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CleanResults {
    private List<String> errorMessages = new ArrayList<String>();
    private Callable<String> cleanHTML;
    private long elapsedScan;
    private DocumentFragment cleanXMLDocumentFragment;

    public CleanResults() {
    }

    public CleanResults(long startOfScan, final String cleanHTML, DocumentFragment XMLDocumentFragment, List<String> errorMessages) {
        this.elapsedScan = System.currentTimeMillis() - startOfScan;
        this.cleanXMLDocumentFragment = XMLDocumentFragment;
        this.cleanHTML = new Callable<String>(){

            @Override
            public String call() throws Exception {
                return cleanHTML;
            }
        };
        this.errorMessages = errorMessages;
    }

    public CleanResults(long startOfScan, Callable<String> cleanHTML, DocumentFragment XMLDocumentFragment, List<String> errorMessages) {
        this.elapsedScan = System.currentTimeMillis() - startOfScan;
        this.cleanXMLDocumentFragment = XMLDocumentFragment;
        this.cleanHTML = cleanHTML;
        this.errorMessages = errorMessages;
    }

    public DocumentFragment getCleanXMLDocumentFragment() {
        return this.cleanXMLDocumentFragment;
    }

    public String getCleanHTML() {
        try {
            return this.cleanHTML.call();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public List<String> getErrorMessages() {
        return this.errorMessages;
    }

    public double getScanTime() {
        return (double)this.elapsedScan / 1000.0;
    }

    public int getNumberOfErrors() {
        return this.errorMessages.size();
    }
}

