/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.jcr.jackrabbit.accessmanager;

import java.util.Arrays;
import javax.jcr.Value;
import org.apache.jackrabbit.oak.spi.security.authorization.restriction.RestrictionDefinition;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LocalRestriction {
    private RestrictionDefinition rd;
    private Value[] values;

    public LocalRestriction(@NotNull RestrictionDefinition rd, @Nullable Value value) {
        Value[] valueArray;
        this.rd = rd;
        if (value == null) {
            valueArray = null;
        } else {
            Value[] valueArray2 = new Value[1];
            valueArray = valueArray2;
            valueArray2[0] = value;
        }
        this.values = valueArray;
    }

    public LocalRestriction(@NotNull RestrictionDefinition rd, @Nullable Value[] values) {
        this.rd = rd;
        this.values = values;
    }

    public String getName() {
        return this.rd.getName();
    }

    public boolean isMultiValue() {
        return this.rd.getRequiredType().isArray();
    }

    public Value getValue() {
        Value v = null;
        if (this.values != null && this.values.length > 0) {
            v = this.values[0];
        }
        return v;
    }

    public Value[] getValues() {
        return this.values;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("LocalRestriction [name=");
        builder.append(this.rd == null ? null : this.rd.getName());
        builder.append(", value=");
        builder.append(Arrays.toString(this.getValues()));
        builder.append("]");
        return builder.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.rd == null ? 0 : this.rd.getName().hashCode());
        result = 31 * result + Arrays.hashCode(this.values);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LocalRestriction other = (LocalRestriction)obj;
        if (this.rd == null) {
            if (other.rd != null) {
                return false;
            }
        } else {
            if (other.rd == null) {
                return false;
            }
            if (!this.rd.getName().equals(other.rd.getName())) {
                return false;
            }
        }
        return Arrays.equals(this.values, other.values);
    }

    @NotNull
    public static LocalRestriction cloneWithNewValues(@NotNull LocalRestriction lr, @NotNull Value[] newValues) {
        return new LocalRestriction(lr.rd, newValues);
    }
}

