/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.jcr.base.util;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.jcr.AccessDeniedException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.UnsupportedRepositoryOperationException;
import javax.jcr.Value;
import javax.jcr.ValueFormatException;
import javax.jcr.security.AccessControlEntry;
import javax.jcr.security.AccessControlException;
import javax.jcr.security.AccessControlList;
import javax.jcr.security.AccessControlManager;
import javax.jcr.security.AccessControlPolicy;
import javax.jcr.security.AccessControlPolicyIterator;
import javax.jcr.security.Privilege;
import org.apache.jackrabbit.api.JackrabbitSession;
import org.apache.jackrabbit.api.security.JackrabbitAccessControlEntry;
import org.apache.jackrabbit.api.security.JackrabbitAccessControlList;
import org.apache.jackrabbit.api.security.principal.PrincipalManager;
import org.apache.jackrabbit.api.security.user.UserManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AccessControlUtil {
    private static final String METHOD_GET_ACCESS_CONTROL_MANAGER = "getAccessControlManager";
    private static final String METHOD_GET_USER_MANAGER = "getUserManager";
    private static final String METHOD_GET_PRINCIPAL_MANAGER = "getPrincipalManager";
    private static final String METHOD_JACKRABBIT_ACL_GET_PATH = "getPath";
    private static final String METHOD_JACKRABBIT_ACL_IS_EMPTY = "isEmpty";
    private static final String METHOD_JACKRABBIT_ACL_SIZE = "size";
    private static final String METHOD_JACKRABBIT_ACL_ADD_ENTRY = "addEntry";
    private static final String METHOD_JACKRABBIT_ACE_IS_ALLOW = "isAllow";
    private static final String METHOD_JACKRABBIT_ACE_GET_RESTRICTIONS = "getRestrictions";
    private static final Logger log = LoggerFactory.getLogger(AccessControlUtil.class);

    public static AccessControlManager getAccessControlManager(Session session) throws UnsupportedRepositoryOperationException, RepositoryException {
        return AccessControlUtil.safeInvokeRepoMethod((Object)session, METHOD_GET_ACCESS_CONTROL_MANAGER, AccessControlManager.class, new Object[0]);
    }

    public static UserManager getUserManager(Session session) throws AccessDeniedException, UnsupportedRepositoryOperationException, RepositoryException {
        JackrabbitSession jackrabbitSession = AccessControlUtil.getJackrabbitSession(session);
        if (jackrabbitSession != null) {
            return jackrabbitSession.getUserManager();
        }
        return AccessControlUtil.safeInvokeRepoMethod((Object)session, METHOD_GET_USER_MANAGER, UserManager.class, new Object[0]);
    }

    public static PrincipalManager getPrincipalManager(Session session) throws AccessDeniedException, UnsupportedRepositoryOperationException, RepositoryException {
        JackrabbitSession jackrabbitSession = AccessControlUtil.getJackrabbitSession(session);
        if (jackrabbitSession != null) {
            return jackrabbitSession.getPrincipalManager();
        }
        return AccessControlUtil.safeInvokeRepoMethod((Object)session, METHOD_GET_PRINCIPAL_MANAGER, PrincipalManager.class, new Object[0]);
    }

    public static String getPath(AccessControlList acl) throws RepositoryException {
        return AccessControlUtil.safeInvokeRepoMethod((Object)acl, METHOD_JACKRABBIT_ACL_GET_PATH, String.class, new Object[0]);
    }

    public static boolean isEmpty(AccessControlList acl) throws RepositoryException {
        return AccessControlUtil.safeInvokeRepoMethod((Object)acl, METHOD_JACKRABBIT_ACL_IS_EMPTY, Boolean.class, new Object[0]);
    }

    public static int size(AccessControlList acl) throws RepositoryException {
        return AccessControlUtil.safeInvokeRepoMethod((Object)acl, METHOD_JACKRABBIT_ACL_SIZE, Integer.class, new Object[0]);
    }

    public static boolean addEntry(AccessControlList acl, Principal principal, Privilege[] privileges, boolean isAllow) throws AccessControlException, RepositoryException {
        Object[] args = new Object[]{principal, privileges, isAllow};
        Class[] types = new Class[]{Principal.class, Privilege[].class, Boolean.TYPE};
        return AccessControlUtil.safeInvokeRepoMethod((Object)acl, METHOD_JACKRABBIT_ACL_ADD_ENTRY, Boolean.class, args, types);
    }

    public static boolean addEntry(AccessControlList acl, Principal principal, Privilege[] privileges, boolean isAllow, Map restrictions) throws UnsupportedRepositoryOperationException, RepositoryException {
        HashMap<String, Value> restrictionsMap = null;
        HashMap<String, Value[]> mvRestrictionsMap = null;
        if (restrictions != null) {
            Set entrySet = restrictions.entrySet();
            for (Map.Entry entry : entrySet) {
                Map.Entry me = entry;
                Object value = me.getValue();
                if (value == null) continue;
                String key = String.valueOf(me.getKey());
                if (value instanceof Value) {
                    if (restrictionsMap == null) {
                        restrictionsMap = new HashMap<String, Value>();
                    }
                    restrictionsMap.put(key, (Value)value);
                    continue;
                }
                if (value instanceof Value[]) {
                    if (mvRestrictionsMap == null) {
                        mvRestrictionsMap = new HashMap<String, Value[]>();
                    }
                    mvRestrictionsMap.put(key, (Value[])value);
                    continue;
                }
                throw new IllegalArgumentException("the values in the restrictions argument must be either a Value or Value[] object");
            }
        }
        return AccessControlUtil.addEntry(acl, principal, privileges, isAllow, restrictionsMap, mvRestrictionsMap);
    }

    public static boolean addEntry(AccessControlList acl, Principal principal, Privilege[] privileges, boolean isAllow, Map<String, Value> restrictions, Map<String, Value[]> mvRestrictions) throws UnsupportedRepositoryOperationException, RepositoryException {
        Object[] args = null;
        Class[] types = null;
        if (mvRestrictions == null && restrictions == null) {
            args = new Object[]{principal, privileges, isAllow};
            types = new Class[]{Principal.class, Privilege[].class, Boolean.TYPE};
        } else if (mvRestrictions == null) {
            args = new Object[]{principal, privileges, isAllow, restrictions};
            types = new Class[]{Principal.class, Privilege[].class, Boolean.TYPE, Map.class};
        } else {
            args = new Object[]{principal, privileges, isAllow, restrictions, mvRestrictions};
            types = new Class[]{Principal.class, Privilege[].class, Boolean.TYPE, Map.class, Map.class};
        }
        return AccessControlUtil.safeInvokeRepoMethod((Object)acl, METHOD_JACKRABBIT_ACL_ADD_ENTRY, Boolean.class, args, types);
    }

    @Deprecated
    public static void replaceAccessControlEntry(Session session, String resourcePath, Principal principal, String[] grantedPrivilegeNames, String[] deniedPrivilegeNames, String[] removedPrivilegeNames) throws RepositoryException {
        AccessControlUtil.replaceAccessControlEntry(session, resourcePath, principal, grantedPrivilegeNames, deniedPrivilegeNames, removedPrivilegeNames, null);
    }

    public static void replaceAccessControlEntry(Session session, String resourcePath, Principal principal, String[] grantedPrivilegeNames, String[] deniedPrivilegeNames, String[] removedPrivilegeNames, String order) throws RepositoryException {
        AccessControlUtil.replaceAccessControlEntry(session, resourcePath, principal, grantedPrivilegeNames, deniedPrivilegeNames, removedPrivilegeNames, order, null, null, null);
    }

    /*
     * WARNING - void declaration
     */
    public static void replaceAccessControlEntry(Session session, String resourcePath, Principal principal, String[] grantedPrivilegeNames, String[] deniedPrivilegeNames, String[] removedPrivilegeNames, String order, Map<String, Value> restrictions, Map<String, Value[]> mvRestrictions, Set<String> removedRestrictionNames) throws RepositoryException {
        void var18_26;
        AccessControlPolicy[] policies;
        String key;
        Set<Map.Entry<String, Value>> entrySet;
        AccessControlManager accessControlManager = AccessControlUtil.getAccessControlManager(session);
        HashSet<String> specifiedPrivilegeNames = new HashSet<String>();
        Set<String> newGrantedPrivilegeNames = AccessControlUtil.disaggregateToPrivilegeNames(accessControlManager, grantedPrivilegeNames, specifiedPrivilegeNames);
        Set<String> newDeniedPrivilegeNames = AccessControlUtil.disaggregateToPrivilegeNames(accessControlManager, deniedPrivilegeNames, specifiedPrivilegeNames);
        AccessControlUtil.disaggregateToPrivilegeNames(accessControlManager, removedPrivilegeNames, specifiedPrivilegeNames);
        HashMap<String, Value> newRestrictions = new HashMap<String, Value>();
        HashMap<String, Value[]> newMvRestrictions = new HashMap<String, Value[]>();
        if (restrictions != null) {
            entrySet = restrictions.entrySet();
            for (Map.Entry<String, Value> entry : entrySet) {
                key = entry.getKey();
                if (removedRestrictionNames != null && removedRestrictionNames.contains(key)) {
                    removedRestrictionNames.remove(key);
                }
                newRestrictions.put(key, entry.getValue());
            }
        }
        if (mvRestrictions != null) {
            entrySet = mvRestrictions.entrySet();
            for (Map.Entry<String, Value> entry : entrySet) {
                key = entry.getKey();
                if (removedRestrictionNames != null && removedRestrictionNames.contains(key)) {
                    removedRestrictionNames.remove(key);
                }
                newMvRestrictions.put(key, (Value[])entry.getValue());
            }
        }
        AccessControlList acl = null;
        for (AccessControlPolicy policy : policies = accessControlManager.getPolicies(resourcePath)) {
            if (!(policy instanceof AccessControlList)) continue;
            acl = (AccessControlList)policy;
            break;
        }
        if (acl == null) {
            AccessControlPolicyIterator accessControlPolicyIterator = accessControlManager.getApplicablePolicies(resourcePath);
            while (accessControlPolicyIterator.hasNext()) {
                AccessControlPolicy policy = accessControlPolicyIterator.nextAccessControlPolicy();
                if (!(policy instanceof AccessControlList)) continue;
                acl = (AccessControlList)policy;
                break;
            }
        }
        if (acl == null) {
            throw new RepositoryException("Could not obtain ACL for resource " + resourcePath);
        }
        Object var18_24 = null;
        HashSet<Privilege> oldDenies = null;
        if (log.isDebugEnabled()) {
            HashSet hashSet = new HashSet();
            oldDenies = new HashSet<Privilege>();
        }
        AccessControlEntry[] accessControlEntries = acl.getAccessControlEntries();
        for (int i = 0; i < accessControlEntries.length; ++i) {
            JackrabbitAccessControlEntry jace;
            String[] restrictionNames;
            AccessControlEntry accessControlEntry = accessControlEntries[i];
            if (!principal.equals(accessControlEntry.getPrincipal())) continue;
            if (log.isDebugEnabled()) {
                log.debug("Found Existing ACE for principal {} on resource {}", new Object[]{principal.getName(), resourcePath});
            }
            if (order == null || order.length() == 0) {
                order = String.valueOf(i);
            }
            boolean isAllow = AccessControlUtil.isAllow(accessControlEntry);
            Privilege[] privilegeArray = accessControlEntry.getPrivileges();
            if (log.isDebugEnabled()) {
                if (isAllow) {
                    var18_26.addAll(Arrays.asList(privilegeArray));
                } else {
                    oldDenies.addAll(Arrays.asList(privilegeArray));
                }
            }
            for (Privilege privilege : privilegeArray) {
                Set<String> maintainedPrivileges = AccessControlUtil.disaggregateToPrivilegeNames(privilege);
                if (!maintainedPrivileges.removeAll(specifiedPrivilegeNames)) {
                    maintainedPrivileges.clear();
                    maintainedPrivileges.add(privilege.getName());
                }
                if (maintainedPrivileges.isEmpty()) continue;
                if (isAllow) {
                    newGrantedPrivilegeNames.addAll(maintainedPrivileges);
                    continue;
                }
                newDeniedPrivilegeNames.addAll(maintainedPrivileges);
            }
            if (accessControlEntry instanceof JackrabbitAccessControlEntry && (restrictionNames = (jace = (JackrabbitAccessControlEntry)accessControlEntry).getRestrictionNames()) != null) {
                for (String rname : restrictionNames) {
                    if (newRestrictions.containsKey(rname) || newMvRestrictions.containsKey(rname)) continue;
                    try {
                        Value restriction = jace.getRestriction(rname);
                        newRestrictions.put(rname, restriction);
                    }
                    catch (Exception vfe) {
                        if (vfe instanceof ValueFormatException) {
                            Value[] rvalue = AccessControlUtil.safeInvokeRepoMethod((Object)accessControlEntry, METHOD_JACKRABBIT_ACE_GET_RESTRICTIONS, Value[].class, new Object[]{rname}, new Class[]{String.class});
                            newMvRestrictions.put(rname, rvalue);
                            continue;
                        }
                        throw vfe;
                    }
                }
            }
            acl.removeAccessControlEntry(accessControlEntry);
        }
        if (removedRestrictionNames != null) {
            for (String string : removedRestrictionNames) {
                if (restrictions != null && restrictions.containsKey(string) || mvRestrictions != null && mvRestrictions.containsKey(string)) continue;
                newRestrictions.remove(string);
                newMvRestrictions.remove(string);
            }
        }
        ArrayList<Privilege> grantedPrivilegeList = new ArrayList<Privilege>();
        for (String name : newGrantedPrivilegeNames) {
            Privilege privilege = accessControlManager.privilegeFromName(name);
            grantedPrivilegeList.add(privilege);
        }
        if (grantedPrivilegeList.size() > 0) {
            AccessControlUtil.addEntry(acl, principal, grantedPrivilegeList.toArray(new Privilege[grantedPrivilegeList.size()]), true, newRestrictions, newMvRestrictions);
        }
        ArrayList<Privilege> arrayList = new ArrayList<Privilege>();
        for (String string : newDeniedPrivilegeNames) {
            Privilege privilege = accessControlManager.privilegeFromName(string);
            arrayList.add(privilege);
        }
        if (arrayList.size() > 0) {
            AccessControlUtil.addEntry(acl, principal, arrayList.toArray(new Privilege[arrayList.size()]), false, newRestrictions, newMvRestrictions);
        }
        AccessControlUtil.reorderAccessControlEntries(acl, principal, order);
        accessControlManager.setPolicy(resourcePath, (AccessControlPolicy)acl);
        if (log.isDebugEnabled()) {
            ArrayList<String> oldGrantedNames = new ArrayList<String>(var18_26.size());
            for (Privilege privilege : var18_26) {
                oldGrantedNames.add(privilege.getName());
            }
            ArrayList<String> arrayList2 = new ArrayList<String>(oldDenies.size());
            for (Privilege privilege : oldDenies) {
                arrayList2.add(privilege.getName());
            }
            log.debug("Updated ACE for principalName {} for resource {} from grants {}, denies {} to grants {}, denies {}", new Object[]{principal.getName(), resourcePath, oldGrantedNames, arrayList2, newGrantedPrivilegeNames, newDeniedPrivilegeNames});
        }
    }

    public static boolean isAllow(AccessControlEntry ace) throws RepositoryException {
        return AccessControlUtil.safeInvokeRepoMethod((Object)ace, METHOD_JACKRABBIT_ACE_IS_ALLOW, Boolean.class, new Object[0]);
    }

    private static <T> T safeInvokeRepoMethod(Object target, String methodName, Class<T> returnType, Object[] args, Class[] argsTypes) throws UnsupportedRepositoryOperationException, RepositoryException {
        try {
            Method m = target.getClass().getMethod(methodName, argsTypes);
            if (!m.isAccessible()) {
                m.setAccessible(true);
            }
            return (T)m.invoke(target, args);
        }
        catch (InvocationTargetException ite) {
            Throwable t = ite.getCause();
            if (t instanceof UnsupportedRepositoryOperationException) {
                throw (UnsupportedRepositoryOperationException)t;
            }
            if (t instanceof AccessDeniedException) {
                throw (AccessDeniedException)t;
            }
            if (t instanceof AccessControlException) {
                throw (AccessControlException)t;
            }
            if (t instanceof RepositoryException) {
                throw (RepositoryException)t;
            }
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            if (t instanceof Error) {
                throw (Error)t;
            }
            throw new RepositoryException(methodName, t);
        }
        catch (Throwable t) {
            throw new RepositoryException(methodName, t);
        }
    }

    private static <T> T safeInvokeRepoMethod(Object target, String methodName, Class<T> returnType, Object ... args) throws UnsupportedRepositoryOperationException, RepositoryException {
        return AccessControlUtil.safeInvokeRepoMethod(target, methodName, returnType, args, new Class[0]);
    }

    private static JackrabbitSession getJackrabbitSession(Session session) {
        if (session instanceof JackrabbitSession) {
            return (JackrabbitSession)session;
        }
        return null;
    }

    private static Set<String> disaggregateToPrivilegeNames(AccessControlManager accessControlManager, String[] privilegeNames, Set<String> disaggregatedPrivilegeNames) throws RepositoryException {
        HashSet<String> originalPrivilegeNames = new HashSet<String>();
        if (privilegeNames != null) {
            for (String privilegeName : privilegeNames) {
                originalPrivilegeNames.add(privilegeName);
                Privilege privilege = accessControlManager.privilegeFromName(privilegeName);
                disaggregatedPrivilegeNames.addAll(AccessControlUtil.disaggregateToPrivilegeNames(privilege));
            }
        }
        return originalPrivilegeNames;
    }

    private static Set<String> disaggregateToPrivilegeNames(Privilege privilege) {
        HashSet<String> disaggregatedPrivilegeNames = new HashSet<String>();
        if (privilege.isAggregate()) {
            Privilege[] privileges;
            for (Privilege disaggregate : privileges = privilege.getAggregatePrivileges()) {
                if (disaggregate.isAggregate()) continue;
                disaggregatedPrivilegeNames.add(disaggregate.getName());
            }
        } else {
            disaggregatedPrivilegeNames.add(privilege.getName());
        }
        return disaggregatedPrivilegeNames;
    }

    private static void reorderAccessControlEntries(AccessControlList acl, Principal principal, String order) throws RepositoryException {
        if (order == null || order.length() == 0) {
            return;
        }
        if (acl instanceof JackrabbitAccessControlList) {
            AccessControlEntry beforeEntry;
            AccessControlEntry[] accessControlEntries;
            JackrabbitAccessControlList jacl;
            block24: {
                jacl = (JackrabbitAccessControlList)acl;
                accessControlEntries = jacl.getAccessControlEntries();
                if (accessControlEntries.length <= 1) {
                    return;
                }
                beforeEntry = null;
                if ("first".equals(order)) {
                    beforeEntry = accessControlEntries[0];
                } else if ("last".equals(order)) {
                    beforeEntry = null;
                } else if (order.startsWith("before ")) {
                    String beforePrincipalName = order.substring(7);
                    for (int i = 0; i < accessControlEntries.length; ++i) {
                        if (!beforePrincipalName.equals(accessControlEntries[i].getPrincipal().getName())) continue;
                        beforeEntry = accessControlEntries[i];
                        break;
                    }
                    if (beforeEntry == null) {
                        throw new IllegalArgumentException("No ACE was found for the specified principal: " + beforePrincipalName);
                    }
                } else if (order.startsWith("after ")) {
                    String afterPrincipalName = order.substring(6);
                    for (int i = accessControlEntries.length - 1; i >= 0; --i) {
                        if (!afterPrincipalName.equals(accessControlEntries[i].getPrincipal().getName())) continue;
                        if (i >= accessControlEntries.length - 1) {
                            beforeEntry = null;
                            break;
                        }
                        beforeEntry = accessControlEntries[i + 1];
                        break;
                    }
                    if (beforeEntry == null) {
                        throw new IllegalArgumentException("No ACE was found for the specified principal: " + afterPrincipalName);
                    }
                } else {
                    try {
                        int index = Integer.parseInt(order);
                        if (index > accessControlEntries.length) {
                            throw new IndexOutOfBoundsException("Index value is too large: " + index);
                        }
                        if (index == 0) {
                            beforeEntry = accessControlEntries[0];
                            break block24;
                        }
                        HashSet<Principal> processedPrincipals = new HashSet<Principal>();
                        for (int i = 0; i < accessControlEntries.length; ++i) {
                            Principal principal2 = accessControlEntries[i].getPrincipal();
                            if (processedPrincipals.size() == index && !processedPrincipals.contains(principal2)) {
                                beforeEntry = accessControlEntries[i];
                                break;
                            }
                            processedPrincipals.add(principal2);
                        }
                    }
                    catch (NumberFormatException nfe) {
                        throw new IllegalArgumentException("Illegal value for the order parameter: " + order);
                    }
                }
            }
            for (int i = accessControlEntries.length - 1; i >= 0; --i) {
                AccessControlEntry ace = accessControlEntries[i];
                if (!principal.equals(ace.getPrincipal())) continue;
                jacl.orderBefore(ace, beforeEntry);
            }
        } else {
            throw new IllegalArgumentException("The acl must be an instance of JackrabbitAccessControlList");
        }
    }
}

