/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.installer.factory.packages.impl;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipInputStream;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.jackrabbit.vault.fs.io.Archive;
import org.apache.jackrabbit.vault.fs.io.ImportOptions;
import org.apache.jackrabbit.vault.fs.io.ZipStreamArchive;
import org.apache.jackrabbit.vault.packaging.Dependency;
import org.apache.jackrabbit.vault.packaging.DependencyHandling;
import org.apache.jackrabbit.vault.packaging.JcrPackage;
import org.apache.jackrabbit.vault.packaging.JcrPackageManager;
import org.apache.jackrabbit.vault.packaging.PackageException;
import org.apache.jackrabbit.vault.packaging.PackageId;
import org.apache.jackrabbit.vault.packaging.Packaging;
import org.apache.jackrabbit.vault.packaging.events.PackageEvent;
import org.apache.jackrabbit.vault.packaging.events.PackageEventListener;
import org.apache.sling.installer.api.tasks.ChangeStateTask;
import org.apache.sling.installer.api.tasks.InstallTask;
import org.apache.sling.installer.api.tasks.InstallTaskFactory;
import org.apache.sling.installer.api.tasks.InstallationContext;
import org.apache.sling.installer.api.tasks.RegisteredResource;
import org.apache.sling.installer.api.tasks.ResourceState;
import org.apache.sling.installer.api.tasks.ResourceTransformer;
import org.apache.sling.installer.api.tasks.RetryHandler;
import org.apache.sling.installer.api.tasks.TaskResource;
import org.apache.sling.installer.api.tasks.TaskResourceGroup;
import org.apache.sling.installer.api.tasks.TransformationResult;
import org.apache.sling.installer.factory.packages.impl.PackageTransformerConfiguration;
import org.apache.sling.jcr.api.SlingRepository;
import org.osgi.framework.Version;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.metatype.annotations.Designate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={ResourceTransformer.class, InstallTaskFactory.class, PackageEventListener.class})
@Designate(ocd=PackageTransformerConfiguration.class)
public class PackageTransformer
implements ResourceTransformer,
InstallTaskFactory,
PackageEventListener {
    private static final String ATTR_PCK_ID = "package-id";
    private static final String RESOURCE_TYPE_REGULAR = "content-package";
    private static final String RESOURCE_TYPE_HOLLOW = "content-package-hollow";
    private static final Logger logger = LoggerFactory.getLogger(PackageTransformer.class);
    @Reference
    private SlingRepository repository;
    @Reference
    private Packaging pkgSvc;
    @Reference
    private RetryHandler retryHandler;
    private PackageTransformerConfiguration configuration;
    private static final Pattern FUZZY_VERSION = Pattern.compile("(\\d+)(\\.(\\d+)(\\.(\\d+))?)?([^a-zA-Z0-9](.*))?", 32);

    @Activate
    private void activate(PackageTransformerConfiguration configuration) {
        this.configuration = configuration;
    }

    public TransformationResult[] transform(RegisteredResource resource) {
        if (resource.getType().equals("file")) {
            return this.checkForPackage(resource);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private TransformationResult[] checkForPackage(RegisteredResource resource) {
        if (!resource.getURL().endsWith(".zip")) {
            return null;
        }
        try (ZipInputStream zin = new ZipInputStream(new BufferedInputStream(resource.getInputStream()));){
            if (zin.getNextEntry() == null) {
                TransformationResult[] transformationResultArray = null;
                return transformationResultArray;
            }
        }
        catch (IOException ioe) {
            logger.debug("Unable to read resource.", (Throwable)ioe);
            return null;
        }
        Session session = null;
        JcrPackage pck = null;
        try {
            TransformationResult tr;
            block28: {
                session = this.repository.loginService(null, null);
                JcrPackageManager pckMgr = this.pkgSvc.getPackageManager(session);
                tr = new TransformationResult();
                if (this.configuration.shouldCreateHollowPackages()) {
                    tr.setResourceType(RESOURCE_TYPE_HOLLOW);
                    tr.setId(PackageTransformer.extractNameFromUrl(resource.getURL()));
                } else {
                    try (InputStream input = resource.getInputStream();){
                        pck = pckMgr.upload(input, true, true);
                        if (pck.isValid()) {
                            PackageId pid = pck.getDefinition().getId();
                            HashMap<String, String> attrs = new HashMap<String, String>();
                            attrs.put(ATTR_PCK_ID, pid.toString());
                            tr.setId(pid.getGroup() + ':' + pid.getName());
                            tr.setResourceType(RESOURCE_TYPE_REGULAR);
                            tr.setAttributes(attrs);
                            String version = pid.getVersionString();
                            if (version.length() > 0) {
                                tr.setVersion(new Version(PackageTransformer.cleanupVersion(version)));
                            }
                            break block28;
                        }
                        logger.warn("Package from resource {} is invalid", (Object)resource);
                        TransformationResult[] transformationResultArray = null;
                        return transformationResultArray;
                    }
                }
            }
            TransformationResult[] transformationResultArray = new TransformationResult[]{tr};
            return transformationResultArray;
        }
        catch (Exception ioe) {
            logger.debug("Unable to check content package " + resource.getURL(), (Throwable)ioe);
            return null;
        }
        finally {
            if (pck != null) {
                pck.close();
            }
            if (session != null) {
                session.logout();
            }
        }
    }

    private static String separatorsToUnix(String path) {
        if (path == null || path.indexOf(92) == -1) {
            return path;
        }
        return path.replace('\\', '/');
    }

    private static String extractNameFromUrl(String url) {
        String lastIdPart = PackageTransformer.separatorsToUnix(url);
        int pos = lastIdPart.lastIndexOf(47);
        if (pos != -1) {
            lastIdPart = lastIdPart.substring(pos + 1);
        }
        return lastIdPart;
    }

    public InstallTask createTask(TaskResourceGroup toActivate) {
        TaskResource resource = toActivate.getActiveResource();
        if (resource == null) {
            logger.warn("The given resource to createTask is null");
            return null;
        }
        AbstractPackageInstallTask task = null;
        switch (resource.getType()) {
            case "content-package": {
                String id = (String)resource.getAttribute(ATTR_PCK_ID);
                PackageId pkgId = PackageId.fromString((String)id);
                if (pkgId == null) {
                    String message = MessageFormat.format("Error during processing of {0}: Package id cannot be parsed from {1}.", resource, id);
                    logger.error(message);
                    return new ChangeStateTask(toActivate, ResourceState.IGNORED, message);
                }
                if (resource.getState() == ResourceState.INSTALL) {
                    task = new InstallPackageTask(pkgId, toActivate);
                    break;
                }
                task = new UninstallPackageTask(pkgId, toActivate);
                break;
            }
            case "content-package-hollow": {
                if (resource.getState() == ResourceState.INSTALL) {
                    task = new InstallHollowPackageTask(toActivate);
                    break;
                }
                String message = MessageFormat.format("Do not uninstall {0}: Hollow-Packages cannot be uninstalled.", resource);
                logger.info(message);
                return new ChangeStateTask(toActivate, ResourceState.IGNORED, message);
            }
            default: {
                String message = MessageFormat.format("Unsupported type of {0}: {1}.", resource, resource.getType());
                logger.debug(message);
            }
        }
        return task;
    }

    private static String cleanupVersion(String version) {
        StringBuilder result = new StringBuilder();
        Matcher m = FUZZY_VERSION.matcher(version);
        if (m.matches()) {
            String major = m.group(1);
            String minor = m.group(3);
            String micro = m.group(5);
            String qualifier = m.group(7);
            if (major != null) {
                result.append(major);
                if (minor != null) {
                    result.append(".");
                    result.append(minor);
                    if (micro != null) {
                        result.append(".");
                        result.append(micro);
                        if (qualifier != null) {
                            result.append(".");
                            PackageTransformer.cleanupModifier(result, qualifier);
                        }
                    } else if (qualifier != null) {
                        result.append(".0.");
                        PackageTransformer.cleanupModifier(result, qualifier);
                    } else {
                        result.append(".0");
                    }
                } else if (qualifier != null) {
                    result.append(".0.0.");
                    PackageTransformer.cleanupModifier(result, qualifier);
                } else {
                    result.append(".0.0");
                }
            }
        } else {
            result.append("0.0.0.");
            PackageTransformer.cleanupModifier(result, version);
        }
        return result.toString();
    }

    private static void cleanupModifier(StringBuilder result, String modifier) {
        for (int i = 0; i < modifier.length(); ++i) {
            char c = modifier.charAt(i);
            if (c >= '0' && c <= '9' || c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c == '_' || c == '-') {
                result.append(c);
                continue;
            }
            result.append('_');
        }
    }

    public void onPackageEvent(PackageEvent event) {
        switch (event.getType()) {
            case INSTALL: 
            case EXTRACT_SUB_PACKAGES: 
            case EXTRACT: 
            case UNINSTALL: {
                logger.debug("Package un-/installation of package {} captured, triggering new OSGI installer cycle.", (Object)event.getId());
                this.retryHandler.scheduleRetry();
                break;
            }
        }
    }

    private final class UninstallPackageTask
    extends AbstractPackageInstallTask {
        private PackageId pkgId;

        public UninstallPackageTask(PackageId pkgId, TaskResourceGroup erl) {
            super("uninstall", erl);
            this.pkgId = pkgId;
        }

        public String getSortKey() {
            return "55-" + this.getResource().getEntityId();
        }

        @Override
        protected void doExecute(InstallationContext ctx, JcrPackageManager pkgMgr, TaskResource resource) throws RepositoryException, PackageException, IOException {
            try (JcrPackage pkg = pkgMgr.open(this.pkgId);){
                if (pkg != null) {
                    ImportOptions opts = new ImportOptions();
                    opts.setDependencyHandling(PackageTransformer.this.configuration.dependencyHandling());
                    pkg.uninstall(opts);
                }
            }
            ctx.log("Uninstalled content package {}", new Object[]{this.getResource()});
            this.setFinishedState(ResourceState.UNINSTALLED);
        }
    }

    private final class InstallHollowPackageTask
    extends AbstractPackageInstallTask {
        public InstallHollowPackageTask(TaskResourceGroup erl) {
            super("install-hollow", erl);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void doExecute(InstallationContext ctx, JcrPackageManager pkgMgr, TaskResource resource) throws RepositoryException, PackageException, IOException {
            try (ZipStreamArchive archive = new ZipStreamArchive(resource.getInputStream());){
                archive.open(false);
                ImportOptions opts = new ImportOptions();
                opts.setDependencyHandling(PackageTransformer.this.configuration.dependencyHandling());
                pkgMgr.extract((Archive)archive, opts, true);
            }
        }

        public String getSortKey() {
            return "35-" + this.getResource().getEntityId();
        }
    }

    private class InstallPackageTask
    extends AbstractPackageInstallTask {
        private final PackageId pkgId;

        public InstallPackageTask(PackageId pkgId, TaskResourceGroup erl) {
            super("install", erl);
            this.pkgId = pkgId;
        }

        @Override
        protected void doExecute(InstallationContext ctx, JcrPackageManager pkgMgr, TaskResource resource) throws RepositoryException, PackageException, IOException {
            try (JcrPackage pkg = pkgMgr.open(this.pkgId);){
                if (pkg == null) {
                    String message = MessageFormat.format("Error during installation of {0}: Package {1} missing.", resource, this.pkgId);
                    logger.error(message);
                    this.setFinishedState(ResourceState.IGNORED, null, message);
                    return;
                }
                if (pkg.isInstalled()) {
                    String message = MessageFormat.format("Package {0} was installed externally. Marking as installed.", this.pkgId);
                    logger.info(message);
                    this.setFinishedState(ResourceState.INSTALLED, null, message);
                    return;
                }
                if (PackageTransformer.this.configuration.dependencyHandling() == DependencyHandling.REQUIRED || PackageTransformer.this.configuration.dependencyHandling() == DependencyHandling.STRICT) {
                    for (Dependency d : pkg.getDefinition().getDependencies()) {
                        if (pkgMgr.resolve(d, PackageTransformer.this.configuration.dependencyHandling() == DependencyHandling.STRICT) != null) continue;
                        logger.info("Delaying installation of {} due to missing dependency {}.", (Object)this.pkgId, (Object)d);
                        return;
                    }
                }
                ImportOptions opts = new ImportOptions();
                opts.setDependencyHandling(PackageTransformer.this.configuration.dependencyHandling());
                if (PackageTransformer.this.configuration.shouldCreateSnapshots()) {
                    pkg.install(opts);
                    ctx.log("Content package installed: {}", new Object[]{resource});
                } else {
                    pkg.extract(opts);
                    ctx.log("Content package extracted: {}", new Object[]{resource});
                }
                this.setFinishedState(ResourceState.INSTALLED);
            }
        }

        public String getSortKey() {
            return "25-" + this.getResource().getEntityId();
        }
    }

    private abstract class AbstractPackageInstallTask
    extends InstallTask {
        protected final String name;

        public AbstractPackageInstallTask(String name, TaskResourceGroup erl) {
            super(erl);
            this.name = name;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void execute(InstallationContext ctx) {
            TaskResource resource = this.getResource();
            Session session = null;
            Object pkg = null;
            try {
                session = PackageTransformer.this.repository.loginService(null, null);
                if (!PackageTransformer.this.configuration.observationManagerUserData().isEmpty()) {
                    session.getWorkspace().getObservationManager().setUserData(PackageTransformer.this.configuration.observationManagerUserData());
                }
                JcrPackageManager pkgMgr = PackageTransformer.this.pkgSvc.getPackageManager(session);
                this.doExecute(ctx, pkgMgr, resource);
            }
            catch (Exception e) {
                String message = MessageFormat.format("Error while processing {0} content package task of {1} due to {2}, no retry.", this.name, resource, e.getLocalizedMessage());
                logger.error(message, (Throwable)e);
                this.setFinishedState(ResourceState.IGNORED, null, message);
            }
            finally {
                if (pkg != null) {
                    pkg.close();
                }
                if (session != null) {
                    session.logout();
                }
            }
        }

        protected abstract void doExecute(InstallationContext var1, JcrPackageManager var2, TaskResource var3) throws RepositoryException, PackageException, IOException;
    }
}

