/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.ide.eclipse.core.internal.sync.content;

import java.util.Set;
import org.apache.sling.ide.eclipse.core.ProjectUtil;
import org.apache.sling.ide.eclipse.core.internal.sync.content.EclipseWorkspaceDirectory;
import org.apache.sling.ide.eclipse.core.internal.sync.content.EclipseWorkspaceResource;
import org.apache.sling.ide.filter.Filter;
import org.apache.sling.ide.sync.content.WorkspaceDirectory;
import org.apache.sling.ide.sync.content.WorkspacePath;
import org.apache.sling.ide.sync.content.WorkspaceProject;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;

public class EclipseWorkspaceProject
extends EclipseWorkspaceResource
implements WorkspaceProject {
    public EclipseWorkspaceProject(IProject project, Set<String> ignoredFileNames) {
        super((IResource)project, ignoredFileNames);
    }

    public WorkspaceDirectory getSyncDirectory() {
        return new EclipseWorkspaceDirectory(ProjectUtil.getSyncDirectory(this.getResource()), this.getIgnoredFileNames());
    }

    public Filter getFilter() {
        try {
            Filter filter = ProjectUtil.loadFilter(this.getResource());
            if (filter == null) {
                throw new IllegalStateException("No filter for " + String.valueOf(this));
            }
            return filter;
        }
        catch (CoreException e) {
            throw new RuntimeException(e);
        }
    }

    public WorkspaceDirectory getDirectory(WorkspacePath path) {
        return new EclipseWorkspaceDirectory(this.getResource().getFolder(path.asPortableString()), this.getIgnoredFileNames());
    }

    protected IProject getResource() {
        return (IProject)super.getResource();
    }
}

