/*
 * Decompiled with CFR 0.152.
 */
package relocated_for_contentpackage.org.apache.jackrabbit.vault.util;

import java.io.IOException;
import java.io.OutputStream;

public class BinaryCheckOutputStream
extends OutputStream {
    private final OutputStream out;
    private boolean binary;
    private static final boolean[] binaries = new boolean[256];

    public BinaryCheckOutputStream(OutputStream out) {
        this.out = out;
    }

    public boolean isBinary() {
        return this.binary;
    }

    @Override
    public void write(int b) throws IOException {
        if (!this.binary) {
            this.binary = binaries[b & 0xFF];
        }
        this.out.write(b);
    }

    @Override
    public void write(byte[] b) throws IOException {
        for (int i = 0; i < b.length && !this.binary; ++i) {
            this.binary = binaries[b[i] & 0xFF];
        }
        this.out.write(b);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        for (int i = 0; i < len && !this.binary; ++i) {
            this.binary = binaries[b[i + off] & 0xFF];
        }
        this.out.write(b, off, len);
    }

    @Override
    public void flush() throws IOException {
        this.out.flush();
    }

    @Override
    public void close() throws IOException {
        this.out.close();
    }

    static {
        for (int i = 0; i < 32; ++i) {
            BinaryCheckOutputStream.binaries[i] = true;
        }
        BinaryCheckOutputStream.binaries[13] = false;
        BinaryCheckOutputStream.binaries[10] = false;
        BinaryCheckOutputStream.binaries[9] = false;
        BinaryCheckOutputStream.binaries[8] = false;
        BinaryCheckOutputStream.binaries[12] = false;
    }
}

