/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.discovery.base.connectors;

import java.util.LinkedList;
import java.util.List;
import org.apache.sling.discovery.TopologyView;
import org.apache.sling.discovery.base.connectors.DummyVirtualInstanceBuilder;
import org.apache.sling.discovery.base.its.setup.TopologyHelper;
import org.apache.sling.discovery.base.its.setup.VirtualConnector;
import org.apache.sling.discovery.base.its.setup.VirtualInstance;
import org.apache.sling.discovery.base.its.setup.VirtualInstanceBuilder;
import org.apache.sling.discovery.commons.providers.spi.LocalClusterView;
import org.apache.sling.testing.mock.sling.ResourceResolverType;
import org.apache.sling.testing.mock.sling.junit.SlingContext;
import org.apache.sling.testing.tools.retry.RetryLoop;
import org.apache.sling.testing.tools.sling.TimeoutsProvider;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LargeTopologyWithHubTest {
    private static final Logger logger = LoggerFactory.getLogger(LargeTopologyWithHubTest.class);
    private static List<VirtualInstance> instances;
    private static VirtualInstance hub;
    private static List<String> slingIds;
    private static final int TEST_SIZE = 50;
    @Rule
    public final SlingContext context = new SlingContext(ResourceResolverType.JCR_MOCK);

    private VirtualInstanceBuilder newBuilder() {
        return new DummyVirtualInstanceBuilder().setSlingContext(this.context);
    }

    @Before
    public void setup() throws Throwable {
        instances = new LinkedList<VirtualInstance>();
        int defaultHeartbeatTimeout = 3600;
        int heartbeatTimeout = TimeoutsProvider.getInstance().getTimeout(3600);
        VirtualInstanceBuilder hubBuilder = this.newBuilder().newRepository("/var/discovery/impl/", true).setDebugName("hub").setConnectorPingInterval(5).setConnectorPingTimeout(heartbeatTimeout);
        hub = hubBuilder.build();
        instances.add(hub);
        hub.getConfig().setViewCheckTimeout(heartbeatTimeout);
        hub.heartbeatsAndCheckView();
        hub.heartbeatsAndCheckView();
        Assert.assertNotNull((Object)hub.getClusterViewService().getLocalClusterView());
        hub.startViewChecker(1);
        hub.dumpRepo();
        slingIds = new LinkedList<String>();
        slingIds.add(hub.getSlingId());
        logger.info("setUp: using heartbeatTimeout of " + heartbeatTimeout + "sec (default: " + 3600 + ")");
        for (int i = 0; i < 50; ++i) {
            logger.info("setUp: creating instance" + i);
            VirtualInstanceBuilder builder2 = this.newBuilder().newRepository("/var/discovery/impl/", false).setDebugName("instance" + i).setConnectorPingInterval(5).setConnectorPingTimeout(heartbeatTimeout);
            VirtualInstance instance = builder2.build();
            instances.add(instance);
            instance.getConfig().setViewCheckTimeout(heartbeatTimeout);
            instance.heartbeatsAndCheckView();
            instance.heartbeatsAndCheckView();
            LocalClusterView clusterView = instance.getClusterViewService().getLocalClusterView();
            Assert.assertNotNull((Object)clusterView);
            new VirtualConnector(instance, hub);
            slingIds.add(instance.getSlingId());
        }
    }

    @After
    public void tearDown() throws Exception {
        for (VirtualInstance instance : instances) {
            instance.stop();
        }
    }

    @Test
    public void testLargeTopologyWithHub() throws Exception {
        new RetryLoop(new RetryLoop.Condition(){

            public String getDescription() {
                return "Waiting for large topology with hub to stabilize";
            }

            public boolean isTrue() throws Exception {
                hub.dumpRepo();
                TopologyView tv = hub.getDiscoveryService().getTopology();
                Assert.assertNotNull((Object)tv);
                logger.info("testLargeTopologyWithHub: checking if all connectors are registered, TopologyView has {} Instances", (Object)tv.getInstances().size());
                TopologyHelper.assertTopologyConsistsOf(tv, slingIds.toArray(new String[slingIds.size()]));
                logger.info("testLargeTopologyWithHub: test passed");
                return true;
            }
        }, 30, 500);
    }
}

