/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.cms.core.internal.jobs;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.cms.ConfigurableJobExecutor;
import org.apache.sling.cms.File;
import org.apache.sling.cms.FileMetadataExtractor;
import org.apache.sling.event.jobs.Job;
import org.apache.sling.event.jobs.consumer.JobExecutionContext;
import org.apache.sling.event.jobs.consumer.JobExecutionResult;
import org.apache.sling.event.jobs.consumer.JobExecutor;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={JobExecutor.class, ConfigurableJobExecutor.class}, property={"job.topics=cmsjob/org/apache/sling/cms/file/ExtractMetadata"})
public class FileMetadataExtractorJob
extends ConfigurableJobExecutor {
    public static final Logger log = LoggerFactory.getLogger(FileMetadataExtractorJob.class);
    public static final String PN_RECURSIVE = "recursive";
    public static final String TOPIC = "cmsjob/org/apache/sling/cms/file/ExtractMetadata";
    @Reference
    private FileMetadataExtractor extractor;
    @Reference
    private ResourceResolverFactory factory;

    private void collectFiles(Resource root, List<File> files) {
        for (Resource child : root.getChildren()) {
            if ("sling:File".equals(child.getResourceType())) {
                files.add((File)child.adaptTo(File.class));
                continue;
            }
            this.collectFiles(child, files);
        }
    }

    public JobExecutionResult doProcess(Job job, JobExecutionContext context, ResourceResolver resolver) {
        String path = (String)job.getProperty("path", (Object)"");
        Resource root = resolver.getResource(path);
        if (root != null) {
            ArrayList<File> files = new ArrayList<File>();
            if ("sling:File".equals(root.getResourceType())) {
                files.add((File)root.adaptTo(File.class));
            } else {
                this.collectFiles(root, files);
            }
            context.log("Found {0} files to extract metadata", new Object[]{files.size()});
            context.initProgress(files.size(), -1L);
            int processed = 1;
            for (File file : files) {
                try {
                    this.extractor.extractMetadata(file);
                    context.incrementProgressCount(processed++);
                    context.log("Extracted metadata for {0}", new Object[]{file.getPath()});
                }
                catch (IOException e) {
                    context.log("Failed to extract matadata for {0}", new Object[]{file.getPath()});
                    context.incrementProgressCount(processed++);
                    context.log("Exception {0}", new Object[]{e.getMessage()});
                    log.warn("Failed to extract metadata for " + file.getPath(), (Throwable)e);
                }
            }
            return context.result().message("Metadata Extracted").succeeded();
        }
        return context.result().message("No file found at " + path).failed();
    }

    public String getConfigurationPath() {
        return "/mnt/overlay/sling-cms/content/jobs/filemetadataextractor";
    }

    public ResourceResolverFactory getResolverFactory() {
        return this.factory;
    }

    public String getTitleKey() {
        return "Extract File Metadata";
    }

    public String getTopic() {
        return TOPIC;
    }
}

