/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.shardingsphere.driver.executor.batch.preparedstatement;

import org.apache.shardingsphere.driver.executor.engine.batch.preparedstatement.BatchExecutionUnit;
import org.apache.shardingsphere.infra.executor.sql.context.ExecutionUnit;
import org.apache.shardingsphere.infra.executor.sql.context.SQLUnit;
import org.junit.jupiter.api.Test;

import java.util.Collections;
import java.util.List;

import static org.hamcrest.CoreMatchers.is;
import static org.hamcrest.MatcherAssert.assertThat;
import static org.junit.jupiter.api.Assertions.assertTrue;

class BatchExecutionUnitTest {
    
    private static final String DATA_SOURCE_NAME = "ds";
    
    private static final String SQL = "SELECT * FROM table WHERE id = ?";
    
    @Test
    void assertGetParameterSets() {
        BatchExecutionUnit batchExecutionUnit = new BatchExecutionUnit(new ExecutionUnit(DATA_SOURCE_NAME, new SQLUnit(SQL, Collections.singletonList(1))));
        List<List<Object>> actual = batchExecutionUnit.getParameterSets();
        assertThat(actual.size(), is(1));
        assertTrue(actual.get(0).isEmpty());
        batchExecutionUnit.mapAddBatchCount(0);
        actual = batchExecutionUnit.getParameterSets();
        assertThat(actual.size(), is(1));
        assertThat(actual.get(0).size(), is(1));
        assertThat(actual.get(0).get(0), is(1));
    }
    
    @Test
    void assertEquals() {
        BatchExecutionUnit actual = new BatchExecutionUnit(new ExecutionUnit(DATA_SOURCE_NAME, new SQLUnit(SQL, Collections.singletonList(1))));
        BatchExecutionUnit expected = new BatchExecutionUnit(new ExecutionUnit(DATA_SOURCE_NAME, new SQLUnit(SQL, Collections.singletonList(2))));
        assertThat(actual, is(expected));
    }
    
    @Test
    void assertToString() {
        ExecutionUnit executionUnit = new ExecutionUnit(DATA_SOURCE_NAME, new SQLUnit(SQL, Collections.singletonList(1)));
        BatchExecutionUnit actual = new BatchExecutionUnit(executionUnit);
        assertThat(actual.toString(), is(String.format("BatchExecutionUnit(executionUnit=ExecutionUnit"
                + "(dataSourceName=%s, sqlUnit=SQLUnit(sql=%s, parameters=[%d], tableRouteMappers=[])), "
                + "jdbcAndActualAddBatchCallTimesMap={}, actualCallAddBatchTimes=0)", DATA_SOURCE_NAME, SQL, 1, "null")));
    }
}
