/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.serviceregistry.consumer;

import org.apache.servicecomb.serviceregistry.RegistryUtils;
import org.apache.servicecomb.serviceregistry.api.registry.Microservice;
import org.apache.servicecomb.serviceregistry.version.Version;

public class MicroserviceVersion {
    protected Version version;
    protected Microservice microservice;

    public MicroserviceVersion(String microserviceId) {
        this.microservice = RegistryUtils.getServiceRegistry().getAggregatedRemoteMicroservice(microserviceId);
        if (this.microservice == null) {
            throw new IllegalStateException(String.format("Invalid microserviceId %s.", microserviceId));
        }
        this.version = new Version(this.microservice.getVersion());
    }

    public MicroserviceVersion(Microservice microservice) {
        this.microservice = microservice;
        this.version = new Version(microservice.getVersion());
    }

    public String getMicroserviceId() {
        return this.microservice.getServiceId();
    }

    public Microservice getMicroservice() {
        return this.microservice;
    }

    public Version getVersion() {
        return this.version;
    }
}

