/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.toolkit.oasv.compatibility.factory;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.servicecomb.toolkit.oasv.compatibility.validators.mediatype.MediaTypeAddInParameterNotAllowedDiffValidator;
import org.apache.servicecomb.toolkit.oasv.compatibility.validators.mediatype.MediaTypeDelInParameterNotAllowedDiffValidator;
import org.apache.servicecomb.toolkit.oasv.compatibility.validators.mediatype.MediaTypeDelInRequestBodyNotAllowedDiffValidator;
import org.apache.servicecomb.toolkit.oasv.compatibility.validators.mediatype.MediaTypeDelInResponseNotAllowedDiffValidator;
import org.apache.servicecomb.toolkit.oasv.diffvalidation.api.MediaTypeDiffValidator;
import org.apache.servicecomb.toolkit.oasv.diffvalidation.factory.EncodingDiffValidatorFactory;
import org.apache.servicecomb.toolkit.oasv.diffvalidation.factory.MediaTypeDiffValidatorFactory;
import org.apache.servicecomb.toolkit.oasv.diffvalidation.factory.SchemaDiffValidatorFactory;
import org.apache.servicecomb.toolkit.oasv.diffvalidation.skeleton.mediatype.MediaTypeEncodingDiffValidator;
import org.apache.servicecomb.toolkit.oasv.diffvalidation.skeleton.mediatype.MediaTypeSchemaDiffValidator;
import org.springframework.stereotype.Component;

@Component
public class DefaultMediaTypeDiffValidatorFactory
implements MediaTypeDiffValidatorFactory {
    private final EncodingDiffValidatorFactory encodingDiffValidatorFactory;
    private final SchemaDiffValidatorFactory schemaDiffValidatorFactory;

    public DefaultMediaTypeDiffValidatorFactory(EncodingDiffValidatorFactory encodingDiffValidatorFactory, SchemaDiffValidatorFactory schemaDiffValidatorFactory) {
        this.encodingDiffValidatorFactory = encodingDiffValidatorFactory;
        this.schemaDiffValidatorFactory = schemaDiffValidatorFactory;
    }

    public List<MediaTypeDiffValidator> create() {
        ArrayList<Object> validators = new ArrayList<Object>();
        validators.add(new MediaTypeEncodingDiffValidator(this.encodingDiffValidatorFactory.create()));
        validators.add(new MediaTypeSchemaDiffValidator(this.schemaDiffValidatorFactory.create()));
        validators.add((Object)new MediaTypeAddInParameterNotAllowedDiffValidator());
        validators.add((Object)new MediaTypeDelInParameterNotAllowedDiffValidator());
        validators.add((Object)new MediaTypeDelInRequestBodyNotAllowedDiffValidator());
        validators.add((Object)new MediaTypeDelInResponseNotAllowedDiffValidator());
        return Collections.unmodifiableList(validators);
    }
}

