/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.internal.codegen.js.jx;

import org.apache.royale.compiler.codegen.IDocEmitter;
import org.apache.royale.compiler.codegen.ISubEmitter;
import org.apache.royale.compiler.codegen.js.IJSEmitter;
import org.apache.royale.compiler.common.ISourceLocation;
import org.apache.royale.compiler.definitions.ITypeDefinition;
import org.apache.royale.compiler.internal.codegen.as.ASEmitterTokens;
import org.apache.royale.compiler.internal.codegen.js.JSSubEmitter;
import org.apache.royale.compiler.internal.codegen.js.royale.JSRoyaleDocEmitter;
import org.apache.royale.compiler.internal.codegen.js.royale.JSRoyaleEmitter;
import org.apache.royale.compiler.internal.codegen.js.royale.JSRoyaleEmitterTokens;
import org.apache.royale.compiler.internal.definitions.AppliedVectorDefinition;
import org.apache.royale.compiler.internal.projects.RoyaleJSProject;
import org.apache.royale.compiler.internal.tree.as.BinaryOperatorAssignmentNode;
import org.apache.royale.compiler.internal.tree.as.IdentifierNode;
import org.apache.royale.compiler.internal.tree.as.MemberAccessExpressionNode;
import org.apache.royale.compiler.tree.ASTNodeID;
import org.apache.royale.compiler.tree.as.IASNode;
import org.apache.royale.compiler.tree.as.IDynamicAccessNode;
import org.apache.royale.compiler.tree.as.IExpressionNode;
import org.apache.royale.compiler.tree.as.ILiteralNode;
import org.apache.royale.compiler.tree.as.IOperatorNode;
import org.apache.royale.compiler.utils.ASNodeUtils;

public class DynamicAccessEmitter
extends JSSubEmitter
implements ISubEmitter<IDynamicAccessNode> {
    public DynamicAccessEmitter(IJSEmitter emitter) {
        super(emitter);
    }

    @Override
    public void emit(IDynamicAccessNode node) {
        JSRoyaleEmitter fjs;
        if (ASNodeUtils.hasParenOpen((IOperatorNode)node)) {
            this.write(ASEmitterTokens.PAREN_OPEN);
        }
        IExpressionNode leftOperandNode = node.getLeftOperandNode();
        this.getWalker().walk((IASNode)leftOperandNode);
        if (leftOperandNode.getNodeID() == ASTNodeID.Op_AtID) {
            return;
        }
        IExpressionNode rightOperandNode = node.getRightOperandNode();
        ITypeDefinition type = rightOperandNode.resolveType(this.getProject());
        IJSEmitter ijs = this.getEmitter();
        JSRoyaleEmitter jSRoyaleEmitter = fjs = ijs instanceof JSRoyaleEmitter ? (JSRoyaleEmitter)ijs : null;
        if (fjs != null) {
            boolean isProxy = false;
            boolean isXML = false;
            if (leftOperandNode instanceof MemberAccessExpressionNode) {
                isXML = fjs.isLeftNodeXMLish((IExpressionNode)((MemberAccessExpressionNode)leftOperandNode));
            } else if (leftOperandNode instanceof IExpressionNode) {
                isXML = fjs.isXMLish(leftOperandNode);
            }
            if (leftOperandNode instanceof MemberAccessExpressionNode) {
                isProxy = fjs.isProxy((IExpressionNode)((MemberAccessExpressionNode)leftOperandNode));
            } else if (leftOperandNode instanceof IExpressionNode) {
                isProxy = fjs.isProxy(leftOperandNode);
            }
            if (isXML) {
                if (type == null) {
                    this.write(".child('' +");
                    this.getWalker().walk((IASNode)rightOperandNode);
                    this.write(")");
                    if (ASNodeUtils.hasParenClose((IOperatorNode)node)) {
                        this.write(ASEmitterTokens.PAREN_CLOSE);
                    }
                    return;
                }
                if (type.isInstanceOf("String", this.getProject())) {
                    String field = fjs.stringifyNode((IASNode)rightOperandNode);
                    if (field.startsWith("\"@")) {
                        field = field.replace("@", "");
                        this.write(".attribute(" + field + ")");
                    } else {
                        this.write(".child(" + field + ")");
                    }
                    if (ASNodeUtils.hasParenClose((IOperatorNode)node)) {
                        this.write(ASEmitterTokens.PAREN_CLOSE);
                    }
                    return;
                }
                if (type.isInstanceOf("QName", this.getProject())) {
                    String field = fjs.stringifyNode((IASNode)rightOperandNode);
                    this.write(".child(" + field + ")");
                    if (ASNodeUtils.hasParenClose((IOperatorNode)node)) {
                        this.write(ASEmitterTokens.PAREN_CLOSE);
                    }
                    return;
                }
            } else if (isProxy) {
                boolean isNonStringLiteral = rightOperandNode instanceof ILiteralNode && ((ILiteralNode)rightOperandNode).getLiteralType() != ILiteralNode.LiteralType.STRING;
                this.write(".getProperty(");
                if (isNonStringLiteral) {
                    this.write("'");
                }
                String s = fjs.stringifyNode((IASNode)rightOperandNode);
                this.write(s);
                if (isNonStringLiteral) {
                    this.write("'");
                }
                this.write(")");
                if (ASNodeUtils.hasParenClose((IOperatorNode)node)) {
                    this.write(ASEmitterTokens.PAREN_CLOSE);
                }
                return;
            }
        }
        this.startMapping((ISourceLocation)node, (ISourceLocation)leftOperandNode);
        this.write(ASEmitterTokens.SQUARE_OPEN);
        this.endMapping((ISourceLocation)node);
        boolean wrapVectorIndex = false;
        if (this.getProject() instanceof RoyaleJSProject && node.getNodeID().equals((Object)ASTNodeID.ArrayIndexExpressionID) && node.getParent() instanceof BinaryOperatorAssignmentNode && node.getLeftOperandNode().resolveType(this.getProject()) instanceof AppliedVectorDefinition) {
            JSRoyaleDocEmitter royaleDocEmitter;
            boolean suppressVectorIndexCheck = !((RoyaleJSProject)this.getProject()).config.getJsVectorIndexChecks();
            IDocEmitter docEmitter = this.getEmitter().getDocEmitter();
            if (docEmitter instanceof JSRoyaleDocEmitter && !(suppressVectorIndexCheck = (royaleDocEmitter = (JSRoyaleDocEmitter)docEmitter).getLocalSettingAsBoolean(JSRoyaleEmitterTokens.SUPPRESS_VECTOR_INDEX_CHECK, (Boolean)suppressVectorIndexCheck)) && leftOperandNode instanceof IdentifierNode && royaleDocEmitter.getLocalSettingIncludesString(JSRoyaleEmitterTokens.SUPPRESS_VECTOR_INDEX_CHECK, ((IdentifierNode)leftOperandNode).getName())) {
                suppressVectorIndexCheck = true;
            }
            if (!suppressVectorIndexCheck) {
                this.getModel().needLanguage = true;
                ((RoyaleJSProject)this.getProject()).needLanguage = true;
                this.getWalker().walk((IASNode)leftOperandNode);
                this.write(ASEmitterTokens.SQUARE_OPEN);
                this.write(JSRoyaleEmitterTokens.VECTOR_INDEX_CHECK_METHOD_NAME);
                this.write(ASEmitterTokens.SQUARE_CLOSE);
                this.write(ASEmitterTokens.PAREN_OPEN);
                wrapVectorIndex = true;
            }
        }
        this.getWalker().walk((IASNode)rightOperandNode);
        if (wrapVectorIndex) {
            this.write(ASEmitterTokens.PAREN_CLOSE);
        }
        if (type != null && type.getQualifiedName().contentEquals("QName")) {
            this.write(".objectAccessFormat()");
        }
        this.startMapping((ISourceLocation)node, (ISourceLocation)rightOperandNode);
        this.write(ASEmitterTokens.SQUARE_CLOSE);
        this.endMapping((ISourceLocation)node);
        if (ASNodeUtils.hasParenClose((IOperatorNode)node)) {
            this.write(ASEmitterTokens.PAREN_CLOSE);
        }
    }
}

