/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.ClosureRewriteModule;
import com.google.javascript.jscomp.CodingConvention;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.HotSwapCompilerPass;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.Node;
import java.util.HashMap;
import java.util.Map;

class CheckProvides
implements HotSwapCompilerPass {
    private final AbstractCompiler compiler;
    private final CodingConvention codingConvention;
    static final DiagnosticType MISSING_PROVIDE_WARNING = DiagnosticType.warning("JSC_MISSING_PROVIDE", "missing goog.provide(''{0}'')");

    CheckProvides(AbstractCompiler compiler) {
        this.compiler = compiler;
        this.codingConvention = compiler.getCodingConvention();
    }

    @Override
    public void process(Node externs, Node root) {
        this.hotSwapScript(root, null);
    }

    @Override
    public void hotSwapScript(Node scriptRoot, Node originalRoot) {
        CheckProvidesCallback callback = new CheckProvidesCallback(this.codingConvention);
        NodeTraversal.traverse(this.compiler, scriptRoot, callback);
    }

    private class CheckProvidesCallback
    extends NodeTraversal.AbstractShallowCallback {
        private final Map<String, Node> provides = new HashMap<String, Node>();
        private final Map<String, Node> ctors = new HashMap<String, Node>();
        private final CodingConvention convention;
        private boolean containsRequires = false;

        CheckProvidesCallback(CodingConvention convention) {
            this.convention = convention;
        }

        @Override
        public void visit(NodeTraversal t, Node n, Node parent) {
            switch (n.getToken()) {
                case CALL: {
                    String providedClassName = CheckProvides.this.codingConvention.extractClassNameIfProvide(n, parent);
                    if (providedClassName != null) {
                        this.provides.put(providedClassName, n);
                    }
                    if (this.containsRequires || CheckProvides.this.codingConvention.extractClassNameIfRequire(n, parent) == null) break;
                    this.containsRequires = true;
                    break;
                }
                case FUNCTION: {
                    if (n.isArrowFunction()) break;
                    this.visitFunctionNode(n, parent);
                    break;
                }
                case CLASS: {
                    this.visitClassNode(n);
                    break;
                }
                case SCRIPT: {
                    this.visitScriptNode();
                    break;
                }
            }
        }

        private void visitFunctionNode(Node n, Node parent) {
            JSDocInfo.Visibility visibility;
            String qualifiedName;
            Node name = null;
            JSDocInfo info = parent.getJSDocInfo();
            if (info != null && info.isConstructor()) {
                name = parent.getFirstChild();
            } else {
                info = n.getJSDocInfo();
                if (info != null && info.isConstructor()) {
                    name = n.getFirstChild();
                }
            }
            if (name != null && name.isQualifiedName() && !this.convention.isPrivate(qualifiedName = name.getQualifiedName()) && !(visibility = info.getVisibility()).equals((Object)JSDocInfo.Visibility.PRIVATE)) {
                this.ctors.put(qualifiedName, name);
            }
        }

        private void visitClassNode(Node classNode) {
            String name = NodeUtil.getName(classNode);
            if (name != null && !this.isPrivate(classNode)) {
                this.ctors.put(name, classNode);
            }
        }

        private boolean isPrivate(Node classOrFn) {
            JSDocInfo info = NodeUtil.getBestJSDocInfo(classOrFn);
            if (info != null && info.getVisibility().equals((Object)JSDocInfo.Visibility.PRIVATE)) {
                return true;
            }
            return CheckProvides.this.compiler.getCodingConvention().isPrivate(NodeUtil.getName(classOrFn));
        }

        private void visitScriptNode() {
            for (Map.Entry<String, Node> ctorEntry : this.ctors.entrySet()) {
                String ctorName = ctorEntry.getKey();
                int index = -1;
                boolean found = false;
                if (ctorName.startsWith("$jscomp.") || ClosureRewriteModule.isModuleContent(ctorName) || ClosureRewriteModule.isModuleExport(ctorName)) continue;
                do {
                    String provideKey;
                    String string = provideKey = (index = ctorName.indexOf(46, index + 1)) == -1 ? ctorName : ctorName.substring(0, index);
                    if (!this.provides.containsKey(provideKey)) continue;
                    found = true;
                    break;
                } while (index != -1);
                if (found || !this.containsRequires && this.provides.isEmpty()) continue;
                Node n = ctorEntry.getValue();
                CheckProvides.this.compiler.report(JSError.make(n, MISSING_PROVIDE_WARNING, ctorEntry.getKey()));
            }
            this.provides.clear();
            this.ctors.clear();
            this.containsRequires = false;
        }
    }
}

