/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.filespecs;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import org.apache.royale.compiler.filespecs.BaseFileSpecification;
import org.apache.royale.compiler.filespecs.CombinedFile;
import org.apache.royale.compiler.filespecs.IBinaryFileSpecification;

public class FileSpecification
extends BaseFileSpecification
implements IBinaryFileSpecification {
    public static boolean useCRLFFilter = false;

    public FileSpecification(String path) {
        super(path);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.path == null ? 0 : this.path.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BaseFileSpecification)) {
            return false;
        }
        BaseFileSpecification other = (BaseFileSpecification)obj;
        return !(this.path == null ? other.path != null : !this.path.equals(other.path));
    }

    @Override
    public Reader createReader() throws FileNotFoundException {
        File fileHandle = this.getFileHandle();
        if (!fileHandle.exists()) {
            throw new FileNotFoundException(fileHandle.getAbsolutePath());
        }
        try {
            return this.createNIOReader();
        }
        catch (FileNotFoundException e) {
            throw e;
        }
        catch (IOException e) {
            return new Reader(){

                @Override
                public int read(char[] cbuf, int off, int len) throws IOException {
                    throw e;
                }

                @Override
                public void close() throws IOException {
                }
            };
        }
    }

    private Reader createNIOReader() throws IOException {
        File file = this.getFileHandle();
        BufferedInputStream strm = new BufferedInputStream(new FileInputStream(file));
        CombinedFile.BOM bom = CombinedFile.getBOM(strm);
        strm.skip(bom.pattern.length);
        InputStreamReader inputSR = useCRLFFilter ? new InputStreamReader((InputStream)new NoCRLFInputStream(strm), bom.charset) : new InputStreamReader((InputStream)strm, bom.charset);
        BufferedReader reader = new BufferedReader(inputSR);
        return reader;
    }

    @Override
    public InputStream createInputStream() throws FileNotFoundException {
        return new BufferedInputStream(new FileInputStream(this.getFileHandle()));
    }

    @Override
    public void setLastModified(long fileDate) {
        File fileHandle = this.getFileHandle();
        fileHandle.setLastModified(fileDate);
    }

    public static class NoCRLFInputStream
    extends FilterInputStream {
        public NoCRLFInputStream(InputStream fileInputStream) {
            super(fileInputStream);
        }

        @Override
        public int read() throws IOException {
            int retval = super.read();
            if (retval == 13) {
                retval = super.read();
            }
            return retval;
        }

        @Override
        public int read(byte[] b) throws IOException {
            int extra;
            byte c;
            int n = b.length;
            byte[] temp = new byte[b.length];
            int retval = super.read(temp);
            if (retval == -1) {
                return -1;
            }
            int j = 0;
            for (int i = 0; i < retval; ++i) {
                c = temp[i];
                if (c == 13) continue;
                b[j++] = c;
            }
            while (j < retval && (extra = super.read(b, j, 1)) != -1) {
                c = b[j];
                if (c == 13) continue;
                ++j;
            }
            return j;
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            int extra;
            byte c;
            byte[] temp = new byte[len];
            int retval = super.read(temp, 0, len);
            if (retval == -1) {
                return -1;
            }
            if (retval == 0) {
                return 0;
            }
            int j = 0;
            for (int i = 0; i < retval; ++i) {
                c = temp[i];
                if (c == 13) continue;
                b[off + j++] = c;
            }
            while (j < retval && (extra = super.read(b, off + j, 1)) != -1) {
                c = b[off + j];
                if (c == 13) continue;
                ++j;
            }
            return j;
        }
    }
}

