/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.playwright.impl;

import com.microsoft.playwright.Page;
import com.microsoft.playwright.assertions.PageAssertions;
import com.microsoft.playwright.impl.AssertionsBase;
import com.microsoft.playwright.impl.ExpectedTextValue;
import com.microsoft.playwright.impl.FrameExpectOptions;
import com.microsoft.playwright.impl.LocatorImpl;
import com.microsoft.playwright.impl.PageImpl;
import com.microsoft.playwright.impl.UrlMatcher;
import com.microsoft.playwright.impl.Utils;
import java.util.regex.Pattern;

public class PageAssertionsImpl
extends AssertionsBase
implements PageAssertions {
    private final PageImpl actualPage;

    public PageAssertionsImpl(Page page) {
        this(page, false);
    }

    private PageAssertionsImpl(Page page, boolean isNot) {
        super((LocatorImpl)page.locator(":root"), isNot);
        this.actualPage = (PageImpl)page;
    }

    @Override
    public void hasTitle(String title, PageAssertions.HasTitleOptions options) {
        ExpectedTextValue expected = new ExpectedTextValue();
        expected.string = title;
        expected.normalizeWhiteSpace = true;
        this.expectImpl("to.have.title", expected, (Object)title, "Page title expected to be", Utils.convertType(options, FrameExpectOptions.class));
    }

    @Override
    public void hasTitle(Pattern pattern, PageAssertions.HasTitleOptions options) {
        ExpectedTextValue expected = PageAssertionsImpl.expectedRegex(pattern);
        this.expectImpl("to.have.title", expected, (Object)pattern, "Page title expected to match regex", Utils.convertType(options, FrameExpectOptions.class));
    }

    @Override
    public void hasURL(String url, PageAssertions.HasURLOptions options) {
        ExpectedTextValue expected = new ExpectedTextValue();
        if (this.actualPage.context().baseUrl != null) {
            url = UrlMatcher.resolveUrl(this.actualPage.context().baseUrl, url);
        }
        expected.string = url;
        this.expectImpl("to.have.url", expected, (Object)url, "Page URL expected to be", Utils.convertType(options, FrameExpectOptions.class));
    }

    @Override
    public void hasURL(Pattern pattern, PageAssertions.HasURLOptions options) {
        ExpectedTextValue expected = PageAssertionsImpl.expectedRegex(pattern);
        this.expectImpl("to.have.url", expected, (Object)pattern, "Page URL expected to match regex", Utils.convertType(options, FrameExpectOptions.class));
    }

    @Override
    public PageAssertions not() {
        return new PageAssertionsImpl(this.actualPage, !this.isNot);
    }
}

