/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.internal.codegen.databinding;

import java.util.Collection;
import org.apache.royale.compiler.internal.as.codegen.MXMLClassDirectiveProcessor;
import org.apache.royale.compiler.internal.codegen.databinding.BindingDatabase;
import org.apache.royale.compiler.internal.codegen.databinding.BindingInfo;
import org.apache.royale.compiler.internal.scopes.ASScope;
import org.apache.royale.compiler.problems.ICompilerProblem;
import org.apache.royale.compiler.scopes.IASScope;
import org.apache.royale.compiler.tree.as.IScopedNode;
import org.apache.royale.compiler.tree.mxml.IMXMLBindingNode;
import org.apache.royale.compiler.tree.mxml.IMXMLDataBindingNode;
import org.apache.royale.compiler.tree.mxml.IMXMLNode;

public class BindingAnalyzer {
    public static BindingInfo analyze(IMXMLDataBindingNode node, BindingDatabase bindingDataBase, Collection<ICompilerProblem> problems, int bindingIndex, MXMLClassDirectiveProcessor host) {
        BindingInfo info = new BindingInfo(node, bindingIndex, host);
        bindingDataBase.getBindingInfo().add(info);
        BindingAnalyzer.saveScope(node, bindingDataBase);
        return info;
    }

    private static void saveScope(IMXMLNode node, BindingDatabase bindingDataBase) {
        IScopedNode scopedNode = node.getContainingScope();
        IASScope iscope = scopedNode.getScope();
        ASScope scope = (ASScope)iscope;
        bindingDataBase.setScope(scope);
    }

    public static BindingInfo analyze(IMXMLBindingNode node, BindingDatabase bindingDataBase, Collection<ICompilerProblem> problems, int bindingIndex, boolean reverseSourceAndDest, MXMLClassDirectiveProcessor host) {
        BindingInfo info = new BindingInfo(node, bindingIndex, host, reverseSourceAndDest);
        bindingDataBase.getBindingInfo().add(info);
        BindingAnalyzer.saveScope(node, bindingDataBase);
        return info;
    }
}

