/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */

package org.apache.rocketmq.eventbridge.adapter.runtime.config;

/**
 * Define keys for target runner configs.
 */
public class RuntimeConfigDefine {

    public static final String RUNNER_CLASS = "class";

    public static final String TASK_CLASS = "task-class";

    public static final String RUNNER_NAME = "runner-name";

    public static final String CONNECT_TIMESTAMP = "connect-timestamp";

    public static final String CONNECT_SCHEMA = "connect-schema";

    public static final String TRANSFORMS = "transforms";

    public static final String CONNECT_RECORDS_KEY = "SYSTEM_RETRY_TIMES";

    public static final String TARGET_RUNNER_KEY = "eventBusName";

    public static final String ACCOUNT_ID = "accountId";

}
