/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.shaded.io.opentelemetry.sdk.metrics.internal.state;

import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.rocketmq.shaded.io.opentelemetry.api.common.Attributes;
import org.apache.rocketmq.shaded.io.opentelemetry.context.Context;
import org.apache.rocketmq.shaded.io.opentelemetry.sdk.common.InstrumentationScopeInfo;
import org.apache.rocketmq.shaded.io.opentelemetry.sdk.internal.ThrottlingLogger;
import org.apache.rocketmq.shaded.io.opentelemetry.sdk.metrics.View;
import org.apache.rocketmq.shaded.io.opentelemetry.sdk.metrics.data.AggregationTemporality;
import org.apache.rocketmq.shaded.io.opentelemetry.sdk.metrics.data.ExemplarData;
import org.apache.rocketmq.shaded.io.opentelemetry.sdk.metrics.data.MetricData;
import org.apache.rocketmq.shaded.io.opentelemetry.sdk.metrics.internal.aggregator.Aggregator;
import org.apache.rocketmq.shaded.io.opentelemetry.sdk.metrics.internal.aggregator.AggregatorFactory;
import org.apache.rocketmq.shaded.io.opentelemetry.sdk.metrics.internal.descriptor.InstrumentDescriptor;
import org.apache.rocketmq.shaded.io.opentelemetry.sdk.metrics.internal.descriptor.MetricDescriptor;
import org.apache.rocketmq.shaded.io.opentelemetry.sdk.metrics.internal.exemplar.ExemplarFilter;
import org.apache.rocketmq.shaded.io.opentelemetry.sdk.metrics.internal.export.CollectionInfo;
import org.apache.rocketmq.shaded.io.opentelemetry.sdk.metrics.internal.state.MetricStorage;
import org.apache.rocketmq.shaded.io.opentelemetry.sdk.metrics.internal.state.TemporalMetricStorage;
import org.apache.rocketmq.shaded.io.opentelemetry.sdk.metrics.internal.view.AttributesProcessor;
import org.apache.rocketmq.shaded.io.opentelemetry.sdk.metrics.internal.view.RegisteredView;
import org.apache.rocketmq.shaded.io.opentelemetry.sdk.resources.Resource;

final class AsynchronousMetricStorage<T, U extends ExemplarData>
implements MetricStorage {
    private static final Logger logger = Logger.getLogger(AsynchronousMetricStorage.class.getName());
    private final ThrottlingLogger throttlingLogger = new ThrottlingLogger(logger);
    private final MetricDescriptor metricDescriptor;
    private final TemporalMetricStorage<T, U> metricStorage;
    private final Aggregator<T, U> aggregator;
    private final AttributesProcessor attributesProcessor;
    private Map<Attributes, T> accumulations = new HashMap<Attributes, T>();

    private AsynchronousMetricStorage(MetricDescriptor metricDescriptor, Aggregator<T, U> aggregator, AttributesProcessor attributesProcessor) {
        this.metricDescriptor = metricDescriptor;
        this.metricStorage = new TemporalMetricStorage<T, U>(aggregator, false);
        this.aggregator = aggregator;
        this.attributesProcessor = attributesProcessor;
    }

    static <T, U extends ExemplarData> AsynchronousMetricStorage<T, U> create(RegisteredView registeredView, InstrumentDescriptor instrumentDescriptor) {
        View view = registeredView.getView();
        MetricDescriptor metricDescriptor = MetricDescriptor.create(view, registeredView.getViewSourceInfo(), instrumentDescriptor);
        Aggregator aggregator = ((AggregatorFactory)((Object)view.getAggregation())).createAggregator(instrumentDescriptor, ExemplarFilter.neverSample());
        return new AsynchronousMetricStorage(metricDescriptor, aggregator, registeredView.getViewAttributesProcessor());
    }

    void recordLong(long value, Attributes attributes) {
        T accumulation = this.aggregator.accumulateLongMeasurement(value, attributes, Context.current());
        if (accumulation != null) {
            this.recordAccumulation(accumulation, attributes);
        }
    }

    void recordDouble(double value, Attributes attributes) {
        T accumulation = this.aggregator.accumulateDoubleMeasurement(value, attributes, Context.current());
        if (accumulation != null) {
            this.recordAccumulation(accumulation, attributes);
        }
    }

    private void recordAccumulation(T accumulation, Attributes attributes) {
        Attributes processedAttributes = this.attributesProcessor.process(attributes, Context.current());
        if (this.accumulations.size() >= 2000) {
            this.throttlingLogger.log(Level.WARNING, "Instrument " + this.metricDescriptor.getSourceInstrument().getName() + " has exceeded the maximum allowed accumulations (" + 2000 + ").");
            return;
        }
        if (this.accumulations.containsKey(attributes)) {
            this.throttlingLogger.log(Level.WARNING, "Instrument " + this.metricDescriptor.getSourceInstrument().getName() + " has recorded multiple values for the same attributes.");
            return;
        }
        this.accumulations.put(processedAttributes, accumulation);
    }

    @Override
    public MetricDescriptor getMetricDescriptor() {
        return this.metricDescriptor;
    }

    @Override
    public MetricData collectAndReset(CollectionInfo collectionInfo, Resource resource, InstrumentationScopeInfo instrumentationScopeInfo, long startEpochNanos, long epochNanos, boolean suppressSynchronousCollection) {
        AggregationTemporality temporality = collectionInfo.getAggregationTemporality(this.metricDescriptor.getSourceInstrument().getType());
        Map<Attributes, T> currentAccumulations = this.accumulations;
        this.accumulations = new HashMap<Attributes, T>();
        return this.metricStorage.buildMetricFor(collectionInfo.getCollector(), resource, instrumentationScopeInfo, this.getMetricDescriptor(), temporality, currentAccumulations, startEpochNanos, epochNanos);
    }

    @Override
    public boolean isEmpty() {
        return this.aggregator == Aggregator.drop();
    }
}

