/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.client.java.rpc;

import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Optional;
import org.apache.rocketmq.client.apis.ClientConfiguration;
import org.apache.rocketmq.client.apis.SessionCredentials;
import org.apache.rocketmq.client.apis.SessionCredentialsProvider;
import org.apache.rocketmq.client.java.misc.MetadataUtils;
import org.apache.rocketmq.client.java.misc.RequestIdGenerator;
import org.apache.rocketmq.client.java.misc.Utilities;
import org.apache.rocketmq.client.java.rpc.TLSHelper;
import org.apache.rocketmq.shaded.commons.lang3.StringUtils;
import org.apache.rocketmq.shaded.io.grpc.Metadata;

public class Signature {
    public static final String AUTHORIZATION_KEY = "authorization";
    public static final String DATE_TIME_KEY = "x-mq-date-time";
    public static final String SESSION_TOKEN_KEY = "x-mq-session-token";
    public static final String CLIENT_ID_KEY = "x-mq-client-id";
    public static final String REQUEST_ID_KEY = "x-mq-request-id";
    public static final String LANGUAGE_KEY = "x-mq-language";
    public static final String CLIENT_VERSION_KEY = "x-mq-client-version";
    public static final String PROTOCOL_VERSION = "x-mq-protocol";
    public static final String ALGORITHM = "MQv2-HMAC-SHA1";
    public static final String CREDENTIAL = "Credential";
    public static final String SIGNED_HEADERS = "SignedHeaders";
    public static final String SIGNATURE = "Signature";
    public static final String DATE_TIME_FORMAT = "yyyyMMdd'T'HHmmss'Z'";

    private Signature() {
    }

    public static Metadata sign(ClientConfiguration config, String clientId) throws NoSuchAlgorithmException, InvalidKeyException {
        Metadata metadata = new Metadata();
        metadata.put(Metadata.Key.of(LANGUAGE_KEY, Metadata.ASCII_STRING_MARSHALLER), "JAVA");
        metadata.put(Metadata.Key.of(PROTOCOL_VERSION, Metadata.ASCII_STRING_MARSHALLER), Utilities.getProtocolVersion());
        metadata.put(Metadata.Key.of(CLIENT_VERSION_KEY, Metadata.ASCII_STRING_MARSHALLER), MetadataUtils.getVersion());
        String dateTime = new SimpleDateFormat(DATE_TIME_FORMAT).format(new Date());
        metadata.put(Metadata.Key.of(DATE_TIME_KEY, Metadata.ASCII_STRING_MARSHALLER), dateTime);
        String requestId = RequestIdGenerator.getInstance().next();
        metadata.put(Metadata.Key.of(REQUEST_ID_KEY, Metadata.ASCII_STRING_MARSHALLER), requestId);
        metadata.put(Metadata.Key.of(CLIENT_ID_KEY, Metadata.ASCII_STRING_MARSHALLER), clientId);
        Optional<SessionCredentialsProvider> optionalSessionCredentialsProvider = config.getCredentialsProvider();
        if (!optionalSessionCredentialsProvider.isPresent()) {
            return metadata;
        }
        SessionCredentialsProvider provider = optionalSessionCredentialsProvider.get();
        SessionCredentials credentials = provider.getSessionCredentials();
        if (null == credentials) {
            return metadata;
        }
        Optional<String> optionalSecurityToken = credentials.tryGetSecurityToken();
        optionalSecurityToken.ifPresent(s2 -> metadata.put(Metadata.Key.of(SESSION_TOKEN_KEY, Metadata.ASCII_STRING_MARSHALLER), s2));
        String accessKey = credentials.getAccessKey();
        String accessSecret = credentials.getAccessSecret();
        if (StringUtils.isBlank(accessKey)) {
            return metadata;
        }
        if (StringUtils.isBlank(accessSecret)) {
            return metadata;
        }
        String sign = TLSHelper.sign(accessSecret, dateTime);
        String authorization = "MQv2-HMAC-SHA1 Credential=" + accessKey + ", " + SIGNED_HEADERS + "=" + DATE_TIME_KEY + ", " + SIGNATURE + "=" + sign;
        metadata.put(Metadata.Key.of(AUTHORIZATION_KEY, Metadata.ASCII_STRING_MARSHALLER), authorization);
        return metadata;
    }
}

