/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.store.rocksdb;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.apache.rocketmq.common.UtilAll;
import org.apache.rocketmq.common.config.AbstractRocksDBStorage;
import org.apache.rocketmq.store.MessageStore;
import org.apache.rocketmq.store.rocksdb.ConsumeQueueCompactionFilterFactory;
import org.apache.rocketmq.store.rocksdb.RocksDBOptionsFactory;
import org.rocksdb.ColumnFamilyDescriptor;
import org.rocksdb.ColumnFamilyHandle;
import org.rocksdb.ColumnFamilyOptions;
import org.rocksdb.ReadOptions;
import org.rocksdb.RocksDB;
import org.rocksdb.RocksDBException;
import org.rocksdb.RocksIterator;
import org.rocksdb.WriteBatch;

public class ConsumeQueueRocksDBStorage
extends AbstractRocksDBStorage {
    public static final byte[] OFFSET_COLUMN_FAMILY = "offset".getBytes(StandardCharsets.UTF_8);
    private final MessageStore messageStore;
    private volatile ColumnFamilyHandle offsetCFHandle;
    private ConsumeQueueCompactionFilterFactory compactionFilterFactory;

    public ConsumeQueueRocksDBStorage(MessageStore messageStore, String dbPath) {
        super(dbPath);
        this.messageStore = messageStore;
        this.readOnly = false;
    }

    protected void initOptions() {
        this.options = RocksDBOptionsFactory.createDBOptions();
        super.initOptions();
    }

    protected void initTotalOrderReadOptions() {
        this.totalOrderReadOptions = new ReadOptions();
        this.totalOrderReadOptions.setPrefixSameAsStart(false);
        this.totalOrderReadOptions.setTotalOrderSeek(false);
    }

    protected boolean postLoad() {
        try {
            UtilAll.ensureDirOK((String)this.dbPath);
            this.initOptions();
            ArrayList<ColumnFamilyDescriptor> cfDescriptors = new ArrayList<ColumnFamilyDescriptor>();
            this.compactionFilterFactory = new ConsumeQueueCompactionFilterFactory(this.messageStore::getMinPhyOffset);
            ColumnFamilyOptions cqCfOptions = RocksDBOptionsFactory.createCQCFOptions(this.messageStore, this.compactionFilterFactory);
            this.cfOptions.add(cqCfOptions);
            cfDescriptors.add(new ColumnFamilyDescriptor(RocksDB.DEFAULT_COLUMN_FAMILY, cqCfOptions));
            ColumnFamilyOptions offsetCfOptions = RocksDBOptionsFactory.createOffsetCFOptions();
            this.cfOptions.add(offsetCfOptions);
            cfDescriptors.add(new ColumnFamilyDescriptor(OFFSET_COLUMN_FAMILY, offsetCfOptions));
            this.open(cfDescriptors);
            this.defaultCFHandle = (ColumnFamilyHandle)this.cfHandles.get(0);
            this.offsetCFHandle = (ColumnFamilyHandle)this.cfHandles.get(1);
        }
        catch (Exception e) {
            LOGGER.error("postLoad Failed. {}", (Object)this.dbPath, (Object)e);
            return false;
        }
        return true;
    }

    protected void preShutdown() {
        if (this.offsetCFHandle != null) {
            this.offsetCFHandle.close();
        }
        if (this.compactionFilterFactory != null) {
            this.compactionFilterFactory.close();
        }
    }

    public byte[] getCQ(byte[] keyBytes) throws RocksDBException {
        return this.get(this.defaultCFHandle, this.totalOrderReadOptions, keyBytes);
    }

    public byte[] getOffset(byte[] keyBytes) throws RocksDBException {
        return this.get(this.offsetCFHandle, this.totalOrderReadOptions, keyBytes);
    }

    public List<byte[]> multiGet(List<ColumnFamilyHandle> cfhList, List<byte[]> keys) throws RocksDBException {
        return this.multiGet(this.totalOrderReadOptions, cfhList, keys);
    }

    public void batchPut(WriteBatch batch) throws RocksDBException {
        this.batchPut(this.writeOptions, batch);
    }

    public void manualCompaction(long minPhyOffset) {
        try {
            this.manualCompaction(minPhyOffset, this.compactRangeOptions);
        }
        catch (Exception e) {
            LOGGER.error("manualCompaction Failed. minPhyOffset: {}", (Object)minPhyOffset, (Object)e);
        }
    }

    public RocksIterator seekOffsetCF() {
        return this.db.newIterator(this.offsetCFHandle, this.totalOrderReadOptions);
    }

    public ColumnFamilyHandle getOffsetCFHandle() {
        return this.offsetCFHandle;
    }
}

