/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.filter.expression;

import org.apache.rocketmq.filter.expression.EvaluationContext;
import org.apache.rocketmq.filter.expression.Expression;
import org.apache.rocketmq.filter.expression.NowExpression;

public class ConstantExpression
implements Expression {
    private Object value;

    public ConstantExpression(Object value) {
        this.value = value;
    }

    public static ConstantExpression createFromDecimal(String text) {
        Number value;
        long l;
        if (text.endsWith("l") || text.endsWith("L")) {
            text = text.substring(0, text.length() - 1);
        }
        if (Integer.MIN_VALUE <= (l = ((Number)(value = new Long(text))).longValue()) && l <= Integer.MAX_VALUE) {
            value = ((Number)value).intValue();
        }
        return new ConstantExpression(value);
    }

    public static ConstantExpression createFloat(String text) {
        Double value = new Double(text);
        if (value > Double.MAX_VALUE) {
            throw new RuntimeException(text + " is greater than " + Double.MAX_VALUE);
        }
        if (value < Double.MIN_VALUE) {
            throw new RuntimeException(text + " is less than " + Double.MIN_VALUE);
        }
        return new ConstantExpression(value);
    }

    public static ConstantExpression createNow() {
        return new NowExpression();
    }

    @Override
    public Object evaluate(EvaluationContext context) throws Exception {
        return this.value;
    }

    public Object getValue() {
        return this.value;
    }

    public String toString() {
        Object value = this.getValue();
        if (value == null) {
            return "NULL";
        }
        if (value instanceof Boolean) {
            return (Boolean)value != false ? "TRUE" : "FALSE";
        }
        if (value instanceof String) {
            return ConstantExpression.encodeString((String)value);
        }
        return value.toString();
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public boolean equals(Object o) {
        if (o == null || !this.getClass().equals(o.getClass())) {
            return false;
        }
        return this.toString().equals(o.toString());
    }

    public static String encodeString(String s) {
        StringBuilder builder = new StringBuilder();
        builder.append('\'');
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == '\'') {
                builder.append(c);
            }
            builder.append(c);
        }
        builder.append('\'');
        return builder.toString();
    }
}

