/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.store;

public class RunningFlags {
    private static final int NOT_READABLE_BIT = 1;
    private static final int NOT_WRITEABLE_BIT = 2;
    private static final int WRITE_LOGICS_QUEUE_ERROR_BIT = 4;
    private static final int WRITE_INDEX_FILE_ERROR_BIT = 8;
    private static final int DISK_FULL_BIT = 16;
    private static final int FENCED_BIT = 32;
    private static final int LOGIC_DISK_FULL_BIT = 64;
    private volatile int flagBits = 0;

    public int getFlagBits() {
        return this.flagBits;
    }

    public boolean getAndMakeReadable() {
        boolean result = this.isReadable();
        if (!result) {
            this.flagBits &= 0xFFFFFFFE;
        }
        return result;
    }

    public boolean isReadable() {
        return (this.flagBits & 1) == 0;
    }

    public boolean isFenced() {
        return (this.flagBits & 0x20) != 0;
    }

    public boolean getAndMakeNotReadable() {
        boolean result = this.isReadable();
        if (result) {
            this.flagBits |= 1;
        }
        return result;
    }

    public void clearLogicsQueueError() {
        this.flagBits &= 0xFFFFFFFB;
    }

    public boolean getAndMakeWriteable() {
        boolean result = this.isWriteable();
        if (!result) {
            this.flagBits &= 0xFFFFFFFD;
        }
        return result;
    }

    public boolean isWriteable() {
        return (this.flagBits & 0x7E) == 0;
    }

    public boolean isCQWriteable() {
        return (this.flagBits & 0x4E) == 0;
    }

    public boolean getAndMakeNotWriteable() {
        boolean result = this.isWriteable();
        if (result) {
            this.flagBits |= 2;
        }
        return result;
    }

    public void makeLogicsQueueError() {
        this.flagBits |= 4;
    }

    public void makeFenced(boolean fenced) {
        this.flagBits = fenced ? (this.flagBits |= 0x20) : (this.flagBits &= 0xFFFFFFDF);
    }

    public boolean isLogicsQueueError() {
        return (this.flagBits & 4) == 4;
    }

    public void makeIndexFileError() {
        this.flagBits |= 8;
    }

    public boolean isIndexFileError() {
        return (this.flagBits & 8) == 8;
    }

    public boolean getAndMakeDiskFull() {
        boolean result = (this.flagBits & 0x10) != 16;
        this.flagBits |= 0x10;
        return result;
    }

    public boolean getAndMakeDiskOK() {
        boolean result = (this.flagBits & 0x10) != 16;
        this.flagBits &= 0xFFFFFFEF;
        return result;
    }

    public boolean getAndMakeLogicDiskFull() {
        boolean result = (this.flagBits & 0x40) != 64;
        this.flagBits |= 0x40;
        return result;
    }

    public boolean getAndMakeLogicDiskOK() {
        boolean result = (this.flagBits & 0x40) != 64;
        this.flagBits &= 0xFFFFFFBF;
        return result;
    }
}

