/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.tools.command.topic;

import java.nio.charset.StandardCharsets;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionGroup;
import org.apache.commons.cli.Options;
import org.apache.rocketmq.common.MixAll;
import org.apache.rocketmq.remoting.RPCHook;
import org.apache.rocketmq.remoting.protocol.body.ClusterInfo;
import org.apache.rocketmq.remoting.protocol.statictopic.TopicQueueMappingUtils;
import org.apache.rocketmq.remoting.protocol.statictopic.TopicRemappingDetailWrapper;
import org.apache.rocketmq.srvutil.ServerUtil;
import org.apache.rocketmq.tools.admin.DefaultMQAdminExt;
import org.apache.rocketmq.tools.admin.MQAdminUtils;
import org.apache.rocketmq.tools.command.SubCommand;
import org.apache.rocketmq.tools.command.SubCommandException;

public class UpdateStaticTopicSubCommand
implements SubCommand {
    @Override
    public String commandName() {
        return "updateStaticTopic";
    }

    @Override
    public String commandDesc() {
        return "Update or create static topic, which has fixed number of queues";
    }

    @Override
    public Options buildCommandlineOptions(Options options) {
        OptionGroup optionGroup = new OptionGroup();
        Option opt = null;
        opt = new Option("c", "clusters", true, "remapping static topic to clusters, comma separated");
        optionGroup.addOption(opt);
        opt = new Option("b", "brokers", true, "remapping static topic to brokers, comma separated");
        optionGroup.addOption(opt);
        optionGroup.setRequired(true);
        options.addOptionGroup(optionGroup);
        opt = new Option("t", "topic", true, "topic name");
        opt.setRequired(true);
        options.addOption(opt);
        opt = new Option("qn", "totalQueueNum", true, "total queue num");
        opt.setRequired(true);
        options.addOption(opt);
        opt = new Option("mf", "mapFile", true, "The mapping data file name");
        opt.setRequired(false);
        options.addOption(opt);
        opt = new Option("fr", "forceReplace", true, "Force replace the old mapping");
        opt.setRequired(false);
        options.addOption(opt);
        return options;
    }

    public void executeFromFile(CommandLine commandLine, Options options, RPCHook rpcHook) throws SubCommandException {
        DefaultMQAdminExt defaultMQAdminExt = new DefaultMQAdminExt(rpcHook);
        defaultMQAdminExt.setInstanceName(Long.toString(System.currentTimeMillis()));
        try {
            defaultMQAdminExt.start();
            String topic = commandLine.getOptionValue('t').trim();
            String mapFileName = commandLine.getOptionValue('f').trim();
            String mapData = MixAll.file2String((String)mapFileName);
            TopicRemappingDetailWrapper wrapper = (TopicRemappingDetailWrapper)TopicRemappingDetailWrapper.decode((byte[])mapData.getBytes(StandardCharsets.UTF_8), TopicRemappingDetailWrapper.class);
            TopicQueueMappingUtils.checkNameEpochNumConsistence((String)topic, (Map)wrapper.getBrokerConfigMap());
            boolean force = false;
            if (commandLine.hasOption("fr") && Boolean.parseBoolean(commandLine.getOptionValue("fr").trim())) {
                force = true;
            }
            TopicQueueMappingUtils.checkAndBuildMappingItems(new ArrayList(TopicQueueMappingUtils.getMappingDetailFromConfig(wrapper.getBrokerConfigMap().values())), (boolean)false, (boolean)true);
            MQAdminUtils.completeNoTargetBrokers(wrapper.getBrokerConfigMap(), defaultMQAdminExt);
            MQAdminUtils.updateTopicConfigMappingAll(wrapper.getBrokerConfigMap(), defaultMQAdminExt, false);
            return;
        }
        catch (Exception e) {
            throw new SubCommandException(this.getClass().getSimpleName() + " command failed", e);
        }
        finally {
            defaultMQAdminExt.shutdown();
        }
    }

    @Override
    public void execute(CommandLine commandLine, Options options, RPCHook rpcHook) throws SubCommandException {
        if (!commandLine.hasOption('t')) {
            ServerUtil.printCommandLineHelp((String)("mqadmin " + this.commandName()), (Options)options);
            return;
        }
        if (commandLine.hasOption("f")) {
            this.executeFromFile(commandLine, options, rpcHook);
            return;
        }
        DefaultMQAdminExt defaultMQAdminExt = new DefaultMQAdminExt(rpcHook);
        defaultMQAdminExt.setInstanceName(Long.toString(System.currentTimeMillis()));
        Map<Object, Object> brokerConfigMap = new HashMap();
        HashSet<Object> targetBrokers = new HashSet<Object>();
        try {
            defaultMQAdminExt.start();
            if (!commandLine.hasOption("b") && !commandLine.hasOption('c') || !commandLine.hasOption("qn")) {
                ServerUtil.printCommandLineHelp((String)("mqadmin " + this.commandName()), (Options)options);
                return;
            }
            String topic = commandLine.getOptionValue('t').trim();
            ClusterInfo clusterInfo = defaultMQAdminExt.examineBrokerClusterInfo();
            if (clusterInfo == null || clusterInfo.getClusterAddrTable().isEmpty()) {
                throw new RuntimeException("The Cluster info is empty");
            }
            if (commandLine.hasOption("b")) {
                String brokerStrs = commandLine.getOptionValue("b").trim();
                for (String broker : brokerStrs.split(",")) {
                    targetBrokers.add(broker.trim());
                }
            } else if (commandLine.hasOption("c")) {
                String clusters = commandLine.getOptionValue('c').trim();
                for (String cluster : clusters.split(",")) {
                    cluster = cluster.trim();
                    if (clusterInfo.getClusterAddrTable().get(cluster) == null) continue;
                    targetBrokers.addAll((Collection)clusterInfo.getClusterAddrTable().get(cluster));
                }
            }
            if (targetBrokers.isEmpty()) {
                throw new RuntimeException("Find none brokers, do nothing");
            }
            brokerConfigMap = MQAdminUtils.examineTopicConfigAll(topic, defaultMQAdminExt);
            int queueNum = Integer.parseInt(commandLine.getOptionValue("qn").trim());
            Map.Entry<Long, Integer> maxEpochAndNum = new AbstractMap.SimpleImmutableEntry<Long, Integer>(System.currentTimeMillis(), queueNum);
            if (!brokerConfigMap.isEmpty()) {
                maxEpochAndNum = TopicQueueMappingUtils.checkNameEpochNumConsistence((String)topic, brokerConfigMap);
            }
            TopicRemappingDetailWrapper oldWrapper = new TopicRemappingDetailWrapper(topic, "CREATE_OR_UPDATE", maxEpochAndNum.getKey().longValue(), brokerConfigMap, new HashSet(), new HashSet());
            String oldMappingDataFile = TopicQueueMappingUtils.writeToTemp((TopicRemappingDetailWrapper)oldWrapper, (boolean)false);
            System.out.printf("The old mapping data is written to file " + oldMappingDataFile + "\n", new Object[0]);
            targetBrokers.addAll(brokerConfigMap.keySet());
            TopicRemappingDetailWrapper newWrapper = TopicQueueMappingUtils.createTopicConfigMapping((String)topic, (int)queueNum, targetBrokers, brokerConfigMap);
            String newMappingDataFile = TopicQueueMappingUtils.writeToTemp((TopicRemappingDetailWrapper)newWrapper, (boolean)true);
            System.out.printf("The new mapping data is written to file " + newMappingDataFile + "\n", new Object[0]);
            MQAdminUtils.completeNoTargetBrokers(brokerConfigMap, defaultMQAdminExt);
            MQAdminUtils.updateTopicConfigMappingAll(brokerConfigMap, defaultMQAdminExt, false);
        }
        catch (Exception e) {
            throw new SubCommandException(this.getClass().getSimpleName() + " command failed", e);
        }
        finally {
            defaultMQAdminExt.shutdown();
        }
    }
}

