/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.broker.processor;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Sets;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.apache.rocketmq.acl.AccessValidator;
import org.apache.rocketmq.acl.plain.PlainAccessValidator;
import org.apache.rocketmq.broker.BrokerController;
import org.apache.rocketmq.broker.client.ClientChannelInfo;
import org.apache.rocketmq.broker.client.ConsumerGroupInfo;
import org.apache.rocketmq.broker.controller.ReplicasManager;
import org.apache.rocketmq.broker.filter.ConsumerFilterData;
import org.apache.rocketmq.broker.filter.ExpressionMessageFilter;
import org.apache.rocketmq.broker.plugin.BrokerAttachedPlugin;
import org.apache.rocketmq.broker.subscription.SubscriptionGroupManager;
import org.apache.rocketmq.broker.transaction.queue.TransactionalMessageUtil;
import org.apache.rocketmq.common.AclConfig;
import org.apache.rocketmq.common.BrokerConfig;
import org.apache.rocketmq.common.LockCallback;
import org.apache.rocketmq.common.MQVersion;
import org.apache.rocketmq.common.MixAll;
import org.apache.rocketmq.common.PlainAccessConfig;
import org.apache.rocketmq.common.TopicConfig;
import org.apache.rocketmq.common.UnlockCallback;
import org.apache.rocketmq.common.UtilAll;
import org.apache.rocketmq.common.attribute.AttributeParser;
import org.apache.rocketmq.common.message.Message;
import org.apache.rocketmq.common.message.MessageAccessor;
import org.apache.rocketmq.common.message.MessageDecoder;
import org.apache.rocketmq.common.message.MessageExt;
import org.apache.rocketmq.common.message.MessageExtBrokerInner;
import org.apache.rocketmq.common.message.MessageId;
import org.apache.rocketmq.common.message.MessageQueue;
import org.apache.rocketmq.common.stats.StatsItem;
import org.apache.rocketmq.common.stats.StatsSnapshot;
import org.apache.rocketmq.common.topic.TopicValidator;
import org.apache.rocketmq.filter.util.BitsArray;
import org.apache.rocketmq.logging.org.slf4j.Logger;
import org.apache.rocketmq.logging.org.slf4j.LoggerFactory;
import org.apache.rocketmq.remoting.CommandCustomHeader;
import org.apache.rocketmq.remoting.common.RemotingHelper;
import org.apache.rocketmq.remoting.exception.RemotingCommandException;
import org.apache.rocketmq.remoting.exception.RemotingTimeoutException;
import org.apache.rocketmq.remoting.netty.NettyRemotingAbstract;
import org.apache.rocketmq.remoting.netty.NettyRequestProcessor;
import org.apache.rocketmq.remoting.protocol.LanguageCode;
import org.apache.rocketmq.remoting.protocol.RemotingCommand;
import org.apache.rocketmq.remoting.protocol.RemotingSerializable;
import org.apache.rocketmq.remoting.protocol.admin.ConsumeStats;
import org.apache.rocketmq.remoting.protocol.admin.OffsetWrapper;
import org.apache.rocketmq.remoting.protocol.admin.TopicOffset;
import org.apache.rocketmq.remoting.protocol.admin.TopicStatsTable;
import org.apache.rocketmq.remoting.protocol.body.BrokerMemberGroup;
import org.apache.rocketmq.remoting.protocol.body.BrokerStatsData;
import org.apache.rocketmq.remoting.protocol.body.BrokerStatsItem;
import org.apache.rocketmq.remoting.protocol.body.Connection;
import org.apache.rocketmq.remoting.protocol.body.ConsumeQueueData;
import org.apache.rocketmq.remoting.protocol.body.ConsumeStatsList;
import org.apache.rocketmq.remoting.protocol.body.ConsumerConnection;
import org.apache.rocketmq.remoting.protocol.body.EpochEntryCache;
import org.apache.rocketmq.remoting.protocol.body.GroupList;
import org.apache.rocketmq.remoting.protocol.body.HARuntimeInfo;
import org.apache.rocketmq.remoting.protocol.body.KVTable;
import org.apache.rocketmq.remoting.protocol.body.LockBatchRequestBody;
import org.apache.rocketmq.remoting.protocol.body.LockBatchResponseBody;
import org.apache.rocketmq.remoting.protocol.body.ProducerConnection;
import org.apache.rocketmq.remoting.protocol.body.ProducerTableInfo;
import org.apache.rocketmq.remoting.protocol.body.QueryConsumeQueueResponseBody;
import org.apache.rocketmq.remoting.protocol.body.QueryConsumeTimeSpanBody;
import org.apache.rocketmq.remoting.protocol.body.QueryCorrectionOffsetBody;
import org.apache.rocketmq.remoting.protocol.body.QuerySubscriptionResponseBody;
import org.apache.rocketmq.remoting.protocol.body.QueueTimeSpan;
import org.apache.rocketmq.remoting.protocol.body.ResetOffsetBody;
import org.apache.rocketmq.remoting.protocol.body.SyncStateSet;
import org.apache.rocketmq.remoting.protocol.body.TopicConfigAndMappingSerializeWrapper;
import org.apache.rocketmq.remoting.protocol.body.TopicList;
import org.apache.rocketmq.remoting.protocol.body.UnlockBatchRequestBody;
import org.apache.rocketmq.remoting.protocol.header.CloneGroupOffsetRequestHeader;
import org.apache.rocketmq.remoting.protocol.header.ConsumeMessageDirectlyResultRequestHeader;
import org.apache.rocketmq.remoting.protocol.header.CreateAccessConfigRequestHeader;
import org.apache.rocketmq.remoting.protocol.header.CreateTopicRequestHeader;
import org.apache.rocketmq.remoting.protocol.header.DeleteAccessConfigRequestHeader;
import org.apache.rocketmq.remoting.protocol.header.DeleteSubscriptionGroupRequestHeader;
import org.apache.rocketmq.remoting.protocol.header.DeleteTopicRequestHeader;
import org.apache.rocketmq.remoting.protocol.header.ExchangeHAInfoRequestHeader;
import org.apache.rocketmq.remoting.protocol.header.ExchangeHAInfoResponseHeader;
import org.apache.rocketmq.remoting.protocol.header.GetAllProducerInfoRequestHeader;
import org.apache.rocketmq.remoting.protocol.header.GetAllTopicConfigResponseHeader;
import org.apache.rocketmq.remoting.protocol.header.GetBrokerAclConfigResponseHeader;
import org.apache.rocketmq.remoting.protocol.header.GetBrokerClusterAclConfigResponseBody;
import org.apache.rocketmq.remoting.protocol.header.GetBrokerClusterAclConfigResponseHeader;
import org.apache.rocketmq.remoting.protocol.header.GetBrokerConfigResponseHeader;
import org.apache.rocketmq.remoting.protocol.header.GetConsumeStatsInBrokerHeader;
import org.apache.rocketmq.remoting.protocol.header.GetConsumeStatsRequestHeader;
import org.apache.rocketmq.remoting.protocol.header.GetConsumerConnectionListRequestHeader;
import org.apache.rocketmq.remoting.protocol.header.GetConsumerRunningInfoRequestHeader;
import org.apache.rocketmq.remoting.protocol.header.GetConsumerStatusRequestHeader;
import org.apache.rocketmq.remoting.protocol.header.GetEarliestMsgStoretimeRequestHeader;
import org.apache.rocketmq.remoting.protocol.header.GetEarliestMsgStoretimeResponseHeader;
import org.apache.rocketmq.remoting.protocol.header.GetMaxOffsetRequestHeader;
import org.apache.rocketmq.remoting.protocol.header.GetMaxOffsetResponseHeader;
import org.apache.rocketmq.remoting.protocol.header.GetMinOffsetRequestHeader;
import org.apache.rocketmq.remoting.protocol.header.GetMinOffsetResponseHeader;
import org.apache.rocketmq.remoting.protocol.header.GetProducerConnectionListRequestHeader;
import org.apache.rocketmq.remoting.protocol.header.GetSubscriptionGroupConfigRequestHeader;
import org.apache.rocketmq.remoting.protocol.header.GetTopicConfigRequestHeader;
import org.apache.rocketmq.remoting.protocol.header.GetTopicStatsInfoRequestHeader;
import org.apache.rocketmq.remoting.protocol.header.NotifyBrokerRoleChangedRequestHeader;
import org.apache.rocketmq.remoting.protocol.header.NotifyMinBrokerIdChangeRequestHeader;
import org.apache.rocketmq.remoting.protocol.header.QueryConsumeQueueRequestHeader;
import org.apache.rocketmq.remoting.protocol.header.QueryConsumeTimeSpanRequestHeader;
import org.apache.rocketmq.remoting.protocol.header.QueryCorrectionOffsetHeader;
import org.apache.rocketmq.remoting.protocol.header.QuerySubscriptionByConsumerRequestHeader;
import org.apache.rocketmq.remoting.protocol.header.QueryTopicConsumeByWhoRequestHeader;
import org.apache.rocketmq.remoting.protocol.header.QueryTopicsByConsumerRequestHeader;
import org.apache.rocketmq.remoting.protocol.header.ResetMasterFlushOffsetHeader;
import org.apache.rocketmq.remoting.protocol.header.ResetOffsetRequestHeader;
import org.apache.rocketmq.remoting.protocol.header.ResumeCheckHalfMessageRequestHeader;
import org.apache.rocketmq.remoting.protocol.header.SearchOffsetRequestHeader;
import org.apache.rocketmq.remoting.protocol.header.SearchOffsetResponseHeader;
import org.apache.rocketmq.remoting.protocol.header.UpdateGlobalWhiteAddrsConfigRequestHeader;
import org.apache.rocketmq.remoting.protocol.header.UpdateGroupForbiddenRequestHeader;
import org.apache.rocketmq.remoting.protocol.header.ViewBrokerStatsDataRequestHeader;
import org.apache.rocketmq.remoting.protocol.heartbeat.SubscriptionData;
import org.apache.rocketmq.remoting.protocol.statictopic.LogicQueueMappingItem;
import org.apache.rocketmq.remoting.protocol.statictopic.TopicConfigAndQueueMapping;
import org.apache.rocketmq.remoting.protocol.statictopic.TopicQueueMappingContext;
import org.apache.rocketmq.remoting.protocol.statictopic.TopicQueueMappingDetail;
import org.apache.rocketmq.remoting.protocol.statictopic.TopicQueueMappingUtils;
import org.apache.rocketmq.remoting.protocol.subscription.GroupForbidden;
import org.apache.rocketmq.remoting.protocol.subscription.SubscriptionGroupConfig;
import org.apache.rocketmq.remoting.rpc.RpcClientUtils;
import org.apache.rocketmq.remoting.rpc.RpcException;
import org.apache.rocketmq.remoting.rpc.RpcRequest;
import org.apache.rocketmq.remoting.rpc.RpcRequestHeader;
import org.apache.rocketmq.remoting.rpc.RpcResponse;
import org.apache.rocketmq.remoting.rpc.TopicRequestHeader;
import org.apache.rocketmq.store.ConsumeQueueExt;
import org.apache.rocketmq.store.DefaultMessageStore;
import org.apache.rocketmq.store.MessageStore;
import org.apache.rocketmq.store.PutMessageResult;
import org.apache.rocketmq.store.PutMessageStatus;
import org.apache.rocketmq.store.SelectMappedBufferResult;
import org.apache.rocketmq.store.config.BrokerRole;
import org.apache.rocketmq.store.queue.ConsumeQueueInterface;
import org.apache.rocketmq.store.queue.CqUnit;
import org.apache.rocketmq.store.queue.ReferredIterator;
import org.apache.rocketmq.store.timer.TimerCheckpoint;
import org.apache.rocketmq.store.timer.TimerMessageStore;

public class AdminBrokerProcessor
implements NettyRequestProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"RocketmqBroker");
    protected final BrokerController brokerController;

    public AdminBrokerProcessor(BrokerController brokerController) {
        this.brokerController = brokerController;
    }

    public RemotingCommand processRequest(ChannelHandlerContext ctx, RemotingCommand request) throws RemotingCommandException {
        switch (request.getCode()) {
            case 17: {
                return this.updateAndCreateTopic(ctx, request);
            }
            case 215: {
                return this.deleteTopic(ctx, request);
            }
            case 21: {
                return this.getAllTopicConfig(ctx, request);
            }
            case 60: {
                return this.getTimerCheckPoint(ctx, request);
            }
            case 61: {
                return this.getTimerMetrics(ctx, request);
            }
            case 25: {
                return this.updateBrokerConfig(ctx, request);
            }
            case 26: {
                return this.getBrokerConfig(ctx, request);
            }
            case 29: {
                return this.searchOffsetByTimestamp(ctx, request);
            }
            case 30: {
                return this.getMaxOffset(ctx, request);
            }
            case 31: {
                return this.getMinOffset(ctx, request);
            }
            case 32: {
                return this.getEarliestMsgStoretime(ctx, request);
            }
            case 28: {
                return this.getBrokerRuntimeInfo(ctx, request);
            }
            case 41: {
                return this.lockBatchMQ(ctx, request);
            }
            case 42: {
                return this.unlockBatchMQ(ctx, request);
            }
            case 200: {
                return this.updateAndCreateSubscriptionGroup(ctx, request);
            }
            case 201: {
                return this.getAllSubscriptionGroup(ctx, request);
            }
            case 207: {
                return this.deleteSubscriptionGroup(ctx, request);
            }
            case 202: {
                return this.getTopicStatsInfo(ctx, request);
            }
            case 203: {
                return this.getConsumerConnectionList(ctx, request);
            }
            case 204: {
                return this.getProducerConnectionList(ctx, request);
            }
            case 328: {
                return this.getAllProducerInfo(ctx, request);
            }
            case 208: {
                return this.getConsumeStats(ctx, request);
            }
            case 43: {
                return this.getAllConsumerOffset(ctx, request);
            }
            case 45: {
                return this.getAllDelayOffset(ctx, request);
            }
            case 402: {
                return this.getAllMessageRequestMode(ctx, request);
            }
            case 222: {
                return this.resetOffset(ctx, request);
            }
            case 223: {
                return this.getConsumerStatus(ctx, request);
            }
            case 300: {
                return this.queryTopicConsumeByWho(ctx, request);
            }
            case 343: {
                return this.queryTopicsByConsumer(ctx, request);
            }
            case 345: {
                return this.querySubscriptionByConsumer(ctx, request);
            }
            case 303: {
                return this.queryConsumeTimeSpan(ctx, request);
            }
            case 305: {
                return this.getSystemTopicListFromBroker(ctx, request);
            }
            case 306: {
                return this.cleanExpiredConsumeQueue();
            }
            case 329: {
                return this.deleteExpiredCommitLog();
            }
            case 316: {
                return this.cleanUnusedTopic();
            }
            case 307: {
                return this.getConsumerRunningInfo(ctx, request);
            }
            case 308: {
                return this.queryCorrectionOffset(ctx, request);
            }
            case 309: {
                return this.consumeMessageDirectly(ctx, request);
            }
            case 314: {
                return this.cloneGroupOffset(ctx, request);
            }
            case 315: {
                return this.ViewBrokerStatsData(ctx, request);
            }
            case 317: {
                return this.fetchAllConsumeStatsInBroker(ctx, request);
            }
            case 321: {
                return this.queryConsumeQueue(ctx, request);
            }
            case 353: {
                return this.updateAndGetGroupForbidden(ctx, request);
            }
            case 352: {
                return this.getSubscriptionGroup(ctx, request);
            }
            case 50: {
                return this.updateAndCreateAccessConfig(ctx, request);
            }
            case 51: {
                return this.deleteAccessConfig(ctx, request);
            }
            case 52: {
                return this.getBrokerAclConfigVersion(ctx, request);
            }
            case 53: {
                return this.updateGlobalWhiteAddrsConfig(ctx, request);
            }
            case 323: {
                return this.resumeCheckHalfMessage(ctx, request);
            }
            case 54: {
                return this.getBrokerClusterAclConfig(ctx, request);
            }
            case 351: {
                return this.getTopicConfig(ctx, request);
            }
            case 513: {
                return this.updateAndCreateStaticTopic(ctx, request);
            }
            case 905: {
                return this.notifyMinBrokerIdChange(ctx, request);
            }
            case 906: {
                return this.updateBrokerHaInfo(ctx, request);
            }
            case 907: {
                return this.getBrokerHaStatus(ctx, request);
            }
            case 908: {
                return this.resetMasterFlushOffset(ctx, request);
            }
            case 1007: {
                return this.getBrokerEpochCache(ctx, request);
            }
            case 1008: {
                return this.notifyBrokerRoleChanged(ctx, request);
            }
        }
        return this.getUnknownCmdResponse(ctx, request);
    }

    private RemotingCommand getSubscriptionGroup(ChannelHandlerContext ctx, RemotingCommand request) throws RemotingCommandException {
        GetSubscriptionGroupConfigRequestHeader requestHeader = (GetSubscriptionGroupConfigRequestHeader)request.decodeCommandCustomHeader(GetSubscriptionGroupConfigRequestHeader.class);
        RemotingCommand response = RemotingCommand.createResponseCommand(null);
        SubscriptionGroupConfig groupConfig = (SubscriptionGroupConfig)this.brokerController.getSubscriptionGroupManager().getSubscriptionGroupTable().get(requestHeader.getGroup());
        if (groupConfig == null) {
            LOGGER.error("No group in this broker, client: {} group: {}", (Object)ctx.channel().remoteAddress(), (Object)requestHeader.getGroup());
            response.setCode(1);
            response.setRemark("No group in this broker");
            return response;
        }
        String content = JSONObject.toJSONString((Object)groupConfig);
        try {
            response.setBody(content.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            LOGGER.error("UnsupportedEncodingException getSubscriptionGroup: group=" + groupConfig.getGroupName(), (Throwable)e);
            response.setCode(1);
            response.setRemark("UnsupportedEncodingException " + e.getMessage());
            return response;
        }
        response.setCode(0);
        response.setRemark(null);
        return response;
    }

    private RemotingCommand updateAndGetGroupForbidden(ChannelHandlerContext ctx, RemotingCommand request) throws RemotingCommandException {
        RemotingCommand response = RemotingCommand.createResponseCommand(null);
        UpdateGroupForbiddenRequestHeader requestHeader = (UpdateGroupForbiddenRequestHeader)request.decodeCommandCustomHeader(UpdateGroupForbiddenRequestHeader.class);
        String group = requestHeader.getGroup();
        String topic = requestHeader.getTopic();
        LOGGER.info("updateAndGetGroupForbidden called by {} for object {}@{} readable={}", new Object[]{RemotingHelper.parseChannelRemoteAddr((Channel)ctx.channel()), group, topic, requestHeader.getReadable()});
        SubscriptionGroupManager groupManager = this.brokerController.getSubscriptionGroupManager();
        if (requestHeader.getReadable() != null) {
            groupManager.updateForbidden(group, topic, 2, requestHeader.getReadable() == false);
        }
        response.setCode(0);
        response.setRemark("");
        GroupForbidden groupForbidden = new GroupForbidden();
        groupForbidden.setGroup(group);
        groupForbidden.setTopic(topic);
        groupForbidden.setReadable(Boolean.valueOf(!groupManager.getForbidden(group, topic, 2)));
        response.setBody(groupForbidden.toJson().getBytes(StandardCharsets.UTF_8));
        return response;
    }

    public boolean rejectRequest() {
        return false;
    }

    private synchronized RemotingCommand updateAndCreateTopic(ChannelHandlerContext ctx, RemotingCommand request) throws RemotingCommandException {
        RemotingCommand response = RemotingCommand.createResponseCommand(null);
        if (this.validateSlave(response)) {
            return response;
        }
        CreateTopicRequestHeader requestHeader = (CreateTopicRequestHeader)request.decodeCommandCustomHeader(CreateTopicRequestHeader.class);
        LOGGER.info("Broker receive request to update or create topic={}, caller address={}", (Object)requestHeader.getTopic(), (Object)RemotingHelper.parseChannelRemoteAddr((Channel)ctx.channel()));
        String topic = requestHeader.getTopic();
        TopicValidator.ValidateTopicResult result = TopicValidator.validateTopic((String)topic);
        if (!result.isValid()) {
            response.setCode(1);
            response.setRemark(result.getRemark());
            return response;
        }
        if (this.brokerController.getBrokerConfig().isValidateSystemTopicWhenUpdateTopic() && TopicValidator.isSystemTopic((String)topic)) {
            response.setCode(1);
            response.setRemark("The topic[" + topic + "] is conflict with system topic.");
            return response;
        }
        TopicConfig topicConfig = new TopicConfig(topic);
        topicConfig.setReadQueueNums(requestHeader.getReadQueueNums().intValue());
        topicConfig.setWriteQueueNums(requestHeader.getWriteQueueNums().intValue());
        topicConfig.setTopicFilterType(requestHeader.getTopicFilterTypeEnum());
        topicConfig.setPerm(requestHeader.getPerm().intValue());
        topicConfig.setTopicSysFlag(requestHeader.getTopicSysFlag() == null ? 0 : requestHeader.getTopicSysFlag());
        topicConfig.setOrder(requestHeader.getOrder().booleanValue());
        String attributesModification = requestHeader.getAttributes();
        topicConfig.setAttributes(AttributeParser.parseToMap((String)attributesModification));
        try {
            this.brokerController.getTopicConfigManager().updateTopicConfig(topicConfig);
            this.brokerController.registerIncrementBrokerData(topicConfig, this.brokerController.getTopicConfigManager().getDataVersion());
            response.setCode(0);
        }
        catch (Exception e) {
            LOGGER.error("Update / create topic failed for [{}]", (Object)request, (Object)e);
            response.setCode(1);
            response.setRemark(e.getMessage());
        }
        return response;
    }

    private synchronized RemotingCommand updateAndCreateStaticTopic(ChannelHandlerContext ctx, RemotingCommand request) throws RemotingCommandException {
        RemotingCommand response = RemotingCommand.createResponseCommand(null);
        CreateTopicRequestHeader requestHeader = (CreateTopicRequestHeader)request.decodeCommandCustomHeader(CreateTopicRequestHeader.class);
        LOGGER.info("Broker receive request to update or create static topic={}, caller address={}", (Object)requestHeader.getTopic(), (Object)RemotingHelper.parseChannelRemoteAddr((Channel)ctx.channel()));
        TopicQueueMappingDetail topicQueueMappingDetail = (TopicQueueMappingDetail)RemotingSerializable.decode((byte[])request.getBody(), TopicQueueMappingDetail.class);
        String topic = requestHeader.getTopic();
        TopicValidator.ValidateTopicResult result = TopicValidator.validateTopic((String)topic);
        if (!result.isValid()) {
            response.setCode(1);
            response.setRemark(result.getRemark());
            return response;
        }
        if (this.brokerController.getBrokerConfig().isValidateSystemTopicWhenUpdateTopic() && TopicValidator.isSystemTopic((String)topic)) {
            response.setCode(1);
            response.setRemark("The topic[" + topic + "] is conflict with system topic.");
            return response;
        }
        boolean force = false;
        if (requestHeader.getForce() != null && requestHeader.getForce().booleanValue()) {
            force = true;
        }
        TopicConfig topicConfig = new TopicConfig(topic);
        topicConfig.setReadQueueNums(requestHeader.getReadQueueNums().intValue());
        topicConfig.setWriteQueueNums(requestHeader.getWriteQueueNums().intValue());
        topicConfig.setTopicFilterType(requestHeader.getTopicFilterTypeEnum());
        topicConfig.setPerm(requestHeader.getPerm().intValue());
        topicConfig.setTopicSysFlag(requestHeader.getTopicSysFlag() == null ? 0 : requestHeader.getTopicSysFlag());
        try {
            this.brokerController.getTopicConfigManager().updateTopicConfig(topicConfig);
            this.brokerController.getTopicQueueMappingManager().updateTopicQueueMapping(topicQueueMappingDetail, force, false, true);
            this.brokerController.registerIncrementBrokerData(topicConfig, this.brokerController.getTopicConfigManager().getDataVersion());
            response.setCode(0);
        }
        catch (Exception e) {
            LOGGER.error("Update static topic failed for [{}]", (Object)request, (Object)e);
            response.setCode(1);
            response.setRemark(e.getMessage());
        }
        return response;
    }

    private synchronized RemotingCommand deleteTopic(ChannelHandlerContext ctx, RemotingCommand request) throws RemotingCommandException {
        RemotingCommand response = RemotingCommand.createResponseCommand(null);
        if (this.validateSlave(response)) {
            return response;
        }
        DeleteTopicRequestHeader requestHeader = (DeleteTopicRequestHeader)request.decodeCommandCustomHeader(DeleteTopicRequestHeader.class);
        LOGGER.info("AdminBrokerProcessor#deleteTopic: broker receive request to delete topic={}, caller={}", (Object)requestHeader.getTopic(), (Object)RemotingHelper.parseChannelRemoteAddr((Channel)ctx.channel()));
        String topic = requestHeader.getTopic();
        TopicValidator.ValidateTopicResult result = TopicValidator.validateTopic((String)topic);
        if (!result.isValid()) {
            response.setCode(1);
            response.setRemark(result.getRemark());
            return response;
        }
        if (this.brokerController.getBrokerConfig().isValidateSystemTopicWhenUpdateTopic() && TopicValidator.isSystemTopic((String)topic)) {
            response.setCode(1);
            response.setRemark("The topic[" + topic + "] is conflict with system topic.");
            return response;
        }
        this.brokerController.getTopicConfigManager().deleteTopicConfig(requestHeader.getTopic());
        this.brokerController.getTopicQueueMappingManager().delete(requestHeader.getTopic());
        this.brokerController.getConsumerOffsetManager().cleanOffsetByTopic(requestHeader.getTopic());
        this.brokerController.getPopInflightMessageCounter().clearInFlightMessageNumByTopicName(requestHeader.getTopic());
        this.brokerController.getMessageStore().deleteTopics((Set)Sets.newHashSet((Object[])new String[]{requestHeader.getTopic()}));
        response.setCode(0);
        response.setRemark(null);
        return response;
    }

    private synchronized RemotingCommand updateAndCreateAccessConfig(ChannelHandlerContext ctx, RemotingCommand request) throws RemotingCommandException {
        RemotingCommand response = RemotingCommand.createResponseCommand(null);
        CreateAccessConfigRequestHeader requestHeader = (CreateAccessConfigRequestHeader)request.decodeCommandCustomHeader(CreateAccessConfigRequestHeader.class);
        PlainAccessConfig accessConfig = new PlainAccessConfig();
        accessConfig.setAccessKey(requestHeader.getAccessKey());
        accessConfig.setSecretKey(requestHeader.getSecretKey());
        accessConfig.setWhiteRemoteAddress(requestHeader.getWhiteRemoteAddress());
        accessConfig.setDefaultTopicPerm(requestHeader.getDefaultTopicPerm());
        accessConfig.setDefaultGroupPerm(requestHeader.getDefaultGroupPerm());
        accessConfig.setTopicPerms(UtilAll.split((String)requestHeader.getTopicPerms(), (String)","));
        accessConfig.setGroupPerms(UtilAll.split((String)requestHeader.getGroupPerms(), (String)","));
        accessConfig.setAdmin(requestHeader.isAdmin());
        try {
            AccessValidator accessValidator = this.brokerController.getAccessValidatorMap().get(PlainAccessValidator.class);
            if (!accessValidator.updateAccessConfig(accessConfig)) {
                String errorMsg = "The accessKey[" + requestHeader.getAccessKey() + "] corresponding to accessConfig has been updated failed.";
                LOGGER.warn(errorMsg);
                response.setCode(209);
                response.setRemark(errorMsg);
                return response;
            }
            response.setCode(0);
            response.setOpaque(request.getOpaque());
            response.markResponseType();
            response.setRemark(null);
            NettyRemotingAbstract.writeResponse((Channel)ctx.channel(), (RemotingCommand)request, (RemotingCommand)response);
        }
        catch (Exception e) {
            LOGGER.error("Failed to generate a proper update accessValidator response", (Throwable)e);
            response.setCode(209);
            response.setRemark(e.getMessage());
            return response;
        }
        return null;
    }

    private synchronized RemotingCommand deleteAccessConfig(ChannelHandlerContext ctx, RemotingCommand request) throws RemotingCommandException {
        RemotingCommand response = RemotingCommand.createResponseCommand(null);
        DeleteAccessConfigRequestHeader requestHeader = (DeleteAccessConfigRequestHeader)request.decodeCommandCustomHeader(DeleteAccessConfigRequestHeader.class);
        LOGGER.info("DeleteAccessConfig called by {}", (Object)RemotingHelper.parseChannelRemoteAddr((Channel)ctx.channel()));
        try {
            String accessKey = requestHeader.getAccessKey();
            AccessValidator accessValidator = this.brokerController.getAccessValidatorMap().get(PlainAccessValidator.class);
            if (!accessValidator.deleteAccessConfig(accessKey)) {
                String errorMsg = "The accessKey[" + requestHeader.getAccessKey() + "] corresponding to accessConfig has been deleted failed.";
                LOGGER.warn(errorMsg);
                response.setCode(210);
                response.setRemark(errorMsg);
                return response;
            }
            response.setCode(0);
            response.setOpaque(request.getOpaque());
            response.markResponseType();
            response.setRemark(null);
            NettyRemotingAbstract.writeResponse((Channel)ctx.channel(), (RemotingCommand)request, (RemotingCommand)response);
        }
        catch (Exception e) {
            LOGGER.error("Failed to generate a proper delete accessValidator response", (Throwable)e);
            response.setCode(210);
            response.setRemark(e.getMessage());
            return response;
        }
        return null;
    }

    private synchronized RemotingCommand updateGlobalWhiteAddrsConfig(ChannelHandlerContext ctx, RemotingCommand request) throws RemotingCommandException {
        RemotingCommand response = RemotingCommand.createResponseCommand(null);
        UpdateGlobalWhiteAddrsConfigRequestHeader requestHeader = (UpdateGlobalWhiteAddrsConfigRequestHeader)request.decodeCommandCustomHeader(UpdateGlobalWhiteAddrsConfigRequestHeader.class);
        try {
            AccessValidator accessValidator = this.brokerController.getAccessValidatorMap().get(PlainAccessValidator.class);
            if (!accessValidator.updateGlobalWhiteAddrsConfig(UtilAll.split((String)requestHeader.getGlobalWhiteAddrs(), (String)","), requestHeader.getAclFileFullPath())) {
                String errorMsg = "The globalWhiteAddresses[" + requestHeader.getGlobalWhiteAddrs() + "] has been updated failed.";
                LOGGER.warn(errorMsg);
                response.setCode(211);
                response.setRemark(errorMsg);
                return response;
            }
            response.setCode(0);
            response.setOpaque(request.getOpaque());
            response.markResponseType();
            response.setRemark(null);
            NettyRemotingAbstract.writeResponse((Channel)ctx.channel(), (RemotingCommand)request, (RemotingCommand)response);
        }
        catch (Exception e) {
            LOGGER.error("Failed to generate a proper update globalWhiteAddresses response", (Throwable)e);
            response.setCode(211);
            response.setRemark(e.getMessage());
            return response;
        }
        return null;
    }

    private RemotingCommand getBrokerAclConfigVersion(ChannelHandlerContext ctx, RemotingCommand request) {
        RemotingCommand response = RemotingCommand.createResponseCommand(GetBrokerAclConfigResponseHeader.class);
        GetBrokerAclConfigResponseHeader responseHeader = (GetBrokerAclConfigResponseHeader)response.readCustomHeader();
        try {
            AccessValidator accessValidator = this.brokerController.getAccessValidatorMap().get(PlainAccessValidator.class);
            responseHeader.setVersion(accessValidator.getAclConfigVersion());
            responseHeader.setBrokerAddr(this.brokerController.getBrokerAddr());
            responseHeader.setBrokerName(this.brokerController.getBrokerConfig().getBrokerName());
            responseHeader.setClusterName(this.brokerController.getBrokerConfig().getBrokerClusterName());
            response.setCode(0);
            response.setRemark(null);
            return response;
        }
        catch (Exception e) {
            LOGGER.error("Failed to generate a proper getBrokerAclConfigVersion response", (Throwable)e);
            return null;
        }
    }

    private RemotingCommand getBrokerClusterAclConfig(ChannelHandlerContext ctx, RemotingCommand request) {
        RemotingCommand response = RemotingCommand.createResponseCommand(GetBrokerClusterAclConfigResponseHeader.class);
        try {
            AccessValidator accessValidator = this.brokerController.getAccessValidatorMap().get(PlainAccessValidator.class);
            GetBrokerClusterAclConfigResponseBody body = new GetBrokerClusterAclConfigResponseBody();
            AclConfig aclConfig = accessValidator.getAllAclConfig();
            body.setGlobalWhiteAddrs(aclConfig.getGlobalWhiteAddrs());
            body.setPlainAccessConfigs(aclConfig.getPlainAccessConfigs());
            response.setCode(0);
            response.setBody(body.encode());
            response.setRemark(null);
            return response;
        }
        catch (Exception e) {
            LOGGER.error("Failed to generate a proper getBrokerClusterAclConfig response", (Throwable)e);
            return null;
        }
    }

    private RemotingCommand getUnknownCmdResponse(ChannelHandlerContext ctx, RemotingCommand request) {
        String error = " request type " + request.getCode() + " not supported";
        RemotingCommand response = RemotingCommand.createResponseCommand((int)3, (String)error);
        return response;
    }

    private RemotingCommand getAllTopicConfig(ChannelHandlerContext ctx, RemotingCommand request) {
        RemotingCommand response = RemotingCommand.createResponseCommand(GetAllTopicConfigResponseHeader.class);
        TopicConfigAndMappingSerializeWrapper topicConfigAndMappingSerializeWrapper = new TopicConfigAndMappingSerializeWrapper();
        topicConfigAndMappingSerializeWrapper.setDataVersion(this.brokerController.getTopicConfigManager().getDataVersion());
        topicConfigAndMappingSerializeWrapper.setTopicConfigTable(this.brokerController.getTopicConfigManager().getTopicConfigTable());
        topicConfigAndMappingSerializeWrapper.setMappingDataVersion(this.brokerController.getTopicQueueMappingManager().getDataVersion());
        topicConfigAndMappingSerializeWrapper.setTopicQueueMappingDetailMap(this.brokerController.getTopicQueueMappingManager().getTopicQueueMappingTable());
        String content = topicConfigAndMappingSerializeWrapper.toJson();
        if (content != null && content.length() > 0) {
            try {
                response.setBody(content.getBytes("UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                LOGGER.error("", (Throwable)e);
                response.setCode(1);
                response.setRemark("UnsupportedEncodingException " + e.getMessage());
                return response;
            }
        } else {
            LOGGER.error("No topic in this broker, client: {}", (Object)ctx.channel().remoteAddress());
            response.setCode(1);
            response.setRemark("No topic in this broker");
            return response;
        }
        response.setCode(0);
        response.setRemark(null);
        return response;
    }

    private RemotingCommand getTimerCheckPoint(ChannelHandlerContext ctx, RemotingCommand request) {
        RemotingCommand response = RemotingCommand.createResponseCommand((int)1, (String)"Unknown");
        TimerCheckpoint timerCheckpoint = this.brokerController.getTimerCheckpoint();
        if (null == timerCheckpoint) {
            LOGGER.error("AdminBrokerProcessor#getTimerCheckPoint: checkpoint is null, caller={}", (Object)ctx.channel().remoteAddress());
            response.setCode(1);
            response.setRemark("The checkpoint is null");
            return response;
        }
        response.setBody(TimerCheckpoint.encode((TimerCheckpoint)timerCheckpoint).array());
        response.setCode(0);
        response.setRemark(null);
        return response;
    }

    private RemotingCommand getTimerMetrics(ChannelHandlerContext ctx, RemotingCommand request) {
        RemotingCommand response = RemotingCommand.createResponseCommand((int)1, (String)"Unknown");
        TimerMessageStore timerMessageStore = this.brokerController.getMessageStore().getTimerMessageStore();
        if (null == timerMessageStore) {
            LOGGER.error("The timer message store is null, client: {}", (Object)ctx.channel().remoteAddress());
            response.setCode(1);
            response.setRemark("The timer message store is null");
            return response;
        }
        response.setBody(timerMessageStore.getTimerMetrics().encode().getBytes(StandardCharsets.UTF_8));
        response.setCode(0);
        response.setRemark(null);
        return response;
    }

    private synchronized RemotingCommand updateBrokerConfig(ChannelHandlerContext ctx, RemotingCommand request) {
        RemotingCommand response;
        block6: {
            response = RemotingCommand.createResponseCommand(null);
            String callerAddress = RemotingHelper.parseChannelRemoteAddr((Channel)ctx.channel());
            LOGGER.info("Broker receive request to update config, caller address={}", (Object)callerAddress);
            byte[] body = request.getBody();
            if (body != null) {
                try {
                    String bodyStr = new String(body, "UTF-8");
                    Properties properties = MixAll.string2Properties((String)bodyStr);
                    if (properties != null) {
                        LOGGER.info("updateBrokerConfig, new config: [{}] client: {} ", (Object)properties, (Object)callerAddress);
                        if (properties.containsKey("brokerConfigPath")) {
                            response.setCode(16);
                            response.setRemark("Can not update config path");
                            return response;
                        }
                        this.brokerController.getConfiguration().update(properties);
                        if (properties.containsKey("brokerPermission")) {
                            long stateMachineVersion = this.brokerController.getMessageStore() != null ? this.brokerController.getMessageStore().getStateMachineVersion() : 0L;
                            this.brokerController.getTopicConfigManager().getDataVersion().nextVersion(stateMachineVersion);
                            this.brokerController.registerBrokerAll(false, false, true);
                        }
                        break block6;
                    }
                    LOGGER.error("string2Properties error");
                    response.setCode(1);
                    response.setRemark("string2Properties error");
                    return response;
                }
                catch (UnsupportedEncodingException e) {
                    LOGGER.error("AdminBrokerProcessor#updateBrokerConfig: unexpected error, caller={}", (Object)callerAddress, (Object)e);
                    response.setCode(1);
                    response.setRemark("UnsupportedEncodingException " + e);
                    return response;
                }
            }
        }
        response.setCode(0);
        response.setRemark(null);
        return response;
    }

    private RemotingCommand getBrokerConfig(ChannelHandlerContext ctx, RemotingCommand request) {
        RemotingCommand response = RemotingCommand.createResponseCommand(GetBrokerConfigResponseHeader.class);
        GetBrokerConfigResponseHeader responseHeader = (GetBrokerConfigResponseHeader)response.readCustomHeader();
        String content = this.brokerController.getConfiguration().getAllConfigsFormatString();
        if (content != null && content.length() > 0) {
            try {
                response.setBody(content.getBytes("UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                LOGGER.error("AdminBrokerProcessor#getBrokerConfig: unexpected error, caller={}", (Object)RemotingHelper.parseChannelRemoteAddr((Channel)ctx.channel()), (Object)e);
                response.setCode(1);
                response.setRemark("UnsupportedEncodingException " + e);
                return response;
            }
        }
        responseHeader.setVersion(this.brokerController.getConfiguration().getDataVersionJson());
        response.setCode(0);
        response.setRemark(null);
        return response;
    }

    private RemotingCommand rewriteRequestForStaticTopic(SearchOffsetRequestHeader requestHeader, TopicQueueMappingContext mappingContext) {
        try {
            if (mappingContext.getMappingDetail() == null) {
                return null;
            }
            TopicQueueMappingDetail mappingDetail = mappingContext.getMappingDetail();
            List mappingItems = mappingContext.getMappingItemList();
            if (!mappingContext.isLeader()) {
                return RemotingCommand.buildErrorResponse((int)501, (String)String.format("%s-%d does not exit in request process of current broker %s", mappingContext.getTopic(), mappingContext.getGlobalId(), mappingDetail.getBname()));
            }
            Long timestamp = requestHeader.getTimestamp();
            long offset = -1L;
            for (int i = 0; i < mappingItems.size(); ++i) {
                LogicQueueMappingItem item = (LogicQueueMappingItem)mappingItems.get(i);
                if (!item.checkIfLogicoffsetDecided()) continue;
                if (mappingDetail.getBname().equals(item.getBname())) {
                    offset = this.brokerController.getMessageStore().getOffsetInQueueByTime(mappingContext.getTopic(), item.getQueueId(), timestamp.longValue());
                    if (offset <= 0L) continue;
                    offset = item.computeStaticQueueOffsetStrictly(offset);
                    break;
                }
                requestHeader.setLo(Boolean.valueOf(false));
                requestHeader.setTimestamp(timestamp);
                requestHeader.setQueueId(Integer.valueOf(item.getQueueId()));
                requestHeader.setBname(item.getBname());
                RpcRequest rpcRequest = new RpcRequest(29, (RpcRequestHeader)requestHeader, null);
                RpcResponse rpcResponse = (RpcResponse)this.brokerController.getBrokerOuterAPI().getRpcClient().invoke(rpcRequest, this.brokerController.getBrokerConfig().getForwardTimeout()).get();
                if (rpcResponse.getException() != null) {
                    throw rpcResponse.getException();
                }
                SearchOffsetResponseHeader offsetResponseHeader = (SearchOffsetResponseHeader)rpcResponse.getHeader();
                if (offsetResponseHeader.getOffset() < 0L || item.checkIfEndOffsetDecided() && offsetResponseHeader.getOffset() >= item.getEndOffset()) continue;
                offset = item.computeStaticQueueOffsetStrictly(offsetResponseHeader.getOffset().longValue());
            }
            RemotingCommand response = RemotingCommand.createResponseCommand(SearchOffsetResponseHeader.class);
            SearchOffsetResponseHeader responseHeader = (SearchOffsetResponseHeader)response.readCustomHeader();
            responseHeader.setOffset(Long.valueOf(offset));
            response.setCode(0);
            response.setRemark(null);
            return response;
        }
        catch (Throwable t) {
            return RemotingCommand.buildErrorResponse((int)1, (String)t.getMessage());
        }
    }

    private RemotingCommand searchOffsetByTimestamp(ChannelHandlerContext ctx, RemotingCommand request) throws RemotingCommandException {
        TopicQueueMappingContext mappingContext;
        RemotingCommand response = RemotingCommand.createResponseCommand(SearchOffsetResponseHeader.class);
        SearchOffsetResponseHeader responseHeader = (SearchOffsetResponseHeader)response.readCustomHeader();
        SearchOffsetRequestHeader requestHeader = (SearchOffsetRequestHeader)request.decodeCommandCustomHeader(SearchOffsetRequestHeader.class);
        RemotingCommand rewriteResult = this.rewriteRequestForStaticTopic(requestHeader, mappingContext = this.brokerController.getTopicQueueMappingManager().buildTopicQueueMappingContext((TopicRequestHeader)requestHeader));
        if (rewriteResult != null) {
            return rewriteResult;
        }
        long offset = this.brokerController.getMessageStore().getOffsetInQueueByTime(requestHeader.getTopic(), requestHeader.getQueueId().intValue(), requestHeader.getTimestamp().longValue());
        responseHeader.setOffset(Long.valueOf(offset));
        response.setCode(0);
        response.setRemark(null);
        return response;
    }

    private RemotingCommand rewriteRequestForStaticTopic(GetMaxOffsetRequestHeader requestHeader, TopicQueueMappingContext mappingContext) {
        if (mappingContext.getMappingDetail() == null) {
            return null;
        }
        TopicQueueMappingDetail mappingDetail = mappingContext.getMappingDetail();
        LogicQueueMappingItem mappingItem = mappingContext.getLeaderItem();
        if (!mappingContext.isLeader()) {
            return RemotingCommand.buildErrorResponse((int)501, (String)String.format("%s-%d does not exit in request process of current broker %s", mappingContext.getTopic(), mappingContext.getGlobalId(), mappingDetail.getBname()));
        }
        try {
            LogicQueueMappingItem maxItem = TopicQueueMappingUtils.findLogicQueueMappingItem((List)mappingContext.getMappingItemList(), (long)Long.MAX_VALUE, (boolean)true);
            assert (maxItem != null);
            assert (maxItem.getLogicOffset() >= 0L);
            requestHeader.setBname(maxItem.getBname());
            requestHeader.setLo(Boolean.valueOf(false));
            requestHeader.setQueueId(Integer.valueOf(mappingItem.getQueueId()));
            long maxPhysicalOffset = Long.MAX_VALUE;
            if (maxItem.getBname().equals(mappingDetail.getBname())) {
                maxPhysicalOffset = this.brokerController.getMessageStore().getMaxOffsetInQueue(mappingContext.getTopic(), mappingItem.getQueueId());
            } else {
                RpcRequest rpcRequest = new RpcRequest(30, (RpcRequestHeader)requestHeader, null);
                RpcResponse rpcResponse = (RpcResponse)this.brokerController.getBrokerOuterAPI().getRpcClient().invoke(rpcRequest, this.brokerController.getBrokerConfig().getForwardTimeout()).get();
                if (rpcResponse.getException() != null) {
                    throw rpcResponse.getException();
                }
                GetMaxOffsetResponseHeader offsetResponseHeader = (GetMaxOffsetResponseHeader)rpcResponse.getHeader();
                maxPhysicalOffset = offsetResponseHeader.getOffset();
            }
            RemotingCommand response = RemotingCommand.createResponseCommand(GetMaxOffsetResponseHeader.class);
            GetMaxOffsetResponseHeader responseHeader = (GetMaxOffsetResponseHeader)response.readCustomHeader();
            responseHeader.setOffset(Long.valueOf(maxItem.computeStaticQueueOffsetStrictly(maxPhysicalOffset)));
            response.setCode(0);
            response.setRemark(null);
            return response;
        }
        catch (Throwable t) {
            return RemotingCommand.buildErrorResponse((int)1, (String)t.getMessage());
        }
    }

    private RemotingCommand getMaxOffset(ChannelHandlerContext ctx, RemotingCommand request) throws RemotingCommandException {
        TopicQueueMappingContext mappingContext;
        RemotingCommand response = RemotingCommand.createResponseCommand(GetMaxOffsetResponseHeader.class);
        GetMaxOffsetResponseHeader responseHeader = (GetMaxOffsetResponseHeader)response.readCustomHeader();
        GetMaxOffsetRequestHeader requestHeader = (GetMaxOffsetRequestHeader)request.decodeCommandCustomHeader(GetMaxOffsetRequestHeader.class);
        RemotingCommand rewriteResult = this.rewriteRequestForStaticTopic(requestHeader, mappingContext = this.brokerController.getTopicQueueMappingManager().buildTopicQueueMappingContext((TopicRequestHeader)requestHeader));
        if (rewriteResult != null) {
            return rewriteResult;
        }
        long offset = this.brokerController.getMessageStore().getMaxOffsetInQueue(requestHeader.getTopic(), requestHeader.getQueueId().intValue());
        responseHeader.setOffset(Long.valueOf(offset));
        response.setCode(0);
        response.setRemark(null);
        return response;
    }

    private CompletableFuture<RpcResponse> handleGetMinOffsetForStaticTopic(RpcRequest request, TopicQueueMappingContext mappingContext) {
        if (mappingContext.getMappingDetail() == null) {
            return null;
        }
        TopicQueueMappingDetail mappingDetail = mappingContext.getMappingDetail();
        if (!mappingContext.isLeader()) {
            return CompletableFuture.completedFuture(new RpcResponse(new RpcException(501, String.format("%s-%d is not leader in broker %s, request code %d", mappingContext.getTopic(), mappingContext.getGlobalId(), mappingDetail.getBname(), request.getCode()))));
        }
        GetMinOffsetRequestHeader requestHeader = (GetMinOffsetRequestHeader)request.getHeader();
        LogicQueueMappingItem mappingItem = TopicQueueMappingUtils.findLogicQueueMappingItem((List)mappingContext.getMappingItemList(), (long)0L, (boolean)true);
        assert (mappingItem != null);
        try {
            long physicalOffset;
            requestHeader.setBname(mappingItem.getBname());
            requestHeader.setLo(Boolean.valueOf(false));
            requestHeader.setQueueId(Integer.valueOf(mappingItem.getQueueId()));
            if (mappingItem.getBname().equals(mappingDetail.getBname())) {
                physicalOffset = this.brokerController.getMessageStore().getMinOffsetInQueue(mappingDetail.getTopic(), mappingItem.getQueueId());
            } else {
                RpcRequest rpcRequest = new RpcRequest(31, (RpcRequestHeader)requestHeader, null);
                RpcResponse rpcResponse = (RpcResponse)this.brokerController.getBrokerOuterAPI().getRpcClient().invoke(rpcRequest, this.brokerController.getBrokerConfig().getForwardTimeout()).get();
                if (rpcResponse.getException() != null) {
                    throw rpcResponse.getException();
                }
                GetMinOffsetResponseHeader offsetResponseHeader = (GetMinOffsetResponseHeader)rpcResponse.getHeader();
                physicalOffset = offsetResponseHeader.getOffset();
            }
            long offset = mappingItem.computeStaticQueueOffsetLoosely(physicalOffset);
            GetMinOffsetResponseHeader responseHeader = new GetMinOffsetResponseHeader();
            responseHeader.setOffset(Long.valueOf(offset));
            return CompletableFuture.completedFuture(new RpcResponse(0, (CommandCustomHeader)responseHeader, null));
        }
        catch (Throwable t) {
            LOGGER.error("rewriteRequestForStaticTopic failed", t);
            return CompletableFuture.completedFuture(new RpcResponse(new RpcException(1, t.getMessage(), t)));
        }
    }

    private CompletableFuture<RpcResponse> handleGetMinOffset(RpcRequest request) {
        assert (request.getCode() == 31);
        GetMinOffsetRequestHeader requestHeader = (GetMinOffsetRequestHeader)request.getHeader();
        TopicQueueMappingContext mappingContext = this.brokerController.getTopicQueueMappingManager().buildTopicQueueMappingContext((TopicRequestHeader)requestHeader, false);
        CompletableFuture<RpcResponse> rewriteResult = this.handleGetMinOffsetForStaticTopic(request, mappingContext);
        if (rewriteResult != null) {
            return rewriteResult;
        }
        GetMinOffsetResponseHeader responseHeader = new GetMinOffsetResponseHeader();
        long offset = this.brokerController.getMessageStore().getMinOffsetInQueue(requestHeader.getTopic(), requestHeader.getQueueId().intValue());
        responseHeader.setOffset(Long.valueOf(offset));
        return CompletableFuture.completedFuture(new RpcResponse(0, (CommandCustomHeader)responseHeader, null));
    }

    private RemotingCommand getMinOffset(ChannelHandlerContext ctx, RemotingCommand request) throws RemotingCommandException {
        GetMinOffsetRequestHeader requestHeader = (GetMinOffsetRequestHeader)request.decodeCommandCustomHeader(GetMinOffsetRequestHeader.class);
        try {
            CompletableFuture<RpcResponse> responseFuture = this.handleGetMinOffset(new RpcRequest(31, (RpcRequestHeader)requestHeader, null));
            RpcResponse rpcResponse = responseFuture.get();
            return RpcClientUtils.createCommandForRpcResponse((RpcResponse)rpcResponse);
        }
        catch (Throwable t) {
            return RemotingCommand.buildErrorResponse((int)1, (String)t.getMessage());
        }
    }

    private RemotingCommand rewriteRequestForStaticTopic(GetEarliestMsgStoretimeRequestHeader requestHeader, TopicQueueMappingContext mappingContext) {
        if (mappingContext.getMappingDetail() == null) {
            return null;
        }
        TopicQueueMappingDetail mappingDetail = mappingContext.getMappingDetail();
        if (!mappingContext.isLeader()) {
            return RemotingCommand.buildErrorResponse((int)501, (String)String.format("%s-%d does not exit in request process of current broker %s", mappingContext.getTopic(), mappingContext.getGlobalId(), mappingDetail.getBname()));
        }
        LogicQueueMappingItem mappingItem = TopicQueueMappingUtils.findLogicQueueMappingItem((List)mappingContext.getMappingItemList(), (long)0L, (boolean)true);
        assert (mappingItem != null);
        try {
            requestHeader.setBname(mappingItem.getBname());
            requestHeader.setLo(Boolean.valueOf(false));
            RpcRequest rpcRequest = new RpcRequest(32, (RpcRequestHeader)requestHeader, null);
            RpcResponse rpcResponse = (RpcResponse)this.brokerController.getBrokerOuterAPI().getRpcClient().invoke(rpcRequest, this.brokerController.getBrokerConfig().getForwardTimeout()).get();
            if (rpcResponse.getException() != null) {
                throw rpcResponse.getException();
            }
            GetEarliestMsgStoretimeResponseHeader offsetResponseHeader = (GetEarliestMsgStoretimeResponseHeader)rpcResponse.getHeader();
            RemotingCommand response = RemotingCommand.createResponseCommand(GetEarliestMsgStoretimeResponseHeader.class);
            GetEarliestMsgStoretimeResponseHeader responseHeader = (GetEarliestMsgStoretimeResponseHeader)response.readCustomHeader();
            responseHeader.setTimestamp(offsetResponseHeader.getTimestamp());
            response.setCode(0);
            response.setRemark(null);
            return response;
        }
        catch (Throwable t) {
            return RemotingCommand.buildErrorResponse((int)1, (String)t.getMessage());
        }
    }

    private RemotingCommand getEarliestMsgStoretime(ChannelHandlerContext ctx, RemotingCommand request) throws RemotingCommandException {
        TopicQueueMappingContext mappingContext;
        RemotingCommand response = RemotingCommand.createResponseCommand(GetEarliestMsgStoretimeResponseHeader.class);
        GetEarliestMsgStoretimeResponseHeader responseHeader = (GetEarliestMsgStoretimeResponseHeader)response.readCustomHeader();
        GetEarliestMsgStoretimeRequestHeader requestHeader = (GetEarliestMsgStoretimeRequestHeader)request.decodeCommandCustomHeader(GetEarliestMsgStoretimeRequestHeader.class);
        RemotingCommand rewriteResult = this.rewriteRequestForStaticTopic(requestHeader, mappingContext = this.brokerController.getTopicQueueMappingManager().buildTopicQueueMappingContext((TopicRequestHeader)requestHeader, false));
        if (rewriteResult != null) {
            return rewriteResult;
        }
        long timestamp = this.brokerController.getMessageStore().getEarliestMessageTime(requestHeader.getTopic(), requestHeader.getQueueId().intValue());
        responseHeader.setTimestamp(Long.valueOf(timestamp));
        response.setCode(0);
        response.setRemark(null);
        return response;
    }

    private RemotingCommand getBrokerRuntimeInfo(ChannelHandlerContext ctx, RemotingCommand request) {
        RemotingCommand response = RemotingCommand.createResponseCommand(null);
        HashMap<String, String> runtimeInfo = this.prepareRuntimeInfo();
        KVTable kvTable = new KVTable();
        kvTable.setTable(runtimeInfo);
        byte[] body = kvTable.encode();
        response.setBody(body);
        response.setCode(0);
        response.setRemark(null);
        return response;
    }

    private RemotingCommand lockBatchMQ(ChannelHandlerContext ctx, RemotingCommand request) throws RemotingCommandException {
        RemotingCommand response = RemotingCommand.createResponseCommand(null);
        LockBatchRequestBody requestBody = (LockBatchRequestBody)LockBatchRequestBody.decode((byte[])request.getBody(), LockBatchRequestBody.class);
        Set<Object> lockOKMQSet = new HashSet();
        Set<MessageQueue> selfLockOKMQSet = this.brokerController.getRebalanceLockManager().tryLockBatch(requestBody.getConsumerGroup(), requestBody.getMqSet(), requestBody.getClientId());
        if (requestBody.isOnlyThisBroker() || !this.brokerController.getBrokerConfig().isLockInStrictMode()) {
            lockOKMQSet = selfLockOKMQSet;
        } else {
            requestBody.setOnlyThisBroker(true);
            int replicaSize = this.brokerController.getMessageStoreConfig().getTotalReplicas();
            int quorum = replicaSize / 2 + 1;
            if (quorum <= 1) {
                lockOKMQSet = selfLockOKMQSet;
            } else {
                final ConcurrentHashMap<MessageQueue, Integer> mqLockMap = new ConcurrentHashMap<MessageQueue, Integer>();
                for (MessageQueue mq : selfLockOKMQSet) {
                    if (!mqLockMap.containsKey(mq)) {
                        mqLockMap.put(mq, 0);
                    }
                    mqLockMap.put(mq, (Integer)mqLockMap.get(mq) + 1);
                }
                BrokerMemberGroup memberGroup = this.brokerController.getBrokerMemberGroup();
                if (memberGroup != null) {
                    final HashMap addrMap = new HashMap(memberGroup.getBrokerAddrs());
                    addrMap.remove(this.brokerController.getBrokerConfig().getBrokerId());
                    final CountDownLatch countDownLatch = new CountDownLatch(addrMap.size());
                    requestBody.setMqSet(selfLockOKMQSet);
                    requestBody.setOnlyThisBroker(true);
                    for (final Long brokerId : addrMap.keySet()) {
                        try {
                            this.brokerController.getBrokerOuterAPI().lockBatchMQAsync((String)addrMap.get(brokerId), requestBody, 1000L, new LockCallback(){

                                public void onSuccess(Set<MessageQueue> lockOKMQSet) {
                                    for (MessageQueue mq : lockOKMQSet) {
                                        if (!mqLockMap.containsKey(mq)) {
                                            mqLockMap.put(mq, 0);
                                        }
                                        mqLockMap.put(mq, (Integer)mqLockMap.get(mq) + 1);
                                    }
                                    countDownLatch.countDown();
                                }

                                public void onException(Throwable e) {
                                    LOGGER.warn("lockBatchMQAsync on {} failed, {}", addrMap.get(brokerId), (Object)e);
                                    countDownLatch.countDown();
                                }
                            });
                        }
                        catch (Exception e) {
                            LOGGER.warn("lockBatchMQAsync on {} failed, {}", addrMap.get(brokerId), (Object)e);
                            countDownLatch.countDown();
                        }
                    }
                    try {
                        countDownLatch.await(2000L, TimeUnit.MILLISECONDS);
                    }
                    catch (InterruptedException e) {
                        LOGGER.warn("lockBatchMQ exception on {}, {}", (Object)this.brokerController.getBrokerConfig().getBrokerName(), (Object)e);
                    }
                }
                for (MessageQueue mq : mqLockMap.keySet()) {
                    if ((Integer)mqLockMap.get(mq) < quorum) continue;
                    lockOKMQSet.add(mq);
                }
            }
        }
        LockBatchResponseBody responseBody = new LockBatchResponseBody();
        responseBody.setLockOKMQSet(lockOKMQSet);
        response.setBody(responseBody.encode());
        response.setCode(0);
        response.setRemark(null);
        return response;
    }

    private RemotingCommand unlockBatchMQ(ChannelHandlerContext ctx, RemotingCommand request) throws RemotingCommandException {
        RemotingCommand response = RemotingCommand.createResponseCommand(null);
        UnlockBatchRequestBody requestBody = (UnlockBatchRequestBody)UnlockBatchRequestBody.decode((byte[])request.getBody(), UnlockBatchRequestBody.class);
        if (requestBody.isOnlyThisBroker() || !this.brokerController.getBrokerConfig().isLockInStrictMode()) {
            this.brokerController.getRebalanceLockManager().unlockBatch(requestBody.getConsumerGroup(), requestBody.getMqSet(), requestBody.getClientId());
        } else {
            requestBody.setOnlyThisBroker(true);
            BrokerMemberGroup memberGroup = this.brokerController.getBrokerMemberGroup();
            if (memberGroup != null) {
                final Map addrMap = memberGroup.getBrokerAddrs();
                for (final Long brokerId : addrMap.keySet()) {
                    try {
                        this.brokerController.getBrokerOuterAPI().unlockBatchMQAsync((String)addrMap.get(brokerId), requestBody, 1000L, new UnlockCallback(){

                            public void onSuccess() {
                            }

                            public void onException(Throwable e) {
                                LOGGER.warn("unlockBatchMQ exception on {}, {}", addrMap.get(brokerId), (Object)e);
                            }
                        });
                    }
                    catch (Exception e) {
                        LOGGER.warn("unlockBatchMQ exception on {}, {}", addrMap.get(brokerId), (Object)e);
                    }
                }
            }
        }
        response.setCode(0);
        response.setRemark(null);
        return response;
    }

    private RemotingCommand updateAndCreateSubscriptionGroup(ChannelHandlerContext ctx, RemotingCommand request) throws RemotingCommandException {
        RemotingCommand response = RemotingCommand.createResponseCommand(null);
        if (this.validateSlave(response)) {
            return response;
        }
        LOGGER.info("AdminBrokerProcessor#updateAndCreateSubscriptionGroup called by {}", (Object)RemotingHelper.parseChannelRemoteAddr((Channel)ctx.channel()));
        SubscriptionGroupConfig config = (SubscriptionGroupConfig)RemotingSerializable.decode((byte[])request.getBody(), SubscriptionGroupConfig.class);
        if (config != null) {
            this.brokerController.getSubscriptionGroupManager().updateSubscriptionGroupConfig(config);
        }
        response.setCode(0);
        response.setRemark(null);
        return response;
    }

    private void initConsumerOffset(String clientHost, String groupName, int mode, TopicConfig topicConfig) {
        String topic = topicConfig.getTopicName();
        for (int queueId = 0; queueId < topicConfig.getReadQueueNums(); ++queueId) {
            if (this.brokerController.getConsumerOffsetManager().queryOffset(groupName, topic, queueId) > -1L) continue;
            long offset = 0L;
            if (this.brokerController.getMessageStore().getConsumeQueue(topic, queueId) != null) {
                if (1 == mode) {
                    offset = this.brokerController.getMessageStore().getMaxOffsetInQueue(topic, queueId);
                } else if (0 == mode) {
                    offset = this.brokerController.getMessageStore().getMinOffsetInQueue(topic, queueId);
                }
            }
            this.brokerController.getConsumerOffsetManager().commitOffset(clientHost, groupName, topic, queueId, offset);
            LOGGER.info("AdminBrokerProcessor#initConsumerOffset: consumerGroup={}, topic={}, queueId={}, offset={}", new Object[]{groupName, topic, queueId, offset});
        }
    }

    private RemotingCommand getAllSubscriptionGroup(ChannelHandlerContext ctx, RemotingCommand request) throws RemotingCommandException {
        RemotingCommand response = RemotingCommand.createResponseCommand(null);
        String content = this.brokerController.getSubscriptionGroupManager().encode();
        if (content != null && content.length() > 0) {
            try {
                response.setBody(content.getBytes("UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                LOGGER.error("UnsupportedEncodingException getAllSubscriptionGroup", (Throwable)e);
                response.setCode(1);
                response.setRemark("UnsupportedEncodingException " + e.getMessage());
                return response;
            }
        } else {
            LOGGER.error("No subscription group in this broker, client:{} ", (Object)ctx.channel().remoteAddress());
            response.setCode(1);
            response.setRemark("No subscription group in this broker");
            return response;
        }
        response.setCode(0);
        response.setRemark(null);
        return response;
    }

    private RemotingCommand deleteSubscriptionGroup(ChannelHandlerContext ctx, RemotingCommand request) throws RemotingCommandException {
        RemotingCommand response = RemotingCommand.createResponseCommand(null);
        if (this.validateSlave(response)) {
            return response;
        }
        DeleteSubscriptionGroupRequestHeader requestHeader = (DeleteSubscriptionGroupRequestHeader)request.decodeCommandCustomHeader(DeleteSubscriptionGroupRequestHeader.class);
        LOGGER.info("AdminBrokerProcessor#deleteSubscriptionGroup, caller={}", (Object)RemotingHelper.parseChannelRemoteAddr((Channel)ctx.channel()));
        this.brokerController.getSubscriptionGroupManager().deleteSubscriptionGroupConfig(requestHeader.getGroupName());
        if (requestHeader.isCleanOffset()) {
            this.brokerController.getConsumerOffsetManager().removeOffset(requestHeader.getGroupName());
            this.brokerController.getPopInflightMessageCounter().clearInFlightMessageNumByGroupName(requestHeader.getGroupName());
        }
        if (this.brokerController.getBrokerConfig().isAutoDeleteUnusedStats()) {
            this.brokerController.getBrokerStatsManager().onGroupDeleted(requestHeader.getGroupName());
        }
        response.setCode(0);
        response.setRemark(null);
        return response;
    }

    private RemotingCommand getTopicStatsInfo(ChannelHandlerContext ctx, RemotingCommand request) throws RemotingCommandException {
        RemotingCommand response = RemotingCommand.createResponseCommand(null);
        GetTopicStatsInfoRequestHeader requestHeader = (GetTopicStatsInfoRequestHeader)request.decodeCommandCustomHeader(GetTopicStatsInfoRequestHeader.class);
        String topic = requestHeader.getTopic();
        TopicConfig topicConfig = this.brokerController.getTopicConfigManager().selectTopicConfig(topic);
        if (null == topicConfig) {
            response.setCode(17);
            response.setRemark("topic[" + topic + "] not exist");
            return response;
        }
        TopicStatsTable topicStatsTable = new TopicStatsTable();
        for (int i = 0; i < topicConfig.getWriteQueueNums(); ++i) {
            long max;
            MessageQueue mq = new MessageQueue();
            mq.setTopic(topic);
            mq.setBrokerName(this.brokerController.getBrokerConfig().getBrokerName());
            mq.setQueueId(i);
            TopicOffset topicOffset = new TopicOffset();
            long min = this.brokerController.getMessageStore().getMinOffsetInQueue(topic, i);
            if (min < 0L) {
                min = 0L;
            }
            if ((max = this.brokerController.getMessageStore().getMaxOffsetInQueue(topic, i)) < 0L) {
                max = 0L;
            }
            long timestamp = 0L;
            if (max > 0L) {
                timestamp = this.brokerController.getMessageStore().getMessageStoreTimeStamp(topic, i, max - 1L);
            }
            topicOffset.setMinOffset(min);
            topicOffset.setMaxOffset(max);
            topicOffset.setLastUpdateTimestamp(timestamp);
            topicStatsTable.getOffsetTable().put(mq, topicOffset);
        }
        byte[] body = topicStatsTable.encode();
        response.setBody(body);
        response.setCode(0);
        response.setRemark(null);
        return response;
    }

    private RemotingCommand getConsumerConnectionList(ChannelHandlerContext ctx, RemotingCommand request) throws RemotingCommandException {
        RemotingCommand response = RemotingCommand.createResponseCommand(null);
        GetConsumerConnectionListRequestHeader requestHeader = (GetConsumerConnectionListRequestHeader)request.decodeCommandCustomHeader(GetConsumerConnectionListRequestHeader.class);
        ConsumerGroupInfo consumerGroupInfo = this.brokerController.getConsumerManager().getConsumerGroupInfo(requestHeader.getConsumerGroup());
        if (consumerGroupInfo != null) {
            ConsumerConnection bodydata = new ConsumerConnection();
            bodydata.setConsumeFromWhere(consumerGroupInfo.getConsumeFromWhere());
            bodydata.setConsumeType(consumerGroupInfo.getConsumeType());
            bodydata.setMessageModel(consumerGroupInfo.getMessageModel());
            bodydata.getSubscriptionTable().putAll(consumerGroupInfo.getSubscriptionTable());
            Iterator it = consumerGroupInfo.getChannelInfoTable().entrySet().iterator();
            while (it.hasNext()) {
                ClientChannelInfo info = (ClientChannelInfo)it.next().getValue();
                Connection connection = new Connection();
                connection.setClientId(info.getClientId());
                connection.setLanguage(info.getLanguage());
                connection.setVersion(info.getVersion());
                connection.setClientAddr(RemotingHelper.parseChannelRemoteAddr((Channel)info.getChannel()));
                bodydata.getConnectionSet().add(connection);
            }
            byte[] body = bodydata.encode();
            response.setBody(body);
            response.setCode(0);
            response.setRemark(null);
            return response;
        }
        response.setCode(206);
        response.setRemark("the consumer group[" + requestHeader.getConsumerGroup() + "] not online");
        return response;
    }

    private RemotingCommand getAllProducerInfo(ChannelHandlerContext ctx, RemotingCommand request) throws RemotingCommandException {
        RemotingCommand response = RemotingCommand.createResponseCommand(null);
        GetAllProducerInfoRequestHeader requestHeader = (GetAllProducerInfoRequestHeader)request.decodeCommandCustomHeader(GetAllProducerInfoRequestHeader.class);
        ProducerTableInfo producerTable = this.brokerController.getProducerManager().getProducerTable();
        if (producerTable != null) {
            byte[] body = producerTable.encode();
            response.setBody(body);
            response.setCode(0);
            response.setRemark(null);
            return response;
        }
        response.setCode(1);
        return response;
    }

    private RemotingCommand getProducerConnectionList(ChannelHandlerContext ctx, RemotingCommand request) throws RemotingCommandException {
        RemotingCommand response = RemotingCommand.createResponseCommand(null);
        GetProducerConnectionListRequestHeader requestHeader = (GetProducerConnectionListRequestHeader)request.decodeCommandCustomHeader(GetProducerConnectionListRequestHeader.class);
        ProducerConnection bodydata = new ProducerConnection();
        Map channelInfoHashMap = this.brokerController.getProducerManager().getGroupChannelTable().get(requestHeader.getProducerGroup());
        if (channelInfoHashMap != null) {
            Iterator it = channelInfoHashMap.entrySet().iterator();
            while (it.hasNext()) {
                ClientChannelInfo info = (ClientChannelInfo)it.next().getValue();
                Connection connection = new Connection();
                connection.setClientId(info.getClientId());
                connection.setLanguage(info.getLanguage());
                connection.setVersion(info.getVersion());
                connection.setClientAddr(RemotingHelper.parseChannelRemoteAddr((Channel)info.getChannel()));
                bodydata.getConnectionSet().add(connection);
            }
            byte[] body = bodydata.encode();
            response.setBody(body);
            response.setCode(0);
            response.setRemark(null);
            return response;
        }
        response.setCode(1);
        response.setRemark("the producer group[" + requestHeader.getProducerGroup() + "] not exist");
        return response;
    }

    private RemotingCommand getConsumeStats(ChannelHandlerContext ctx, RemotingCommand request) throws RemotingCommandException {
        RemotingCommand response = RemotingCommand.createResponseCommand(null);
        GetConsumeStatsRequestHeader requestHeader = (GetConsumeStatsRequestHeader)request.decodeCommandCustomHeader(GetConsumeStatsRequestHeader.class);
        ConsumeStats consumeStats = new ConsumeStats();
        Set<String> topics = new HashSet<String>();
        if (UtilAll.isBlank((String)requestHeader.getTopic())) {
            topics = this.brokerController.getConsumerOffsetManager().whichTopicByConsumer(requestHeader.getConsumerGroup());
        } else {
            topics.add(requestHeader.getTopic());
        }
        for (String topic : topics) {
            TopicConfig topicConfig = this.brokerController.getTopicConfigManager().selectTopicConfig(topic);
            if (null == topicConfig) {
                LOGGER.warn("AdminBrokerProcessor#getConsumeStats: topic config does not exist, topic={}", (Object)topic);
                continue;
            }
            TopicQueueMappingDetail mappingDetail = this.brokerController.getTopicQueueMappingManager().getTopicQueueMapping(topic);
            SubscriptionData findSubscriptionData = this.brokerController.getConsumerManager().findSubscriptionData(requestHeader.getConsumerGroup(), topic);
            if (null == findSubscriptionData && this.brokerController.getConsumerManager().findSubscriptionDataCount(requestHeader.getConsumerGroup()) > 0) {
                LOGGER.warn("AdminBrokerProcessor#getConsumeStats: topic does not exist in consumer group's subscription, topic={}, consumer group={}", (Object)topic, (Object)requestHeader.getConsumerGroup());
                continue;
            }
            for (int i = 0; i < topicConfig.getReadQueueNums(); ++i) {
                long lastTimestamp;
                MessageQueue mq = new MessageQueue();
                mq.setTopic(topic);
                mq.setBrokerName(this.brokerController.getBrokerConfig().getBrokerName());
                mq.setQueueId(i);
                OffsetWrapper offsetWrapper = new OffsetWrapper();
                long brokerOffset = this.brokerController.getMessageStore().getMaxOffsetInQueue(topic, i);
                if (brokerOffset < 0L) {
                    brokerOffset = 0L;
                }
                long consumerOffset = this.brokerController.getConsumerOffsetManager().queryOffset(requestHeader.getConsumerGroup(), topic, i);
                if (mappingDetail == null && consumerOffset < 0L) {
                    consumerOffset = 0L;
                }
                long pullOffset = this.brokerController.getConsumerOffsetManager().queryPullOffset(requestHeader.getConsumerGroup(), topic, i);
                offsetWrapper.setBrokerOffset(brokerOffset);
                offsetWrapper.setConsumerOffset(consumerOffset);
                offsetWrapper.setPullOffset(Math.max(consumerOffset, pullOffset));
                long timeOffset = consumerOffset - 1L;
                if (timeOffset >= 0L && (lastTimestamp = this.brokerController.getMessageStore().getMessageStoreTimeStamp(topic, i, timeOffset)) > 0L) {
                    offsetWrapper.setLastTimestamp(lastTimestamp);
                }
                consumeStats.getOffsetTable().put(mq, offsetWrapper);
            }
            double consumeTps = this.brokerController.getBrokerStatsManager().tpsGroupGetNums(requestHeader.getConsumerGroup(), topic);
            consumeStats.setConsumeTps(consumeTps += consumeStats.getConsumeTps());
        }
        byte[] body = consumeStats.encode();
        response.setBody(body);
        response.setCode(0);
        response.setRemark(null);
        return response;
    }

    private RemotingCommand getAllConsumerOffset(ChannelHandlerContext ctx, RemotingCommand request) {
        RemotingCommand response = RemotingCommand.createResponseCommand(null);
        String content = this.brokerController.getConsumerOffsetManager().encode();
        if (content != null && content.length() > 0) {
            try {
                response.setBody(content.getBytes("UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                LOGGER.error("get all consumer offset from master error.", (Throwable)e);
                response.setCode(1);
                response.setRemark("UnsupportedEncodingException " + e.getMessage());
                return response;
            }
        } else {
            LOGGER.error("No consumer offset in this broker, client: {} ", (Object)ctx.channel().remoteAddress());
            response.setCode(1);
            response.setRemark("No consumer offset in this broker");
            return response;
        }
        response.setCode(0);
        response.setRemark(null);
        return response;
    }

    private RemotingCommand getAllDelayOffset(ChannelHandlerContext ctx, RemotingCommand request) {
        RemotingCommand response = RemotingCommand.createResponseCommand(null);
        String content = this.brokerController.getScheduleMessageService().encode();
        if (content != null && content.length() > 0) {
            try {
                response.setBody(content.getBytes("UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                LOGGER.error("AdminBrokerProcessor#getAllDelayOffset: unexpected error, caller={}.", (Object)RemotingHelper.parseChannelRemoteAddr((Channel)ctx.channel()), (Object)e);
                response.setCode(1);
                response.setRemark("UnsupportedEncodingException " + e);
                return response;
            }
        } else {
            LOGGER.error("AdminBrokerProcessor#getAllDelayOffset: no delay offset in this broker, caller={}", (Object)RemotingHelper.parseChannelRemoteAddr((Channel)ctx.channel()));
            response.setCode(1);
            response.setRemark("No delay offset in this broker");
            return response;
        }
        response.setCode(0);
        response.setRemark(null);
        return response;
    }

    private RemotingCommand getAllMessageRequestMode(ChannelHandlerContext ctx, RemotingCommand request) {
        RemotingCommand response = RemotingCommand.createResponseCommand(null);
        String content = this.brokerController.getQueryAssignmentProcessor().getMessageRequestModeManager().encode();
        if (content != null && content.length() > 0) {
            try {
                response.setBody(content.getBytes("UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                LOGGER.error("get all message request mode from master error.", (Throwable)e);
                response.setCode(1);
                response.setRemark("UnsupportedEncodingException " + e);
                return response;
            }
        } else {
            LOGGER.error("No message request mode in this broker, client: {} ", (Object)ctx.channel().remoteAddress());
            response.setCode(1);
            response.setRemark("No message request mode in this broker");
            return response;
        }
        response.setCode(0);
        response.setRemark(null);
        return response;
    }

    public RemotingCommand resetOffset(ChannelHandlerContext ctx, RemotingCommand request) throws RemotingCommandException {
        ResetOffsetRequestHeader requestHeader = (ResetOffsetRequestHeader)request.decodeCommandCustomHeader(ResetOffsetRequestHeader.class);
        LOGGER.info("[reset-offset] reset offset started by {}. topic={}, group={}, timestamp={}, isForce={}", new Object[]{RemotingHelper.parseChannelRemoteAddr((Channel)ctx.channel()), requestHeader.getTopic(), requestHeader.getGroup(), requestHeader.getTimestamp(), requestHeader.isForce()});
        if (this.brokerController.getBrokerConfig().isUseServerSideResetOffset()) {
            String topic = requestHeader.getTopic();
            String group = requestHeader.getGroup();
            int queueId = requestHeader.getQueueId();
            long timestamp = requestHeader.getTimestamp();
            Long offset = requestHeader.getOffset();
            return this.resetOffsetInner(topic, group, queueId, timestamp, offset);
        }
        boolean isC = false;
        LanguageCode language = request.getLanguage();
        switch (language) {
            case CPP: {
                isC = true;
            }
        }
        return this.brokerController.getBroker2Client().resetOffset(requestHeader.getTopic(), requestHeader.getGroup(), requestHeader.getTimestamp(), requestHeader.isForce(), isC);
    }

    private Long searchOffsetByTimestamp(String topic, int queueId, long timestamp) {
        if (timestamp < 0L) {
            return this.brokerController.getMessageStore().getMaxOffsetInQueue(topic, queueId);
        }
        return this.brokerController.getMessageStore().getOffsetInQueueByTime(topic, queueId, timestamp);
    }

    private RemotingCommand resetOffsetInner(String topic, String group, int queueId, long timestamp, Long offset) {
        RemotingCommand response = RemotingCommand.createResponseCommand((int)0, null);
        if (BrokerRole.SLAVE == this.brokerController.getMessageStoreConfig().getBrokerRole()) {
            response.setCode(1);
            response.setRemark("Can not reset offset in slave broker");
            return response;
        }
        HashMap<Integer, Long> queueOffsetMap = new HashMap<Integer, Long>();
        TopicConfig topicConfig = (TopicConfig)this.brokerController.getTopicConfigManager().getTopicConfigTable().get(topic);
        if (null == topicConfig) {
            response.setCode(17);
            response.setRemark("Topic " + topic + " does not exist");
            LOGGER.warn("Reset offset failed, topic does not exist. topic={}, group={}", (Object)topic, (Object)group);
            return response;
        }
        if (!this.brokerController.getSubscriptionGroupManager().containsSubscriptionGroup(group)) {
            response.setCode(26);
            response.setRemark("Group " + group + " does not exist");
            LOGGER.warn("Reset offset failed, group does not exist. topic={}, group={}", (Object)topic, (Object)group);
            return response;
        }
        if (queueId >= 0) {
            if (null != offset && -1L != offset) {
                long min = this.brokerController.getMessageStore().getMinOffsetInQueue(topic, queueId);
                long max = this.brokerController.getMessageStore().getMaxOffsetInQueue(topic, queueId);
                if (min >= 0L && offset < min || offset > max + 1L) {
                    response.setCode(1);
                    response.setRemark(String.format("Target offset %d not in consume queue range [%d-%d]", offset, min, max));
                    return response;
                }
            } else {
                offset = this.searchOffsetByTimestamp(topic, queueId, timestamp);
            }
            queueOffsetMap.put(queueId, offset);
        } else {
            for (int index = 0; index < topicConfig.getReadQueueNums(); ++index) {
                offset = this.searchOffsetByTimestamp(topic, index, timestamp);
                queueOffsetMap.put(index, offset);
            }
        }
        if (queueOffsetMap.isEmpty()) {
            response.setCode(1);
            response.setRemark("No queues to reset.");
            LOGGER.warn("Reset offset aborted: no queues to reset");
            return response;
        }
        for (Map.Entry entry : queueOffsetMap.entrySet()) {
            this.brokerController.getConsumerOffsetManager().assignResetOffset(topic, group, (Integer)entry.getKey(), (Long)entry.getValue());
        }
        ResetOffsetBody body = new ResetOffsetBody();
        String brokerName = this.brokerController.getBrokerConfig().getBrokerName();
        for (Map.Entry entry : queueOffsetMap.entrySet()) {
            this.brokerController.getPopInflightMessageCounter().clearInFlightMessageNum(topic, group, (Integer)entry.getKey());
            body.getOffsetTable().put(new MessageQueue(topic, brokerName, ((Integer)entry.getKey()).intValue()), entry.getValue());
        }
        LOGGER.info("Reset offset, topic={}, group={}, queues={}", new Object[]{topic, group, body.toJson(false)});
        response.setBody(body.encode());
        return response;
    }

    public RemotingCommand getConsumerStatus(ChannelHandlerContext ctx, RemotingCommand request) throws RemotingCommandException {
        GetConsumerStatusRequestHeader requestHeader = (GetConsumerStatusRequestHeader)request.decodeCommandCustomHeader(GetConsumerStatusRequestHeader.class);
        LOGGER.info("[get-consumer-status] get consumer status by {}. topic={}, group={}", new Object[]{RemotingHelper.parseChannelRemoteAddr((Channel)ctx.channel()), requestHeader.getTopic(), requestHeader.getGroup()});
        return this.brokerController.getBroker2Client().getConsumeStatus(requestHeader.getTopic(), requestHeader.getGroup(), requestHeader.getClientAddr());
    }

    private RemotingCommand queryTopicConsumeByWho(ChannelHandlerContext ctx, RemotingCommand request) throws RemotingCommandException {
        RemotingCommand response = RemotingCommand.createResponseCommand(null);
        QueryTopicConsumeByWhoRequestHeader requestHeader = (QueryTopicConsumeByWhoRequestHeader)request.decodeCommandCustomHeader(QueryTopicConsumeByWhoRequestHeader.class);
        HashSet<String> groups = this.brokerController.getConsumerManager().queryTopicConsumeByWho(requestHeader.getTopic());
        Set<String> groupInOffset = this.brokerController.getConsumerOffsetManager().whichGroupByTopic(requestHeader.getTopic());
        if (groupInOffset != null && !groupInOffset.isEmpty()) {
            groups.addAll(groupInOffset);
        }
        GroupList groupList = new GroupList();
        groupList.setGroupList(groups);
        byte[] body = groupList.encode();
        response.setBody(body);
        response.setCode(0);
        response.setRemark(null);
        return response;
    }

    private RemotingCommand queryTopicsByConsumer(ChannelHandlerContext ctx, RemotingCommand request) throws RemotingCommandException {
        RemotingCommand response = RemotingCommand.createResponseCommand(null);
        QueryTopicsByConsumerRequestHeader requestHeader = (QueryTopicsByConsumerRequestHeader)request.decodeCommandCustomHeader(QueryTopicsByConsumerRequestHeader.class);
        Set<String> topics = this.brokerController.getConsumerOffsetManager().whichTopicByConsumer(requestHeader.getGroup());
        TopicList topicList = new TopicList();
        topicList.setTopicList(topics);
        topicList.setBrokerAddr(this.brokerController.getBrokerAddr());
        byte[] body = topicList.encode();
        response.setBody(body);
        response.setCode(0);
        response.setRemark(null);
        return response;
    }

    private RemotingCommand querySubscriptionByConsumer(ChannelHandlerContext ctx, RemotingCommand request) throws RemotingCommandException {
        RemotingCommand response = RemotingCommand.createResponseCommand(null);
        QuerySubscriptionByConsumerRequestHeader requestHeader = (QuerySubscriptionByConsumerRequestHeader)request.decodeCommandCustomHeader(QuerySubscriptionByConsumerRequestHeader.class);
        SubscriptionData subscriptionData = this.brokerController.getConsumerManager().findSubscriptionData(requestHeader.getGroup(), requestHeader.getTopic());
        QuerySubscriptionResponseBody responseBody = new QuerySubscriptionResponseBody();
        responseBody.setGroup(requestHeader.getGroup());
        responseBody.setTopic(requestHeader.getTopic());
        responseBody.setSubscriptionData(subscriptionData);
        byte[] body = responseBody.encode();
        response.setBody(body);
        response.setCode(0);
        response.setRemark(null);
        return response;
    }

    private RemotingCommand queryConsumeTimeSpan(ChannelHandlerContext ctx, RemotingCommand request) throws RemotingCommandException {
        RemotingCommand response = RemotingCommand.createResponseCommand(null);
        QueryConsumeTimeSpanRequestHeader requestHeader = (QueryConsumeTimeSpanRequestHeader)request.decodeCommandCustomHeader(QueryConsumeTimeSpanRequestHeader.class);
        String topic = requestHeader.getTopic();
        TopicConfig topicConfig = this.brokerController.getTopicConfigManager().selectTopicConfig(topic);
        if (null == topicConfig) {
            response.setCode(17);
            response.setRemark("topic[" + topic + "] not exist");
            return response;
        }
        ArrayList<QueueTimeSpan> timeSpanSet = new ArrayList<QueueTimeSpan>();
        for (int i = 0; i < topicConfig.getWriteQueueNums(); ++i) {
            QueueTimeSpan timeSpan = new QueueTimeSpan();
            MessageQueue mq = new MessageQueue();
            mq.setTopic(topic);
            mq.setBrokerName(this.brokerController.getBrokerConfig().getBrokerName());
            mq.setQueueId(i);
            timeSpan.setMessageQueue(mq);
            long minTime = this.brokerController.getMessageStore().getEarliestMessageTime(topic, i);
            timeSpan.setMinTimeStamp(minTime);
            long max = this.brokerController.getMessageStore().getMaxOffsetInQueue(topic, i);
            long maxTime = this.brokerController.getMessageStore().getMessageStoreTimeStamp(topic, i, max - 1L);
            timeSpan.setMaxTimeStamp(maxTime);
            long consumerOffset = this.brokerController.getConsumerOffsetManager().queryOffset(requestHeader.getGroup(), topic, i);
            long consumeTime = consumerOffset > 0L ? this.brokerController.getMessageStore().getMessageStoreTimeStamp(topic, i, consumerOffset - 1L) : minTime;
            timeSpan.setConsumeTimeStamp(consumeTime);
            long maxBrokerOffset = this.brokerController.getMessageStore().getMaxOffsetInQueue(requestHeader.getTopic(), i);
            if (consumerOffset < maxBrokerOffset) {
                long nextTime = this.brokerController.getMessageStore().getMessageStoreTimeStamp(topic, i, consumerOffset);
                timeSpan.setDelayTime(System.currentTimeMillis() - nextTime);
            }
            timeSpanSet.add(timeSpan);
        }
        QueryConsumeTimeSpanBody queryConsumeTimeSpanBody = new QueryConsumeTimeSpanBody();
        queryConsumeTimeSpanBody.setConsumeTimeSpanSet(timeSpanSet);
        response.setBody(queryConsumeTimeSpanBody.encode());
        response.setCode(0);
        response.setRemark(null);
        return response;
    }

    private RemotingCommand getSystemTopicListFromBroker(ChannelHandlerContext ctx, RemotingCommand request) throws RemotingCommandException {
        RemotingCommand response = RemotingCommand.createResponseCommand(null);
        Set topics = TopicValidator.getSystemTopicSet();
        TopicList topicList = new TopicList();
        topicList.setTopicList(topics);
        response.setBody(topicList.encode());
        response.setCode(0);
        response.setRemark(null);
        return response;
    }

    public RemotingCommand cleanExpiredConsumeQueue() {
        LOGGER.info("AdminBrokerProcessor#cleanExpiredConsumeQueue: start.");
        RemotingCommand response = RemotingCommand.createResponseCommand(null);
        this.brokerController.getMessageStore().cleanExpiredConsumerQueue();
        LOGGER.info("AdminBrokerProcessor#cleanExpiredConsumeQueue: end.");
        response.setCode(0);
        response.setRemark(null);
        return response;
    }

    public RemotingCommand deleteExpiredCommitLog() {
        LOGGER.warn("invoke deleteExpiredCommitLog start.");
        RemotingCommand response = RemotingCommand.createResponseCommand(null);
        this.brokerController.getMessageStore().executeDeleteFilesManually();
        LOGGER.warn("invoke deleteExpiredCommitLog end.");
        response.setCode(0);
        response.setRemark(null);
        return response;
    }

    public RemotingCommand cleanUnusedTopic() {
        LOGGER.warn("invoke cleanUnusedTopic start.");
        RemotingCommand response = RemotingCommand.createResponseCommand(null);
        this.brokerController.getMessageStore().cleanUnusedTopic(this.brokerController.getTopicConfigManager().getTopicConfigTable().keySet());
        LOGGER.warn("invoke cleanUnusedTopic end.");
        response.setCode(0);
        response.setRemark(null);
        return response;
    }

    private RemotingCommand getConsumerRunningInfo(ChannelHandlerContext ctx, RemotingCommand request) throws RemotingCommandException {
        GetConsumerRunningInfoRequestHeader requestHeader = (GetConsumerRunningInfoRequestHeader)request.decodeCommandCustomHeader(GetConsumerRunningInfoRequestHeader.class);
        return this.callConsumer(307, request, requestHeader.getConsumerGroup(), requestHeader.getClientId());
    }

    private RemotingCommand queryCorrectionOffset(ChannelHandlerContext ctx, RemotingCommand request) throws RemotingCommandException {
        RemotingCommand response = RemotingCommand.createResponseCommand(null);
        QueryCorrectionOffsetHeader requestHeader = (QueryCorrectionOffsetHeader)request.decodeCommandCustomHeader(QueryCorrectionOffsetHeader.class);
        Map<Integer, Long> correctionOffset = this.brokerController.getConsumerOffsetManager().queryMinOffsetInAllGroup(requestHeader.getTopic(), requestHeader.getFilterGroups());
        Map<Integer, Long> compareOffset = this.brokerController.getConsumerOffsetManager().queryOffset(requestHeader.getCompareGroup(), requestHeader.getTopic());
        if (compareOffset != null && !compareOffset.isEmpty()) {
            for (Map.Entry<Integer, Long> entry : compareOffset.entrySet()) {
                Integer queueId;
                correctionOffset.put(queueId, correctionOffset.get(queueId = entry.getKey()) > entry.getValue() ? Long.valueOf(Long.MAX_VALUE) : correctionOffset.get(queueId));
            }
        }
        QueryCorrectionOffsetBody body = new QueryCorrectionOffsetBody();
        body.setCorrectionOffsets(correctionOffset);
        response.setBody(body.encode());
        response.setCode(0);
        response.setRemark(null);
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RemotingCommand consumeMessageDirectly(ChannelHandlerContext ctx, RemotingCommand request) throws RemotingCommandException {
        SubscriptionGroupConfig groupConfig;
        TopicConfig topicConfig;
        ConsumeMessageDirectlyResultRequestHeader requestHeader = (ConsumeMessageDirectlyResultRequestHeader)request.decodeCommandCustomHeader(ConsumeMessageDirectlyResultRequestHeader.class);
        request.getExtFields().put("brokerName", this.brokerController.getBrokerConfig().getBrokerName());
        if (StringUtils.isNotEmpty((CharSequence)requestHeader.getTopic()) && (topicConfig = (TopicConfig)this.brokerController.getTopicConfigManager().getTopicConfigTable().get(requestHeader.getTopic())) != null) {
            request.addExtField("topicSysFlag", String.valueOf(topicConfig.getTopicSysFlag()));
        }
        if (StringUtils.isNotEmpty((CharSequence)requestHeader.getConsumerGroup()) && (groupConfig = (SubscriptionGroupConfig)this.brokerController.getSubscriptionGroupManager().getSubscriptionGroupTable().get(requestHeader.getConsumerGroup())) != null) {
            request.addExtField("groupSysFlag", String.valueOf(groupConfig.getGroupSysFlag()));
        }
        SelectMappedBufferResult selectMappedBufferResult = null;
        try {
            MessageId messageId = MessageDecoder.decodeMessageId((String)requestHeader.getMsgId());
            selectMappedBufferResult = this.brokerController.getMessageStore().selectOneMessageByOffset(messageId.getOffset());
            byte[] body = new byte[selectMappedBufferResult.getSize()];
            selectMappedBufferResult.getByteBuffer().get(body);
            request.setBody(body);
        }
        catch (UnknownHostException unknownHostException) {
        }
        finally {
            if (selectMappedBufferResult != null) {
                selectMappedBufferResult.release();
            }
        }
        return this.callConsumer(309, request, requestHeader.getConsumerGroup(), requestHeader.getClientId());
    }

    private RemotingCommand cloneGroupOffset(ChannelHandlerContext ctx, RemotingCommand request) throws RemotingCommandException {
        Set<Object> topics;
        RemotingCommand response = RemotingCommand.createResponseCommand(null);
        CloneGroupOffsetRequestHeader requestHeader = (CloneGroupOffsetRequestHeader)request.decodeCommandCustomHeader(CloneGroupOffsetRequestHeader.class);
        if (UtilAll.isBlank((String)requestHeader.getTopic())) {
            topics = this.brokerController.getConsumerOffsetManager().whichTopicByConsumer(requestHeader.getSrcGroup());
        } else {
            topics = new HashSet<String>();
            topics.add(requestHeader.getTopic());
        }
        for (String string : topics) {
            TopicConfig topicConfig = this.brokerController.getTopicConfigManager().selectTopicConfig(string);
            if (null == topicConfig) {
                LOGGER.warn("[cloneGroupOffset], topic config not exist, {}", (Object)string);
                continue;
            }
            if (!requestHeader.isOffline()) {
                SubscriptionData findSubscriptionData = this.brokerController.getConsumerManager().findSubscriptionData(requestHeader.getSrcGroup(), string);
                if (this.brokerController.getConsumerManager().findSubscriptionDataCount(requestHeader.getSrcGroup()) > 0 && findSubscriptionData == null) {
                    LOGGER.warn("AdminBrokerProcessor#cloneGroupOffset: topic does not exist in consumer group's subscription, topic={}, consumer group={}", (Object)string, (Object)requestHeader.getSrcGroup());
                    continue;
                }
            }
            this.brokerController.getConsumerOffsetManager().cloneOffset(requestHeader.getSrcGroup(), requestHeader.getDestGroup(), requestHeader.getTopic());
        }
        response.setCode(0);
        response.setRemark(null);
        return response;
    }

    private RemotingCommand ViewBrokerStatsData(ChannelHandlerContext ctx, RemotingCommand request) throws RemotingCommandException {
        ViewBrokerStatsDataRequestHeader requestHeader = (ViewBrokerStatsDataRequestHeader)request.decodeCommandCustomHeader(ViewBrokerStatsDataRequestHeader.class);
        RemotingCommand response = RemotingCommand.createResponseCommand(null);
        MessageStore messageStore = this.brokerController.getMessageStore();
        StatsItem statsItem = messageStore.getBrokerStatsManager().getStatsItem(requestHeader.getStatsName(), requestHeader.getStatsKey());
        if (null == statsItem) {
            response.setCode(1);
            response.setRemark(String.format("The stats <%s> <%s> not exist", requestHeader.getStatsName(), requestHeader.getStatsKey()));
            return response;
        }
        BrokerStatsData brokerStatsData = new BrokerStatsData();
        BrokerStatsItem it = new BrokerStatsItem();
        StatsSnapshot ss = statsItem.getStatsDataInMinute();
        it.setSum(ss.getSum());
        it.setTps(ss.getTps());
        it.setAvgpt(ss.getAvgpt());
        brokerStatsData.setStatsMinute(it);
        it = new BrokerStatsItem();
        ss = statsItem.getStatsDataInHour();
        it.setSum(ss.getSum());
        it.setTps(ss.getTps());
        it.setAvgpt(ss.getAvgpt());
        brokerStatsData.setStatsHour(it);
        it = new BrokerStatsItem();
        ss = statsItem.getStatsDataInDay();
        it.setSum(ss.getSum());
        it.setTps(ss.getTps());
        it.setAvgpt(ss.getAvgpt());
        brokerStatsData.setStatsDay(it);
        response.setBody(brokerStatsData.encode());
        response.setCode(0);
        response.setRemark(null);
        return response;
    }

    private RemotingCommand fetchAllConsumeStatsInBroker(ChannelHandlerContext ctx, RemotingCommand request) throws RemotingCommandException {
        RemotingCommand response = RemotingCommand.createResponseCommand(null);
        GetConsumeStatsInBrokerHeader requestHeader = (GetConsumeStatsInBrokerHeader)request.decodeCommandCustomHeader(GetConsumeStatsInBrokerHeader.class);
        boolean isOrder = requestHeader.isOrder();
        ConcurrentMap<String, SubscriptionGroupConfig> subscriptionGroups = this.brokerController.getSubscriptionGroupManager().getSubscriptionGroupTable();
        ArrayList brokerConsumeStatsList = new ArrayList();
        long totalDiff = 0L;
        long totalInflightDiff = 0L;
        for (String group : subscriptionGroups.keySet()) {
            HashMap subscripTopicConsumeMap = new HashMap();
            Set<String> topics = this.brokerController.getConsumerOffsetManager().whichTopicByConsumer(group);
            ArrayList<ConsumeStats> consumeStatsList = new ArrayList<ConsumeStats>();
            for (String topic : topics) {
                ConsumeStats consumeStats = new ConsumeStats();
                TopicConfig topicConfig = this.brokerController.getTopicConfigManager().selectTopicConfig(topic);
                if (null == topicConfig) {
                    LOGGER.warn("AdminBrokerProcessor#fetchAllConsumeStatsInBroker: topic config does not exist, topic={}", (Object)topic);
                    continue;
                }
                if (isOrder && !topicConfig.isOrder()) continue;
                SubscriptionData findSubscriptionData = this.brokerController.getConsumerManager().findSubscriptionData(group, topic);
                if (null == findSubscriptionData && this.brokerController.getConsumerManager().findSubscriptionDataCount(group) > 0) {
                    LOGGER.warn("AdminBrokerProcessor#fetchAllConsumeStatsInBroker: topic does not exist in consumer group's subscription, topic={}, consumer group={}", (Object)topic, (Object)group);
                    continue;
                }
                for (int i = 0; i < topicConfig.getWriteQueueNums(); ++i) {
                    long lastTimestamp;
                    long consumerOffset;
                    MessageQueue mq = new MessageQueue();
                    mq.setTopic(topic);
                    mq.setBrokerName(this.brokerController.getBrokerConfig().getBrokerName());
                    mq.setQueueId(i);
                    OffsetWrapper offsetWrapper = new OffsetWrapper();
                    long brokerOffset = this.brokerController.getMessageStore().getMaxOffsetInQueue(topic, i);
                    if (brokerOffset < 0L) {
                        brokerOffset = 0L;
                    }
                    if ((consumerOffset = this.brokerController.getConsumerOffsetManager().queryOffset(group, topic, i)) < 0L) {
                        consumerOffset = 0L;
                    }
                    offsetWrapper.setBrokerOffset(brokerOffset);
                    offsetWrapper.setConsumerOffset(consumerOffset);
                    long timeOffset = consumerOffset - 1L;
                    if (timeOffset >= 0L && (lastTimestamp = this.brokerController.getMessageStore().getMessageStoreTimeStamp(topic, i, timeOffset)) > 0L) {
                        offsetWrapper.setLastTimestamp(lastTimestamp);
                    }
                    consumeStats.getOffsetTable().put(mq, offsetWrapper);
                }
                double consumeTps = this.brokerController.getBrokerStatsManager().tpsGroupGetNums(group, topic);
                consumeStats.setConsumeTps(consumeTps += consumeStats.getConsumeTps());
                totalDiff += consumeStats.computeTotalDiff();
                totalInflightDiff += consumeStats.computeInflightTotalDiff();
                consumeStatsList.add(consumeStats);
            }
            subscripTopicConsumeMap.put(group, consumeStatsList);
            brokerConsumeStatsList.add(subscripTopicConsumeMap);
        }
        ConsumeStatsList consumeStats = new ConsumeStatsList();
        consumeStats.setBrokerAddr(this.brokerController.getBrokerAddr());
        consumeStats.setConsumeStatsList(brokerConsumeStatsList);
        consumeStats.setTotalDiff(totalDiff);
        consumeStats.setTotalInflightDiff(totalInflightDiff);
        response.setBody(consumeStats.encode());
        response.setCode(0);
        response.setRemark(null);
        return response;
    }

    private HashMap<String, String> prepareRuntimeInfo() {
        HashMap runtimeInfo = this.brokerController.getMessageStore().getRuntimeInfo();
        for (BrokerAttachedPlugin brokerAttachedPlugin : this.brokerController.getBrokerAttachedPlugins()) {
            if (brokerAttachedPlugin == null) continue;
            brokerAttachedPlugin.buildRuntimeInfo(runtimeInfo);
        }
        this.brokerController.getScheduleMessageService().buildRunningStats(runtimeInfo);
        runtimeInfo.put("brokerActive", String.valueOf(this.brokerController.isSpecialServiceRunning()));
        runtimeInfo.put("brokerVersionDesc", MQVersion.getVersionDesc((int)MQVersion.CURRENT_VERSION));
        runtimeInfo.put("brokerVersion", String.valueOf(MQVersion.CURRENT_VERSION));
        runtimeInfo.put("msgPutTotalYesterdayMorning", String.valueOf(this.brokerController.getBrokerStats().getMsgPutTotalYesterdayMorning()));
        runtimeInfo.put("msgPutTotalTodayMorning", String.valueOf(this.brokerController.getBrokerStats().getMsgPutTotalTodayMorning()));
        runtimeInfo.put("msgPutTotalTodayNow", String.valueOf(this.brokerController.getBrokerStats().getMsgPutTotalTodayNow()));
        runtimeInfo.put("msgGetTotalYesterdayMorning", String.valueOf(this.brokerController.getBrokerStats().getMsgGetTotalYesterdayMorning()));
        runtimeInfo.put("msgGetTotalTodayMorning", String.valueOf(this.brokerController.getBrokerStats().getMsgGetTotalTodayMorning()));
        runtimeInfo.put("msgGetTotalTodayNow", String.valueOf(this.brokerController.getBrokerStats().getMsgGetTotalTodayNow()));
        runtimeInfo.put("dispatchBehindBytes", String.valueOf(this.brokerController.getMessageStore().dispatchBehindBytes()));
        runtimeInfo.put("pageCacheLockTimeMills", String.valueOf(this.brokerController.getMessageStore().lockTimeMills()));
        runtimeInfo.put("earliestMessageTimeStamp", String.valueOf(this.brokerController.getMessageStore().getEarliestMessageTime()));
        runtimeInfo.put("startAcceptSendRequestTimeStamp", String.valueOf(this.brokerController.getBrokerConfig().getStartAcceptSendRequestTimeStamp()));
        if (this.brokerController.getMessageStoreConfig().isTimerWheelEnable()) {
            runtimeInfo.put("timerReadBehind", String.valueOf(this.brokerController.getMessageStore().getTimerMessageStore().getDequeueBehind()));
            runtimeInfo.put("timerOffsetBehind", String.valueOf(this.brokerController.getMessageStore().getTimerMessageStore().getEnqueueBehindMessages()));
            runtimeInfo.put("timerCongestNum", String.valueOf(this.brokerController.getMessageStore().getTimerMessageStore().getAllCongestNum()));
            runtimeInfo.put("timerEnqueueTps", String.valueOf(this.brokerController.getMessageStore().getTimerMessageStore().getEnqueueTps()));
            runtimeInfo.put("timerDequeueTps", String.valueOf(this.brokerController.getMessageStore().getTimerMessageStore().getDequeueTps()));
        } else {
            runtimeInfo.put("timerReadBehind", "0");
            runtimeInfo.put("timerOffsetBehind", "0");
            runtimeInfo.put("timerCongestNum", "0");
            runtimeInfo.put("timerEnqueueTps", "0.0");
            runtimeInfo.put("timerDequeueTps", "0.0");
        }
        MessageStore messageStore = this.brokerController.getMessageStore();
        runtimeInfo.put("remainTransientStoreBufferNumbs", String.valueOf(messageStore.remainTransientStoreBufferNumbs()));
        if (this.brokerController.getMessageStore() instanceof DefaultMessageStore && ((DefaultMessageStore)this.brokerController.getMessageStore()).isTransientStorePoolEnable()) {
            runtimeInfo.put("remainHowManyDataToCommit", MixAll.humanReadableByteCount((long)messageStore.remainHowManyDataToCommit(), (boolean)false));
        }
        runtimeInfo.put("remainHowManyDataToFlush", MixAll.humanReadableByteCount((long)messageStore.remainHowManyDataToFlush(), (boolean)false));
        File commitLogDir = new File(this.brokerController.getMessageStoreConfig().getStorePathRootDir());
        if (commitLogDir.exists()) {
            runtimeInfo.put("commitLogDirCapacity", String.format("Total : %s, Free : %s.", MixAll.humanReadableByteCount((long)commitLogDir.getTotalSpace(), (boolean)false), MixAll.humanReadableByteCount((long)commitLogDir.getFreeSpace(), (boolean)false)));
        }
        runtimeInfo.put("sendThreadPoolQueueSize", String.valueOf(this.brokerController.getSendThreadPoolQueue().size()));
        runtimeInfo.put("sendThreadPoolQueueCapacity", String.valueOf(this.brokerController.getBrokerConfig().getSendThreadPoolQueueCapacity()));
        runtimeInfo.put("pullThreadPoolQueueSize", String.valueOf(this.brokerController.getPullThreadPoolQueue().size()));
        runtimeInfo.put("pullThreadPoolQueueCapacity", String.valueOf(this.brokerController.getBrokerConfig().getPullThreadPoolQueueCapacity()));
        runtimeInfo.put("litePullThreadPoolQueueSize", String.valueOf(this.brokerController.getLitePullThreadPoolQueue().size()));
        runtimeInfo.put("litePullThreadPoolQueueCapacity", String.valueOf(this.brokerController.getBrokerConfig().getLitePullThreadPoolQueueCapacity()));
        runtimeInfo.put("queryThreadPoolQueueSize", String.valueOf(this.brokerController.getQueryThreadPoolQueue().size()));
        runtimeInfo.put("queryThreadPoolQueueCapacity", String.valueOf(this.brokerController.getBrokerConfig().getQueryThreadPoolQueueCapacity()));
        runtimeInfo.put("sendThreadPoolQueueHeadWaitTimeMills", String.valueOf(this.brokerController.headSlowTimeMills4SendThreadPoolQueue()));
        runtimeInfo.put("pullThreadPoolQueueHeadWaitTimeMills", String.valueOf(this.brokerController.headSlowTimeMills4PullThreadPoolQueue()));
        runtimeInfo.put("queryThreadPoolQueueHeadWaitTimeMills", String.valueOf(this.brokerController.headSlowTimeMills4QueryThreadPoolQueue()));
        runtimeInfo.put("litePullThreadPoolQueueHeadWaitTimeMills", String.valueOf(this.brokerController.headSlowTimeMills4LitePullThreadPoolQueue()));
        runtimeInfo.put("EndTransactionQueueSize", String.valueOf(this.brokerController.getEndTransactionThreadPoolQueue().size()));
        runtimeInfo.put("EndTransactionThreadPoolQueueCapacity", String.valueOf(this.brokerController.getBrokerConfig().getEndTransactionPoolQueueCapacity()));
        return runtimeInfo;
    }

    private RemotingCommand callConsumer(int requestCode, RemotingCommand request, String consumerGroup, String clientId) throws RemotingCommandException {
        RemotingCommand response = RemotingCommand.createResponseCommand(null);
        ClientChannelInfo clientChannelInfo = this.brokerController.getConsumerManager().findChannel(consumerGroup, clientId);
        if (null == clientChannelInfo) {
            response.setCode(1);
            response.setRemark(String.format("The Consumer <%s> <%s> not online", consumerGroup, clientId));
            return response;
        }
        if (clientChannelInfo.getVersion() < MQVersion.Version.V3_1_8_SNAPSHOT.ordinal()) {
            response.setCode(1);
            response.setRemark(String.format("The Consumer <%s> Version <%s> too low to finish, please upgrade it to V3_1_8_SNAPSHOT", clientId, MQVersion.getVersionDesc((int)clientChannelInfo.getVersion())));
            return response;
        }
        try {
            RemotingCommand newRequest = RemotingCommand.createRequestCommand((int)requestCode, null);
            newRequest.setExtFields(request.getExtFields());
            newRequest.setBody(request.getBody());
            return this.brokerController.getBroker2Client().callClient(clientChannelInfo.getChannel(), newRequest);
        }
        catch (RemotingTimeoutException e) {
            response.setCode(207);
            response.setRemark(String.format("consumer <%s> <%s> Timeout: %s", consumerGroup, clientId, UtilAll.exceptionSimpleDesc((Throwable)e)));
            return response;
        }
        catch (Exception e) {
            response.setCode(1);
            response.setRemark(String.format("invoke consumer <%s> <%s> Exception: %s", consumerGroup, clientId, UtilAll.exceptionSimpleDesc((Throwable)e)));
            return response;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RemotingCommand queryConsumeQueue(ChannelHandlerContext ctx, RemotingCommand request) throws RemotingCommandException {
        ReferredIterator result;
        QueryConsumeQueueRequestHeader requestHeader = (QueryConsumeQueueRequestHeader)request.decodeCommandCustomHeader(QueryConsumeQueueRequestHeader.class);
        RemotingCommand response = RemotingCommand.createResponseCommand(null);
        ConsumeQueueInterface consumeQueue = this.brokerController.getMessageStore().getConsumeQueue(requestHeader.getTopic(), requestHeader.getQueueId());
        if (consumeQueue == null) {
            response.setCode(1);
            response.setRemark(String.format("%d@%s is not exist!", requestHeader.getQueueId(), requestHeader.getTopic()));
            return response;
        }
        response.setCode(0);
        QueryConsumeQueueResponseBody body = new QueryConsumeQueueResponseBody();
        body.setMaxQueueIndex(consumeQueue.getMaxOffsetInQueue());
        body.setMinQueueIndex(consumeQueue.getMinOffsetInQueue());
        ExpressionMessageFilter messageFilter = null;
        if (requestHeader.getConsumerGroup() != null) {
            SubscriptionData subscriptionData = this.brokerController.getConsumerManager().findSubscriptionData(requestHeader.getConsumerGroup(), requestHeader.getTopic());
            body.setSubscriptionData(subscriptionData);
            if (subscriptionData == null) {
                body.setFilterData(String.format("%s@%s is not online!", requestHeader.getConsumerGroup(), requestHeader.getTopic()));
            } else {
                ConsumerFilterData filterData = this.brokerController.getConsumerFilterManager().get(requestHeader.getTopic(), requestHeader.getConsumerGroup());
                body.setFilterData(JSON.toJSONString((Object)filterData, (boolean)true));
                messageFilter = new ExpressionMessageFilter(subscriptionData, filterData, this.brokerController.getConsumerFilterManager());
            }
        }
        if ((result = consumeQueue.iterateFrom(requestHeader.getIndex())) == null) {
            response.setRemark(String.format("Index %d of %d@%s is not exist!", requestHeader.getIndex(), requestHeader.getQueueId(), requestHeader.getTopic()));
            return response;
        }
        try {
            CqUnit cqUnit;
            ArrayList<ConsumeQueueData> queues = new ArrayList<ConsumeQueueData>();
            while (result.hasNext() && (cqUnit = (CqUnit)result.next()).getQueueOffset() - requestHeader.getIndex() < (long)requestHeader.getCount()) {
                ConsumeQueueData one = new ConsumeQueueData();
                one.setPhysicOffset(cqUnit.getPos());
                one.setPhysicSize(cqUnit.getSize());
                one.setTagsCode(cqUnit.getTagsCode());
                if (cqUnit.getCqExtUnit() == null && cqUnit.isTagsCodeValid()) {
                    queues.add(one);
                    continue;
                }
                if (cqUnit.getCqExtUnit() != null) {
                    ConsumeQueueExt.CqExtUnit cqExtUnit = cqUnit.getCqExtUnit();
                    one.setExtendDataJson(JSON.toJSONString((Object)cqExtUnit));
                    if (cqExtUnit.getFilterBitMap() != null) {
                        one.setBitMap(BitsArray.create((byte[])cqExtUnit.getFilterBitMap()).toString());
                    }
                    if (messageFilter != null) {
                        one.setEval(messageFilter.isMatchedByConsumeQueue(cqExtUnit.getTagsCode(), cqExtUnit));
                    }
                } else {
                    one.setMsg("Cq extend not exist!addr: " + one.getTagsCode());
                }
                queues.add(one);
            }
            body.setQueueData(queues);
        }
        finally {
            result.release();
        }
        response.setBody(body.encode());
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RemotingCommand resumeCheckHalfMessage(ChannelHandlerContext ctx, RemotingCommand request) throws RemotingCommandException {
        ResumeCheckHalfMessageRequestHeader requestHeader = (ResumeCheckHalfMessageRequestHeader)request.decodeCommandCustomHeader(ResumeCheckHalfMessageRequestHeader.class);
        RemotingCommand response = RemotingCommand.createResponseCommand(null);
        SelectMappedBufferResult selectMappedBufferResult = null;
        try {
            MessageId messageId = MessageDecoder.decodeMessageId((String)requestHeader.getMsgId());
            selectMappedBufferResult = this.brokerController.getMessageStore().selectOneMessageByOffset(messageId.getOffset());
            MessageExt msg = MessageDecoder.decode((ByteBuffer)selectMappedBufferResult.getByteBuffer());
            msg.putUserProperty("TRANSACTION_CHECK_TIMES", String.valueOf(0));
            PutMessageResult putMessageResult = this.brokerController.getMessageStore().putMessage(this.toMessageExtBrokerInner(msg));
            if (putMessageResult != null && putMessageResult.getPutMessageStatus() == PutMessageStatus.PUT_OK) {
                LOGGER.info("Put message back to RMQ_SYS_TRANS_HALF_TOPIC. real topic={}", (Object)msg.getUserProperty("REAL_TOPIC"));
                response.setCode(0);
                response.setRemark(null);
            } else {
                LOGGER.error("Put message back to RMQ_SYS_TRANS_HALF_TOPIC failed.");
                response.setCode(1);
                response.setRemark("Put message back to RMQ_SYS_TRANS_HALF_TOPIC failed.");
            }
        }
        catch (Exception e) {
            LOGGER.error("Exception was thrown when putting message back to RMQ_SYS_TRANS_HALF_TOPIC.");
            response.setCode(1);
            response.setRemark("Exception was thrown when putting message back to RMQ_SYS_TRANS_HALF_TOPIC.");
        }
        finally {
            if (selectMappedBufferResult != null) {
                selectMappedBufferResult.release();
            }
        }
        return response;
    }

    private MessageExtBrokerInner toMessageExtBrokerInner(MessageExt msgExt) {
        MessageExtBrokerInner inner = new MessageExtBrokerInner();
        inner.setTopic(TransactionalMessageUtil.buildHalfTopic());
        inner.setBody(msgExt.getBody());
        inner.setFlag(msgExt.getFlag());
        MessageAccessor.setProperties((Message)inner, (Map)msgExt.getProperties());
        inner.setPropertiesString(MessageDecoder.messageProperties2String((Map)msgExt.getProperties()));
        inner.setTagsCode(MessageExtBrokerInner.tagsString2tagsCode((String)msgExt.getTags()));
        inner.setQueueId(0);
        inner.setSysFlag(msgExt.getSysFlag());
        inner.setBornHost(msgExt.getBornHost());
        inner.setBornTimestamp(msgExt.getBornTimestamp());
        inner.setStoreHost(msgExt.getStoreHost());
        inner.setReconsumeTimes(msgExt.getReconsumeTimes());
        inner.setMsgId(msgExt.getMsgId());
        inner.setWaitStoreMsgOK(false);
        return inner;
    }

    private RemotingCommand getTopicConfig(ChannelHandlerContext ctx, RemotingCommand request) throws RemotingCommandException {
        GetTopicConfigRequestHeader requestHeader = (GetTopicConfigRequestHeader)request.decodeCommandCustomHeader(GetTopicConfigRequestHeader.class);
        RemotingCommand response = RemotingCommand.createResponseCommand(null);
        TopicConfig topicConfig = (TopicConfig)this.brokerController.getTopicConfigManager().getTopicConfigTable().get(requestHeader.getTopic());
        if (topicConfig == null) {
            LOGGER.error("No topic in this broker, client: {} topic: {}", (Object)ctx.channel().remoteAddress(), (Object)requestHeader.getTopic());
            response.setCode(17);
            response.setRemark("No topic in this broker. topic: " + requestHeader.getTopic());
            return response;
        }
        TopicQueueMappingDetail topicQueueMappingDetail = null;
        if (Boolean.TRUE.equals(requestHeader.getLo())) {
            topicQueueMappingDetail = this.brokerController.getTopicQueueMappingManager().getTopicQueueMapping(requestHeader.getTopic());
        }
        String content = JSONObject.toJSONString((Object)new TopicConfigAndQueueMapping(topicConfig, topicQueueMappingDetail));
        try {
            response.setBody(content.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            LOGGER.error("UnsupportedEncodingException getTopicConfig: topic=" + topicConfig.getTopicName(), (Throwable)e);
            response.setCode(1);
            response.setRemark("UnsupportedEncodingException " + e.getMessage());
            return response;
        }
        response.setCode(0);
        response.setRemark(null);
        return response;
    }

    private RemotingCommand notifyMinBrokerIdChange(ChannelHandlerContext ctx, RemotingCommand request) throws RemotingCommandException {
        NotifyMinBrokerIdChangeRequestHeader requestHeader = (NotifyMinBrokerIdChangeRequestHeader)request.decodeCommandCustomHeader(NotifyMinBrokerIdChangeRequestHeader.class);
        RemotingCommand response = RemotingCommand.createResponseCommand(null);
        LOGGER.warn("min broker id changed, prev {}, new {}", (Object)this.brokerController.getMinBrokerIdInGroup(), (Object)requestHeader.getMinBrokerId());
        this.brokerController.updateMinBroker(requestHeader.getMinBrokerId(), requestHeader.getMinBrokerAddr(), requestHeader.getOfflineBrokerAddr(), requestHeader.getHaBrokerAddr());
        response.setCode(0);
        response.setRemark(null);
        return response;
    }

    private RemotingCommand updateBrokerHaInfo(ChannelHandlerContext ctx, RemotingCommand request) throws RemotingCommandException {
        RemotingCommand response = RemotingCommand.createResponseCommand(ExchangeHAInfoResponseHeader.class);
        ExchangeHAInfoRequestHeader requestHeader = (ExchangeHAInfoRequestHeader)request.decodeCommandCustomHeader(ExchangeHAInfoRequestHeader.class);
        if (requestHeader.getMasterHaAddress() != null) {
            this.brokerController.getMessageStore().updateHaMasterAddress(requestHeader.getMasterHaAddress());
            this.brokerController.getMessageStore().updateMasterAddress(requestHeader.getMasterAddress());
            if (this.brokerController.getMessageStore().getMasterFlushedOffset() == 0L && this.brokerController.getMessageStoreConfig().isSyncMasterFlushOffsetWhenStartup()) {
                LOGGER.info("Set master flush offset in slave to {}", (Object)requestHeader.getMasterFlushOffset());
                this.brokerController.getMessageStore().setMasterFlushedOffset(requestHeader.getMasterFlushOffset().longValue());
            }
        } else if (this.brokerController.getBrokerConfig().getBrokerId() == 0L) {
            ExchangeHAInfoResponseHeader responseHeader = (ExchangeHAInfoResponseHeader)response.readCustomHeader();
            responseHeader.setMasterHaAddress(this.brokerController.getHAServerAddr());
            responseHeader.setMasterFlushOffset(Long.valueOf(this.brokerController.getMessageStore().getBrokerInitMaxOffset()));
            responseHeader.setMasterAddress(this.brokerController.getBrokerAddr());
        }
        response.setCode(0);
        response.setRemark(null);
        return response;
    }

    private RemotingCommand getBrokerHaStatus(ChannelHandlerContext ctx, RemotingCommand request) {
        RemotingCommand response = RemotingCommand.createResponseCommand(null);
        HARuntimeInfo runtimeInfo = this.brokerController.getMessageStore().getHARuntimeInfo();
        if (runtimeInfo != null) {
            byte[] body = runtimeInfo.encode();
            response.setBody(body);
            response.setCode(0);
            response.setRemark(null);
        } else {
            response.setCode(1);
            response.setRemark("Can not get HARuntimeInfo, may be duplicationEnable is true");
        }
        return response;
    }

    private RemotingCommand getBrokerEpochCache(ChannelHandlerContext ctx, RemotingCommand request) {
        ReplicasManager replicasManager = this.brokerController.getReplicasManager();
        assert (replicasManager != null);
        BrokerConfig brokerConfig = this.brokerController.getBrokerConfig();
        EpochEntryCache entryCache = new EpochEntryCache(brokerConfig.getBrokerClusterName(), brokerConfig.getBrokerName(), brokerConfig.getBrokerId(), replicasManager.getEpochEntries(), this.brokerController.getMessageStore().getMaxPhyOffset());
        RemotingCommand response = RemotingCommand.createResponseCommand(null);
        response.setBody(entryCache.encode());
        response.setCode(0);
        response.setRemark(null);
        return response;
    }

    private RemotingCommand resetMasterFlushOffset(ChannelHandlerContext ctx, RemotingCommand request) throws RemotingCommandException {
        ResetMasterFlushOffsetHeader requestHeader;
        RemotingCommand response = RemotingCommand.createResponseCommand(null);
        if (this.brokerController.getBrokerConfig().getBrokerId() != 0L && (requestHeader = (ResetMasterFlushOffsetHeader)request.decodeCommandCustomHeader(ResetMasterFlushOffsetHeader.class)).getMasterFlushOffset() != null) {
            this.brokerController.getMessageStore().setMasterFlushedOffset(requestHeader.getMasterFlushOffset().longValue());
        }
        response.setCode(0);
        response.setRemark(null);
        return response;
    }

    private RemotingCommand notifyBrokerRoleChanged(ChannelHandlerContext ctx, RemotingCommand request) throws RemotingCommandException {
        NotifyBrokerRoleChangedRequestHeader requestHeader = (NotifyBrokerRoleChangedRequestHeader)request.decodeCommandCustomHeader(NotifyBrokerRoleChangedRequestHeader.class);
        SyncStateSet syncStateSetInfo = (SyncStateSet)RemotingSerializable.decode((byte[])request.getBody(), SyncStateSet.class);
        RemotingCommand response = RemotingCommand.createResponseCommand(null);
        LOGGER.info("Receive notifyBrokerRoleChanged request, try to change brokerRole, request:{}", (Object)requestHeader);
        ReplicasManager replicasManager = this.brokerController.getReplicasManager();
        if (replicasManager != null) {
            replicasManager.changeBrokerRole(requestHeader.getMasterBrokerId(), requestHeader.getMasterAddress(), requestHeader.getMasterEpoch(), requestHeader.getSyncStateSetEpoch(), syncStateSetInfo.getSyncStateSet());
        }
        response.setCode(0);
        response.setRemark(null);
        return response;
    }

    private boolean validateSlave(RemotingCommand response) {
        if (this.brokerController.getMessageStoreConfig().getBrokerRole().equals((Object)BrokerRole.SLAVE)) {
            response.setCode(1);
            response.setRemark("Can't modify topic or subscription group from slave broker, please execute it from master broker.");
            return true;
        }
        return false;
    }
}

