/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.tieredstore;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.Scheduler;
import com.google.common.base.Stopwatch;
import com.google.common.collect.Sets;
import io.opentelemetry.api.common.Attributes;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.rocketmq.common.message.MessageQueue;
import org.apache.rocketmq.logging.org.slf4j.Logger;
import org.apache.rocketmq.logging.org.slf4j.LoggerFactory;
import org.apache.rocketmq.store.GetMessageResult;
import org.apache.rocketmq.store.GetMessageStatus;
import org.apache.rocketmq.store.MessageFilter;
import org.apache.rocketmq.store.QueryMessageResult;
import org.apache.rocketmq.store.SelectMappedBufferResult;
import org.apache.rocketmq.tieredstore.common.BoundaryType;
import org.apache.rocketmq.tieredstore.common.InflightRequestFuture;
import org.apache.rocketmq.tieredstore.common.MessageCacheKey;
import org.apache.rocketmq.tieredstore.common.SelectMappedBufferResultWrapper;
import org.apache.rocketmq.tieredstore.common.TieredMessageStoreConfig;
import org.apache.rocketmq.tieredstore.common.TieredStoreExecutor;
import org.apache.rocketmq.tieredstore.container.TieredContainerManager;
import org.apache.rocketmq.tieredstore.container.TieredIndexFile;
import org.apache.rocketmq.tieredstore.container.TieredMessageQueueContainer;
import org.apache.rocketmq.tieredstore.exception.TieredStoreErrorCode;
import org.apache.rocketmq.tieredstore.exception.TieredStoreException;
import org.apache.rocketmq.tieredstore.metadata.TieredMetadataStore;
import org.apache.rocketmq.tieredstore.metadata.TopicMetadata;
import org.apache.rocketmq.tieredstore.metrics.TieredStoreMetricsManager;
import org.apache.rocketmq.tieredstore.util.CQItemBufferUtil;
import org.apache.rocketmq.tieredstore.util.MessageBufferUtil;
import org.apache.rocketmq.tieredstore.util.TieredStoreUtil;

public class TieredMessageFetcher {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"RocketmqTieredStore");
    private final TieredMessageStoreConfig storeConfig;
    private final String brokerName;
    private TieredMetadataStore metadataStore;
    private final TieredContainerManager containerManager;
    protected final Cache<MessageCacheKey, SelectMappedBufferResultWrapper> readAheadCache;

    public TieredMessageFetcher(TieredMessageStoreConfig storeConfig) {
        this.storeConfig = storeConfig;
        this.brokerName = storeConfig.getBrokerName();
        this.containerManager = TieredContainerManager.getInstance(storeConfig);
        this.readAheadCache = Caffeine.newBuilder().scheduler(Scheduler.systemScheduler()).expireAfterWrite(storeConfig.getReadAheadCacheExpireDuration(), TimeUnit.MILLISECONDS).maximumWeight((long)((double)Runtime.getRuntime().maxMemory() * storeConfig.getReadAheadCacheSizeThresholdRate())).weigher((key, msg) -> msg.getDuplicateResult().getSize()).recordStats().build();
        try {
            this.metadataStore = TieredStoreUtil.getMetadataStore(storeConfig);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public Cache<MessageCacheKey, SelectMappedBufferResultWrapper> getReadAheadCache() {
        return this.readAheadCache;
    }

    public CompletableFuture<GetMessageResult> getMessageFromCacheAsync(TieredMessageQueueContainer container, String group, long queueOffset, int maxMsgNums) {
        return this.getMessageFromCacheAsync(container, group, queueOffset, maxMsgNums, true);
    }

    protected SelectMappedBufferResultWrapper putMessageToCache(TieredMessageQueueContainer container, long queueOffset, SelectMappedBufferResult msg, long minOffset, long maxOffset, int size) {
        return this.putMessageToCache(container, queueOffset, msg, minOffset, maxOffset, size, false);
    }

    protected SelectMappedBufferResultWrapper putMessageToCache(TieredMessageQueueContainer container, long queueOffset, SelectMappedBufferResult msg, long minOffset, long maxOffset, int size, boolean used) {
        SelectMappedBufferResultWrapper wrapper = new SelectMappedBufferResultWrapper(msg, queueOffset, minOffset, maxOffset, size);
        if (used) {
            wrapper.addAccessCount();
        }
        this.readAheadCache.put((Object)new MessageCacheKey(container, queueOffset), (Object)wrapper);
        return wrapper;
    }

    @Nullable
    protected SelectMappedBufferResultWrapper getMessageFromCache(TieredMessageQueueContainer container, long queueOffset) {
        MessageCacheKey cacheKey = new MessageCacheKey(container, queueOffset);
        return (SelectMappedBufferResultWrapper)this.readAheadCache.getIfPresent((Object)cacheKey);
    }

    protected void recordCacheAccess(TieredMessageQueueContainer container, String group, long queueOffset, List<SelectMappedBufferResultWrapper> resultWrapperList) {
        if (resultWrapperList.size() > 0) {
            queueOffset = resultWrapperList.get(resultWrapperList.size() - 1).getCurOffset();
        }
        container.recordGroupAccess(group, queueOffset);
        for (SelectMappedBufferResultWrapper wrapper : resultWrapperList) {
            wrapper.addAccessCount();
            if (wrapper.getAccessCount() < container.getActiveGroupCount()) continue;
            MessageCacheKey cacheKey = new MessageCacheKey(container, wrapper.getCurOffset());
            this.readAheadCache.invalidate((Object)cacheKey);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void preFetchMessage(TieredMessageQueueContainer container, String group, int maxMsgNums, long nextBeginOffset) {
        if (maxMsgNums == 1 || container.getReadAheadFactor() == 1) {
            return;
        }
        MessageQueue mq = container.getMessageQueue();
        int prefetchBatchSize = Math.min(maxMsgNums * container.getReadAheadFactor(), this.storeConfig.getReadAheadMessageCountThreshold());
        InflightRequestFuture inflightRequest = container.getInflightRequest(group, nextBeginOffset, prefetchBatchSize);
        if (!inflightRequest.isAllDone()) {
            return;
        }
        TieredMessageQueueContainer tieredMessageQueueContainer = container;
        synchronized (tieredMessageQueueContainer) {
            inflightRequest = container.getInflightRequest(nextBeginOffset, maxMsgNums);
            if (!inflightRequest.isAllDone()) {
                return;
            }
            long maxOffsetOfLastRequest = inflightRequest.getLastFuture().join();
            boolean lastRequestIsExpired = this.getMessageFromCache(container, nextBeginOffset) == null;
            int cacheRemainCount = (int)(maxOffsetOfLastRequest - nextBeginOffset);
            LOGGER.debug("TieredMessageFetcher#preFetchMessage: group={}, nextBeginOffset={}, maxOffsetOfLastRequest={}, lastRequestIsExpired={}, cacheRemainCount={}", new Object[]{group, nextBeginOffset, maxOffsetOfLastRequest, lastRequestIsExpired, cacheRemainCount});
            if (lastRequestIsExpired || maxOffsetOfLastRequest != -1L && nextBeginOffset >= inflightRequest.getStartOffset()) {
                long queueOffset;
                if (lastRequestIsExpired) {
                    queueOffset = nextBeginOffset;
                    container.decreaseReadAheadFactor();
                } else {
                    queueOffset = maxOffsetOfLastRequest + 1L;
                    container.increaseReadAheadFactor();
                }
                int factor = Math.min(container.getReadAheadFactor(), this.storeConfig.getReadAheadMessageCountThreshold() / maxMsgNums);
                int flag = 0;
                int concurrency = 1;
                if (factor > this.storeConfig.getReadAheadBatchSizeFactorThreshold()) {
                    flag = factor % this.storeConfig.getReadAheadBatchSizeFactorThreshold() == 0 ? 0 : 1;
                    concurrency = factor / this.storeConfig.getReadAheadBatchSizeFactorThreshold() + flag;
                }
                int requestBatchSize = maxMsgNums * Math.min(factor, this.storeConfig.getReadAheadBatchSizeFactorThreshold());
                ArrayList<Pair<Integer, CompletableFuture<Long>>> futureList = new ArrayList<Pair<Integer, CompletableFuture<Long>>>();
                long nextQueueOffset = queueOffset;
                if (flag == 1) {
                    int firstBatchSize = factor % this.storeConfig.getReadAheadBatchSizeFactorThreshold() * maxMsgNums;
                    CompletableFuture<Long> future = this.prefetchAndPutMsgToCache(container, mq, nextQueueOffset, firstBatchSize);
                    futureList.add((Pair<Integer, CompletableFuture<Long>>)Pair.of((Object)firstBatchSize, future));
                    nextQueueOffset += (long)firstBatchSize;
                }
                for (long i = 0L; i < (long)(concurrency - flag); ++i) {
                    CompletableFuture<Long> future = this.prefetchAndPutMsgToCache(container, mq, nextQueueOffset + i * (long)requestBatchSize, requestBatchSize);
                    futureList.add((Pair<Integer, CompletableFuture<Long>>)Pair.of((Object)requestBatchSize, future));
                }
                container.putInflightRequest(group, queueOffset, maxMsgNums * factor, futureList);
                LOGGER.debug("TieredMessageFetcher#preFetchMessage: try to prefetch messages for later requests: next begin offset: {}, request offset: {}, factor: {}, flag: {}, request batch: {}, concurrency: {}", new Object[]{nextBeginOffset, queueOffset, factor, flag, requestBatchSize, concurrency});
            }
        }
    }

    private CompletableFuture<Long> prefetchAndPutMsgToCache(TieredMessageQueueContainer container, MessageQueue mq, long queueOffset, int batchSize) {
        return this.getMessageFromTieredStoreAsync(container, queueOffset, batchSize).thenApplyAsync(result -> {
            if (result.getStatus() != GetMessageStatus.FOUND) {
                LOGGER.warn("TieredMessageFetcher#prefetchAndPutMsgToCache: read ahead failed: topic: {}, queue: {}, queue offset: {}, batch size: {}, result: {}", new Object[]{mq.getTopic(), mq.getQueueId(), queueOffset, batchSize, result.getStatus()});
                return -1L;
            }
            List offsetList = result.getMessageQueueOffset();
            List msgList = result.getMessageMapedList();
            if (offsetList.size() != msgList.size()) {
                LOGGER.error("TieredMessageFetcher#prefetchAndPutMsgToCache: read ahead failed, result is illegal: topic: {}, queue: {}, queue offset: {}, batch size: {}, offsetList size: {}, msgList size: {}", new Object[]{mq.getTopic(), mq.getQueueId(), queueOffset, batchSize, offsetList.size(), msgList.size()});
                return -1L;
            }
            if (offsetList.isEmpty()) {
                LOGGER.error("TieredMessageFetcher#prefetchAndPutMsgToCache: read ahead failed, result is FOUND but msgList is empty: topic: {}, queue: {}, queue offset: {}, batch size: {}", new Object[]{mq.getTopic(), mq.getQueueId(), queueOffset, batchSize});
                return -1L;
            }
            Long minOffset = (Long)offsetList.get(0);
            Long maxOffset = (Long)offsetList.get(offsetList.size() - 1);
            int size = offsetList.size();
            for (int n = 0; n < offsetList.size(); ++n) {
                this.putMessageToCache(container, (Long)offsetList.get(n), (SelectMappedBufferResult)msgList.get(n), minOffset, maxOffset, size);
            }
            if (size != batchSize || maxOffset != queueOffset + (long)batchSize - 1L) {
                LOGGER.warn("TieredMessageFetcher#prefetchAndPutMsgToCache: size not match: except: {}, actual: {}, queue offset: {}, min offset: {}, except offset: {}, max offset: {}", new Object[]{batchSize, size, queueOffset, minOffset, queueOffset + (long)batchSize - 1L, maxOffset});
            }
            return maxOffset;
        }, (Executor)TieredStoreExecutor.fetchDataExecutor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CompletableFuture<GetMessageResult> getMessageFromCacheAsync(TieredMessageQueueContainer container, String group, long queueOffset, int maxMsgNums, boolean waitInflightRequest) {
        CompletionStage resultFuture;
        CompletableFuture<Long> future;
        SelectMappedBufferResultWrapper wrapper2;
        int i;
        MessageQueue mq = container.getMessageQueue();
        long lastGetOffset = queueOffset - 1L;
        ArrayList<SelectMappedBufferResultWrapper> resultWrapperList = new ArrayList<SelectMappedBufferResultWrapper>(maxMsgNums);
        for (i = 0; i < maxMsgNums; ++i) {
            if ((wrapper2 = this.getMessageFromCache(container, ++lastGetOffset)) == null) {
                --lastGetOffset;
                break;
            }
            resultWrapperList.add(wrapper2);
        }
        if (waitInflightRequest) {
            Attributes attributes = TieredStoreMetricsManager.newAttributesBuilder().put("topic", mq.getTopic()).put("group", group).build();
            TieredStoreMetricsManager.cacheAccess.add((long)maxMsgNums, attributes);
            TieredStoreMetricsManager.cacheHit.add((long)resultWrapperList.size(), attributes);
        }
        if (resultWrapperList.isEmpty() && waitInflightRequest && !(future = container.getInflightRequest(group, queueOffset, maxMsgNums).getFuture(queueOffset)).isDone()) {
            Stopwatch stopwatch = Stopwatch.createStarted();
            return future.thenCompose(v -> {
                LOGGER.debug("TieredMessageFetcher#getMessageFromCacheAsync: wait for inflight request cost: {}ms", (Object)stopwatch.elapsed(TimeUnit.MILLISECONDS));
                return this.getMessageFromCacheAsync(container, group, queueOffset, maxMsgNums, false);
            });
        }
        for (i = 0; i < maxMsgNums - resultWrapperList.size(); ++i) {
            if ((wrapper2 = this.getMessageFromCache(container, ++lastGetOffset)) == null) {
                --lastGetOffset;
                break;
            }
            resultWrapperList.add(wrapper2);
        }
        this.recordCacheAccess(container, group, queueOffset, resultWrapperList);
        if (!resultWrapperList.isEmpty()) {
            LOGGER.debug("TieredMessageFetcher#getMessageFromCacheAsync: cache hit: topic: {}, queue: {}, queue offset: {}, max message num: {}, cache hit num: {}", new Object[]{mq.getTopic(), mq.getQueueId(), queueOffset, maxMsgNums, resultWrapperList.size()});
            this.preFetchMessage(container, group, maxMsgNums, lastGetOffset + 1L);
            GetMessageResult result2 = new GetMessageResult();
            result2.setStatus(GetMessageStatus.FOUND);
            result2.setMinOffset(container.getConsumeQueueMinOffset());
            result2.setMaxOffset(container.getConsumeQueueCommitOffset());
            result2.setNextBeginOffset(queueOffset + (long)resultWrapperList.size());
            resultWrapperList.forEach(wrapper -> result2.addMessage(wrapper.getDuplicateResult(), wrapper.getCurOffset()));
            return CompletableFuture.completedFuture(result2);
        }
        LOGGER.warn("TieredMessageFetcher#getMessageFromCacheAsync: cache miss: topic: {}, queue: {}, queue offset: {}, max message num: {}", new Object[]{mq.getTopic(), mq.getQueueId(), queueOffset, maxMsgNums});
        TieredMessageQueueContainer tieredMessageQueueContainer = container;
        synchronized (tieredMessageQueueContainer) {
            int batchSize = maxMsgNums * this.storeConfig.getReadAheadMinFactor();
            resultFuture = this.getMessageFromTieredStoreAsync(container, queueOffset, batchSize).thenApplyAsync(result -> {
                if (result.getStatus() != GetMessageStatus.FOUND) {
                    return result;
                }
                GetMessageResult newResult = new GetMessageResult();
                newResult.setStatus(GetMessageStatus.FOUND);
                newResult.setMinOffset(container.getConsumeQueueMinOffset());
                newResult.setMaxOffset(container.getConsumeQueueCommitOffset());
                List offsetList = result.getMessageQueueOffset();
                List msgList = result.getMessageMapedList();
                Long minOffset = (Long)offsetList.get(0);
                Long maxOffset = (Long)offsetList.get(offsetList.size() - 1);
                int size = offsetList.size();
                for (int i = 0; i < offsetList.size(); ++i) {
                    Long offset = (Long)offsetList.get(i);
                    SelectMappedBufferResult msg = (SelectMappedBufferResult)msgList.get(i);
                    SelectMappedBufferResultWrapper resultWrapper = this.putMessageToCache(container, offset, msg, minOffset, maxOffset, size, true);
                    if (newResult.getMessageMapedList().size() >= maxMsgNums) continue;
                    newResult.addMessage(resultWrapper.getDuplicateResult(), offset.longValue());
                }
                newResult.setNextBeginOffset(queueOffset + (long)newResult.getMessageMapedList().size());
                return newResult;
            }, (Executor)TieredStoreExecutor.fetchDataExecutor);
            ArrayList<Pair<Integer, CompletableFuture<Long>>> futureList = new ArrayList<Pair<Integer, CompletableFuture<Long>>>();
            CompletionStage inflightRequestFuture = ((CompletableFuture)resultFuture).thenApply(result -> result.getStatus() == GetMessageStatus.FOUND ? (Long)result.getMessageQueueOffset().get(result.getMessageQueueOffset().size() - 1) : Long.valueOf(-1L));
            futureList.add(Pair.of((Object)batchSize, (Object)inflightRequestFuture));
            container.putInflightRequest(group, queueOffset, batchSize, futureList);
        }
        return resultFuture;
    }

    public CompletableFuture<GetMessageResult> getMessageFromTieredStoreAsync(TieredMessageQueueContainer container, long queueOffset, int batchSize) {
        CompletableFuture<ByteBuffer> readConsumeQueueFuture;
        GetMessageResult result = new GetMessageResult();
        result.setMinOffset(container.getConsumeQueueMinOffset());
        result.setMaxOffset(container.getConsumeQueueCommitOffset());
        try {
            readConsumeQueueFuture = container.readConsumeQueue(queueOffset, batchSize);
        }
        catch (TieredStoreException e2) {
            switch (e2.getErrorCode()) {
                case NO_NEW_DATA: {
                    result.setStatus(GetMessageStatus.OFFSET_OVERFLOW_ONE);
                    result.setNextBeginOffset(queueOffset);
                    return CompletableFuture.completedFuture(result);
                }
            }
            result.setStatus(GetMessageStatus.OFFSET_FOUND_NULL);
            result.setNextBeginOffset(queueOffset);
            return CompletableFuture.completedFuture(result);
        }
        CompletionStage readCommitLogFuture = readConsumeQueueFuture.thenComposeAsync(cqBuffer -> {
            long length;
            long firstCommitLogOffset = CQItemBufferUtil.getCommitLogOffset(cqBuffer);
            cqBuffer.position(cqBuffer.remaining() - 20);
            long lastCommitLogOffset = CQItemBufferUtil.getCommitLogOffset(cqBuffer);
            if (lastCommitLogOffset < firstCommitLogOffset) {
                MessageQueue mq = container.getMessageQueue();
                LOGGER.error("TieredMessageFetcher#getMessageFromTieredStoreAsync: message is not in order, try to fetch data in next store, topic: {}, queueId: {}, batch size: {}, queue offset {}", new Object[]{mq.getTopic(), mq.getQueueId(), batchSize, queueOffset});
                throw new TieredStoreException(TieredStoreErrorCode.ILLEGAL_OFFSET, "message is not in order");
            }
            long originLength = length = lastCommitLogOffset - firstCommitLogOffset + (long)CQItemBufferUtil.getSize(cqBuffer);
            while (cqBuffer.limit() > 20 && length > (long)this.storeConfig.getReadAheadMessageSizeThreshold()) {
                cqBuffer.limit(cqBuffer.position());
                cqBuffer.position(cqBuffer.limit() - 20);
                length = CQItemBufferUtil.getCommitLogOffset(cqBuffer) - firstCommitLogOffset + (long)CQItemBufferUtil.getSize(cqBuffer);
            }
            if (originLength != length) {
                MessageQueue mq = container.getMessageQueue();
                LOGGER.info("TieredMessageFetcher#getMessageFromTieredStoreAsync: msg data is too large, topic: {}, queueId: {}, batch size: {}, fix it from {} to {}", new Object[]{mq.getTopic(), mq.getQueueId(), batchSize, originLength, length});
            }
            return container.readCommitLog(firstCommitLogOffset, (int)length);
        }, (Executor)TieredStoreExecutor.fetchDataExecutor);
        return ((CompletableFuture)readConsumeQueueFuture.thenCombineAsync(readCommitLogFuture, (cqBuffer, msgBuffer) -> {
            List<Pair<Integer, Integer>> msgList = MessageBufferUtil.splitMessageBuffer(cqBuffer, msgBuffer);
            if (!msgList.isEmpty()) {
                int requestSize = cqBuffer.remaining() / 20;
                result.setStatus(GetMessageStatus.FOUND);
                result.setNextBeginOffset(queueOffset + (long)msgList.size());
                msgList.forEach(pair -> {
                    msgBuffer.position((Integer)pair.getLeft());
                    ByteBuffer slice = msgBuffer.slice();
                    slice.limit((Integer)pair.getRight());
                    result.addMessage(new SelectMappedBufferResult((long)((Integer)pair.getLeft()).intValue(), slice, ((Integer)pair.getRight()).intValue(), null), MessageBufferUtil.getQueueOffset(slice));
                });
                if (requestSize != msgList.size()) {
                    HashSet<Long> requestOffsetSet = new HashSet<Long>();
                    for (int i = 0; i < requestSize; ++i) {
                        requestOffsetSet.add(queueOffset + (long)i);
                    }
                    LOGGER.error("TieredMessageFetcher#getMessageFromTieredStoreAsync: split message buffer failed, batch size: {}, request message count: {}, actual message count: {}, these messages may lost: {}", new Object[]{batchSize, requestSize, msgList.size(), Sets.difference(requestOffsetSet, (Set)Sets.newHashSet((Iterable)result.getMessageQueueOffset()))});
                } else if (requestSize != batchSize) {
                    LOGGER.debug("TieredMessageFetcher#getMessageFromTieredStoreAsync: message count does not meet batch size, maybe dispatch delay: batch size: {}, request message count: {}", (Object)batchSize, (Object)requestSize);
                }
                return result;
            }
            long nextBeginOffset = queueOffset + (long)(cqBuffer.remaining() / 20);
            LOGGER.error("TieredMessageFetcher#getMessageFromTieredStoreAsync: split message buffer failed, consume queue buffer size: {}, message buffer size: {}, change offset from {} to {}", new Object[]{cqBuffer.remaining(), msgBuffer.remaining(), queueOffset, nextBeginOffset});
            result.setStatus(GetMessageStatus.MESSAGE_WAS_REMOVING);
            result.setNextBeginOffset(nextBeginOffset);
            return result;
        }, (Executor)TieredStoreExecutor.fetchDataExecutor)).exceptionally(e -> {
            MessageQueue mq = container.getMessageQueue();
            LOGGER.warn("TieredMessageFetcher#getMessageFromTieredStoreAsync: get message failed: topic: {} queueId: {}", new Object[]{mq.getTopic(), mq.getQueueId(), e});
            result.setStatus(GetMessageStatus.OFFSET_FOUND_NULL);
            result.setNextBeginOffset(queueOffset);
            return result;
        });
    }

    public CompletableFuture<GetMessageResult> getMessageAsync(String group, String topic, int queueId, long queueOffset, int maxMsgNums, MessageFilter messageFilter) {
        TieredMessageQueueContainer container = this.containerManager.getMQContainer(new MessageQueue(topic, this.brokerName, queueId));
        if (container == null) {
            GetMessageResult result = new GetMessageResult();
            result.setNextBeginOffset(queueOffset);
            result.setStatus(GetMessageStatus.NO_MATCHED_LOGIC_QUEUE);
            return CompletableFuture.completedFuture(result);
        }
        GetMessageResult result = new GetMessageResult();
        long minQueueOffset = container.getConsumeQueueMinOffset();
        result.setMinOffset(minQueueOffset);
        long maxQueueOffset = container.getConsumeQueueCommitOffset();
        result.setMaxOffset(maxQueueOffset);
        if (container.getConsumeQueueCommitOffset() <= 0L) {
            result.setStatus(GetMessageStatus.NO_MESSAGE_IN_QUEUE);
            result.setNextBeginOffset(queueOffset);
            return CompletableFuture.completedFuture(result);
        }
        if (queueOffset < minQueueOffset) {
            result.setStatus(GetMessageStatus.OFFSET_TOO_SMALL);
            result.setNextBeginOffset(container.getConsumeQueueMinOffset());
            return CompletableFuture.completedFuture(result);
        }
        if (queueOffset == maxQueueOffset) {
            result.setStatus(GetMessageStatus.OFFSET_OVERFLOW_ONE);
            result.setNextBeginOffset(container.getConsumeQueueCommitOffset());
            return CompletableFuture.completedFuture(result);
        }
        if (queueOffset > maxQueueOffset) {
            result.setStatus(GetMessageStatus.OFFSET_OVERFLOW_BADLY);
            result.setNextBeginOffset(container.getConsumeQueueCommitOffset());
            return CompletableFuture.completedFuture(result);
        }
        return this.getMessageFromCacheAsync(container, group, queueOffset, maxMsgNums);
    }

    public CompletableFuture<Long> getEarliestMessageTimeAsync(String topic, int queueId) {
        TieredMessageQueueContainer container = this.containerManager.getMQContainer(new MessageQueue(topic, this.brokerName, queueId));
        if (container == null) {
            return CompletableFuture.completedFuture(-1L);
        }
        return container.readCommitLog(container.getCommitLogMinOffset(), 64).thenApply(MessageBufferUtil::getStoreTimeStamp);
    }

    public CompletableFuture<Long> getMessageStoreTimeStampAsync(String topic, int queueId, long queueOffset) {
        TieredMessageQueueContainer container = this.containerManager.getMQContainer(new MessageQueue(topic, this.brokerName, queueId));
        if (container == null) {
            return CompletableFuture.completedFuture(-1L);
        }
        return ((CompletableFuture)((CompletableFuture)container.readConsumeQueue(queueOffset).thenComposeAsync(cqItem -> {
            long commitLogOffset = CQItemBufferUtil.getCommitLogOffset(cqItem);
            int size = CQItemBufferUtil.getSize(cqItem);
            return container.readCommitLog(commitLogOffset, size);
        }, (Executor)TieredStoreExecutor.fetchDataExecutor)).thenApply(MessageBufferUtil::getStoreTimeStamp)).exceptionally(e -> {
            LOGGER.error("TieredMessageFetcher#getMessageStoreTimeStampAsync: get or decode message failed: topic: {}, queue: {}, offset: {}", new Object[]{topic, queueId, queueOffset, e});
            return -1L;
        });
    }

    public long getOffsetInQueueByTime(String topic, int queueId, long timestamp, BoundaryType type) {
        TieredMessageQueueContainer container = this.containerManager.getMQContainer(new MessageQueue(topic, this.brokerName, queueId));
        if (container == null) {
            return -1L;
        }
        try {
            return container.binarySearchInQueueByTime(timestamp, type);
        }
        catch (Exception e) {
            LOGGER.error("TieredMessageFetcher#getOffsetInQueueByTime: get offset in queue by time failed: topic: {}, queue: {}, timestamp: {}, type: {}", new Object[]{topic, queueId, timestamp, type, e});
            return -1L;
        }
    }

    public CompletableFuture<QueryMessageResult> queryMessageAsync(String topic, String key, int maxNum, long begin, long end) {
        int topicId;
        TieredIndexFile indexFile = TieredContainerManager.getIndexFile(this.storeConfig);
        int hashCode = TieredIndexFile.indexKeyHashMethod(TieredIndexFile.buildKey(topic, key));
        try {
            TopicMetadata topicMetadata = this.metadataStore.getTopic(topic);
            if (topicMetadata == null) {
                LOGGER.info("TieredMessageFetcher#queryMessageAsync: get topic id from metadata failed, topic metadata not found: topic: {}", (Object)topic);
                return CompletableFuture.completedFuture(new QueryMessageResult());
            }
            topicId = topicMetadata.getTopicId();
        }
        catch (Exception e) {
            LOGGER.error("TieredMessageFetcher#queryMessageAsync: get topic id from metadata failed: topic: {}", (Object)topic, (Object)e);
            return CompletableFuture.completedFuture(new QueryMessageResult());
        }
        return indexFile.queryAsync(topic, key, begin, end).thenCompose(indexBufferList -> {
            QueryMessageResult result = new QueryMessageResult();
            int resultCount = 0;
            ArrayList<CompletionStage> futureList = new ArrayList<CompletionStage>(maxNum);
            for (Pair pair : indexBufferList) {
                Long fileBeginTimestamp = (Long)pair.getKey();
                ByteBuffer indexBuffer = (ByteBuffer)pair.getValue();
                if (indexBuffer.remaining() % 28 != 0) {
                    LOGGER.error("[Bug]TieredMessageFetcher#queryMessageAsync: index buffer size {} is not multiple of index item size {}", (Object)indexBuffer.remaining(), (Object)28);
                    continue;
                }
                for (int indexOffset = indexBuffer.position(); indexOffset < indexBuffer.limit(); indexOffset += 28) {
                    int indexItemTopicId;
                    int indexItemHashCode = indexBuffer.getInt(indexOffset);
                    if (indexItemHashCode != hashCode || (indexItemTopicId = indexBuffer.getInt(indexOffset + 4)) != topicId) continue;
                    int queueId = indexBuffer.getInt(indexOffset + 4 + 4);
                    TieredMessageQueueContainer container = TieredContainerManager.getInstance(this.storeConfig).getMQContainer(new MessageQueue(topic, this.brokerName, queueId));
                    if (container == null) continue;
                    long offset = indexBuffer.getLong(indexOffset + 4 + 4 + 4);
                    int size = indexBuffer.getInt(indexOffset + 4 + 4 + 4 + 8);
                    int timeDiff = indexBuffer.getInt(indexOffset + 4 + 4 + 4 + 8 + 4);
                    long indexTimestamp = fileBeginTimestamp + (long)timeDiff;
                    if (indexTimestamp < begin || indexTimestamp > end) continue;
                    CompletionStage getMessageFuture = container.readCommitLog(offset, size).thenAccept(messageBuffer -> result.addMessage(new SelectMappedBufferResult(0L, messageBuffer, size, null)));
                    futureList.add(getMessageFuture);
                    if (++resultCount >= maxNum) break;
                }
                if (resultCount < maxNum) continue;
                break;
            }
            return CompletableFuture.allOf(futureList.toArray(new CompletableFuture[0])).thenApply(v -> result);
        });
    }
}

