/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.proxy.service.metadata;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.Optional;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.rocketmq.common.attribute.TopicMessageType;
import org.apache.rocketmq.common.protocol.route.BrokerData;
import org.apache.rocketmq.common.statictopic.TopicConfigAndQueueMapping;
import org.apache.rocketmq.common.subscription.SubscriptionGroupConfig;
import org.apache.rocketmq.common.thread.ThreadPoolMonitor;
import org.apache.rocketmq.logging.InternalLogger;
import org.apache.rocketmq.logging.InternalLoggerFactory;
import org.apache.rocketmq.proxy.common.AbstractCacheLoader;
import org.apache.rocketmq.proxy.common.AbstractStartAndShutdown;
import org.apache.rocketmq.proxy.config.ConfigurationManager;
import org.apache.rocketmq.proxy.config.ProxyConfig;
import org.apache.rocketmq.proxy.service.metadata.MetadataService;
import org.apache.rocketmq.proxy.service.mqclient.MQClientAPIFactory;
import org.apache.rocketmq.proxy.service.route.TopicRouteHelper;
import org.apache.rocketmq.proxy.service.route.TopicRouteService;

public class ClusterMetadataService
extends AbstractStartAndShutdown
implements MetadataService {
    protected static final InternalLogger log = InternalLoggerFactory.getLogger((String)"RocketmqProxy");
    private static final long DEFAULT_TIMEOUT = 3000L;
    private final TopicRouteService topicRouteService;
    private final MQClientAPIFactory mqClientAPIFactory;
    protected final ThreadPoolExecutor cacheRefreshExecutor;
    protected final LoadingCache<String, TopicConfigAndQueueMapping> topicConfigCache;
    protected static final TopicConfigAndQueueMapping EMPTY_TOPIC_CONFIG = new TopicConfigAndQueueMapping();
    protected final LoadingCache<String, SubscriptionGroupConfig> subscriptionGroupConfigCache;
    protected static final SubscriptionGroupConfig EMPTY_SUBSCRIPTION_GROUP_CONFIG = new SubscriptionGroupConfig();

    public ClusterMetadataService(TopicRouteService topicRouteService, MQClientAPIFactory mqClientAPIFactory) {
        this.topicRouteService = topicRouteService;
        this.mqClientAPIFactory = mqClientAPIFactory;
        ProxyConfig config = ConfigurationManager.getProxyConfig();
        this.cacheRefreshExecutor = ThreadPoolMonitor.createAndMonitor((int)config.getMetadataThreadPoolNums(), (int)config.getMetadataThreadPoolNums(), (long)60000L, (TimeUnit)TimeUnit.MILLISECONDS, (String)"MetadataCacheRefresh", (int)config.getMetadataThreadPoolQueueCapacity());
        this.topicConfigCache = CacheBuilder.newBuilder().maximumSize((long)config.getTopicConfigCacheMaxNum()).refreshAfterWrite((long)config.getTopicConfigCacheExpiredInSeconds(), TimeUnit.SECONDS).build((CacheLoader)new ClusterTopicConfigCacheLoader());
        this.subscriptionGroupConfigCache = CacheBuilder.newBuilder().maximumSize((long)config.getSubscriptionGroupConfigCacheMaxNum()).refreshAfterWrite((long)config.getSubscriptionGroupConfigCacheExpiredInSeconds(), TimeUnit.SECONDS).build((CacheLoader)new ClusterSubscriptionGroupConfigCacheLoader());
        this.init();
    }

    protected void init() {
        this.appendShutdown(this.cacheRefreshExecutor::shutdown);
    }

    @Override
    public TopicMessageType getTopicMessageType(String topic) {
        TopicConfigAndQueueMapping topicConfigAndQueueMapping;
        try {
            topicConfigAndQueueMapping = (TopicConfigAndQueueMapping)this.topicConfigCache.get((Object)topic);
        }
        catch (Exception e) {
            return TopicMessageType.UNSPECIFIED;
        }
        if (topicConfigAndQueueMapping.equals((Object)EMPTY_TOPIC_CONFIG)) {
            return TopicMessageType.UNSPECIFIED;
        }
        return topicConfigAndQueueMapping.getTopicMessageType();
    }

    @Override
    public SubscriptionGroupConfig getSubscriptionGroupConfig(String group) {
        SubscriptionGroupConfig config;
        try {
            config = (SubscriptionGroupConfig)this.subscriptionGroupConfigCache.get((Object)group);
        }
        catch (Exception e) {
            return null;
        }
        if (config == EMPTY_SUBSCRIPTION_GROUP_CONFIG) {
            return null;
        }
        return config;
    }

    protected Optional<BrokerData> findOneBroker(String topic) throws Exception {
        try {
            return this.topicRouteService.getAllMessageQueueView(topic).getTopicRouteData().getBrokerDatas().stream().findAny();
        }
        catch (Exception e) {
            if (TopicRouteHelper.isTopicNotExistError(e)) {
                return Optional.empty();
            }
            throw e;
        }
    }

    protected class ClusterTopicConfigCacheLoader
    extends AbstractCacheLoader<String, TopicConfigAndQueueMapping> {
        public ClusterTopicConfigCacheLoader() {
            super(ClusterMetadataService.this.cacheRefreshExecutor);
        }

        @Override
        protected TopicConfigAndQueueMapping getDirectly(String topic) throws Exception {
            Optional<BrokerData> brokerDataOptional = ClusterMetadataService.this.findOneBroker(topic);
            if (brokerDataOptional.isPresent()) {
                String brokerAddress = brokerDataOptional.get().selectBrokerAddr();
                return ClusterMetadataService.this.mqClientAPIFactory.getClient().getTopicConfig(brokerAddress, topic, 3000L);
            }
            return EMPTY_TOPIC_CONFIG;
        }

        @Override
        protected void onErr(String key, Exception e) {
            log.error("load topic config failed. topic:{}", (Object)key, (Object)e);
        }
    }

    protected class ClusterSubscriptionGroupConfigCacheLoader
    extends AbstractCacheLoader<String, SubscriptionGroupConfig> {
        public ClusterSubscriptionGroupConfigCacheLoader() {
            super(ClusterMetadataService.this.cacheRefreshExecutor);
        }

        @Override
        protected SubscriptionGroupConfig getDirectly(String consumerGroup) throws Exception {
            ProxyConfig config = ConfigurationManager.getProxyConfig();
            String clusterName = config.getRocketMQClusterName();
            Optional<BrokerData> brokerDataOptional = ClusterMetadataService.this.findOneBroker(clusterName);
            if (brokerDataOptional.isPresent()) {
                String brokerAddress = brokerDataOptional.get().selectBrokerAddr();
                return ClusterMetadataService.this.mqClientAPIFactory.getClient().getSubscriptionGroupConfig(brokerAddress, consumerGroup, 3000L);
            }
            return EMPTY_SUBSCRIPTION_GROUP_CONFIG;
        }

        @Override
        protected void onErr(String consumerGroup, Exception e) {
            log.error("load subscription config failed. consumerGroup:{}", (Object)consumerGroup, (Object)e);
        }
    }
}

