/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

// Code generated by code-generation. DO NOT EDIT.
using org.apache.plc4net.types;

namespace org.apache.plc4net.drivers.knxnetip.readwrite.model
{

    public enum AccessLevel
    {
        Level0 = 0x0,
        Level1 = 0x1,
        Level2 = 0x2,
        Level3 = 0x3,
        Level15 = 0xF,
    }

    public static class AccessLevelInfo
    {

        public static string Purpose(this AccessLevel value)
        {
            switch (value)
            {
                case AccessLevel.Level0: { /* '0x0' */
                    return "system manufacturer";
                }
                case AccessLevel.Level1: { /* '0x1' */
                    return "product manufacturer";
                }
                case AccessLevel.Level2: { /* '0x2' */
                    return "configuration";
                }
                case AccessLevel.Level3: { /* '0x3' */
                    return "end-user";
                }
                case AccessLevel.Level15: { /* '0xF' */
                    return "read access";
                }
                default: {
                    return null;
                }
            }
        }

        public static bool? NeedsAuthentication(this AccessLevel value)
        {
            switch (value)
            {
                case AccessLevel.Level0: { /* '0x0' */
                    return true;
                }
                case AccessLevel.Level1: { /* '0x1' */
                    return true;
                }
                case AccessLevel.Level2: { /* '0x2' */
                    return true;
                }
                case AccessLevel.Level3: { /* '0x3' */
                    return false;
                }
                case AccessLevel.Level15: { /* '0xF' */
                    return false;
                }
                default: {
                    return false;
                }
            }
        }
    }

}

