/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.profinet.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class TlvOrganizationSpecific extends LldpUnit implements Message {

  // Accessors for discriminator values.
  public TlvType getTlvId() {
    return TlvType.ORGANIZATION_SPECIFIC;
  }

  // Properties.
  protected final TlvOrganizationSpecificUnit organizationSpecificUnit;

  public TlvOrganizationSpecific(
      short tlvIdLength, TlvOrganizationSpecificUnit organizationSpecificUnit) {
    super(tlvIdLength);
    this.organizationSpecificUnit = organizationSpecificUnit;
  }

  public TlvOrganizationSpecificUnit getOrganizationSpecificUnit() {
    return organizationSpecificUnit;
  }

  @Override
  protected void serializeLldpUnitChild(WriteBuffer writeBuffer) throws SerializationException {
    PositionAware positionAware = writeBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
    writeBuffer.pushContext("TlvOrganizationSpecific");

    // Simple Field (organizationSpecificUnit)
    writeSimpleField(
        "organizationSpecificUnit", organizationSpecificUnit, writeComplex(writeBuffer));

    writeBuffer.popContext("TlvOrganizationSpecific");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = super.getLengthInBits();
    TlvOrganizationSpecific _value = this;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    // Simple field (organizationSpecificUnit)
    lengthInBits += organizationSpecificUnit.getLengthInBits();

    return lengthInBits;
  }

  public static LldpUnitBuilder staticParseLldpUnitBuilder(ReadBuffer readBuffer)
      throws ParseException {
    readBuffer.pullContext("TlvOrganizationSpecific");
    PositionAware positionAware = readBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    TlvOrganizationSpecificUnit organizationSpecificUnit =
        readSimpleField(
            "organizationSpecificUnit",
            readComplex(() -> TlvOrganizationSpecificUnit.staticParse(readBuffer), readBuffer));

    readBuffer.closeContext("TlvOrganizationSpecific");
    // Create the instance
    return new TlvOrganizationSpecificBuilderImpl(organizationSpecificUnit);
  }

  public static class TlvOrganizationSpecificBuilderImpl implements LldpUnit.LldpUnitBuilder {
    private final TlvOrganizationSpecificUnit organizationSpecificUnit;

    public TlvOrganizationSpecificBuilderImpl(
        TlvOrganizationSpecificUnit organizationSpecificUnit) {
      this.organizationSpecificUnit = organizationSpecificUnit;
    }

    public TlvOrganizationSpecific build(short tlvIdLength) {
      TlvOrganizationSpecific tlvOrganizationSpecific =
          new TlvOrganizationSpecific(tlvIdLength, organizationSpecificUnit);
      return tlvOrganizationSpecific;
    }
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof TlvOrganizationSpecific)) {
      return false;
    }
    TlvOrganizationSpecific that = (TlvOrganizationSpecific) o;
    return (getOrganizationSpecificUnit() == that.getOrganizationSpecificUnit())
        && super.equals(that)
        && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(super.hashCode(), getOrganizationSpecificUnit());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
