/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.profinet.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class PnIoCm_RealIdentificationApi_Subslot implements Message {

  // Properties.
  protected final int subslotNumber;
  protected final long submoduleIdentNumber;

  public PnIoCm_RealIdentificationApi_Subslot(int subslotNumber, long submoduleIdentNumber) {
    super();
    this.subslotNumber = subslotNumber;
    this.submoduleIdentNumber = submoduleIdentNumber;
  }

  public int getSubslotNumber() {
    return subslotNumber;
  }

  public long getSubmoduleIdentNumber() {
    return submoduleIdentNumber;
  }

  public void serialize(WriteBuffer writeBuffer) throws SerializationException {
    PositionAware positionAware = writeBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
    writeBuffer.pushContext("PnIoCm_RealIdentificationApi_Subslot");

    // Simple Field (subslotNumber)
    writeSimpleField(
        "subslotNumber",
        subslotNumber,
        writeUnsignedInt(writeBuffer, 16),
        WithOption.WithByteOrder(ByteOrder.BIG_ENDIAN));

    // Simple Field (submoduleIdentNumber)
    writeSimpleField(
        "submoduleIdentNumber",
        submoduleIdentNumber,
        writeUnsignedLong(writeBuffer, 32),
        WithOption.WithByteOrder(ByteOrder.BIG_ENDIAN));

    writeBuffer.popContext("PnIoCm_RealIdentificationApi_Subslot");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = 0;
    PnIoCm_RealIdentificationApi_Subslot _value = this;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    // Simple field (subslotNumber)
    lengthInBits += 16;

    // Simple field (submoduleIdentNumber)
    lengthInBits += 32;

    return lengthInBits;
  }

  public static PnIoCm_RealIdentificationApi_Subslot staticParse(ReadBuffer readBuffer)
      throws ParseException {
    readBuffer.pullContext("PnIoCm_RealIdentificationApi_Subslot");
    PositionAware positionAware = readBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    int subslotNumber =
        readSimpleField(
            "subslotNumber",
            readUnsignedInt(readBuffer, 16),
            WithOption.WithByteOrder(ByteOrder.BIG_ENDIAN));

    long submoduleIdentNumber =
        readSimpleField(
            "submoduleIdentNumber",
            readUnsignedLong(readBuffer, 32),
            WithOption.WithByteOrder(ByteOrder.BIG_ENDIAN));

    readBuffer.closeContext("PnIoCm_RealIdentificationApi_Subslot");
    // Create the instance
    PnIoCm_RealIdentificationApi_Subslot _pnIoCm_RealIdentificationApi_Subslot;
    _pnIoCm_RealIdentificationApi_Subslot =
        new PnIoCm_RealIdentificationApi_Subslot(subslotNumber, submoduleIdentNumber);
    return _pnIoCm_RealIdentificationApi_Subslot;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof PnIoCm_RealIdentificationApi_Subslot)) {
      return false;
    }
    PnIoCm_RealIdentificationApi_Subslot that = (PnIoCm_RealIdentificationApi_Subslot) o;
    return (getSubslotNumber() == that.getSubslotNumber())
        && (getSubmoduleIdentNumber() == that.getSubmoduleIdentNumber())
        && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(getSubslotNumber(), getSubmoduleIdentNumber());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
