/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.openprotocol.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class OpenProtocolMessageSetParameterSetBatchSizeRev1
    extends OpenProtocolMessageSetParameterSetBatchSize implements Message {

  // Accessors for discriminator values.
  public Integer getRevision() {
    return (int) 1;
  }

  // Properties.
  protected final int parameterSetId;
  protected final int batchSize;

  public OpenProtocolMessageSetParameterSetBatchSizeRev1(
      Integer midRevision,
      Short noAckFlag,
      Integer targetStationId,
      Integer targetSpindleId,
      Integer sequenceNumber,
      Short numberOfMessageParts,
      Short messagePartNumber,
      int parameterSetId,
      int batchSize) {
    super(
        midRevision,
        noAckFlag,
        targetStationId,
        targetSpindleId,
        sequenceNumber,
        numberOfMessageParts,
        messagePartNumber);
    this.parameterSetId = parameterSetId;
    this.batchSize = batchSize;
  }

  public int getParameterSetId() {
    return parameterSetId;
  }

  public int getBatchSize() {
    return batchSize;
  }

  @Override
  protected void serializeOpenProtocolMessageSetParameterSetBatchSizeChild(WriteBuffer writeBuffer)
      throws SerializationException {
    PositionAware positionAware = writeBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
    writeBuffer.pushContext("OpenProtocolMessageSetParameterSetBatchSizeRev1");

    // Simple Field (parameterSetId)
    writeSimpleField(
        "parameterSetId",
        parameterSetId,
        writeUnsignedInt(writeBuffer, 24),
        WithOption.WithEncoding("ASCII"));

    // Simple Field (batchSize)
    writeSimpleField(
        "batchSize",
        batchSize,
        writeUnsignedInt(writeBuffer, 16),
        WithOption.WithEncoding("ASCII"));

    writeBuffer.popContext("OpenProtocolMessageSetParameterSetBatchSizeRev1");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = super.getLengthInBits();
    OpenProtocolMessageSetParameterSetBatchSizeRev1 _value = this;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    // Simple field (parameterSetId)
    lengthInBits += 24;

    // Simple field (batchSize)
    lengthInBits += 16;

    return lengthInBits;
  }

  public static OpenProtocolMessageSetParameterSetBatchSizeBuilder
      staticParseOpenProtocolMessageSetParameterSetBatchSizeBuilder(
          ReadBuffer readBuffer, Integer revision) throws ParseException {
    readBuffer.pullContext("OpenProtocolMessageSetParameterSetBatchSizeRev1");
    PositionAware positionAware = readBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    int parameterSetId =
        readSimpleField(
            "parameterSetId", readUnsignedInt(readBuffer, 24), WithOption.WithEncoding("ASCII"));

    int batchSize =
        readSimpleField(
            "batchSize", readUnsignedInt(readBuffer, 16), WithOption.WithEncoding("ASCII"));

    readBuffer.closeContext("OpenProtocolMessageSetParameterSetBatchSizeRev1");
    // Create the instance
    return new OpenProtocolMessageSetParameterSetBatchSizeRev1BuilderImpl(
        parameterSetId, batchSize);
  }

  public static class OpenProtocolMessageSetParameterSetBatchSizeRev1BuilderImpl
      implements OpenProtocolMessageSetParameterSetBatchSize
          .OpenProtocolMessageSetParameterSetBatchSizeBuilder {
    private final int parameterSetId;
    private final int batchSize;

    public OpenProtocolMessageSetParameterSetBatchSizeRev1BuilderImpl(
        int parameterSetId, int batchSize) {
      this.parameterSetId = parameterSetId;
      this.batchSize = batchSize;
    }

    public OpenProtocolMessageSetParameterSetBatchSizeRev1 build(
        Integer midRevision,
        Short noAckFlag,
        Integer targetStationId,
        Integer targetSpindleId,
        Integer sequenceNumber,
        Short numberOfMessageParts,
        Short messagePartNumber) {
      OpenProtocolMessageSetParameterSetBatchSizeRev1
          openProtocolMessageSetParameterSetBatchSizeRev1 =
              new OpenProtocolMessageSetParameterSetBatchSizeRev1(
                  midRevision,
                  noAckFlag,
                  targetStationId,
                  targetSpindleId,
                  sequenceNumber,
                  numberOfMessageParts,
                  messagePartNumber,
                  parameterSetId,
                  batchSize);
      return openProtocolMessageSetParameterSetBatchSizeRev1;
    }
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof OpenProtocolMessageSetParameterSetBatchSizeRev1)) {
      return false;
    }
    OpenProtocolMessageSetParameterSetBatchSizeRev1 that =
        (OpenProtocolMessageSetParameterSetBatchSizeRev1) o;
    return (getParameterSetId() == that.getParameterSetId())
        && (getBatchSize() == that.getBatchSize())
        && super.equals(that)
        && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(super.hashCode(), getParameterSetId(), getBatchSize());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
